/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMatchingWorkflowResponse extends EntityResolutionResponse implements
        ToCopyableBuilder<GetMatchingWorkflowResponse.Builder, GetMatchingWorkflowResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetMatchingWorkflowResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetMatchingWorkflowResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<IncrementalRunConfig> INCREMENTAL_RUN_CONFIG_FIELD = SdkField
            .<IncrementalRunConfig> builder(MarshallingType.SDK_POJO).memberName("incrementalRunConfig")
            .getter(getter(GetMatchingWorkflowResponse::incrementalRunConfig)).setter(setter(Builder::incrementalRunConfig))
            .constructor(IncrementalRunConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incrementalRunConfig").build())
            .build();

    private static final SdkField<List<InputSource>> INPUT_SOURCE_CONFIG_FIELD = SdkField
            .<List<InputSource>> builder(MarshallingType.LIST)
            .memberName("inputSourceConfig")
            .getter(getter(GetMatchingWorkflowResponse::inputSourceConfig))
            .setter(setter(Builder::inputSourceConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSourceConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OutputSource>> OUTPUT_SOURCE_CONFIG_FIELD = SdkField
            .<List<OutputSource>> builder(MarshallingType.LIST)
            .memberName("outputSourceConfig")
            .getter(getter(GetMatchingWorkflowResponse::outputSourceConfig))
            .setter(setter(Builder::outputSourceConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSourceConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ResolutionTechniques> RESOLUTION_TECHNIQUES_FIELD = SdkField
            .<ResolutionTechniques> builder(MarshallingType.SDK_POJO).memberName("resolutionTechniques")
            .getter(getter(GetMatchingWorkflowResponse::resolutionTechniques)).setter(setter(Builder::resolutionTechniques))
            .constructor(ResolutionTechniques::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionTechniques").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetMatchingWorkflowResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetMatchingWorkflowResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(GetMatchingWorkflowResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowArn").getter(getter(GetMatchingWorkflowResponse::workflowArn))
            .setter(setter(Builder::workflowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowArn").build()).build();

    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowName").getter(getter(GetMatchingWorkflowResponse::workflowName))
            .setter(setter(Builder::workflowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            DESCRIPTION_FIELD, INCREMENTAL_RUN_CONFIG_FIELD, INPUT_SOURCE_CONFIG_FIELD, OUTPUT_SOURCE_CONFIG_FIELD,
            RESOLUTION_TECHNIQUES_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, UPDATED_AT_FIELD, WORKFLOW_ARN_FIELD, WORKFLOW_NAME_FIELD));

    private final Instant createdAt;

    private final String description;

    private final IncrementalRunConfig incrementalRunConfig;

    private final List<InputSource> inputSourceConfig;

    private final List<OutputSource> outputSourceConfig;

    private final ResolutionTechniques resolutionTechniques;

    private final String roleArn;

    private final Map<String, String> tags;

    private final Instant updatedAt;

    private final String workflowArn;

    private final String workflowName;

    private GetMatchingWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.incrementalRunConfig = builder.incrementalRunConfig;
        this.inputSourceConfig = builder.inputSourceConfig;
        this.outputSourceConfig = builder.outputSourceConfig;
        this.resolutionTechniques = builder.resolutionTechniques;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.updatedAt = builder.updatedAt;
        this.workflowArn = builder.workflowArn;
        this.workflowName = builder.workflowName;
    }

    /**
     * <p>
     * The timestamp of when the workflow was created.
     * </p>
     * 
     * @return The timestamp of when the workflow was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * A description of the workflow.
     * </p>
     * 
     * @return A description of the workflow.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
     * </p>
     * 
     * @return An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
     */
    public final IncrementalRunConfig incrementalRunConfig() {
        return incrementalRunConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputSourceConfig property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputSourceConfig() {
        return inputSourceConfig != null && !(inputSourceConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
     * <code>SchemaName</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputSourceConfig} method.
     * </p>
     * 
     * @return A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
     *         <code>SchemaName</code>.
     */
    public final List<InputSource> inputSourceConfig() {
        return inputSourceConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputSourceConfig property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputSourceConfig() {
        return outputSourceConfig != null && !(outputSourceConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>,
     * <code>ApplyNormalization</code>, and <code>Output</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputSourceConfig} method.
     * </p>
     * 
     * @return A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>,
     *         <code>ApplyNormalization</code>, and <code>Output</code>.
     */
    public final List<OutputSource> outputSourceConfig() {
        return outputSourceConfig;
    }

    /**
     * <p>
     * An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>.
     * </p>
     * 
     * @return An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>.
     */
    public final ResolutionTechniques resolutionTechniques() {
        return resolutionTechniques;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access resources on your
     * behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access resources
     *         on your behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The timestamp of when the workflow was last updated.
     * </p>
     * 
     * @return The timestamp of when the workflow was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>MatchingWorkflow</code>.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>MatchingWorkflow</code>.
     */
    public final String workflowArn() {
        return workflowArn;
    }

    /**
     * <p>
     * The name of the workflow.
     * </p>
     * 
     * @return The name of the workflow.
     */
    public final String workflowName() {
        return workflowName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(incrementalRunConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputSourceConfig() ? inputSourceConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputSourceConfig() ? outputSourceConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resolutionTechniques());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(workflowName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMatchingWorkflowResponse)) {
            return false;
        }
        GetMatchingWorkflowResponse other = (GetMatchingWorkflowResponse) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(description(), other.description())
                && Objects.equals(incrementalRunConfig(), other.incrementalRunConfig())
                && hasInputSourceConfig() == other.hasInputSourceConfig()
                && Objects.equals(inputSourceConfig(), other.inputSourceConfig())
                && hasOutputSourceConfig() == other.hasOutputSourceConfig()
                && Objects.equals(outputSourceConfig(), other.outputSourceConfig())
                && Objects.equals(resolutionTechniques(), other.resolutionTechniques())
                && Objects.equals(roleArn(), other.roleArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(workflowArn(), other.workflowArn()) && Objects.equals(workflowName(), other.workflowName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMatchingWorkflowResponse").add("CreatedAt", createdAt()).add("Description", description())
                .add("IncrementalRunConfig", incrementalRunConfig())
                .add("InputSourceConfig", hasInputSourceConfig() ? inputSourceConfig() : null)
                .add("OutputSourceConfig", hasOutputSourceConfig() ? outputSourceConfig() : null)
                .add("ResolutionTechniques", resolutionTechniques()).add("RoleArn", roleArn())
                .add("Tags", hasTags() ? tags() : null).add("UpdatedAt", updatedAt()).add("WorkflowArn", workflowArn())
                .add("WorkflowName", workflowName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "incrementalRunConfig":
            return Optional.ofNullable(clazz.cast(incrementalRunConfig()));
        case "inputSourceConfig":
            return Optional.ofNullable(clazz.cast(inputSourceConfig()));
        case "outputSourceConfig":
            return Optional.ofNullable(clazz.cast(outputSourceConfig()));
        case "resolutionTechniques":
            return Optional.ofNullable(clazz.cast(resolutionTechniques()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "workflowArn":
            return Optional.ofNullable(clazz.cast(workflowArn()));
        case "workflowName":
            return Optional.ofNullable(clazz.cast(workflowName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMatchingWorkflowResponse, T> g) {
        return obj -> g.apply((GetMatchingWorkflowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EntityResolutionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMatchingWorkflowResponse> {
        /**
         * <p>
         * The timestamp of when the workflow was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the workflow was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A description of the workflow.
         * </p>
         * 
         * @param description
         *        A description of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
         * </p>
         * 
         * @param incrementalRunConfig
         *        An object which defines an incremental run type and has only <code>incrementalRunType</code> as a
         *        field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incrementalRunConfig(IncrementalRunConfig incrementalRunConfig);

        /**
         * <p>
         * An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
         * </p>
         * This is a convenience method that creates an instance of the {@link IncrementalRunConfig.Builder} avoiding
         * the need to create one manually via {@link IncrementalRunConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IncrementalRunConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #incrementalRunConfig(IncrementalRunConfig)}.
         * 
         * @param incrementalRunConfig
         *        a consumer that will call methods on {@link IncrementalRunConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incrementalRunConfig(IncrementalRunConfig)
         */
        default Builder incrementalRunConfig(Consumer<IncrementalRunConfig.Builder> incrementalRunConfig) {
            return incrementalRunConfig(IncrementalRunConfig.builder().applyMutation(incrementalRunConfig).build());
        }

        /**
         * <p>
         * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
         * <code>SchemaName</code>.
         * </p>
         * 
         * @param inputSourceConfig
         *        A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
         *        <code>SchemaName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSourceConfig(Collection<InputSource> inputSourceConfig);

        /**
         * <p>
         * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
         * <code>SchemaName</code>.
         * </p>
         * 
         * @param inputSourceConfig
         *        A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
         *        <code>SchemaName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSourceConfig(InputSource... inputSourceConfig);

        /**
         * <p>
         * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
         * <code>SchemaName</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.InputSource.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.entityresolution.model.InputSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.InputSource.Builder#build()} is called
         * immediately and its result is passed to {@link #inputSourceConfig(List<InputSource>)}.
         * 
         * @param inputSourceConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.InputSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSourceConfig(java.util.Collection<InputSource>)
         */
        Builder inputSourceConfig(Consumer<InputSource.Builder>... inputSourceConfig);

        /**
         * <p>
         * A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>,
         * <code>ApplyNormalization</code>, and <code>Output</code>.
         * </p>
         * 
         * @param outputSourceConfig
         *        A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>,
         *        <code>ApplyNormalization</code>, and <code>Output</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSourceConfig(Collection<OutputSource> outputSourceConfig);

        /**
         * <p>
         * A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>,
         * <code>ApplyNormalization</code>, and <code>Output</code>.
         * </p>
         * 
         * @param outputSourceConfig
         *        A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>,
         *        <code>ApplyNormalization</code>, and <code>Output</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSourceConfig(OutputSource... outputSourceConfig);

        /**
         * <p>
         * A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>,
         * <code>ApplyNormalization</code>, and <code>Output</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.OutputSource.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.entityresolution.model.OutputSource#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.OutputSource.Builder#build()} is called
         * immediately and its result is passed to {@link #outputSourceConfig(List<OutputSource>)}.
         * 
         * @param outputSourceConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.OutputSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputSourceConfig(java.util.Collection<OutputSource>)
         */
        Builder outputSourceConfig(Consumer<OutputSource.Builder>... outputSourceConfig);

        /**
         * <p>
         * An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>.
         * </p>
         * 
         * @param resolutionTechniques
         *        An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolutionTechniques(ResolutionTechniques resolutionTechniques);

        /**
         * <p>
         * An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResolutionTechniques.Builder} avoiding
         * the need to create one manually via {@link ResolutionTechniques#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResolutionTechniques.Builder#build()} is called immediately and
         * its result is passed to {@link #resolutionTechniques(ResolutionTechniques)}.
         * 
         * @param resolutionTechniques
         *        a consumer that will call methods on {@link ResolutionTechniques.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolutionTechniques(ResolutionTechniques)
         */
        default Builder resolutionTechniques(Consumer<ResolutionTechniques.Builder> resolutionTechniques) {
            return resolutionTechniques(ResolutionTechniques.builder().applyMutation(resolutionTechniques).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access resources on
         * your behalf.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access
         *        resources on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The timestamp of when the workflow was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the workflow was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>MatchingWorkflow</code>.
         * </p>
         * 
         * @param workflowArn
         *        The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>MatchingWorkflow</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowArn(String workflowArn);

        /**
         * <p>
         * The name of the workflow.
         * </p>
         * 
         * @param workflowName
         *        The name of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowName(String workflowName);
    }

    static final class BuilderImpl extends EntityResolutionResponse.BuilderImpl implements Builder {
        private Instant createdAt;

        private String description;

        private IncrementalRunConfig incrementalRunConfig;

        private List<InputSource> inputSourceConfig = DefaultSdkAutoConstructList.getInstance();

        private List<OutputSource> outputSourceConfig = DefaultSdkAutoConstructList.getInstance();

        private ResolutionTechniques resolutionTechniques;

        private String roleArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Instant updatedAt;

        private String workflowArn;

        private String workflowName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMatchingWorkflowResponse model) {
            super(model);
            createdAt(model.createdAt);
            description(model.description);
            incrementalRunConfig(model.incrementalRunConfig);
            inputSourceConfig(model.inputSourceConfig);
            outputSourceConfig(model.outputSourceConfig);
            resolutionTechniques(model.resolutionTechniques);
            roleArn(model.roleArn);
            tags(model.tags);
            updatedAt(model.updatedAt);
            workflowArn(model.workflowArn);
            workflowName(model.workflowName);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final IncrementalRunConfig.Builder getIncrementalRunConfig() {
            return incrementalRunConfig != null ? incrementalRunConfig.toBuilder() : null;
        }

        public final void setIncrementalRunConfig(IncrementalRunConfig.BuilderImpl incrementalRunConfig) {
            this.incrementalRunConfig = incrementalRunConfig != null ? incrementalRunConfig.build() : null;
        }

        @Override
        public final Builder incrementalRunConfig(IncrementalRunConfig incrementalRunConfig) {
            this.incrementalRunConfig = incrementalRunConfig;
            return this;
        }

        public final List<InputSource.Builder> getInputSourceConfig() {
            List<InputSource.Builder> result = InputSourceConfigCopier.copyToBuilder(this.inputSourceConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputSourceConfig(Collection<InputSource.BuilderImpl> inputSourceConfig) {
            this.inputSourceConfig = InputSourceConfigCopier.copyFromBuilder(inputSourceConfig);
        }

        @Override
        public final Builder inputSourceConfig(Collection<InputSource> inputSourceConfig) {
            this.inputSourceConfig = InputSourceConfigCopier.copy(inputSourceConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSourceConfig(InputSource... inputSourceConfig) {
            inputSourceConfig(Arrays.asList(inputSourceConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSourceConfig(Consumer<InputSource.Builder>... inputSourceConfig) {
            inputSourceConfig(Stream.of(inputSourceConfig).map(c -> InputSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<OutputSource.Builder> getOutputSourceConfig() {
            List<OutputSource.Builder> result = OutputSourceConfigCopier.copyToBuilder(this.outputSourceConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSourceConfig(Collection<OutputSource.BuilderImpl> outputSourceConfig) {
            this.outputSourceConfig = OutputSourceConfigCopier.copyFromBuilder(outputSourceConfig);
        }

        @Override
        public final Builder outputSourceConfig(Collection<OutputSource> outputSourceConfig) {
            this.outputSourceConfig = OutputSourceConfigCopier.copy(outputSourceConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(OutputSource... outputSourceConfig) {
            outputSourceConfig(Arrays.asList(outputSourceConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(Consumer<OutputSource.Builder>... outputSourceConfig) {
            outputSourceConfig(Stream.of(outputSourceConfig).map(c -> OutputSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ResolutionTechniques.Builder getResolutionTechniques() {
            return resolutionTechniques != null ? resolutionTechniques.toBuilder() : null;
        }

        public final void setResolutionTechniques(ResolutionTechniques.BuilderImpl resolutionTechniques) {
            this.resolutionTechniques = resolutionTechniques != null ? resolutionTechniques.build() : null;
        }

        @Override
        public final Builder resolutionTechniques(ResolutionTechniques resolutionTechniques) {
            this.resolutionTechniques = resolutionTechniques;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getWorkflowArn() {
            return workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final String getWorkflowName() {
            return workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        @Override
        public GetMatchingWorkflowResponse build() {
            return new GetMatchingWorkflowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
