/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMatchIdResponse extends EntityResolutionResponse implements
        ToCopyableBuilder<GetMatchIdResponse.Builder, GetMatchIdResponse> {
    private static final SdkField<String> MATCH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("matchId").getter(getter(GetMatchIdResponse::matchId)).setter(setter(Builder::matchId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_ID_FIELD));

    private final String matchId;

    private GetMatchIdResponse(BuilderImpl builder) {
        super(builder);
        this.matchId = builder.matchId;
    }

    /**
     * <p>
     * The unique identifiers for this group of match records.
     * </p>
     * 
     * @return The unique identifiers for this group of match records.
     */
    public final String matchId() {
        return matchId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(matchId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMatchIdResponse)) {
            return false;
        }
        GetMatchIdResponse other = (GetMatchIdResponse) obj;
        return Objects.equals(matchId(), other.matchId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMatchIdResponse").add("MatchId", matchId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "matchId":
            return Optional.ofNullable(clazz.cast(matchId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMatchIdResponse, T> g) {
        return obj -> g.apply((GetMatchIdResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EntityResolutionResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMatchIdResponse> {
        /**
         * <p>
         * The unique identifiers for this group of match records.
         * </p>
         * 
         * @param matchId
         *        The unique identifiers for this group of match records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchId(String matchId);
    }

    static final class BuilderImpl extends EntityResolutionResponse.BuilderImpl implements Builder {
        private String matchId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMatchIdResponse model) {
            super(model);
            matchId(model.matchId);
        }

        public final String getMatchId() {
            return matchId;
        }

        public final void setMatchId(String matchId) {
            this.matchId = matchId;
        }

        @Override
        public final Builder matchId(String matchId) {
            this.matchId = matchId;
            return this;
        }

        @Override
        public GetMatchIdResponse build() {
            return new GetMatchIdResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
