/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.entityresolution.internal.EntityResolutionServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.entityresolution.model.AccessDeniedException;
import software.amazon.awssdk.services.entityresolution.model.ConflictException;
import software.amazon.awssdk.services.entityresolution.model.CreateIdMappingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.CreateIdMappingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.CreateMatchingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.CreateMatchingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.CreateSchemaMappingRequest;
import software.amazon.awssdk.services.entityresolution.model.CreateSchemaMappingResponse;
import software.amazon.awssdk.services.entityresolution.model.DeleteIdMappingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.DeleteIdMappingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.DeleteMatchingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.DeleteMatchingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.DeleteSchemaMappingRequest;
import software.amazon.awssdk.services.entityresolution.model.DeleteSchemaMappingResponse;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionException;
import software.amazon.awssdk.services.entityresolution.model.ExceedsLimitException;
import software.amazon.awssdk.services.entityresolution.model.GetIdMappingJobRequest;
import software.amazon.awssdk.services.entityresolution.model.GetIdMappingJobResponse;
import software.amazon.awssdk.services.entityresolution.model.GetIdMappingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.GetIdMappingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.GetMatchIdRequest;
import software.amazon.awssdk.services.entityresolution.model.GetMatchIdResponse;
import software.amazon.awssdk.services.entityresolution.model.GetMatchingJobRequest;
import software.amazon.awssdk.services.entityresolution.model.GetMatchingJobResponse;
import software.amazon.awssdk.services.entityresolution.model.GetMatchingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.GetMatchingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.GetProviderServiceRequest;
import software.amazon.awssdk.services.entityresolution.model.GetProviderServiceResponse;
import software.amazon.awssdk.services.entityresolution.model.GetSchemaMappingRequest;
import software.amazon.awssdk.services.entityresolution.model.GetSchemaMappingResponse;
import software.amazon.awssdk.services.entityresolution.model.InternalServerException;
import software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsResponse;
import software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsResponse;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsResponse;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsResponse;
import software.amazon.awssdk.services.entityresolution.model.ListProviderServicesRequest;
import software.amazon.awssdk.services.entityresolution.model.ListProviderServicesResponse;
import software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsResponse;
import software.amazon.awssdk.services.entityresolution.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.entityresolution.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.entityresolution.model.ResourceNotFoundException;
import software.amazon.awssdk.services.entityresolution.model.StartIdMappingJobRequest;
import software.amazon.awssdk.services.entityresolution.model.StartIdMappingJobResponse;
import software.amazon.awssdk.services.entityresolution.model.StartMatchingJobRequest;
import software.amazon.awssdk.services.entityresolution.model.StartMatchingJobResponse;
import software.amazon.awssdk.services.entityresolution.model.TagResourceRequest;
import software.amazon.awssdk.services.entityresolution.model.TagResourceResponse;
import software.amazon.awssdk.services.entityresolution.model.ThrottlingException;
import software.amazon.awssdk.services.entityresolution.model.UntagResourceRequest;
import software.amazon.awssdk.services.entityresolution.model.UntagResourceResponse;
import software.amazon.awssdk.services.entityresolution.model.UpdateIdMappingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.UpdateIdMappingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.UpdateMatchingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.UpdateMatchingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.UpdateSchemaMappingRequest;
import software.amazon.awssdk.services.entityresolution.model.UpdateSchemaMappingResponse;
import software.amazon.awssdk.services.entityresolution.model.ValidationException;
import software.amazon.awssdk.services.entityresolution.transform.CreateIdMappingWorkflowRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.CreateMatchingWorkflowRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.CreateSchemaMappingRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.DeleteIdMappingWorkflowRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.DeleteMatchingWorkflowRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.DeleteSchemaMappingRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.GetIdMappingJobRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.GetIdMappingWorkflowRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.GetMatchIdRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.GetMatchingJobRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.GetMatchingWorkflowRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.GetProviderServiceRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.GetSchemaMappingRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.ListIdMappingJobsRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.ListIdMappingWorkflowsRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.ListMatchingJobsRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.ListMatchingWorkflowsRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.ListProviderServicesRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.ListSchemaMappingsRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.StartIdMappingJobRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.StartMatchingJobRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.UpdateIdMappingWorkflowRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.UpdateMatchingWorkflowRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.UpdateSchemaMappingRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link EntityResolutionClient}.
 *
 * @see EntityResolutionClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultEntityResolutionClient implements EntityResolutionClient {
    private static final Logger log = Logger.loggerFor(DefaultEntityResolutionClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultEntityResolutionClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates an <code>IdMappingWorkflow</code> object which stores the configuration of the data processing job to be
     * run. Each <code>IdMappingWorkflow</code> must have a unique workflow name. To modify an existing workflow, use
     * the <code>UpdateIdMappingWorkflow</code> API.
     * </p>
     *
     * @param createIdMappingWorkflowRequest
     * @return Result of the CreateIdMappingWorkflow operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ExceedsLimitException
     *         The request was rejected because it attempted to create resources beyond the current Entity Resolution
     *         account limits. The error message describes the limit exceeded. <code>HTTP Status Code: 402</code>
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. Example:
     *         Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.CreateIdMappingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateIdMappingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateIdMappingWorkflowResponse createIdMappingWorkflow(CreateIdMappingWorkflowRequest createIdMappingWorkflowRequest)
            throws ThrottlingException, InternalServerException, AccessDeniedException, ExceedsLimitException, ConflictException,
            ValidationException, AwsServiceException, SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIdMappingWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateIdMappingWorkflowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIdMappingWorkflowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIdMappingWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIdMappingWorkflow");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateIdMappingWorkflowRequest, CreateIdMappingWorkflowResponse>()
                            .withOperationName("CreateIdMappingWorkflow").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createIdMappingWorkflowRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateIdMappingWorkflowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <code>MatchingWorkflow</code> object which stores the configuration of the data processing job to be
     * run. It is important to note that there should not be a pre-existing <code>MatchingWorkflow</code> with the same
     * name. To modify an existing workflow, utilize the <code>UpdateMatchingWorkflow</code> API.
     * </p>
     *
     * @param createMatchingWorkflowRequest
     * @return Result of the CreateMatchingWorkflow operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ExceedsLimitException
     *         The request was rejected because it attempted to create resources beyond the current Entity Resolution
     *         account limits. The error message describes the limit exceeded. <code>HTTP Status Code: 402</code>
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. Example:
     *         Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.CreateMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMatchingWorkflowResponse createMatchingWorkflow(CreateMatchingWorkflowRequest createMatchingWorkflowRequest)
            throws ThrottlingException, InternalServerException, AccessDeniedException, ExceedsLimitException, ConflictException,
            ValidationException, AwsServiceException, SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMatchingWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateMatchingWorkflowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMatchingWorkflowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMatchingWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMatchingWorkflow");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMatchingWorkflowRequest, CreateMatchingWorkflowResponse>()
                            .withOperationName("CreateMatchingWorkflow").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createMatchingWorkflowRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateMatchingWorkflowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a schema mapping, which defines the schema of the input customer records table. The
     * <code>SchemaMapping</code> also provides Entity Resolution with some metadata about the table, such as the
     * attribute types of the columns and which columns to match on.
     * </p>
     *
     * @param createSchemaMappingRequest
     * @return Result of the CreateSchemaMapping operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ExceedsLimitException
     *         The request was rejected because it attempted to create resources beyond the current Entity Resolution
     *         account limits. The error message describes the limit exceeded. <code>HTTP Status Code: 402</code>
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. Example:
     *         Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.CreateSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateSchemaMappingResponse createSchemaMapping(CreateSchemaMappingRequest createSchemaMappingRequest)
            throws ThrottlingException, InternalServerException, AccessDeniedException, ExceedsLimitException, ConflictException,
            ValidationException, AwsServiceException, SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSchemaMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateSchemaMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSchemaMappingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSchemaMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSchemaMapping");

            return clientHandler.execute(new ClientExecutionParams<CreateSchemaMappingRequest, CreateSchemaMappingResponse>()
                    .withOperationName("CreateSchemaMapping").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSchemaMappingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSchemaMappingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the <code>IdMappingWorkflow</code> with a given name. This operation will succeed even if a workflow with
     * the given name does not exist.
     * </p>
     *
     * @param deleteIdMappingWorkflowRequest
     * @return Result of the DeleteIdMappingWorkflow operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.DeleteIdMappingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteIdMappingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteIdMappingWorkflowResponse deleteIdMappingWorkflow(DeleteIdMappingWorkflowRequest deleteIdMappingWorkflowRequest)
            throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIdMappingWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteIdMappingWorkflowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIdMappingWorkflowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIdMappingWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIdMappingWorkflow");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteIdMappingWorkflowRequest, DeleteIdMappingWorkflowResponse>()
                            .withOperationName("DeleteIdMappingWorkflow").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteIdMappingWorkflowRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteIdMappingWorkflowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the <code>MatchingWorkflow</code> with a given name. This operation will succeed even if a workflow with
     * the given name does not exist.
     * </p>
     *
     * @param deleteMatchingWorkflowRequest
     * @return Result of the DeleteMatchingWorkflow operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.DeleteMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteMatchingWorkflowResponse deleteMatchingWorkflow(DeleteMatchingWorkflowRequest deleteMatchingWorkflowRequest)
            throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMatchingWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteMatchingWorkflowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMatchingWorkflowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMatchingWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMatchingWorkflow");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteMatchingWorkflowRequest, DeleteMatchingWorkflowResponse>()
                            .withOperationName("DeleteMatchingWorkflow").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteMatchingWorkflowRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteMatchingWorkflowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the <code>SchemaMapping</code> with a given name. This operation will succeed even if a schema with the
     * given name does not exist. This operation will fail if there is a <code>MatchingWorkflow</code> object that
     * references the <code>SchemaMapping</code> in the workflow's <code>InputSourceConfig</code>.
     * </p>
     *
     * @param deleteSchemaMappingRequest
     * @return Result of the DeleteSchemaMapping operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. Example:
     *         Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.DeleteSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteSchemaMappingResponse deleteSchemaMapping(DeleteSchemaMappingRequest deleteSchemaMappingRequest)
            throws ThrottlingException, InternalServerException, AccessDeniedException, ConflictException, ValidationException,
            AwsServiceException, SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSchemaMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteSchemaMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSchemaMappingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSchemaMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSchemaMapping");

            return clientHandler.execute(new ClientExecutionParams<DeleteSchemaMappingRequest, DeleteSchemaMappingResponse>()
                    .withOperationName("DeleteSchemaMapping").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteSchemaMappingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSchemaMappingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the status, metrics, and errors (if there are any) that are associated with a job.
     * </p>
     *
     * @param getIdMappingJobRequest
     * @return Result of the GetIdMappingJob operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws ResourceNotFoundException
     *         The resource could not be found. <code>HTTP Status Code: 404</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.GetIdMappingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetIdMappingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetIdMappingJobResponse getIdMappingJob(GetIdMappingJobRequest getIdMappingJobRequest) throws ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetIdMappingJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetIdMappingJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIdMappingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIdMappingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIdMappingJob");

            return clientHandler.execute(new ClientExecutionParams<GetIdMappingJobRequest, GetIdMappingJobResponse>()
                    .withOperationName("GetIdMappingJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getIdMappingJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetIdMappingJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the <code>IdMappingWorkflow</code> with a given name, if it exists.
     * </p>
     *
     * @param getIdMappingWorkflowRequest
     * @return Result of the GetIdMappingWorkflow operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws ResourceNotFoundException
     *         The resource could not be found. <code>HTTP Status Code: 404</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.GetIdMappingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetIdMappingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetIdMappingWorkflowResponse getIdMappingWorkflow(GetIdMappingWorkflowRequest getIdMappingWorkflowRequest)
            throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, AwsServiceException, SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetIdMappingWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetIdMappingWorkflowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIdMappingWorkflowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIdMappingWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIdMappingWorkflow");

            return clientHandler.execute(new ClientExecutionParams<GetIdMappingWorkflowRequest, GetIdMappingWorkflowResponse>()
                    .withOperationName("GetIdMappingWorkflow").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getIdMappingWorkflowRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetIdMappingWorkflowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the corresponding Match ID of a customer record if the record has been processed.
     * </p>
     *
     * @param getMatchIdRequest
     * @return Result of the GetMatchId operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws ResourceNotFoundException
     *         The resource could not be found. <code>HTTP Status Code: 404</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.GetMatchId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchId" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetMatchIdResponse getMatchId(GetMatchIdRequest getMatchIdRequest) throws ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMatchIdResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMatchIdResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMatchIdRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMatchIdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMatchId");

            return clientHandler.execute(new ClientExecutionParams<GetMatchIdRequest, GetMatchIdResponse>()
                    .withOperationName("GetMatchId").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getMatchIdRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetMatchIdRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the status, metrics, and errors (if there are any) that are associated with a job.
     * </p>
     *
     * @param getMatchingJobRequest
     * @return Result of the GetMatchingJob operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws ResourceNotFoundException
     *         The resource could not be found. <code>HTTP Status Code: 404</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.GetMatchingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetMatchingJobResponse getMatchingJob(GetMatchingJobRequest getMatchingJobRequest) throws ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMatchingJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMatchingJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMatchingJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMatchingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMatchingJob");

            return clientHandler.execute(new ClientExecutionParams<GetMatchingJobRequest, GetMatchingJobResponse>()
                    .withOperationName("GetMatchingJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getMatchingJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetMatchingJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the <code>MatchingWorkflow</code> with a given name, if it exists.
     * </p>
     *
     * @param getMatchingWorkflowRequest
     * @return Result of the GetMatchingWorkflow operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws ResourceNotFoundException
     *         The resource could not be found. <code>HTTP Status Code: 404</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.GetMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetMatchingWorkflowResponse getMatchingWorkflow(GetMatchingWorkflowRequest getMatchingWorkflowRequest)
            throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, AwsServiceException, SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMatchingWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetMatchingWorkflowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMatchingWorkflowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMatchingWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMatchingWorkflow");

            return clientHandler.execute(new ClientExecutionParams<GetMatchingWorkflowRequest, GetMatchingWorkflowResponse>()
                    .withOperationName("GetMatchingWorkflow").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getMatchingWorkflowRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetMatchingWorkflowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the <code>ProviderService</code> of a given name.
     * </p>
     *
     * @param getProviderServiceRequest
     * @return Result of the GetProviderService operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws ResourceNotFoundException
     *         The resource could not be found. <code>HTTP Status Code: 404</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.GetProviderService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetProviderService"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetProviderServiceResponse getProviderService(GetProviderServiceRequest getProviderServiceRequest)
            throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, AwsServiceException, SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetProviderServiceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetProviderServiceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getProviderServiceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getProviderServiceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetProviderService");

            return clientHandler.execute(new ClientExecutionParams<GetProviderServiceRequest, GetProviderServiceResponse>()
                    .withOperationName("GetProviderService").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getProviderServiceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetProviderServiceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the SchemaMapping of a given name.
     * </p>
     *
     * @param getSchemaMappingRequest
     * @return Result of the GetSchemaMapping operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws ResourceNotFoundException
     *         The resource could not be found. <code>HTTP Status Code: 404</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.GetSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetSchemaMappingResponse getSchemaMapping(GetSchemaMappingRequest getSchemaMappingRequest) throws ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSchemaMappingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSchemaMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSchemaMappingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSchemaMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSchemaMapping");

            return clientHandler.execute(new ClientExecutionParams<GetSchemaMappingRequest, GetSchemaMappingResponse>()
                    .withOperationName("GetSchemaMapping").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getSchemaMappingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSchemaMappingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all ID mapping jobs for a given workflow.
     * </p>
     *
     * @param listIdMappingJobsRequest
     * @return Result of the ListIdMappingJobs operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws ResourceNotFoundException
     *         The resource could not be found. <code>HTTP Status Code: 404</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.ListIdMappingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListIdMappingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListIdMappingJobsResponse listIdMappingJobs(ListIdMappingJobsRequest listIdMappingJobsRequest)
            throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, AwsServiceException, SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIdMappingJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListIdMappingJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIdMappingJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIdMappingJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIdMappingJobs");

            return clientHandler.execute(new ClientExecutionParams<ListIdMappingJobsRequest, ListIdMappingJobsResponse>()
                    .withOperationName("ListIdMappingJobs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listIdMappingJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListIdMappingJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of all the <code>IdMappingWorkflows</code> that have been created for an Amazon Web Services
     * account.
     * </p>
     *
     * @param listIdMappingWorkflowsRequest
     * @return Result of the ListIdMappingWorkflows operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.ListIdMappingWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListIdMappingWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListIdMappingWorkflowsResponse listIdMappingWorkflows(ListIdMappingWorkflowsRequest listIdMappingWorkflowsRequest)
            throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIdMappingWorkflowsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListIdMappingWorkflowsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIdMappingWorkflowsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIdMappingWorkflowsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIdMappingWorkflows");

            return clientHandler
                    .execute(new ClientExecutionParams<ListIdMappingWorkflowsRequest, ListIdMappingWorkflowsResponse>()
                            .withOperationName("ListIdMappingWorkflows").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listIdMappingWorkflowsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListIdMappingWorkflowsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all jobs for a given workflow.
     * </p>
     *
     * @param listMatchingJobsRequest
     * @return Result of the ListMatchingJobs operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws ResourceNotFoundException
     *         The resource could not be found. <code>HTTP Status Code: 404</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.ListMatchingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMatchingJobsResponse listMatchingJobs(ListMatchingJobsRequest listMatchingJobsRequest) throws ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMatchingJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListMatchingJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMatchingJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMatchingJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMatchingJobs");

            return clientHandler.execute(new ClientExecutionParams<ListMatchingJobsRequest, ListMatchingJobsResponse>()
                    .withOperationName("ListMatchingJobs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listMatchingJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListMatchingJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of all the <code>MatchingWorkflows</code> that have been created for an Amazon Web Services
     * account.
     * </p>
     *
     * @param listMatchingWorkflowsRequest
     * @return Result of the ListMatchingWorkflows operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.ListMatchingWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMatchingWorkflowsResponse listMatchingWorkflows(ListMatchingWorkflowsRequest listMatchingWorkflowsRequest)
            throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMatchingWorkflowsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListMatchingWorkflowsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMatchingWorkflowsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMatchingWorkflowsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMatchingWorkflows");

            return clientHandler.execute(new ClientExecutionParams<ListMatchingWorkflowsRequest, ListMatchingWorkflowsResponse>()
                    .withOperationName("ListMatchingWorkflows").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listMatchingWorkflowsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListMatchingWorkflowsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of all the <code>ProviderServices</code> that are available in this Amazon Web Services Region.
     * </p>
     *
     * @param listProviderServicesRequest
     * @return Result of the ListProviderServices operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.ListProviderServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListProviderServices"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListProviderServicesResponse listProviderServices(ListProviderServicesRequest listProviderServicesRequest)
            throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListProviderServicesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListProviderServicesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listProviderServicesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProviderServicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProviderServices");

            return clientHandler.execute(new ClientExecutionParams<ListProviderServicesRequest, ListProviderServicesResponse>()
                    .withOperationName("ListProviderServices").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listProviderServicesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListProviderServicesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of all the <code>SchemaMappings</code> that have been created for an Amazon Web Services account.
     * </p>
     *
     * @param listSchemaMappingsRequest
     * @return Result of the ListSchemaMappings operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.ListSchemaMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListSchemaMappings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSchemaMappingsResponse listSchemaMappings(ListSchemaMappingsRequest listSchemaMappingsRequest)
            throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSchemaMappingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSchemaMappingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSchemaMappingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSchemaMappingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSchemaMappings");

            return clientHandler.execute(new ClientExecutionParams<ListSchemaMappingsRequest, ListSchemaMappingsResponse>()
                    .withOperationName("ListSchemaMappings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listSchemaMappingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSchemaMappingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays the tags associated with an Entity Resolution resource. In Entity Resolution, <code>SchemaMapping</code>
     * , and <code>MatchingWorkflow</code> can be tagged.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws ResourceNotFoundException
     *         The resource could not be found. <code>HTTP Status Code: 404</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts the <code>IdMappingJob</code> of a workflow. The workflow must have previously been created using the
     * <code>CreateIdMappingWorkflow</code> endpoint.
     * </p>
     *
     * @param startIdMappingJobRequest
     * @return Result of the StartIdMappingJob operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws ResourceNotFoundException
     *         The resource could not be found. <code>HTTP Status Code: 404</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ExceedsLimitException
     *         The request was rejected because it attempted to create resources beyond the current Entity Resolution
     *         account limits. The error message describes the limit exceeded. <code>HTTP Status Code: 402</code>
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. Example:
     *         Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.StartIdMappingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/StartIdMappingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartIdMappingJobResponse startIdMappingJob(StartIdMappingJobRequest startIdMappingJobRequest)
            throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ExceedsLimitException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartIdMappingJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartIdMappingJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startIdMappingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startIdMappingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartIdMappingJob");

            return clientHandler.execute(new ClientExecutionParams<StartIdMappingJobRequest, StartIdMappingJobResponse>()
                    .withOperationName("StartIdMappingJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startIdMappingJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartIdMappingJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts the <code>MatchingJob</code> of a workflow. The workflow must have previously been created using the
     * <code>CreateMatchingWorkflow</code> endpoint.
     * </p>
     *
     * @param startMatchingJobRequest
     * @return Result of the StartMatchingJob operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws ResourceNotFoundException
     *         The resource could not be found. <code>HTTP Status Code: 404</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ExceedsLimitException
     *         The request was rejected because it attempted to create resources beyond the current Entity Resolution
     *         account limits. The error message describes the limit exceeded. <code>HTTP Status Code: 402</code>
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. Example:
     *         Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.StartMatchingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/StartMatchingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartMatchingJobResponse startMatchingJob(StartMatchingJobRequest startMatchingJobRequest) throws ThrottlingException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ExceedsLimitException, ConflictException,
            ValidationException, AwsServiceException, SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartMatchingJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartMatchingJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startMatchingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMatchingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMatchingJob");

            return clientHandler.execute(new ClientExecutionParams<StartMatchingJobRequest, StartMatchingJobResponse>()
                    .withOperationName("StartMatchingJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startMatchingJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartMatchingJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified Entity Resolution resource. Tags can help you
     * organize and categorize your resources. You can also use them to scope user permissions by granting a user
     * permission to access or change only resources with certain tag values. In Entity Resolution,
     * <code>SchemaMapping</code> and <code>MatchingWorkflow</code> can be tagged. Tags don't have any semantic meaning
     * to Amazon Web Services and are interpreted strictly as strings of characters. You can use the
     * <code>TagResource</code> action with a resource that already has tags. If you specify a new tag key, this tag is
     * appended to the list of tags associated with the resource. If you specify a tag key that is already associated
     * with the resource, the new tag value that you specify replaces the previous value for that tag.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws ResourceNotFoundException
     *         The resource could not be found. <code>HTTP Status Code: 404</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes one or more tags from the specified Entity Resolution resource. In Entity Resolution,
     * <code>SchemaMapping</code>, and <code>MatchingWorkflow</code> can be tagged.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws ResourceNotFoundException
     *         The resource could not be found. <code>HTTP Status Code: 404</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing <code>IdMappingWorkflow</code>. This method is identical to
     * <code>CreateIdMappingWorkflow</code>, except it uses an HTTP <code>PUT</code> request instead of a
     * <code>POST</code> request, and the <code>IdMappingWorkflow</code> must already exist for the method to succeed.
     * </p>
     *
     * @param updateIdMappingWorkflowRequest
     * @return Result of the UpdateIdMappingWorkflow operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws ResourceNotFoundException
     *         The resource could not be found. <code>HTTP Status Code: 404</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.UpdateIdMappingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateIdMappingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateIdMappingWorkflowResponse updateIdMappingWorkflow(UpdateIdMappingWorkflowRequest updateIdMappingWorkflowRequest)
            throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, AwsServiceException, SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateIdMappingWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateIdMappingWorkflowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateIdMappingWorkflowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIdMappingWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIdMappingWorkflow");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateIdMappingWorkflowRequest, UpdateIdMappingWorkflowResponse>()
                            .withOperationName("UpdateIdMappingWorkflow").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateIdMappingWorkflowRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateIdMappingWorkflowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing <code>MatchingWorkflow</code>. This method is identical to
     * <code>CreateMatchingWorkflow</code>, except it uses an HTTP <code>PUT</code> request instead of a
     * <code>POST</code> request, and the <code>MatchingWorkflow</code> must already exist for the method to succeed.
     * </p>
     *
     * @param updateMatchingWorkflowRequest
     * @return Result of the UpdateMatchingWorkflow operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws ResourceNotFoundException
     *         The resource could not be found. <code>HTTP Status Code: 404</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.UpdateMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateMatchingWorkflowResponse updateMatchingWorkflow(UpdateMatchingWorkflowRequest updateMatchingWorkflowRequest)
            throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, AwsServiceException, SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMatchingWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateMatchingWorkflowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMatchingWorkflowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMatchingWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMatchingWorkflow");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateMatchingWorkflowRequest, UpdateMatchingWorkflowResponse>()
                            .withOperationName("UpdateMatchingWorkflow").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateMatchingWorkflowRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateMatchingWorkflowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a schema mapping.
     * </p>
     * <note>
     * <p>
     * A schema is immutable if it is being used by a workflow. Therefore, you can't update a schema mapping if it's
     * associated with a workflow.
     * </p>
     * </note>
     *
     * @param updateSchemaMappingRequest
     * @return Result of the UpdateSchemaMapping operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling. <code>HTTP Status Code: 429</code>
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the Entity Resolution service.
     *         <code>HTTP Status Code: 500</code>
     * @throws ResourceNotFoundException
     *         The resource could not be found. <code>HTTP Status Code: 404</code>
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action. <code>HTTP Status Code: 403</code>
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource. Example:
     *         Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code>
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EntityResolutionException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EntityResolutionClient.UpdateSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateSchemaMappingResponse updateSchemaMapping(UpdateSchemaMappingRequest updateSchemaMappingRequest)
            throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ConflictException, ValidationException, AwsServiceException, SdkClientException, EntityResolutionException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSchemaMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateSchemaMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSchemaMappingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSchemaMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSchemaMapping");

            return clientHandler.execute(new ClientExecutionParams<UpdateSchemaMappingRequest, UpdateSchemaMappingResponse>()
                    .withOperationName("UpdateSchemaMapping").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateSchemaMappingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSchemaMappingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        EntityResolutionServiceClientConfigurationBuilder serviceConfigBuilder = new EntityResolutionServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(EntityResolutionException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ExceedsLimitException")
                                .exceptionBuilderSupplier(ExceedsLimitException::builder).httpStatusCode(402).build());
    }

    @Override
    public final EntityResolutionServiceClientConfiguration serviceClientConfiguration() {
        return new EntityResolutionServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
