/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The required configuration fields to use with the provider service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProviderEndpointConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ProviderEndpointConfiguration.Builder, ProviderEndpointConfiguration> {
    private static final SdkField<ProviderMarketplaceConfiguration> MARKETPLACE_CONFIGURATION_FIELD = SdkField
            .<ProviderMarketplaceConfiguration> builder(MarshallingType.SDK_POJO).memberName("marketplaceConfiguration")
            .getter(getter(ProviderEndpointConfiguration::marketplaceConfiguration))
            .setter(setter(Builder::marketplaceConfiguration)).constructor(ProviderMarketplaceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("marketplaceConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MARKETPLACE_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ProviderMarketplaceConfiguration marketplaceConfiguration;

    private final Type type;

    private ProviderEndpointConfiguration(BuilderImpl builder) {
        this.marketplaceConfiguration = builder.marketplaceConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * The identifiers of the provider service, from Data Exchange.
     * </p>
     * 
     * @return The identifiers of the provider service, from Data Exchange.
     */
    public final ProviderMarketplaceConfiguration marketplaceConfiguration() {
        return marketplaceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marketplaceConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderEndpointConfiguration)) {
            return false;
        }
        ProviderEndpointConfiguration other = (ProviderEndpointConfiguration) obj;
        return Objects.equals(marketplaceConfiguration(), other.marketplaceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProviderEndpointConfiguration").add("MarketplaceConfiguration", marketplaceConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "marketplaceConfiguration":
            return Optional.ofNullable(clazz.cast(marketplaceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #marketplaceConfiguration()} initialized to the given value.
     *
     * <p>
     * The identifiers of the provider service, from Data Exchange.
     * </p>
     * 
     * @param marketplaceConfiguration
     *        The identifiers of the provider service, from Data Exchange.
     */
    public static ProviderEndpointConfiguration fromMarketplaceConfiguration(
            ProviderMarketplaceConfiguration marketplaceConfiguration) {
        return builder().marketplaceConfiguration(marketplaceConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #marketplaceConfiguration()} initialized to the given value.
     *
     * <p>
     * The identifiers of the provider service, from Data Exchange.
     * </p>
     * 
     * @param marketplaceConfiguration
     *        The identifiers of the provider service, from Data Exchange.
     */
    public static ProviderEndpointConfiguration fromMarketplaceConfiguration(
            Consumer<ProviderMarketplaceConfiguration.Builder> marketplaceConfiguration) {
        ProviderMarketplaceConfiguration.Builder builder = ProviderMarketplaceConfiguration.builder();
        marketplaceConfiguration.accept(builder);
        return fromMarketplaceConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProviderEndpointConfiguration, T> g) {
        return obj -> g.apply((ProviderEndpointConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProviderEndpointConfiguration> {
        /**
         * <p>
         * The identifiers of the provider service, from Data Exchange.
         * </p>
         * 
         * @param marketplaceConfiguration
         *        The identifiers of the provider service, from Data Exchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marketplaceConfiguration(ProviderMarketplaceConfiguration marketplaceConfiguration);

        /**
         * <p>
         * The identifiers of the provider service, from Data Exchange.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProviderMarketplaceConfiguration.Builder}
         * avoiding the need to create one manually via {@link ProviderMarketplaceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProviderMarketplaceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #marketplaceConfiguration(ProviderMarketplaceConfiguration)}.
         * 
         * @param marketplaceConfiguration
         *        a consumer that will call methods on {@link ProviderMarketplaceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #marketplaceConfiguration(ProviderMarketplaceConfiguration)
         */
        default Builder marketplaceConfiguration(Consumer<ProviderMarketplaceConfiguration.Builder> marketplaceConfiguration) {
            return marketplaceConfiguration(ProviderMarketplaceConfiguration.builder().applyMutation(marketplaceConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProviderMarketplaceConfiguration marketplaceConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderEndpointConfiguration model) {
            marketplaceConfiguration(model.marketplaceConfiguration);
        }

        public final ProviderMarketplaceConfiguration.Builder getMarketplaceConfiguration() {
            return marketplaceConfiguration != null ? marketplaceConfiguration.toBuilder() : null;
        }

        public final void setMarketplaceConfiguration(ProviderMarketplaceConfiguration.BuilderImpl marketplaceConfiguration) {
            Object oldValue = this.marketplaceConfiguration;
            this.marketplaceConfiguration = marketplaceConfiguration != null ? marketplaceConfiguration.build() : null;
            handleUnionValueChange(Type.MARKETPLACE_CONFIGURATION, oldValue, this.marketplaceConfiguration);
        }

        @Override
        public final Builder marketplaceConfiguration(ProviderMarketplaceConfiguration marketplaceConfiguration) {
            Object oldValue = this.marketplaceConfiguration;
            this.marketplaceConfiguration = marketplaceConfiguration;
            handleUnionValueChange(Type.MARKETPLACE_CONFIGURATION, oldValue, this.marketplaceConfiguration);
            return this;
        }

        @Override
        public ProviderEndpointConfiguration build() {
            return new ProviderEndpointConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ProviderEndpointConfiguration#type()
     */
    public enum Type {
        MARKETPLACE_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
