/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSchemaMappingRequest extends EntityResolutionRequest implements
        ToCopyableBuilder<UpdateSchemaMappingRequest.Builder, UpdateSchemaMappingRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateSchemaMappingRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<SchemaInputAttribute>> MAPPED_INPUT_FIELDS_FIELD = SdkField
            .<List<SchemaInputAttribute>> builder(MarshallingType.LIST)
            .memberName("mappedInputFields")
            .getter(getter(UpdateSchemaMappingRequest::mappedInputFields))
            .setter(setter(Builder::mappedInputFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappedInputFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SchemaInputAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(SchemaInputAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaName").getter(getter(UpdateSchemaMappingRequest::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("schemaName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            MAPPED_INPUT_FIELDS_FIELD, SCHEMA_NAME_FIELD));

    private final String description;

    private final List<SchemaInputAttribute> mappedInputFields;

    private final String schemaName;

    private UpdateSchemaMappingRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.mappedInputFields = builder.mappedInputFields;
        this.schemaName = builder.schemaName;
    }

    /**
     * <p>
     * A description of the schema.
     * </p>
     * 
     * @return A description of the schema.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the MappedInputFields property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMappedInputFields() {
        return mappedInputFields != null && !(mappedInputFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>MappedInputFields</code>. Each <code>MappedInputField</code> corresponds to a column the source
     * data table, and contains column name plus additional information that Entity Resolution uses for matching.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMappedInputFields} method.
     * </p>
     * 
     * @return A list of <code>MappedInputFields</code>. Each <code>MappedInputField</code> corresponds to a column the
     *         source data table, and contains column name plus additional information that Entity Resolution uses for
     *         matching.
     */
    public final List<SchemaInputAttribute> mappedInputFields() {
        return mappedInputFields;
    }

    /**
     * <p>
     * The name of the schema. There can't be multiple <code>SchemaMappings</code> with the same name.
     * </p>
     * 
     * @return The name of the schema. There can't be multiple <code>SchemaMappings</code> with the same name.
     */
    public final String schemaName() {
        return schemaName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasMappedInputFields() ? mappedInputFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSchemaMappingRequest)) {
            return false;
        }
        UpdateSchemaMappingRequest other = (UpdateSchemaMappingRequest) obj;
        return Objects.equals(description(), other.description()) && hasMappedInputFields() == other.hasMappedInputFields()
                && Objects.equals(mappedInputFields(), other.mappedInputFields())
                && Objects.equals(schemaName(), other.schemaName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSchemaMappingRequest").add("Description", description())
                .add("MappedInputFields", hasMappedInputFields() ? mappedInputFields() : null).add("SchemaName", schemaName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "mappedInputFields":
            return Optional.ofNullable(clazz.cast(mappedInputFields()));
        case "schemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSchemaMappingRequest, T> g) {
        return obj -> g.apply((UpdateSchemaMappingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EntityResolutionRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSchemaMappingRequest> {
        /**
         * <p>
         * A description of the schema.
         * </p>
         * 
         * @param description
         *        A description of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of <code>MappedInputFields</code>. Each <code>MappedInputField</code> corresponds to a column the
         * source data table, and contains column name plus additional information that Entity Resolution uses for
         * matching.
         * </p>
         * 
         * @param mappedInputFields
         *        A list of <code>MappedInputFields</code>. Each <code>MappedInputField</code> corresponds to a column
         *        the source data table, and contains column name plus additional information that Entity Resolution
         *        uses for matching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappedInputFields(Collection<SchemaInputAttribute> mappedInputFields);

        /**
         * <p>
         * A list of <code>MappedInputFields</code>. Each <code>MappedInputField</code> corresponds to a column the
         * source data table, and contains column name plus additional information that Entity Resolution uses for
         * matching.
         * </p>
         * 
         * @param mappedInputFields
         *        A list of <code>MappedInputFields</code>. Each <code>MappedInputField</code> corresponds to a column
         *        the source data table, and contains column name plus additional information that Entity Resolution
         *        uses for matching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappedInputFields(SchemaInputAttribute... mappedInputFields);

        /**
         * <p>
         * A list of <code>MappedInputFields</code>. Each <code>MappedInputField</code> corresponds to a column the
         * source data table, and contains column name plus additional information that Entity Resolution uses for
         * matching.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.SchemaInputAttribute.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.entityresolution.model.SchemaInputAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.SchemaInputAttribute.Builder#build()} is called
         * immediately and its result is passed to {@link #mappedInputFields(List<SchemaInputAttribute>)}.
         * 
         * @param mappedInputFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.SchemaInputAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mappedInputFields(java.util.Collection<SchemaInputAttribute>)
         */
        Builder mappedInputFields(Consumer<SchemaInputAttribute.Builder>... mappedInputFields);

        /**
         * <p>
         * The name of the schema. There can't be multiple <code>SchemaMappings</code> with the same name.
         * </p>
         * 
         * @param schemaName
         *        The name of the schema. There can't be multiple <code>SchemaMappings</code> with the same name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EntityResolutionRequest.BuilderImpl implements Builder {
        private String description;

        private List<SchemaInputAttribute> mappedInputFields = DefaultSdkAutoConstructList.getInstance();

        private String schemaName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSchemaMappingRequest model) {
            super(model);
            description(model.description);
            mappedInputFields(model.mappedInputFields);
            schemaName(model.schemaName);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<SchemaInputAttribute.Builder> getMappedInputFields() {
            List<SchemaInputAttribute.Builder> result = SchemaInputAttributesCopier.copyToBuilder(this.mappedInputFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMappedInputFields(Collection<SchemaInputAttribute.BuilderImpl> mappedInputFields) {
            this.mappedInputFields = SchemaInputAttributesCopier.copyFromBuilder(mappedInputFields);
        }

        @Override
        public final Builder mappedInputFields(Collection<SchemaInputAttribute> mappedInputFields) {
            this.mappedInputFields = SchemaInputAttributesCopier.copy(mappedInputFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappedInputFields(SchemaInputAttribute... mappedInputFields) {
            mappedInputFields(Arrays.asList(mappedInputFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappedInputFields(Consumer<SchemaInputAttribute.Builder>... mappedInputFields) {
            mappedInputFields(Stream.of(mappedInputFields).map(c -> SchemaInputAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSchemaMappingRequest build() {
            return new UpdateSchemaMappingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
