/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.entityresolution.model.CreateIdMappingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.CreateIdMappingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.CreateMatchingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.CreateMatchingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.CreateSchemaMappingRequest;
import software.amazon.awssdk.services.entityresolution.model.CreateSchemaMappingResponse;
import software.amazon.awssdk.services.entityresolution.model.DeleteIdMappingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.DeleteIdMappingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.DeleteMatchingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.DeleteMatchingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.DeleteSchemaMappingRequest;
import software.amazon.awssdk.services.entityresolution.model.DeleteSchemaMappingResponse;
import software.amazon.awssdk.services.entityresolution.model.GetIdMappingJobRequest;
import software.amazon.awssdk.services.entityresolution.model.GetIdMappingJobResponse;
import software.amazon.awssdk.services.entityresolution.model.GetIdMappingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.GetIdMappingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.GetMatchIdRequest;
import software.amazon.awssdk.services.entityresolution.model.GetMatchIdResponse;
import software.amazon.awssdk.services.entityresolution.model.GetMatchingJobRequest;
import software.amazon.awssdk.services.entityresolution.model.GetMatchingJobResponse;
import software.amazon.awssdk.services.entityresolution.model.GetMatchingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.GetMatchingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.GetProviderServiceRequest;
import software.amazon.awssdk.services.entityresolution.model.GetProviderServiceResponse;
import software.amazon.awssdk.services.entityresolution.model.GetSchemaMappingRequest;
import software.amazon.awssdk.services.entityresolution.model.GetSchemaMappingResponse;
import software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsResponse;
import software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsResponse;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsResponse;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsResponse;
import software.amazon.awssdk.services.entityresolution.model.ListProviderServicesRequest;
import software.amazon.awssdk.services.entityresolution.model.ListProviderServicesResponse;
import software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsResponse;
import software.amazon.awssdk.services.entityresolution.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.entityresolution.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.entityresolution.model.StartIdMappingJobRequest;
import software.amazon.awssdk.services.entityresolution.model.StartIdMappingJobResponse;
import software.amazon.awssdk.services.entityresolution.model.StartMatchingJobRequest;
import software.amazon.awssdk.services.entityresolution.model.StartMatchingJobResponse;
import software.amazon.awssdk.services.entityresolution.model.TagResourceRequest;
import software.amazon.awssdk.services.entityresolution.model.TagResourceResponse;
import software.amazon.awssdk.services.entityresolution.model.UntagResourceRequest;
import software.amazon.awssdk.services.entityresolution.model.UntagResourceResponse;
import software.amazon.awssdk.services.entityresolution.model.UpdateIdMappingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.UpdateIdMappingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.UpdateMatchingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.UpdateMatchingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.UpdateSchemaMappingRequest;
import software.amazon.awssdk.services.entityresolution.model.UpdateSchemaMappingResponse;
import software.amazon.awssdk.services.entityresolution.paginators.ListIdMappingJobsPublisher;
import software.amazon.awssdk.services.entityresolution.paginators.ListIdMappingWorkflowsPublisher;
import software.amazon.awssdk.services.entityresolution.paginators.ListMatchingJobsPublisher;
import software.amazon.awssdk.services.entityresolution.paginators.ListMatchingWorkflowsPublisher;
import software.amazon.awssdk.services.entityresolution.paginators.ListProviderServicesPublisher;
import software.amazon.awssdk.services.entityresolution.paginators.ListSchemaMappingsPublisher;

/**
 * Service client for accessing AWSEntityResolution asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@link SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Welcome to the <i>Entity Resolution API Reference</i>.
 * </p>
 * <p>
 * Entity Resolution is an Amazon Web Services service that provides pre-configured entity resolution capabilities that
 * enable developers and analysts at advertising and marketing companies to build an accurate and complete view of their
 * consumers.
 * </p>
 * <p>
 * With Entity Resolution, you can match source records containing consumer identifiers, such as name, email address,
 * and phone number. This is true even when these records have incomplete or conflicting identifiers. For example,
 * Entity Resolution can effectively match a source record from a customer relationship management (CRM) system with a
 * source record from a marketing system containing campaign information.
 * </p>
 * <p>
 * To learn more about Entity Resolution concepts, procedures, and best practices, see the <a
 * href="https://docs.aws.amazon.com/entityresolution/latest/userguide/what-is-service.html">Entity Resolution User
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface EntityResolutionAsyncClient extends AwsClient {
    String SERVICE_NAME = "entityresolution";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "entityresolution";

    /**
     * <p>
     * Creates an <code>IdMappingWorkflow</code> object which stores the configuration of the data processing job to be
     * run. Each <code>IdMappingWorkflow</code> must have a unique workflow name. To modify an existing workflow, use
     * the <code>UpdateIdMappingWorkflow</code> API.
     * </p>
     *
     * @param createIdMappingWorkflowRequest
     * @return A Java Future containing the result of the CreateIdMappingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current Entity Resolution account limits. The error message describes the limit exceeded.
     *         <code>HTTP Status Code: 402</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.CreateIdMappingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateIdMappingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIdMappingWorkflowResponse> createIdMappingWorkflow(
            CreateIdMappingWorkflowRequest createIdMappingWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <code>IdMappingWorkflow</code> object which stores the configuration of the data processing job to be
     * run. Each <code>IdMappingWorkflow</code> must have a unique workflow name. To modify an existing workflow, use
     * the <code>UpdateIdMappingWorkflow</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIdMappingWorkflowRequest.Builder} avoiding
     * the need to create one manually via {@link CreateIdMappingWorkflowRequest#builder()}
     * </p>
     *
     * @param createIdMappingWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.CreateIdMappingWorkflowRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateIdMappingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current Entity Resolution account limits. The error message describes the limit exceeded.
     *         <code>HTTP Status Code: 402</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.CreateIdMappingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateIdMappingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIdMappingWorkflowResponse> createIdMappingWorkflow(
            Consumer<CreateIdMappingWorkflowRequest.Builder> createIdMappingWorkflowRequest) {
        return createIdMappingWorkflow(CreateIdMappingWorkflowRequest.builder().applyMutation(createIdMappingWorkflowRequest)
                .build());
    }

    /**
     * <p>
     * Creates a <code>MatchingWorkflow</code> object which stores the configuration of the data processing job to be
     * run. It is important to note that there should not be a pre-existing <code>MatchingWorkflow</code> with the same
     * name. To modify an existing workflow, utilize the <code>UpdateMatchingWorkflow</code> API.
     * </p>
     *
     * @param createMatchingWorkflowRequest
     * @return A Java Future containing the result of the CreateMatchingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current Entity Resolution account limits. The error message describes the limit exceeded.
     *         <code>HTTP Status Code: 402</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.CreateMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMatchingWorkflowResponse> createMatchingWorkflow(
            CreateMatchingWorkflowRequest createMatchingWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>MatchingWorkflow</code> object which stores the configuration of the data processing job to be
     * run. It is important to note that there should not be a pre-existing <code>MatchingWorkflow</code> with the same
     * name. To modify an existing workflow, utilize the <code>UpdateMatchingWorkflow</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMatchingWorkflowRequest.Builder} avoiding the
     * need to create one manually via {@link CreateMatchingWorkflowRequest#builder()}
     * </p>
     *
     * @param createMatchingWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.CreateMatchingWorkflowRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateMatchingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current Entity Resolution account limits. The error message describes the limit exceeded.
     *         <code>HTTP Status Code: 402</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.CreateMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMatchingWorkflowResponse> createMatchingWorkflow(
            Consumer<CreateMatchingWorkflowRequest.Builder> createMatchingWorkflowRequest) {
        return createMatchingWorkflow(CreateMatchingWorkflowRequest.builder().applyMutation(createMatchingWorkflowRequest)
                .build());
    }

    /**
     * <p>
     * Creates a schema mapping, which defines the schema of the input customer records table. The
     * <code>SchemaMapping</code> also provides Entity Resolution with some metadata about the table, such as the
     * attribute types of the columns and which columns to match on.
     * </p>
     *
     * @param createSchemaMappingRequest
     * @return A Java Future containing the result of the CreateSchemaMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current Entity Resolution account limits. The error message describes the limit exceeded.
     *         <code>HTTP Status Code: 402</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.CreateSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSchemaMappingResponse> createSchemaMapping(
            CreateSchemaMappingRequest createSchemaMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a schema mapping, which defines the schema of the input customer records table. The
     * <code>SchemaMapping</code> also provides Entity Resolution with some metadata about the table, such as the
     * attribute types of the columns and which columns to match on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSchemaMappingRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSchemaMappingRequest#builder()}
     * </p>
     *
     * @param createSchemaMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.CreateSchemaMappingRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateSchemaMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current Entity Resolution account limits. The error message describes the limit exceeded.
     *         <code>HTTP Status Code: 402</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.CreateSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSchemaMappingResponse> createSchemaMapping(
            Consumer<CreateSchemaMappingRequest.Builder> createSchemaMappingRequest) {
        return createSchemaMapping(CreateSchemaMappingRequest.builder().applyMutation(createSchemaMappingRequest).build());
    }

    /**
     * <p>
     * Deletes the <code>IdMappingWorkflow</code> with a given name. This operation will succeed even if a workflow with
     * the given name does not exist.
     * </p>
     *
     * @param deleteIdMappingWorkflowRequest
     * @return A Java Future containing the result of the DeleteIdMappingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.DeleteIdMappingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteIdMappingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIdMappingWorkflowResponse> deleteIdMappingWorkflow(
            DeleteIdMappingWorkflowRequest deleteIdMappingWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the <code>IdMappingWorkflow</code> with a given name. This operation will succeed even if a workflow with
     * the given name does not exist.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIdMappingWorkflowRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteIdMappingWorkflowRequest#builder()}
     * </p>
     *
     * @param deleteIdMappingWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.DeleteIdMappingWorkflowRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteIdMappingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.DeleteIdMappingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteIdMappingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIdMappingWorkflowResponse> deleteIdMappingWorkflow(
            Consumer<DeleteIdMappingWorkflowRequest.Builder> deleteIdMappingWorkflowRequest) {
        return deleteIdMappingWorkflow(DeleteIdMappingWorkflowRequest.builder().applyMutation(deleteIdMappingWorkflowRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the <code>MatchingWorkflow</code> with a given name. This operation will succeed even if a workflow with
     * the given name does not exist.
     * </p>
     *
     * @param deleteMatchingWorkflowRequest
     * @return A Java Future containing the result of the DeleteMatchingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.DeleteMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMatchingWorkflowResponse> deleteMatchingWorkflow(
            DeleteMatchingWorkflowRequest deleteMatchingWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the <code>MatchingWorkflow</code> with a given name. This operation will succeed even if a workflow with
     * the given name does not exist.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMatchingWorkflowRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMatchingWorkflowRequest#builder()}
     * </p>
     *
     * @param deleteMatchingWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.DeleteMatchingWorkflowRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteMatchingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.DeleteMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMatchingWorkflowResponse> deleteMatchingWorkflow(
            Consumer<DeleteMatchingWorkflowRequest.Builder> deleteMatchingWorkflowRequest) {
        return deleteMatchingWorkflow(DeleteMatchingWorkflowRequest.builder().applyMutation(deleteMatchingWorkflowRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the <code>SchemaMapping</code> with a given name. This operation will succeed even if a schema with the
     * given name does not exist. This operation will fail if there is a <code>MatchingWorkflow</code> object that
     * references the <code>SchemaMapping</code> in the workflow's <code>InputSourceConfig</code>.
     * </p>
     *
     * @param deleteSchemaMappingRequest
     * @return A Java Future containing the result of the DeleteSchemaMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.DeleteSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSchemaMappingResponse> deleteSchemaMapping(
            DeleteSchemaMappingRequest deleteSchemaMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the <code>SchemaMapping</code> with a given name. This operation will succeed even if a schema with the
     * given name does not exist. This operation will fail if there is a <code>MatchingWorkflow</code> object that
     * references the <code>SchemaMapping</code> in the workflow's <code>InputSourceConfig</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSchemaMappingRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSchemaMappingRequest#builder()}
     * </p>
     *
     * @param deleteSchemaMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.DeleteSchemaMappingRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteSchemaMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.DeleteSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSchemaMappingResponse> deleteSchemaMapping(
            Consumer<DeleteSchemaMappingRequest.Builder> deleteSchemaMappingRequest) {
        return deleteSchemaMapping(DeleteSchemaMappingRequest.builder().applyMutation(deleteSchemaMappingRequest).build());
    }

    /**
     * <p>
     * Gets the status, metrics, and errors (if there are any) that are associated with a job.
     * </p>
     *
     * @param getIdMappingJobRequest
     * @return A Java Future containing the result of the GetIdMappingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetIdMappingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetIdMappingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdMappingJobResponse> getIdMappingJob(GetIdMappingJobRequest getIdMappingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status, metrics, and errors (if there are any) that are associated with a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdMappingJobRequest.Builder} avoiding the need
     * to create one manually via {@link GetIdMappingJobRequest#builder()}
     * </p>
     *
     * @param getIdMappingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.GetIdMappingJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetIdMappingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetIdMappingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetIdMappingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdMappingJobResponse> getIdMappingJob(
            Consumer<GetIdMappingJobRequest.Builder> getIdMappingJobRequest) {
        return getIdMappingJob(GetIdMappingJobRequest.builder().applyMutation(getIdMappingJobRequest).build());
    }

    /**
     * <p>
     * Returns the <code>IdMappingWorkflow</code> with a given name, if it exists.
     * </p>
     *
     * @param getIdMappingWorkflowRequest
     * @return A Java Future containing the result of the GetIdMappingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetIdMappingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetIdMappingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdMappingWorkflowResponse> getIdMappingWorkflow(
            GetIdMappingWorkflowRequest getIdMappingWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the <code>IdMappingWorkflow</code> with a given name, if it exists.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdMappingWorkflowRequest.Builder} avoiding the
     * need to create one manually via {@link GetIdMappingWorkflowRequest#builder()}
     * </p>
     *
     * @param getIdMappingWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.GetIdMappingWorkflowRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetIdMappingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetIdMappingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetIdMappingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdMappingWorkflowResponse> getIdMappingWorkflow(
            Consumer<GetIdMappingWorkflowRequest.Builder> getIdMappingWorkflowRequest) {
        return getIdMappingWorkflow(GetIdMappingWorkflowRequest.builder().applyMutation(getIdMappingWorkflowRequest).build());
    }

    /**
     * <p>
     * Returns the corresponding Match ID of a customer record if the record has been processed.
     * </p>
     *
     * @param getMatchIdRequest
     * @return A Java Future containing the result of the GetMatchId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetMatchId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchId" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMatchIdResponse> getMatchId(GetMatchIdRequest getMatchIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the corresponding Match ID of a customer record if the record has been processed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMatchIdRequest.Builder} avoiding the need to
     * create one manually via {@link GetMatchIdRequest#builder()}
     * </p>
     *
     * @param getMatchIdRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.GetMatchIdRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMatchId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetMatchId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchId" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMatchIdResponse> getMatchId(Consumer<GetMatchIdRequest.Builder> getMatchIdRequest) {
        return getMatchId(GetMatchIdRequest.builder().applyMutation(getMatchIdRequest).build());
    }

    /**
     * <p>
     * Gets the status, metrics, and errors (if there are any) that are associated with a job.
     * </p>
     *
     * @param getMatchingJobRequest
     * @return A Java Future containing the result of the GetMatchingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetMatchingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMatchingJobResponse> getMatchingJob(GetMatchingJobRequest getMatchingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status, metrics, and errors (if there are any) that are associated with a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMatchingJobRequest.Builder} avoiding the need to
     * create one manually via {@link GetMatchingJobRequest#builder()}
     * </p>
     *
     * @param getMatchingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.GetMatchingJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMatchingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetMatchingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMatchingJobResponse> getMatchingJob(Consumer<GetMatchingJobRequest.Builder> getMatchingJobRequest) {
        return getMatchingJob(GetMatchingJobRequest.builder().applyMutation(getMatchingJobRequest).build());
    }

    /**
     * <p>
     * Returns the <code>MatchingWorkflow</code> with a given name, if it exists.
     * </p>
     *
     * @param getMatchingWorkflowRequest
     * @return A Java Future containing the result of the GetMatchingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMatchingWorkflowResponse> getMatchingWorkflow(
            GetMatchingWorkflowRequest getMatchingWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the <code>MatchingWorkflow</code> with a given name, if it exists.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMatchingWorkflowRequest.Builder} avoiding the
     * need to create one manually via {@link GetMatchingWorkflowRequest#builder()}
     * </p>
     *
     * @param getMatchingWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.GetMatchingWorkflowRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetMatchingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMatchingWorkflowResponse> getMatchingWorkflow(
            Consumer<GetMatchingWorkflowRequest.Builder> getMatchingWorkflowRequest) {
        return getMatchingWorkflow(GetMatchingWorkflowRequest.builder().applyMutation(getMatchingWorkflowRequest).build());
    }

    /**
     * <p>
     * Returns the <code>ProviderService</code> of a given name.
     * </p>
     *
     * @param getProviderServiceRequest
     * @return A Java Future containing the result of the GetProviderService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetProviderService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetProviderService"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetProviderServiceResponse> getProviderService(GetProviderServiceRequest getProviderServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the <code>ProviderService</code> of a given name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProviderServiceRequest.Builder} avoiding the
     * need to create one manually via {@link GetProviderServiceRequest#builder()}
     * </p>
     *
     * @param getProviderServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.GetProviderServiceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetProviderService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetProviderService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetProviderService"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetProviderServiceResponse> getProviderService(
            Consumer<GetProviderServiceRequest.Builder> getProviderServiceRequest) {
        return getProviderService(GetProviderServiceRequest.builder().applyMutation(getProviderServiceRequest).build());
    }

    /**
     * <p>
     * Returns the SchemaMapping of a given name.
     * </p>
     *
     * @param getSchemaMappingRequest
     * @return A Java Future containing the result of the GetSchemaMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSchemaMappingResponse> getSchemaMapping(GetSchemaMappingRequest getSchemaMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the SchemaMapping of a given name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSchemaMappingRequest.Builder} avoiding the need
     * to create one manually via {@link GetSchemaMappingRequest#builder()}
     * </p>
     *
     * @param getSchemaMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.GetSchemaMappingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSchemaMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSchemaMappingResponse> getSchemaMapping(
            Consumer<GetSchemaMappingRequest.Builder> getSchemaMappingRequest) {
        return getSchemaMapping(GetSchemaMappingRequest.builder().applyMutation(getSchemaMappingRequest).build());
    }

    /**
     * <p>
     * Lists all ID mapping jobs for a given workflow.
     * </p>
     *
     * @param listIdMappingJobsRequest
     * @return A Java Future containing the result of the ListIdMappingJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListIdMappingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListIdMappingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIdMappingJobsResponse> listIdMappingJobs(ListIdMappingJobsRequest listIdMappingJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all ID mapping jobs for a given workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdMappingJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListIdMappingJobsRequest#builder()}
     * </p>
     *
     * @param listIdMappingJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListIdMappingJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListIdMappingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListIdMappingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIdMappingJobsResponse> listIdMappingJobs(
            Consumer<ListIdMappingJobsRequest.Builder> listIdMappingJobsRequest) {
        return listIdMappingJobs(ListIdMappingJobsRequest.builder().applyMutation(listIdMappingJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIdMappingJobs(software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListIdMappingJobsPublisher publisher = client.listIdMappingJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListIdMappingJobsPublisher publisher = client.listIdMappingJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdMappingJobs(software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIdMappingJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListIdMappingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListIdMappingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdMappingJobsPublisher listIdMappingJobsPaginator(ListIdMappingJobsRequest listIdMappingJobsRequest) {
        return new ListIdMappingJobsPublisher(this, listIdMappingJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIdMappingJobs(software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListIdMappingJobsPublisher publisher = client.listIdMappingJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListIdMappingJobsPublisher publisher = client.listIdMappingJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdMappingJobs(software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdMappingJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListIdMappingJobsRequest#builder()}
     * </p>
     *
     * @param listIdMappingJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListIdMappingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListIdMappingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdMappingJobsPublisher listIdMappingJobsPaginator(
            Consumer<ListIdMappingJobsRequest.Builder> listIdMappingJobsRequest) {
        return listIdMappingJobsPaginator(ListIdMappingJobsRequest.builder().applyMutation(listIdMappingJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the <code>IdMappingWorkflows</code> that have been created for an Amazon Web Services
     * account.
     * </p>
     *
     * @param listIdMappingWorkflowsRequest
     * @return A Java Future containing the result of the ListIdMappingWorkflows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListIdMappingWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListIdMappingWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIdMappingWorkflowsResponse> listIdMappingWorkflows(
            ListIdMappingWorkflowsRequest listIdMappingWorkflowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the <code>IdMappingWorkflows</code> that have been created for an Amazon Web Services
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdMappingWorkflowsRequest.Builder} avoiding the
     * need to create one manually via {@link ListIdMappingWorkflowsRequest#builder()}
     * </p>
     *
     * @param listIdMappingWorkflowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListIdMappingWorkflows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListIdMappingWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListIdMappingWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIdMappingWorkflowsResponse> listIdMappingWorkflows(
            Consumer<ListIdMappingWorkflowsRequest.Builder> listIdMappingWorkflowsRequest) {
        return listIdMappingWorkflows(ListIdMappingWorkflowsRequest.builder().applyMutation(listIdMappingWorkflowsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIdMappingWorkflows(software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListIdMappingWorkflowsPublisher publisher = client.listIdMappingWorkflowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListIdMappingWorkflowsPublisher publisher = client.listIdMappingWorkflowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdMappingWorkflows(software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIdMappingWorkflowsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListIdMappingWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListIdMappingWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdMappingWorkflowsPublisher listIdMappingWorkflowsPaginator(
            ListIdMappingWorkflowsRequest listIdMappingWorkflowsRequest) {
        return new ListIdMappingWorkflowsPublisher(this, listIdMappingWorkflowsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIdMappingWorkflows(software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListIdMappingWorkflowsPublisher publisher = client.listIdMappingWorkflowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListIdMappingWorkflowsPublisher publisher = client.listIdMappingWorkflowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdMappingWorkflows(software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdMappingWorkflowsRequest.Builder} avoiding the
     * need to create one manually via {@link ListIdMappingWorkflowsRequest#builder()}
     * </p>
     *
     * @param listIdMappingWorkflowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListIdMappingWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListIdMappingWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdMappingWorkflowsPublisher listIdMappingWorkflowsPaginator(
            Consumer<ListIdMappingWorkflowsRequest.Builder> listIdMappingWorkflowsRequest) {
        return listIdMappingWorkflowsPaginator(ListIdMappingWorkflowsRequest.builder()
                .applyMutation(listIdMappingWorkflowsRequest).build());
    }

    /**
     * <p>
     * Lists all jobs for a given workflow.
     * </p>
     *
     * @param listMatchingJobsRequest
     * @return A Java Future containing the result of the ListMatchingJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListMatchingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMatchingJobsResponse> listMatchingJobs(ListMatchingJobsRequest listMatchingJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all jobs for a given workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMatchingJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMatchingJobsRequest#builder()}
     * </p>
     *
     * @param listMatchingJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListMatchingJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListMatchingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMatchingJobsResponse> listMatchingJobs(
            Consumer<ListMatchingJobsRequest.Builder> listMatchingJobsRequest) {
        return listMatchingJobs(ListMatchingJobsRequest.builder().applyMutation(listMatchingJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMatchingJobs(software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListMatchingJobsPublisher publisher = client.listMatchingJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListMatchingJobsPublisher publisher = client.listMatchingJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMatchingJobs(software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMatchingJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListMatchingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMatchingJobsPublisher listMatchingJobsPaginator(ListMatchingJobsRequest listMatchingJobsRequest) {
        return new ListMatchingJobsPublisher(this, listMatchingJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMatchingJobs(software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListMatchingJobsPublisher publisher = client.listMatchingJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListMatchingJobsPublisher publisher = client.listMatchingJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMatchingJobs(software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMatchingJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMatchingJobsRequest#builder()}
     * </p>
     *
     * @param listMatchingJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListMatchingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMatchingJobsPublisher listMatchingJobsPaginator(Consumer<ListMatchingJobsRequest.Builder> listMatchingJobsRequest) {
        return listMatchingJobsPaginator(ListMatchingJobsRequest.builder().applyMutation(listMatchingJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the <code>MatchingWorkflows</code> that have been created for an Amazon Web Services
     * account.
     * </p>
     *
     * @param listMatchingWorkflowsRequest
     * @return A Java Future containing the result of the ListMatchingWorkflows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListMatchingWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMatchingWorkflowsResponse> listMatchingWorkflows(
            ListMatchingWorkflowsRequest listMatchingWorkflowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the <code>MatchingWorkflows</code> that have been created for an Amazon Web Services
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMatchingWorkflowsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMatchingWorkflowsRequest#builder()}
     * </p>
     *
     * @param listMatchingWorkflowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListMatchingWorkflows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListMatchingWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMatchingWorkflowsResponse> listMatchingWorkflows(
            Consumer<ListMatchingWorkflowsRequest.Builder> listMatchingWorkflowsRequest) {
        return listMatchingWorkflows(ListMatchingWorkflowsRequest.builder().applyMutation(listMatchingWorkflowsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMatchingWorkflows(software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListMatchingWorkflowsPublisher publisher = client.listMatchingWorkflowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListMatchingWorkflowsPublisher publisher = client.listMatchingWorkflowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMatchingWorkflows(software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMatchingWorkflowsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListMatchingWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMatchingWorkflowsPublisher listMatchingWorkflowsPaginator(
            ListMatchingWorkflowsRequest listMatchingWorkflowsRequest) {
        return new ListMatchingWorkflowsPublisher(this, listMatchingWorkflowsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMatchingWorkflows(software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListMatchingWorkflowsPublisher publisher = client.listMatchingWorkflowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListMatchingWorkflowsPublisher publisher = client.listMatchingWorkflowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMatchingWorkflows(software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMatchingWorkflowsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMatchingWorkflowsRequest#builder()}
     * </p>
     *
     * @param listMatchingWorkflowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListMatchingWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMatchingWorkflowsPublisher listMatchingWorkflowsPaginator(
            Consumer<ListMatchingWorkflowsRequest.Builder> listMatchingWorkflowsRequest) {
        return listMatchingWorkflowsPaginator(ListMatchingWorkflowsRequest.builder().applyMutation(listMatchingWorkflowsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of all the <code>ProviderServices</code> that are available in this Amazon Web Services Region.
     * </p>
     *
     * @param listProviderServicesRequest
     * @return A Java Future containing the result of the ListProviderServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListProviderServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListProviderServices"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProviderServicesResponse> listProviderServices(
            ListProviderServicesRequest listProviderServicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the <code>ProviderServices</code> that are available in this Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProviderServicesRequest.Builder} avoiding the
     * need to create one manually via {@link ListProviderServicesRequest#builder()}
     * </p>
     *
     * @param listProviderServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.ListProviderServicesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListProviderServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListProviderServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListProviderServices"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProviderServicesResponse> listProviderServices(
            Consumer<ListProviderServicesRequest.Builder> listProviderServicesRequest) {
        return listProviderServices(ListProviderServicesRequest.builder().applyMutation(listProviderServicesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProviderServices(software.amazon.awssdk.services.entityresolution.model.ListProviderServicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListProviderServicesPublisher publisher = client.listProviderServicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListProviderServicesPublisher publisher = client.listProviderServicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.entityresolution.model.ListProviderServicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.entityresolution.model.ListProviderServicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProviderServices(software.amazon.awssdk.services.entityresolution.model.ListProviderServicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProviderServicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListProviderServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListProviderServices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProviderServicesPublisher listProviderServicesPaginator(ListProviderServicesRequest listProviderServicesRequest) {
        return new ListProviderServicesPublisher(this, listProviderServicesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProviderServices(software.amazon.awssdk.services.entityresolution.model.ListProviderServicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListProviderServicesPublisher publisher = client.listProviderServicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListProviderServicesPublisher publisher = client.listProviderServicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.entityresolution.model.ListProviderServicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.entityresolution.model.ListProviderServicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProviderServices(software.amazon.awssdk.services.entityresolution.model.ListProviderServicesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProviderServicesRequest.Builder} avoiding the
     * need to create one manually via {@link ListProviderServicesRequest#builder()}
     * </p>
     *
     * @param listProviderServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.ListProviderServicesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListProviderServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListProviderServices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProviderServicesPublisher listProviderServicesPaginator(
            Consumer<ListProviderServicesRequest.Builder> listProviderServicesRequest) {
        return listProviderServicesPaginator(ListProviderServicesRequest.builder().applyMutation(listProviderServicesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of all the <code>SchemaMappings</code> that have been created for an Amazon Web Services account.
     * </p>
     *
     * @param listSchemaMappingsRequest
     * @return A Java Future containing the result of the ListSchemaMappings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListSchemaMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListSchemaMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSchemaMappingsResponse> listSchemaMappings(ListSchemaMappingsRequest listSchemaMappingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the <code>SchemaMappings</code> that have been created for an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemaMappingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSchemaMappingsRequest#builder()}
     * </p>
     *
     * @param listSchemaMappingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListSchemaMappings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListSchemaMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListSchemaMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSchemaMappingsResponse> listSchemaMappings(
            Consumer<ListSchemaMappingsRequest.Builder> listSchemaMappingsRequest) {
        return listSchemaMappings(ListSchemaMappingsRequest.builder().applyMutation(listSchemaMappingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSchemaMappings(software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListSchemaMappingsPublisher publisher = client.listSchemaMappingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListSchemaMappingsPublisher publisher = client.listSchemaMappingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemaMappings(software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSchemaMappingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListSchemaMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListSchemaMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSchemaMappingsPublisher listSchemaMappingsPaginator(ListSchemaMappingsRequest listSchemaMappingsRequest) {
        return new ListSchemaMappingsPublisher(this, listSchemaMappingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSchemaMappings(software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListSchemaMappingsPublisher publisher = client.listSchemaMappingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.entityresolution.paginators.ListSchemaMappingsPublisher publisher = client.listSchemaMappingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemaMappings(software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemaMappingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSchemaMappingsRequest#builder()}
     * </p>
     *
     * @param listSchemaMappingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListSchemaMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListSchemaMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSchemaMappingsPublisher listSchemaMappingsPaginator(
            Consumer<ListSchemaMappingsRequest.Builder> listSchemaMappingsRequest) {
        return listSchemaMappingsPaginator(ListSchemaMappingsRequest.builder().applyMutation(listSchemaMappingsRequest).build());
    }

    /**
     * <p>
     * Displays the tags associated with an Entity Resolution resource. In Entity Resolution, <code>SchemaMapping</code>
     * , and <code>MatchingWorkflow</code> can be tagged.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the tags associated with an Entity Resolution resource. In Entity Resolution, <code>SchemaMapping</code>
     * , and <code>MatchingWorkflow</code> can be tagged.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts the <code>IdMappingJob</code> of a workflow. The workflow must have previously been created using the
     * <code>CreateIdMappingWorkflow</code> endpoint.
     * </p>
     *
     * @param startIdMappingJobRequest
     * @return A Java Future containing the result of the StartIdMappingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current Entity Resolution account limits. The error message describes the limit exceeded.
     *         <code>HTTP Status Code: 402</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.StartIdMappingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/StartIdMappingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartIdMappingJobResponse> startIdMappingJob(StartIdMappingJobRequest startIdMappingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the <code>IdMappingJob</code> of a workflow. The workflow must have previously been created using the
     * <code>CreateIdMappingWorkflow</code> endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartIdMappingJobRequest.Builder} avoiding the need
     * to create one manually via {@link StartIdMappingJobRequest#builder()}
     * </p>
     *
     * @param startIdMappingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.StartIdMappingJobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StartIdMappingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current Entity Resolution account limits. The error message describes the limit exceeded.
     *         <code>HTTP Status Code: 402</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.StartIdMappingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/StartIdMappingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartIdMappingJobResponse> startIdMappingJob(
            Consumer<StartIdMappingJobRequest.Builder> startIdMappingJobRequest) {
        return startIdMappingJob(StartIdMappingJobRequest.builder().applyMutation(startIdMappingJobRequest).build());
    }

    /**
     * <p>
     * Starts the <code>MatchingJob</code> of a workflow. The workflow must have previously been created using the
     * <code>CreateMatchingWorkflow</code> endpoint.
     * </p>
     *
     * @param startMatchingJobRequest
     * @return A Java Future containing the result of the StartMatchingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current Entity Resolution account limits. The error message describes the limit exceeded.
     *         <code>HTTP Status Code: 402</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.StartMatchingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/StartMatchingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMatchingJobResponse> startMatchingJob(StartMatchingJobRequest startMatchingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the <code>MatchingJob</code> of a workflow. The workflow must have previously been created using the
     * <code>CreateMatchingWorkflow</code> endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMatchingJobRequest.Builder} avoiding the need
     * to create one manually via {@link StartMatchingJobRequest#builder()}
     * </p>
     *
     * @param startMatchingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.StartMatchingJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartMatchingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current Entity Resolution account limits. The error message describes the limit exceeded.
     *         <code>HTTP Status Code: 402</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.StartMatchingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/StartMatchingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMatchingJobResponse> startMatchingJob(
            Consumer<StartMatchingJobRequest.Builder> startMatchingJobRequest) {
        return startMatchingJob(StartMatchingJobRequest.builder().applyMutation(startMatchingJobRequest).build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified Entity Resolution resource. Tags can help you
     * organize and categorize your resources. You can also use them to scope user permissions by granting a user
     * permission to access or change only resources with certain tag values. In Entity Resolution,
     * <code>SchemaMapping</code> and <code>MatchingWorkflow</code> can be tagged. Tags don't have any semantic meaning
     * to Amazon Web Services and are interpreted strictly as strings of characters. You can use the
     * <code>TagResource</code> action with a resource that already has tags. If you specify a new tag key, this tag is
     * appended to the list of tags associated with the resource. If you specify a tag key that is already associated
     * with the resource, the new tag value that you specify replaces the previous value for that tag.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified Entity Resolution resource. Tags can help you
     * organize and categorize your resources. You can also use them to scope user permissions by granting a user
     * permission to access or change only resources with certain tag values. In Entity Resolution,
     * <code>SchemaMapping</code> and <code>MatchingWorkflow</code> can be tagged. Tags don't have any semantic meaning
     * to Amazon Web Services and are interpreted strictly as strings of characters. You can use the
     * <code>TagResource</code> action with a resource that already has tags. If you specify a new tag key, this tag is
     * appended to the list of tags associated with the resource. If you specify a tag key that is already associated
     * with the resource, the new tag value that you specify replaces the previous value for that tag.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified Entity Resolution resource. In Entity Resolution,
     * <code>SchemaMapping</code>, and <code>MatchingWorkflow</code> can be tagged.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified Entity Resolution resource. In Entity Resolution,
     * <code>SchemaMapping</code>, and <code>MatchingWorkflow</code> can be tagged.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing <code>IdMappingWorkflow</code>. This method is identical to
     * <code>CreateIdMappingWorkflow</code>, except it uses an HTTP <code>PUT</code> request instead of a
     * <code>POST</code> request, and the <code>IdMappingWorkflow</code> must already exist for the method to succeed.
     * </p>
     *
     * @param updateIdMappingWorkflowRequest
     * @return A Java Future containing the result of the UpdateIdMappingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.UpdateIdMappingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateIdMappingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIdMappingWorkflowResponse> updateIdMappingWorkflow(
            UpdateIdMappingWorkflowRequest updateIdMappingWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing <code>IdMappingWorkflow</code>. This method is identical to
     * <code>CreateIdMappingWorkflow</code>, except it uses an HTTP <code>PUT</code> request instead of a
     * <code>POST</code> request, and the <code>IdMappingWorkflow</code> must already exist for the method to succeed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIdMappingWorkflowRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateIdMappingWorkflowRequest#builder()}
     * </p>
     *
     * @param updateIdMappingWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.UpdateIdMappingWorkflowRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateIdMappingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.UpdateIdMappingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateIdMappingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIdMappingWorkflowResponse> updateIdMappingWorkflow(
            Consumer<UpdateIdMappingWorkflowRequest.Builder> updateIdMappingWorkflowRequest) {
        return updateIdMappingWorkflow(UpdateIdMappingWorkflowRequest.builder().applyMutation(updateIdMappingWorkflowRequest)
                .build());
    }

    /**
     * <p>
     * Updates an existing <code>MatchingWorkflow</code>. This method is identical to
     * <code>CreateMatchingWorkflow</code>, except it uses an HTTP <code>PUT</code> request instead of a
     * <code>POST</code> request, and the <code>MatchingWorkflow</code> must already exist for the method to succeed.
     * </p>
     *
     * @param updateMatchingWorkflowRequest
     * @return A Java Future containing the result of the UpdateMatchingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.UpdateMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMatchingWorkflowResponse> updateMatchingWorkflow(
            UpdateMatchingWorkflowRequest updateMatchingWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing <code>MatchingWorkflow</code>. This method is identical to
     * <code>CreateMatchingWorkflow</code>, except it uses an HTTP <code>PUT</code> request instead of a
     * <code>POST</code> request, and the <code>MatchingWorkflow</code> must already exist for the method to succeed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMatchingWorkflowRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateMatchingWorkflowRequest#builder()}
     * </p>
     *
     * @param updateMatchingWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.UpdateMatchingWorkflowRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateMatchingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.UpdateMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMatchingWorkflowResponse> updateMatchingWorkflow(
            Consumer<UpdateMatchingWorkflowRequest.Builder> updateMatchingWorkflowRequest) {
        return updateMatchingWorkflow(UpdateMatchingWorkflowRequest.builder().applyMutation(updateMatchingWorkflowRequest)
                .build());
    }

    /**
     * <p>
     * Updates a schema mapping.
     * </p>
     * <note>
     * <p>
     * A schema is immutable if it is being used by a workflow. Therefore, you can't update a schema mapping if it's
     * associated with a workflow.
     * </p>
     * </note>
     *
     * @param updateSchemaMappingRequest
     * @return A Java Future containing the result of the UpdateSchemaMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.UpdateSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSchemaMappingResponse> updateSchemaMapping(
            UpdateSchemaMappingRequest updateSchemaMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a schema mapping.
     * </p>
     * <note>
     * <p>
     * A schema is immutable if it is being used by a workflow. Therefore, you can't update a schema mapping if it's
     * associated with a workflow.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSchemaMappingRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSchemaMappingRequest#builder()}
     * </p>
     *
     * @param updateSchemaMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.entityresolution.model.UpdateSchemaMappingRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateSchemaMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.
     *         <code>HTTP Status Code: 429</code></li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service. <code>HTTP Status Code: 500</code></li>
     *         <li>ResourceNotFoundException The resource could not be found. <code>HTTP Status Code: 404</code></li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.
     *         <code>HTTP Status Code: 403</code></li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.
     *         <code>HTTP Status Code: 400</code></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.UpdateSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSchemaMappingResponse> updateSchemaMapping(
            Consumer<UpdateSchemaMappingRequest.Builder> updateSchemaMappingRequest) {
        return updateSchemaMapping(UpdateSchemaMappingRequest.builder().applyMutation(updateSchemaMappingRequest).build());
    }

    @Override
    default EntityResolutionServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link EntityResolutionAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static EntityResolutionAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link EntityResolutionAsyncClient}.
     */
    static EntityResolutionAsyncClientBuilder builder() {
        return new DefaultEntityResolutionAsyncClientBuilder();
    }
}
