/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input schema supported by provider service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProviderComponentSchema implements SdkPojo, Serializable,
        ToCopyableBuilder<ProviderComponentSchema.Builder, ProviderComponentSchema> {
    private static final SdkField<List<ProviderSchemaAttribute>> PROVIDER_SCHEMA_ATTRIBUTES_FIELD = SdkField
            .<List<ProviderSchemaAttribute>> builder(MarshallingType.LIST)
            .memberName("providerSchemaAttributes")
            .getter(getter(ProviderComponentSchema::providerSchemaAttributes))
            .setter(setter(Builder::providerSchemaAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerSchemaAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProviderSchemaAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProviderSchemaAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<List<String>>> SCHEMAS_FIELD = SdkField
            .<List<List<String>>> builder(MarshallingType.LIST)
            .memberName("schemas")
            .getter(getter(ProviderComponentSchema::schemas))
            .setter(setter(Builder::schemas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROVIDER_SCHEMA_ATTRIBUTES_FIELD, SCHEMAS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ProviderSchemaAttribute> providerSchemaAttributes;

    private final List<List<String>> schemas;

    private ProviderComponentSchema(BuilderImpl builder) {
        this.providerSchemaAttributes = builder.providerSchemaAttributes;
        this.schemas = builder.schemas;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProviderSchemaAttributes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProviderSchemaAttributes() {
        return providerSchemaAttributes != null && !(providerSchemaAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The provider schema attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProviderSchemaAttributes} method.
     * </p>
     * 
     * @return The provider schema attributes.
     */
    public final List<ProviderSchemaAttribute> providerSchemaAttributes() {
        return providerSchemaAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Schemas property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSchemas() {
        return schemas != null && !(schemas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Input schema for the provider service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSchemas} method.
     * </p>
     * 
     * @return Input schema for the provider service.
     */
    public final List<List<String>> schemas() {
        return schemas;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasProviderSchemaAttributes() ? providerSchemaAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSchemas() ? schemas() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderComponentSchema)) {
            return false;
        }
        ProviderComponentSchema other = (ProviderComponentSchema) obj;
        return hasProviderSchemaAttributes() == other.hasProviderSchemaAttributes()
                && Objects.equals(providerSchemaAttributes(), other.providerSchemaAttributes())
                && hasSchemas() == other.hasSchemas() && Objects.equals(schemas(), other.schemas());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProviderComponentSchema")
                .add("ProviderSchemaAttributes", hasProviderSchemaAttributes() ? providerSchemaAttributes() : null)
                .add("Schemas", hasSchemas() ? schemas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "providerSchemaAttributes":
            return Optional.ofNullable(clazz.cast(providerSchemaAttributes()));
        case "schemas":
            return Optional.ofNullable(clazz.cast(schemas()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProviderComponentSchema, T> g) {
        return obj -> g.apply((ProviderComponentSchema) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProviderComponentSchema> {
        /**
         * <p>
         * The provider schema attributes.
         * </p>
         * 
         * @param providerSchemaAttributes
         *        The provider schema attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerSchemaAttributes(Collection<ProviderSchemaAttribute> providerSchemaAttributes);

        /**
         * <p>
         * The provider schema attributes.
         * </p>
         * 
         * @param providerSchemaAttributes
         *        The provider schema attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerSchemaAttributes(ProviderSchemaAttribute... providerSchemaAttributes);

        /**
         * <p>
         * The provider schema attributes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.ProviderSchemaAttribute.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.entityresolution.model.ProviderSchemaAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.ProviderSchemaAttribute.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #providerSchemaAttributes(List<ProviderSchemaAttribute>)}.
         * 
         * @param providerSchemaAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.ProviderSchemaAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #providerSchemaAttributes(java.util.Collection<ProviderSchemaAttribute>)
         */
        Builder providerSchemaAttributes(Consumer<ProviderSchemaAttribute.Builder>... providerSchemaAttributes);

        /**
         * <p>
         * Input schema for the provider service.
         * </p>
         * 
         * @param schemas
         *        Input schema for the provider service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemas(Collection<? extends Collection<String>> schemas);

        /**
         * <p>
         * Input schema for the provider service.
         * </p>
         * 
         * @param schemas
         *        Input schema for the provider service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemas(Collection<String>... schemas);
    }

    static final class BuilderImpl implements Builder {
        private List<ProviderSchemaAttribute> providerSchemaAttributes = DefaultSdkAutoConstructList.getInstance();

        private List<List<String>> schemas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderComponentSchema model) {
            providerSchemaAttributes(model.providerSchemaAttributes);
            schemas(model.schemas);
        }

        public final List<ProviderSchemaAttribute.Builder> getProviderSchemaAttributes() {
            List<ProviderSchemaAttribute.Builder> result = ProviderSchemaAttributesCopier
                    .copyToBuilder(this.providerSchemaAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProviderSchemaAttributes(Collection<ProviderSchemaAttribute.BuilderImpl> providerSchemaAttributes) {
            this.providerSchemaAttributes = ProviderSchemaAttributesCopier.copyFromBuilder(providerSchemaAttributes);
        }

        @Override
        public final Builder providerSchemaAttributes(Collection<ProviderSchemaAttribute> providerSchemaAttributes) {
            this.providerSchemaAttributes = ProviderSchemaAttributesCopier.copy(providerSchemaAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerSchemaAttributes(ProviderSchemaAttribute... providerSchemaAttributes) {
            providerSchemaAttributes(Arrays.asList(providerSchemaAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerSchemaAttributes(Consumer<ProviderSchemaAttribute.Builder>... providerSchemaAttributes) {
            providerSchemaAttributes(Stream.of(providerSchemaAttributes)
                    .map(c -> ProviderSchemaAttribute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<? extends Collection<String>> getSchemas() {
            if (schemas instanceof SdkAutoConstructList) {
                return null;
            }
            return schemas;
        }

        public final void setSchemas(Collection<? extends Collection<String>> schemas) {
            this.schemas = SchemasCopier.copy(schemas);
        }

        @Override
        public final Builder schemas(Collection<? extends Collection<String>> schemas) {
            this.schemas = SchemasCopier.copy(schemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(Collection<String>... schemas) {
            schemas(Arrays.asList(schemas));
            return this;
        }

        @Override
        public ProviderComponentSchema build() {
            return new ProviderComponentSchema(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
