/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartIdMappingJobResponse extends EntityResolutionResponse implements
        ToCopyableBuilder<StartIdMappingJobResponse.Builder, StartIdMappingJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(StartIdMappingJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<List<IdMappingJobOutputSource>> OUTPUT_SOURCE_CONFIG_FIELD = SdkField
            .<List<IdMappingJobOutputSource>> builder(MarshallingType.LIST)
            .memberName("outputSourceConfig")
            .getter(getter(StartIdMappingJobResponse::outputSourceConfig))
            .setter(setter(Builder::outputSourceConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSourceConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdMappingJobOutputSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdMappingJobOutputSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            OUTPUT_SOURCE_CONFIG_FIELD));

    private final String jobId;

    private final List<IdMappingJobOutputSource> outputSourceConfig;

    private StartIdMappingJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.outputSourceConfig = builder.outputSourceConfig;
    }

    /**
     * <p>
     * The ID of the job.
     * </p>
     * 
     * @return The ID of the job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputSourceConfig property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputSourceConfig() {
        return outputSourceConfig != null && !(outputSourceConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>OutputSource</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputSourceConfig} method.
     * </p>
     * 
     * @return A list of <code>OutputSource</code> objects.
     */
    public final List<IdMappingJobOutputSource> outputSourceConfig() {
        return outputSourceConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputSourceConfig() ? outputSourceConfig() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartIdMappingJobResponse)) {
            return false;
        }
        StartIdMappingJobResponse other = (StartIdMappingJobResponse) obj;
        return Objects.equals(jobId(), other.jobId()) && hasOutputSourceConfig() == other.hasOutputSourceConfig()
                && Objects.equals(outputSourceConfig(), other.outputSourceConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartIdMappingJobResponse").add("JobId", jobId())
                .add("OutputSourceConfig", hasOutputSourceConfig() ? outputSourceConfig() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "outputSourceConfig":
            return Optional.ofNullable(clazz.cast(outputSourceConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartIdMappingJobResponse, T> g) {
        return obj -> g.apply((StartIdMappingJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EntityResolutionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartIdMappingJobResponse> {
        /**
         * <p>
         * The ID of the job.
         * </p>
         * 
         * @param jobId
         *        The ID of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * A list of <code>OutputSource</code> objects.
         * </p>
         * 
         * @param outputSourceConfig
         *        A list of <code>OutputSource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSourceConfig(Collection<IdMappingJobOutputSource> outputSourceConfig);

        /**
         * <p>
         * A list of <code>OutputSource</code> objects.
         * </p>
         * 
         * @param outputSourceConfig
         *        A list of <code>OutputSource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSourceConfig(IdMappingJobOutputSource... outputSourceConfig);

        /**
         * <p>
         * A list of <code>OutputSource</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.IdMappingJobOutputSource.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.entityresolution.model.IdMappingJobOutputSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.IdMappingJobOutputSource.Builder#build()} is
         * called immediately and its result is passed to {@link #outputSourceConfig(List<IdMappingJobOutputSource>)}.
         * 
         * @param outputSourceConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.IdMappingJobOutputSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputSourceConfig(java.util.Collection<IdMappingJobOutputSource>)
         */
        Builder outputSourceConfig(Consumer<IdMappingJobOutputSource.Builder>... outputSourceConfig);
    }

    static final class BuilderImpl extends EntityResolutionResponse.BuilderImpl implements Builder {
        private String jobId;

        private List<IdMappingJobOutputSource> outputSourceConfig = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartIdMappingJobResponse model) {
            super(model);
            jobId(model.jobId);
            outputSourceConfig(model.outputSourceConfig);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final List<IdMappingJobOutputSource.Builder> getOutputSourceConfig() {
            List<IdMappingJobOutputSource.Builder> result = IdMappingJobOutputSourceConfigCopier
                    .copyToBuilder(this.outputSourceConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSourceConfig(Collection<IdMappingJobOutputSource.BuilderImpl> outputSourceConfig) {
            this.outputSourceConfig = IdMappingJobOutputSourceConfigCopier.copyFromBuilder(outputSourceConfig);
        }

        @Override
        public final Builder outputSourceConfig(Collection<IdMappingJobOutputSource> outputSourceConfig) {
            this.outputSourceConfig = IdMappingJobOutputSourceConfigCopier.copy(outputSourceConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(IdMappingJobOutputSource... outputSourceConfig) {
            outputSourceConfig(Arrays.asList(outputSourceConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(Consumer<IdMappingJobOutputSource.Builder>... outputSourceConfig) {
            outputSourceConfig(Stream.of(outputSourceConfig)
                    .map(c -> IdMappingJobOutputSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public StartIdMappingJobResponse build() {
            return new StartIdMappingJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
