/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The provider configuration required for different ID namespace types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProviderIdNameSpaceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ProviderIdNameSpaceConfiguration.Builder, ProviderIdNameSpaceConfiguration> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ProviderIdNameSpaceConfiguration::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Document> PROVIDER_SOURCE_CONFIGURATION_DEFINITION_FIELD = SdkField
            .<Document> builder(MarshallingType.DOCUMENT)
            .memberName("providerSourceConfigurationDefinition")
            .getter(getter(ProviderIdNameSpaceConfiguration::providerSourceConfigurationDefinition))
            .setter(setter(Builder::providerSourceConfigurationDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("providerSourceConfigurationDefinition").build()).build();

    private static final SdkField<Document> PROVIDER_TARGET_CONFIGURATION_DEFINITION_FIELD = SdkField
            .<Document> builder(MarshallingType.DOCUMENT)
            .memberName("providerTargetConfigurationDefinition")
            .getter(getter(ProviderIdNameSpaceConfiguration::providerTargetConfigurationDefinition))
            .setter(setter(Builder::providerTargetConfigurationDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("providerTargetConfigurationDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            PROVIDER_SOURCE_CONFIGURATION_DEFINITION_FIELD, PROVIDER_TARGET_CONFIGURATION_DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final Document providerSourceConfigurationDefinition;

    private final Document providerTargetConfigurationDefinition;

    private ProviderIdNameSpaceConfiguration(BuilderImpl builder) {
        this.description = builder.description;
        this.providerSourceConfigurationDefinition = builder.providerSourceConfigurationDefinition;
        this.providerTargetConfigurationDefinition = builder.providerTargetConfigurationDefinition;
    }

    /**
     * <p>
     * The description of the ID namespace.
     * </p>
     * 
     * @return The description of the ID namespace.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Configurations required for the source ID namespace.
     * </p>
     * 
     * @return Configurations required for the source ID namespace.
     */
    public final Document providerSourceConfigurationDefinition() {
        return providerSourceConfigurationDefinition;
    }

    /**
     * <p>
     * Configurations required for the target ID namespace.
     * </p>
     * 
     * @return Configurations required for the target ID namespace.
     */
    public final Document providerTargetConfigurationDefinition() {
        return providerTargetConfigurationDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(providerSourceConfigurationDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(providerTargetConfigurationDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderIdNameSpaceConfiguration)) {
            return false;
        }
        ProviderIdNameSpaceConfiguration other = (ProviderIdNameSpaceConfiguration) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(providerSourceConfigurationDefinition(), other.providerSourceConfigurationDefinition())
                && Objects.equals(providerTargetConfigurationDefinition(), other.providerTargetConfigurationDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProviderIdNameSpaceConfiguration").add("Description", description())
                .add("ProviderSourceConfigurationDefinition", providerSourceConfigurationDefinition())
                .add("ProviderTargetConfigurationDefinition", providerTargetConfigurationDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "providerSourceConfigurationDefinition":
            return Optional.ofNullable(clazz.cast(providerSourceConfigurationDefinition()));
        case "providerTargetConfigurationDefinition":
            return Optional.ofNullable(clazz.cast(providerTargetConfigurationDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProviderIdNameSpaceConfiguration, T> g) {
        return obj -> g.apply((ProviderIdNameSpaceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProviderIdNameSpaceConfiguration> {
        /**
         * <p>
         * The description of the ID namespace.
         * </p>
         * 
         * @param description
         *        The description of the ID namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Configurations required for the source ID namespace.
         * </p>
         * 
         * @param providerSourceConfigurationDefinition
         *        Configurations required for the source ID namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerSourceConfigurationDefinition(Document providerSourceConfigurationDefinition);

        /**
         * <p>
         * Configurations required for the target ID namespace.
         * </p>
         * 
         * @param providerTargetConfigurationDefinition
         *        Configurations required for the target ID namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerTargetConfigurationDefinition(Document providerTargetConfigurationDefinition);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private Document providerSourceConfigurationDefinition;

        private Document providerTargetConfigurationDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderIdNameSpaceConfiguration model) {
            description(model.description);
            providerSourceConfigurationDefinition(model.providerSourceConfigurationDefinition);
            providerTargetConfigurationDefinition(model.providerTargetConfigurationDefinition);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Document getProviderSourceConfigurationDefinition() {
            return providerSourceConfigurationDefinition;
        }

        public final void setProviderSourceConfigurationDefinition(Document providerSourceConfigurationDefinition) {
            this.providerSourceConfigurationDefinition = providerSourceConfigurationDefinition;
        }

        @Override
        public final Builder providerSourceConfigurationDefinition(Document providerSourceConfigurationDefinition) {
            this.providerSourceConfigurationDefinition = providerSourceConfigurationDefinition;
            return this;
        }

        public final Document getProviderTargetConfigurationDefinition() {
            return providerTargetConfigurationDefinition;
        }

        public final void setProviderTargetConfigurationDefinition(Document providerTargetConfigurationDefinition) {
            this.providerTargetConfigurationDefinition = providerTargetConfigurationDefinition;
        }

        @Override
        public final Builder providerTargetConfigurationDefinition(Document providerTargetConfigurationDefinition) {
            this.providerTargetConfigurationDefinition = providerTargetConfigurationDefinition;
            return this;
        }

        @Override
        public ProviderIdNameSpaceConfiguration build() {
            return new ProviderIdNameSpaceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
