/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddPolicyStatementRequest extends EntityResolutionRequest implements
        ToCopyableBuilder<AddPolicyStatementRequest.Builder, AddPolicyStatementRequest> {
    private static final SdkField<List<String>> ACTION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("action")
            .getter(getter(AddPolicyStatementRequest::action))
            .setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(AddPolicyStatementRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("arn").build()).build();

    private static final SdkField<String> CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("condition").getter(getter(AddPolicyStatementRequest::condition)).setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build()).build();

    private static final SdkField<String> EFFECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("effect")
            .getter(getter(AddPolicyStatementRequest::effectAsString)).setter(setter(Builder::effect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effect").build()).build();

    private static final SdkField<List<String>> PRINCIPAL_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("principal")
            .getter(getter(AddPolicyStatementRequest::principal))
            .setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statementId").getter(getter(AddPolicyStatementRequest::statementId))
            .setter(setter(Builder::statementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("statementId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, ARN_FIELD,
            CONDITION_FIELD, EFFECT_FIELD, PRINCIPAL_FIELD, STATEMENT_ID_FIELD));

    private final List<String> action;

    private final String arn;

    private final String condition;

    private final String effect;

    private final List<String> principal;

    private final String statementId;

    private AddPolicyStatementRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.arn = builder.arn;
        this.condition = builder.condition;
        this.effect = builder.effect;
        this.principal = builder.principal;
        this.statementId = builder.statementId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Action property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAction() {
        return action != null && !(action instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The action that the principal can use on the resource.
     * </p>
     * <p>
     * For example, <code>entityresolution:GetIdMappingJob</code>, <code>entityresolution:GetMatchingJob</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAction} method.
     * </p>
     * 
     * @return The action that the principal can use on the resource. </p>
     *         <p>
     *         For example, <code>entityresolution:GetIdMappingJob</code>, <code>entityresolution:GetMatchingJob</code>.
     */
    public final List<String> action() {
        return action;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource that will be accessed by the principal.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource that will be accessed by the principal.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A set of condition keys that you can use in key policies.
     * </p>
     * 
     * @return A set of condition keys that you can use in key policies.
     */
    public final String condition() {
        return condition;
    }

    /**
     * <p>
     * Determines whether the permissions specified in the policy are to be allowed (<code>Allow</code>) or denied (
     * <code>Deny</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link StatementEffect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #effectAsString}.
     * </p>
     * 
     * @return Determines whether the permissions specified in the policy are to be allowed (<code>Allow</code>) or
     *         denied (<code>Deny</code>).
     * @see StatementEffect
     */
    public final StatementEffect effect() {
        return StatementEffect.fromValue(effect);
    }

    /**
     * <p>
     * Determines whether the permissions specified in the policy are to be allowed (<code>Allow</code>) or denied (
     * <code>Deny</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link StatementEffect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #effectAsString}.
     * </p>
     * 
     * @return Determines whether the permissions specified in the policy are to be allowed (<code>Allow</code>) or
     *         denied (<code>Deny</code>).
     * @see StatementEffect
     */
    public final String effectAsString() {
        return effect;
    }

    /**
     * For responses, this returns true if the service returned a value for the Principal property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrincipal() {
        return principal != null && !(principal instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services service or Amazon Web Services account that can access the resource defined as ARN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrincipal} method.
     * </p>
     * 
     * @return The Amazon Web Services service or Amazon Web Services account that can access the resource defined as
     *         ARN.
     */
    public final List<String> principal() {
        return principal;
    }

    /**
     * <p>
     * A statement identifier that differentiates the statement from others in the same policy.
     * </p>
     * 
     * @return A statement identifier that differentiates the statement from others in the same policy.
     */
    public final String statementId() {
        return statementId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAction() ? action() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        hashCode = 31 * hashCode + Objects.hashCode(effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrincipal() ? principal() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statementId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPolicyStatementRequest)) {
            return false;
        }
        AddPolicyStatementRequest other = (AddPolicyStatementRequest) obj;
        return hasAction() == other.hasAction() && Objects.equals(action(), other.action()) && Objects.equals(arn(), other.arn())
                && Objects.equals(condition(), other.condition()) && Objects.equals(effectAsString(), other.effectAsString())
                && hasPrincipal() == other.hasPrincipal() && Objects.equals(principal(), other.principal())
                && Objects.equals(statementId(), other.statementId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddPolicyStatementRequest").add("Action", hasAction() ? action() : null).add("Arn", arn())
                .add("Condition", condition()).add("Effect", effectAsString())
                .add("Principal", hasPrincipal() ? principal() : null).add("StatementId", statementId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "effect":
            return Optional.ofNullable(clazz.cast(effectAsString()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "statementId":
            return Optional.ofNullable(clazz.cast(statementId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddPolicyStatementRequest, T> g) {
        return obj -> g.apply((AddPolicyStatementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EntityResolutionRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AddPolicyStatementRequest> {
        /**
         * <p>
         * The action that the principal can use on the resource.
         * </p>
         * <p>
         * For example, <code>entityresolution:GetIdMappingJob</code>, <code>entityresolution:GetMatchingJob</code>.
         * </p>
         * 
         * @param action
         *        The action that the principal can use on the resource. </p>
         *        <p>
         *        For example, <code>entityresolution:GetIdMappingJob</code>,
         *        <code>entityresolution:GetMatchingJob</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(Collection<String> action);

        /**
         * <p>
         * The action that the principal can use on the resource.
         * </p>
         * <p>
         * For example, <code>entityresolution:GetIdMappingJob</code>, <code>entityresolution:GetMatchingJob</code>.
         * </p>
         * 
         * @param action
         *        The action that the principal can use on the resource. </p>
         *        <p>
         *        For example, <code>entityresolution:GetIdMappingJob</code>,
         *        <code>entityresolution:GetMatchingJob</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String... action);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource that will be accessed by the principal.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the resource that will be accessed by the principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A set of condition keys that you can use in key policies.
         * </p>
         * 
         * @param condition
         *        A set of condition keys that you can use in key policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(String condition);

        /**
         * <p>
         * Determines whether the permissions specified in the policy are to be allowed (<code>Allow</code>) or denied (
         * <code>Deny</code>).
         * </p>
         * 
         * @param effect
         *        Determines whether the permissions specified in the policy are to be allowed (<code>Allow</code>) or
         *        denied (<code>Deny</code>).
         * @see StatementEffect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatementEffect
         */
        Builder effect(String effect);

        /**
         * <p>
         * Determines whether the permissions specified in the policy are to be allowed (<code>Allow</code>) or denied (
         * <code>Deny</code>).
         * </p>
         * 
         * @param effect
         *        Determines whether the permissions specified in the policy are to be allowed (<code>Allow</code>) or
         *        denied (<code>Deny</code>).
         * @see StatementEffect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatementEffect
         */
        Builder effect(StatementEffect effect);

        /**
         * <p>
         * The Amazon Web Services service or Amazon Web Services account that can access the resource defined as ARN.
         * </p>
         * 
         * @param principal
         *        The Amazon Web Services service or Amazon Web Services account that can access the resource defined as
         *        ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(Collection<String> principal);

        /**
         * <p>
         * The Amazon Web Services service or Amazon Web Services account that can access the resource defined as ARN.
         * </p>
         * 
         * @param principal
         *        The Amazon Web Services service or Amazon Web Services account that can access the resource defined as
         *        ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String... principal);

        /**
         * <p>
         * A statement identifier that differentiates the statement from others in the same policy.
         * </p>
         * 
         * @param statementId
         *        A statement identifier that differentiates the statement from others in the same policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementId(String statementId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EntityResolutionRequest.BuilderImpl implements Builder {
        private List<String> action = DefaultSdkAutoConstructList.getInstance();

        private String arn;

        private String condition;

        private String effect;

        private List<String> principal = DefaultSdkAutoConstructList.getInstance();

        private String statementId;

        private BuilderImpl() {
        }

        private BuilderImpl(AddPolicyStatementRequest model) {
            super(model);
            action(model.action);
            arn(model.arn);
            condition(model.condition);
            effect(model.effect);
            principal(model.principal);
            statementId(model.statementId);
        }

        public final Collection<String> getAction() {
            if (action instanceof SdkAutoConstructList) {
                return null;
            }
            return action;
        }

        public final void setAction(Collection<String> action) {
            this.action = StatementActionListCopier.copy(action);
        }

        @Override
        public final Builder action(Collection<String> action) {
            this.action = StatementActionListCopier.copy(action);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder action(String... action) {
            action(Arrays.asList(action));
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCondition() {
            return condition;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        public final String getEffect() {
            return effect;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(StatementEffect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final Collection<String> getPrincipal() {
            if (principal instanceof SdkAutoConstructList) {
                return null;
            }
            return principal;
        }

        public final void setPrincipal(Collection<String> principal) {
            this.principal = StatementPrincipalListCopier.copy(principal);
        }

        @Override
        public final Builder principal(Collection<String> principal) {
            this.principal = StatementPrincipalListCopier.copy(principal);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principal(String... principal) {
            principal(Arrays.asList(principal));
            return this;
        }

        public final String getStatementId() {
            return statementId;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddPolicyStatementRequest build() {
            return new AddPolicyStatementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
