/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of <code>ProviderService</code> objects, each of which contain the fields <code>providerName</code>,
 * <code>providerServiceArn</code>, <code>providerServiceName</code>, and <code>providerServiceType</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProviderServiceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ProviderServiceSummary.Builder, ProviderServiceSummary> {
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerName").getter(getter(ProviderServiceSummary::providerName))
            .setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()).build();

    private static final SdkField<String> PROVIDER_SERVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerServiceArn").getter(getter(ProviderServiceSummary::providerServiceArn))
            .setter(setter(Builder::providerServiceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceArn").build())
            .build();

    private static final SdkField<String> PROVIDER_SERVICE_DISPLAY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("providerServiceDisplayName")
            .getter(getter(ProviderServiceSummary::providerServiceDisplayName))
            .setter(setter(Builder::providerServiceDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceDisplayName").build())
            .build();

    private static final SdkField<String> PROVIDER_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerServiceName").getter(getter(ProviderServiceSummary::providerServiceName))
            .setter(setter(Builder::providerServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceName").build())
            .build();

    private static final SdkField<String> PROVIDER_SERVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerServiceType").getter(getter(ProviderServiceSummary::providerServiceTypeAsString))
            .setter(setter(Builder::providerServiceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_NAME_FIELD,
            PROVIDER_SERVICE_ARN_FIELD, PROVIDER_SERVICE_DISPLAY_NAME_FIELD, PROVIDER_SERVICE_NAME_FIELD,
            PROVIDER_SERVICE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String providerName;

    private final String providerServiceArn;

    private final String providerServiceDisplayName;

    private final String providerServiceName;

    private final String providerServiceType;

    private ProviderServiceSummary(BuilderImpl builder) {
        this.providerName = builder.providerName;
        this.providerServiceArn = builder.providerServiceArn;
        this.providerServiceDisplayName = builder.providerServiceDisplayName;
        this.providerServiceName = builder.providerServiceName;
        this.providerServiceType = builder.providerServiceType;
    }

    /**
     * <p>
     * The name of the provider. This name is typically the company name.
     * </p>
     * 
     * @return The name of the provider. This name is typically the company name.
     */
    public final String providerName() {
        return providerName;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>providerService</code>.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>providerService</code>.
     */
    public final String providerServiceArn() {
        return providerServiceArn;
    }

    /**
     * <p>
     * The display name of the provider service.
     * </p>
     * 
     * @return The display name of the provider service.
     */
    public final String providerServiceDisplayName() {
        return providerServiceDisplayName;
    }

    /**
     * <p>
     * The name of the product that the provider service provides.
     * </p>
     * 
     * @return The name of the product that the provider service provides.
     */
    public final String providerServiceName() {
        return providerServiceName;
    }

    /**
     * <p>
     * The type of provider service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #providerServiceType} will return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #providerServiceTypeAsString}.
     * </p>
     * 
     * @return The type of provider service.
     * @see ServiceType
     */
    public final ServiceType providerServiceType() {
        return ServiceType.fromValue(providerServiceType);
    }

    /**
     * <p>
     * The type of provider service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #providerServiceType} will return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #providerServiceTypeAsString}.
     * </p>
     * 
     * @return The type of provider service.
     * @see ServiceType
     */
    public final String providerServiceTypeAsString() {
        return providerServiceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        hashCode = 31 * hashCode + Objects.hashCode(providerServiceArn());
        hashCode = 31 * hashCode + Objects.hashCode(providerServiceDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(providerServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(providerServiceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderServiceSummary)) {
            return false;
        }
        ProviderServiceSummary other = (ProviderServiceSummary) obj;
        return Objects.equals(providerName(), other.providerName())
                && Objects.equals(providerServiceArn(), other.providerServiceArn())
                && Objects.equals(providerServiceDisplayName(), other.providerServiceDisplayName())
                && Objects.equals(providerServiceName(), other.providerServiceName())
                && Objects.equals(providerServiceTypeAsString(), other.providerServiceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProviderServiceSummary").add("ProviderName", providerName())
                .add("ProviderServiceArn", providerServiceArn()).add("ProviderServiceDisplayName", providerServiceDisplayName())
                .add("ProviderServiceName", providerServiceName()).add("ProviderServiceType", providerServiceTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "providerName":
            return Optional.ofNullable(clazz.cast(providerName()));
        case "providerServiceArn":
            return Optional.ofNullable(clazz.cast(providerServiceArn()));
        case "providerServiceDisplayName":
            return Optional.ofNullable(clazz.cast(providerServiceDisplayName()));
        case "providerServiceName":
            return Optional.ofNullable(clazz.cast(providerServiceName()));
        case "providerServiceType":
            return Optional.ofNullable(clazz.cast(providerServiceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProviderServiceSummary, T> g) {
        return obj -> g.apply((ProviderServiceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProviderServiceSummary> {
        /**
         * <p>
         * The name of the provider. This name is typically the company name.
         * </p>
         * 
         * @param providerName
         *        The name of the provider. This name is typically the company name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>providerService</code>.
         * </p>
         * 
         * @param providerServiceArn
         *        The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>providerService</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerServiceArn(String providerServiceArn);

        /**
         * <p>
         * The display name of the provider service.
         * </p>
         * 
         * @param providerServiceDisplayName
         *        The display name of the provider service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerServiceDisplayName(String providerServiceDisplayName);

        /**
         * <p>
         * The name of the product that the provider service provides.
         * </p>
         * 
         * @param providerServiceName
         *        The name of the product that the provider service provides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerServiceName(String providerServiceName);

        /**
         * <p>
         * The type of provider service.
         * </p>
         * 
         * @param providerServiceType
         *        The type of provider service.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder providerServiceType(String providerServiceType);

        /**
         * <p>
         * The type of provider service.
         * </p>
         * 
         * @param providerServiceType
         *        The type of provider service.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder providerServiceType(ServiceType providerServiceType);
    }

    static final class BuilderImpl implements Builder {
        private String providerName;

        private String providerServiceArn;

        private String providerServiceDisplayName;

        private String providerServiceName;

        private String providerServiceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderServiceSummary model) {
            providerName(model.providerName);
            providerServiceArn(model.providerServiceArn);
            providerServiceDisplayName(model.providerServiceDisplayName);
            providerServiceName(model.providerServiceName);
            providerServiceType(model.providerServiceType);
        }

        public final String getProviderName() {
            return providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final String getProviderServiceArn() {
            return providerServiceArn;
        }

        public final void setProviderServiceArn(String providerServiceArn) {
            this.providerServiceArn = providerServiceArn;
        }

        @Override
        public final Builder providerServiceArn(String providerServiceArn) {
            this.providerServiceArn = providerServiceArn;
            return this;
        }

        public final String getProviderServiceDisplayName() {
            return providerServiceDisplayName;
        }

        public final void setProviderServiceDisplayName(String providerServiceDisplayName) {
            this.providerServiceDisplayName = providerServiceDisplayName;
        }

        @Override
        public final Builder providerServiceDisplayName(String providerServiceDisplayName) {
            this.providerServiceDisplayName = providerServiceDisplayName;
            return this;
        }

        public final String getProviderServiceName() {
            return providerServiceName;
        }

        public final void setProviderServiceName(String providerServiceName) {
            this.providerServiceName = providerServiceName;
        }

        @Override
        public final Builder providerServiceName(String providerServiceName) {
            this.providerServiceName = providerServiceName;
            return this;
        }

        public final String getProviderServiceType() {
            return providerServiceType;
        }

        public final void setProviderServiceType(String providerServiceType) {
            this.providerServiceType = providerServiceType;
        }

        @Override
        public final Builder providerServiceType(String providerServiceType) {
            this.providerServiceType = providerServiceType;
            return this;
        }

        @Override
        public final Builder providerServiceType(ServiceType providerServiceType) {
            this.providerServiceType(providerServiceType == null ? null : providerServiceType.toString());
            return this;
        }

        @Override
        public ProviderServiceSummary build() {
            return new ProviderServiceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
