/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon S3 location that temporarily stores your data while it processes. Your information won't be saved
 * permanently.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntermediateSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IntermediateSourceConfiguration.Builder, IntermediateSourceConfiguration> {
    private static final SdkField<String> INTERMEDIATE_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intermediateS3Path").getter(getter(IntermediateSourceConfiguration::intermediateS3Path))
            .setter(setter(Builder::intermediateS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intermediateS3Path").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERMEDIATE_S3_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String intermediateS3Path;

    private IntermediateSourceConfiguration(BuilderImpl builder) {
        this.intermediateS3Path = builder.intermediateS3Path;
    }

    /**
     * <p>
     * The Amazon S3 location (bucket and prefix). For example: <code>s3://provider_bucket/DOC-EXAMPLE-BUCKET</code>
     * </p>
     * 
     * @return The Amazon S3 location (bucket and prefix). For example:
     *         <code>s3://provider_bucket/DOC-EXAMPLE-BUCKET</code>
     */
    public final String intermediateS3Path() {
        return intermediateS3Path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intermediateS3Path());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntermediateSourceConfiguration)) {
            return false;
        }
        IntermediateSourceConfiguration other = (IntermediateSourceConfiguration) obj;
        return Objects.equals(intermediateS3Path(), other.intermediateS3Path());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntermediateSourceConfiguration").add("IntermediateS3Path", intermediateS3Path()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intermediateS3Path":
            return Optional.ofNullable(clazz.cast(intermediateS3Path()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntermediateSourceConfiguration, T> g) {
        return obj -> g.apply((IntermediateSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntermediateSourceConfiguration> {
        /**
         * <p>
         * The Amazon S3 location (bucket and prefix). For example: <code>s3://provider_bucket/DOC-EXAMPLE-BUCKET</code>
         * </p>
         * 
         * @param intermediateS3Path
         *        The Amazon S3 location (bucket and prefix). For example:
         *        <code>s3://provider_bucket/DOC-EXAMPLE-BUCKET</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intermediateS3Path(String intermediateS3Path);
    }

    static final class BuilderImpl implements Builder {
        private String intermediateS3Path;

        private BuilderImpl() {
        }

        private BuilderImpl(IntermediateSourceConfiguration model) {
            intermediateS3Path(model.intermediateS3Path);
        }

        public final String getIntermediateS3Path() {
            return intermediateS3Path;
        }

        public final void setIntermediateS3Path(String intermediateS3Path) {
            this.intermediateS3Path = intermediateS3Path;
        }

        @Override
        public final Builder intermediateS3Path(String intermediateS3Path) {
            this.intermediateS3Path = intermediateS3Path;
            return this;
        }

        @Override
        public IntermediateSourceConfiguration build() {
            return new IntermediateSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
