/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.entityresolution.internal.EntityResolutionServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.entityresolution.model.AccessDeniedException;
import software.amazon.awssdk.services.entityresolution.model.AddPolicyStatementRequest;
import software.amazon.awssdk.services.entityresolution.model.AddPolicyStatementResponse;
import software.amazon.awssdk.services.entityresolution.model.BatchDeleteUniqueIdRequest;
import software.amazon.awssdk.services.entityresolution.model.BatchDeleteUniqueIdResponse;
import software.amazon.awssdk.services.entityresolution.model.ConflictException;
import software.amazon.awssdk.services.entityresolution.model.CreateIdMappingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.CreateIdMappingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.CreateIdNamespaceRequest;
import software.amazon.awssdk.services.entityresolution.model.CreateIdNamespaceResponse;
import software.amazon.awssdk.services.entityresolution.model.CreateMatchingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.CreateMatchingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.CreateSchemaMappingRequest;
import software.amazon.awssdk.services.entityresolution.model.CreateSchemaMappingResponse;
import software.amazon.awssdk.services.entityresolution.model.DeleteIdMappingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.DeleteIdMappingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.DeleteIdNamespaceRequest;
import software.amazon.awssdk.services.entityresolution.model.DeleteIdNamespaceResponse;
import software.amazon.awssdk.services.entityresolution.model.DeleteMatchingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.DeleteMatchingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.DeletePolicyStatementRequest;
import software.amazon.awssdk.services.entityresolution.model.DeletePolicyStatementResponse;
import software.amazon.awssdk.services.entityresolution.model.DeleteSchemaMappingRequest;
import software.amazon.awssdk.services.entityresolution.model.DeleteSchemaMappingResponse;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionException;
import software.amazon.awssdk.services.entityresolution.model.ExceedsLimitException;
import software.amazon.awssdk.services.entityresolution.model.GetIdMappingJobRequest;
import software.amazon.awssdk.services.entityresolution.model.GetIdMappingJobResponse;
import software.amazon.awssdk.services.entityresolution.model.GetIdMappingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.GetIdMappingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.GetIdNamespaceRequest;
import software.amazon.awssdk.services.entityresolution.model.GetIdNamespaceResponse;
import software.amazon.awssdk.services.entityresolution.model.GetMatchIdRequest;
import software.amazon.awssdk.services.entityresolution.model.GetMatchIdResponse;
import software.amazon.awssdk.services.entityresolution.model.GetMatchingJobRequest;
import software.amazon.awssdk.services.entityresolution.model.GetMatchingJobResponse;
import software.amazon.awssdk.services.entityresolution.model.GetMatchingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.GetMatchingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.GetPolicyRequest;
import software.amazon.awssdk.services.entityresolution.model.GetPolicyResponse;
import software.amazon.awssdk.services.entityresolution.model.GetProviderServiceRequest;
import software.amazon.awssdk.services.entityresolution.model.GetProviderServiceResponse;
import software.amazon.awssdk.services.entityresolution.model.GetSchemaMappingRequest;
import software.amazon.awssdk.services.entityresolution.model.GetSchemaMappingResponse;
import software.amazon.awssdk.services.entityresolution.model.InternalServerException;
import software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsResponse;
import software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsResponse;
import software.amazon.awssdk.services.entityresolution.model.ListIdNamespacesRequest;
import software.amazon.awssdk.services.entityresolution.model.ListIdNamespacesResponse;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsResponse;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsResponse;
import software.amazon.awssdk.services.entityresolution.model.ListProviderServicesRequest;
import software.amazon.awssdk.services.entityresolution.model.ListProviderServicesResponse;
import software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsResponse;
import software.amazon.awssdk.services.entityresolution.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.entityresolution.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.entityresolution.model.PutPolicyRequest;
import software.amazon.awssdk.services.entityresolution.model.PutPolicyResponse;
import software.amazon.awssdk.services.entityresolution.model.ResourceNotFoundException;
import software.amazon.awssdk.services.entityresolution.model.StartIdMappingJobRequest;
import software.amazon.awssdk.services.entityresolution.model.StartIdMappingJobResponse;
import software.amazon.awssdk.services.entityresolution.model.StartMatchingJobRequest;
import software.amazon.awssdk.services.entityresolution.model.StartMatchingJobResponse;
import software.amazon.awssdk.services.entityresolution.model.TagResourceRequest;
import software.amazon.awssdk.services.entityresolution.model.TagResourceResponse;
import software.amazon.awssdk.services.entityresolution.model.ThrottlingException;
import software.amazon.awssdk.services.entityresolution.model.UntagResourceRequest;
import software.amazon.awssdk.services.entityresolution.model.UntagResourceResponse;
import software.amazon.awssdk.services.entityresolution.model.UpdateIdMappingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.UpdateIdMappingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.UpdateIdNamespaceRequest;
import software.amazon.awssdk.services.entityresolution.model.UpdateIdNamespaceResponse;
import software.amazon.awssdk.services.entityresolution.model.UpdateMatchingWorkflowRequest;
import software.amazon.awssdk.services.entityresolution.model.UpdateMatchingWorkflowResponse;
import software.amazon.awssdk.services.entityresolution.model.UpdateSchemaMappingRequest;
import software.amazon.awssdk.services.entityresolution.model.UpdateSchemaMappingResponse;
import software.amazon.awssdk.services.entityresolution.model.ValidationException;
import software.amazon.awssdk.services.entityresolution.transform.AddPolicyStatementRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.BatchDeleteUniqueIdRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.CreateIdMappingWorkflowRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.CreateIdNamespaceRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.CreateMatchingWorkflowRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.CreateSchemaMappingRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.DeleteIdMappingWorkflowRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.DeleteIdNamespaceRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.DeleteMatchingWorkflowRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.DeletePolicyStatementRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.DeleteSchemaMappingRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.GetIdMappingJobRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.GetIdMappingWorkflowRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.GetIdNamespaceRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.GetMatchIdRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.GetMatchingJobRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.GetMatchingWorkflowRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.GetPolicyRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.GetProviderServiceRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.GetSchemaMappingRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.ListIdMappingJobsRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.ListIdMappingWorkflowsRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.ListIdNamespacesRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.ListMatchingJobsRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.ListMatchingWorkflowsRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.ListProviderServicesRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.ListSchemaMappingsRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.PutPolicyRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.StartIdMappingJobRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.StartMatchingJobRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.UpdateIdMappingWorkflowRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.UpdateIdNamespaceRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.UpdateMatchingWorkflowRequestMarshaller;
import software.amazon.awssdk.services.entityresolution.transform.UpdateSchemaMappingRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link EntityResolutionAsyncClient}.
 *
 * @see EntityResolutionAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultEntityResolutionAsyncClient implements EntityResolutionAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultEntityResolutionAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultEntityResolutionAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Adds a policy statement object. To retrieve a list of existing policy statements, use the <code>GetPolicy</code>
     * API.
     * </p>
     *
     * @param addPolicyStatementRequest
     * @return A Java Future containing the result of the AddPolicyStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.AddPolicyStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/AddPolicyStatement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddPolicyStatementResponse> addPolicyStatement(AddPolicyStatementRequest addPolicyStatementRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addPolicyStatementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addPolicyStatementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddPolicyStatement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddPolicyStatementResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddPolicyStatementResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddPolicyStatementResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddPolicyStatementRequest, AddPolicyStatementResponse>()
                            .withOperationName("AddPolicyStatement").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddPolicyStatementRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addPolicyStatementRequest));
            CompletableFuture<AddPolicyStatementResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes multiple unique IDs in a matching workflow.
     * </p>
     *
     * @param batchDeleteUniqueIdRequest
     * @return A Java Future containing the result of the BatchDeleteUniqueId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.BatchDeleteUniqueId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/BatchDeleteUniqueId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDeleteUniqueIdResponse> batchDeleteUniqueId(
            BatchDeleteUniqueIdRequest batchDeleteUniqueIdRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteUniqueIdRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeleteUniqueIdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteUniqueId");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDeleteUniqueIdResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDeleteUniqueIdResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDeleteUniqueIdResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteUniqueIdRequest, BatchDeleteUniqueIdResponse>()
                            .withOperationName("BatchDeleteUniqueId").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDeleteUniqueIdRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDeleteUniqueIdRequest));
            CompletableFuture<BatchDeleteUniqueIdResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an <code>IdMappingWorkflow</code> object which stores the configuration of the data processing job to be
     * run. Each <code>IdMappingWorkflow</code> must have a unique workflow name. To modify an existing workflow, use
     * the <code>UpdateIdMappingWorkflow</code> API.
     * </p>
     *
     * @param createIdMappingWorkflowRequest
     * @return A Java Future containing the result of the CreateIdMappingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current Entity Resolution account limits. The error message describes the limit exceeded.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.CreateIdMappingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateIdMappingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIdMappingWorkflowResponse> createIdMappingWorkflow(
            CreateIdMappingWorkflowRequest createIdMappingWorkflowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIdMappingWorkflowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIdMappingWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIdMappingWorkflow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateIdMappingWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateIdMappingWorkflowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateIdMappingWorkflowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIdMappingWorkflowRequest, CreateIdMappingWorkflowResponse>()
                            .withOperationName("CreateIdMappingWorkflow").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateIdMappingWorkflowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createIdMappingWorkflowRequest));
            CompletableFuture<CreateIdMappingWorkflowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an ID namespace object which will help customers provide metadata explaining their dataset and how to use
     * it. Each ID namespace must have a unique name. To modify an existing ID namespace, use the
     * <code>UpdateIdNamespace</code> API.
     * </p>
     *
     * @param createIdNamespaceRequest
     * @return A Java Future containing the result of the CreateIdNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current Entity Resolution account limits. The error message describes the limit exceeded.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.CreateIdNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateIdNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIdNamespaceResponse> createIdNamespace(CreateIdNamespaceRequest createIdNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIdNamespaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIdNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIdNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateIdNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateIdNamespaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateIdNamespaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIdNamespaceRequest, CreateIdNamespaceResponse>()
                            .withOperationName("CreateIdNamespace").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateIdNamespaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createIdNamespaceRequest));
            CompletableFuture<CreateIdNamespaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a <code>MatchingWorkflow</code> object which stores the configuration of the data processing job to be
     * run. It is important to note that there should not be a pre-existing <code>MatchingWorkflow</code> with the same
     * name. To modify an existing workflow, utilize the <code>UpdateMatchingWorkflow</code> API.
     * </p>
     *
     * @param createMatchingWorkflowRequest
     * @return A Java Future containing the result of the CreateMatchingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current Entity Resolution account limits. The error message describes the limit exceeded.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.CreateMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMatchingWorkflowResponse> createMatchingWorkflow(
            CreateMatchingWorkflowRequest createMatchingWorkflowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMatchingWorkflowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMatchingWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMatchingWorkflow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMatchingWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMatchingWorkflowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMatchingWorkflowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMatchingWorkflowRequest, CreateMatchingWorkflowResponse>()
                            .withOperationName("CreateMatchingWorkflow").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMatchingWorkflowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMatchingWorkflowRequest));
            CompletableFuture<CreateMatchingWorkflowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a schema mapping, which defines the schema of the input customer records table. The
     * <code>SchemaMapping</code> also provides Entity Resolution with some metadata about the table, such as the
     * attribute types of the columns and which columns to match on.
     * </p>
     *
     * @param createSchemaMappingRequest
     * @return A Java Future containing the result of the CreateSchemaMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current Entity Resolution account limits. The error message describes the limit exceeded.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.CreateSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSchemaMappingResponse> createSchemaMapping(
            CreateSchemaMappingRequest createSchemaMappingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSchemaMappingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSchemaMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSchemaMapping");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSchemaMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSchemaMappingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSchemaMappingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSchemaMappingRequest, CreateSchemaMappingResponse>()
                            .withOperationName("CreateSchemaMapping").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSchemaMappingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSchemaMappingRequest));
            CompletableFuture<CreateSchemaMappingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the <code>IdMappingWorkflow</code> with a given name. This operation will succeed even if a workflow with
     * the given name does not exist.
     * </p>
     *
     * @param deleteIdMappingWorkflowRequest
     * @return A Java Future containing the result of the DeleteIdMappingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.DeleteIdMappingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteIdMappingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIdMappingWorkflowResponse> deleteIdMappingWorkflow(
            DeleteIdMappingWorkflowRequest deleteIdMappingWorkflowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIdMappingWorkflowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIdMappingWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIdMappingWorkflow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIdMappingWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteIdMappingWorkflowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteIdMappingWorkflowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIdMappingWorkflowRequest, DeleteIdMappingWorkflowResponse>()
                            .withOperationName("DeleteIdMappingWorkflow").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIdMappingWorkflowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIdMappingWorkflowRequest));
            CompletableFuture<DeleteIdMappingWorkflowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the <code>IdNamespace</code> with a given name.
     * </p>
     *
     * @param deleteIdNamespaceRequest
     * @return A Java Future containing the result of the DeleteIdNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.DeleteIdNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteIdNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIdNamespaceResponse> deleteIdNamespace(DeleteIdNamespaceRequest deleteIdNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIdNamespaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIdNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIdNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIdNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteIdNamespaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteIdNamespaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIdNamespaceRequest, DeleteIdNamespaceResponse>()
                            .withOperationName("DeleteIdNamespace").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIdNamespaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIdNamespaceRequest));
            CompletableFuture<DeleteIdNamespaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the <code>MatchingWorkflow</code> with a given name. This operation will succeed even if a workflow with
     * the given name does not exist.
     * </p>
     *
     * @param deleteMatchingWorkflowRequest
     * @return A Java Future containing the result of the DeleteMatchingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.DeleteMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMatchingWorkflowResponse> deleteMatchingWorkflow(
            DeleteMatchingWorkflowRequest deleteMatchingWorkflowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMatchingWorkflowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMatchingWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMatchingWorkflow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMatchingWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMatchingWorkflowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMatchingWorkflowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMatchingWorkflowRequest, DeleteMatchingWorkflowResponse>()
                            .withOperationName("DeleteMatchingWorkflow").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMatchingWorkflowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMatchingWorkflowRequest));
            CompletableFuture<DeleteMatchingWorkflowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the policy statement.
     * </p>
     *
     * @param deletePolicyStatementRequest
     * @return A Java Future containing the result of the DeletePolicyStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.DeletePolicyStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeletePolicyStatement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePolicyStatementResponse> deletePolicyStatement(
            DeletePolicyStatementRequest deletePolicyStatementRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePolicyStatementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePolicyStatementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePolicyStatement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePolicyStatementResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePolicyStatementResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePolicyStatementResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePolicyStatementRequest, DeletePolicyStatementResponse>()
                            .withOperationName("DeletePolicyStatement").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeletePolicyStatementRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePolicyStatementRequest));
            CompletableFuture<DeletePolicyStatementResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the <code>SchemaMapping</code> with a given name. This operation will succeed even if a schema with the
     * given name does not exist. This operation will fail if there is a <code>MatchingWorkflow</code> object that
     * references the <code>SchemaMapping</code> in the workflow's <code>InputSourceConfig</code>.
     * </p>
     *
     * @param deleteSchemaMappingRequest
     * @return A Java Future containing the result of the DeleteSchemaMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.DeleteSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSchemaMappingResponse> deleteSchemaMapping(
            DeleteSchemaMappingRequest deleteSchemaMappingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSchemaMappingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSchemaMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSchemaMapping");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSchemaMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSchemaMappingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSchemaMappingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSchemaMappingRequest, DeleteSchemaMappingResponse>()
                            .withOperationName("DeleteSchemaMapping").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSchemaMappingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSchemaMappingRequest));
            CompletableFuture<DeleteSchemaMappingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the status, metrics, and errors (if there are any) that are associated with a job.
     * </p>
     *
     * @param getIdMappingJobRequest
     * @return A Java Future containing the result of the GetIdMappingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetIdMappingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetIdMappingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetIdMappingJobResponse> getIdMappingJob(GetIdMappingJobRequest getIdMappingJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIdMappingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIdMappingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIdMappingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetIdMappingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetIdMappingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetIdMappingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetIdMappingJobRequest, GetIdMappingJobResponse>()
                            .withOperationName("GetIdMappingJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetIdMappingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getIdMappingJobRequest));
            CompletableFuture<GetIdMappingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the <code>IdMappingWorkflow</code> with a given name, if it exists.
     * </p>
     *
     * @param getIdMappingWorkflowRequest
     * @return A Java Future containing the result of the GetIdMappingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetIdMappingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetIdMappingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetIdMappingWorkflowResponse> getIdMappingWorkflow(
            GetIdMappingWorkflowRequest getIdMappingWorkflowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIdMappingWorkflowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIdMappingWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIdMappingWorkflow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetIdMappingWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetIdMappingWorkflowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetIdMappingWorkflowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetIdMappingWorkflowRequest, GetIdMappingWorkflowResponse>()
                            .withOperationName("GetIdMappingWorkflow").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetIdMappingWorkflowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getIdMappingWorkflowRequest));
            CompletableFuture<GetIdMappingWorkflowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the <code>IdNamespace</code> with a given name, if it exists.
     * </p>
     *
     * @param getIdNamespaceRequest
     * @return A Java Future containing the result of the GetIdNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetIdNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetIdNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetIdNamespaceResponse> getIdNamespace(GetIdNamespaceRequest getIdNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIdNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIdNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIdNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetIdNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetIdNamespaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetIdNamespaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetIdNamespaceRequest, GetIdNamespaceResponse>()
                            .withOperationName("GetIdNamespace").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetIdNamespaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getIdNamespaceRequest));
            CompletableFuture<GetIdNamespaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the corresponding Match ID of a customer record if the record has been processed.
     * </p>
     *
     * @param getMatchIdRequest
     * @return A Java Future containing the result of the GetMatchId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetMatchId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchId" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMatchIdResponse> getMatchId(GetMatchIdRequest getMatchIdRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMatchIdRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMatchIdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMatchId");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMatchIdResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetMatchIdResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMatchIdResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMatchIdRequest, GetMatchIdResponse>().withOperationName("GetMatchId")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMatchIdRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMatchIdRequest));
            CompletableFuture<GetMatchIdResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the status, metrics, and errors (if there are any) that are associated with a job.
     * </p>
     *
     * @param getMatchingJobRequest
     * @return A Java Future containing the result of the GetMatchingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetMatchingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMatchingJobResponse> getMatchingJob(GetMatchingJobRequest getMatchingJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMatchingJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMatchingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMatchingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMatchingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMatchingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMatchingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMatchingJobRequest, GetMatchingJobResponse>()
                            .withOperationName("GetMatchingJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMatchingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMatchingJobRequest));
            CompletableFuture<GetMatchingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the <code>MatchingWorkflow</code> with a given name, if it exists.
     * </p>
     *
     * @param getMatchingWorkflowRequest
     * @return A Java Future containing the result of the GetMatchingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMatchingWorkflowResponse> getMatchingWorkflow(
            GetMatchingWorkflowRequest getMatchingWorkflowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMatchingWorkflowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMatchingWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMatchingWorkflow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMatchingWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMatchingWorkflowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMatchingWorkflowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMatchingWorkflowRequest, GetMatchingWorkflowResponse>()
                            .withOperationName("GetMatchingWorkflow").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMatchingWorkflowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMatchingWorkflowRequest));
            CompletableFuture<GetMatchingWorkflowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the resource-based policy.
     * </p>
     *
     * @param getPolicyRequest
     * @return A Java Future containing the result of the GetPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPolicyResponse> getPolicy(GetPolicyRequest getPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPolicyRequest, GetPolicyResponse>().withOperationName("GetPolicy")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetPolicyRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getPolicyRequest));
            CompletableFuture<GetPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the <code>ProviderService</code> of a given name.
     * </p>
     *
     * @param getProviderServiceRequest
     * @return A Java Future containing the result of the GetProviderService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetProviderService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetProviderService"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetProviderServiceResponse> getProviderService(GetProviderServiceRequest getProviderServiceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getProviderServiceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getProviderServiceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetProviderService");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetProviderServiceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetProviderServiceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetProviderServiceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetProviderServiceRequest, GetProviderServiceResponse>()
                            .withOperationName("GetProviderService").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetProviderServiceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getProviderServiceRequest));
            CompletableFuture<GetProviderServiceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the SchemaMapping of a given name.
     * </p>
     *
     * @param getSchemaMappingRequest
     * @return A Java Future containing the result of the GetSchemaMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.GetSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSchemaMappingResponse> getSchemaMapping(GetSchemaMappingRequest getSchemaMappingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSchemaMappingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSchemaMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSchemaMapping");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSchemaMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSchemaMappingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSchemaMappingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSchemaMappingRequest, GetSchemaMappingResponse>()
                            .withOperationName("GetSchemaMapping").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSchemaMappingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSchemaMappingRequest));
            CompletableFuture<GetSchemaMappingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all ID mapping jobs for a given workflow.
     * </p>
     *
     * @param listIdMappingJobsRequest
     * @return A Java Future containing the result of the ListIdMappingJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListIdMappingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListIdMappingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListIdMappingJobsResponse> listIdMappingJobs(ListIdMappingJobsRequest listIdMappingJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIdMappingJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIdMappingJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIdMappingJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIdMappingJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListIdMappingJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIdMappingJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIdMappingJobsRequest, ListIdMappingJobsResponse>()
                            .withOperationName("ListIdMappingJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListIdMappingJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listIdMappingJobsRequest));
            CompletableFuture<ListIdMappingJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all the <code>IdMappingWorkflows</code> that have been created for an Amazon Web Services
     * account.
     * </p>
     *
     * @param listIdMappingWorkflowsRequest
     * @return A Java Future containing the result of the ListIdMappingWorkflows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListIdMappingWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListIdMappingWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListIdMappingWorkflowsResponse> listIdMappingWorkflows(
            ListIdMappingWorkflowsRequest listIdMappingWorkflowsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIdMappingWorkflowsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIdMappingWorkflowsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIdMappingWorkflows");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIdMappingWorkflowsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListIdMappingWorkflowsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIdMappingWorkflowsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIdMappingWorkflowsRequest, ListIdMappingWorkflowsResponse>()
                            .withOperationName("ListIdMappingWorkflows").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListIdMappingWorkflowsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listIdMappingWorkflowsRequest));
            CompletableFuture<ListIdMappingWorkflowsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all ID namespaces.
     * </p>
     *
     * @param listIdNamespacesRequest
     * @return A Java Future containing the result of the ListIdNamespaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListIdNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListIdNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListIdNamespacesResponse> listIdNamespaces(ListIdNamespacesRequest listIdNamespacesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIdNamespacesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIdNamespacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIdNamespaces");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIdNamespacesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListIdNamespacesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIdNamespacesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIdNamespacesRequest, ListIdNamespacesResponse>()
                            .withOperationName("ListIdNamespaces").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListIdNamespacesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listIdNamespacesRequest));
            CompletableFuture<ListIdNamespacesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all jobs for a given workflow.
     * </p>
     *
     * @param listMatchingJobsRequest
     * @return A Java Future containing the result of the ListMatchingJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListMatchingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMatchingJobsResponse> listMatchingJobs(ListMatchingJobsRequest listMatchingJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMatchingJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMatchingJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMatchingJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMatchingJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMatchingJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMatchingJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMatchingJobsRequest, ListMatchingJobsResponse>()
                            .withOperationName("ListMatchingJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMatchingJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMatchingJobsRequest));
            CompletableFuture<ListMatchingJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all the <code>MatchingWorkflows</code> that have been created for an Amazon Web Services
     * account.
     * </p>
     *
     * @param listMatchingWorkflowsRequest
     * @return A Java Future containing the result of the ListMatchingWorkflows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListMatchingWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMatchingWorkflowsResponse> listMatchingWorkflows(
            ListMatchingWorkflowsRequest listMatchingWorkflowsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMatchingWorkflowsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMatchingWorkflowsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMatchingWorkflows");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMatchingWorkflowsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMatchingWorkflowsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMatchingWorkflowsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMatchingWorkflowsRequest, ListMatchingWorkflowsResponse>()
                            .withOperationName("ListMatchingWorkflows").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMatchingWorkflowsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMatchingWorkflowsRequest));
            CompletableFuture<ListMatchingWorkflowsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all the <code>ProviderServices</code> that are available in this Amazon Web Services Region.
     * </p>
     *
     * @param listProviderServicesRequest
     * @return A Java Future containing the result of the ListProviderServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListProviderServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListProviderServices"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListProviderServicesResponse> listProviderServices(
            ListProviderServicesRequest listProviderServicesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listProviderServicesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProviderServicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProviderServices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListProviderServicesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListProviderServicesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListProviderServicesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListProviderServicesRequest, ListProviderServicesResponse>()
                            .withOperationName("ListProviderServices").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListProviderServicesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listProviderServicesRequest));
            CompletableFuture<ListProviderServicesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all the <code>SchemaMappings</code> that have been created for an Amazon Web Services account.
     * </p>
     *
     * @param listSchemaMappingsRequest
     * @return A Java Future containing the result of the ListSchemaMappings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListSchemaMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListSchemaMappings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSchemaMappingsResponse> listSchemaMappings(ListSchemaMappingsRequest listSchemaMappingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSchemaMappingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSchemaMappingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSchemaMappings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSchemaMappingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSchemaMappingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSchemaMappingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSchemaMappingsRequest, ListSchemaMappingsResponse>()
                            .withOperationName("ListSchemaMappings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSchemaMappingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSchemaMappingsRequest));
            CompletableFuture<ListSchemaMappingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays the tags associated with an Entity Resolution resource. In Entity Resolution, <code>SchemaMapping</code>
     * , and <code>MatchingWorkflow</code> can be tagged.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the resource-based policy.
     * </p>
     *
     * @param putPolicyRequest
     * @return A Java Future containing the result of the PutPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.PutPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/PutPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutPolicyResponse> putPolicy(PutPolicyRequest putPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutPolicyRequest, PutPolicyResponse>().withOperationName("PutPolicy")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutPolicyRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(putPolicyRequest));
            CompletableFuture<PutPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts the <code>IdMappingJob</code> of a workflow. The workflow must have previously been created using the
     * <code>CreateIdMappingWorkflow</code> endpoint.
     * </p>
     *
     * @param startIdMappingJobRequest
     * @return A Java Future containing the result of the StartIdMappingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current Entity Resolution account limits. The error message describes the limit exceeded.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.StartIdMappingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/StartIdMappingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartIdMappingJobResponse> startIdMappingJob(StartIdMappingJobRequest startIdMappingJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startIdMappingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startIdMappingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartIdMappingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartIdMappingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartIdMappingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartIdMappingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartIdMappingJobRequest, StartIdMappingJobResponse>()
                            .withOperationName("StartIdMappingJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartIdMappingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startIdMappingJobRequest));
            CompletableFuture<StartIdMappingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts the <code>MatchingJob</code> of a workflow. The workflow must have previously been created using the
     * <code>CreateMatchingWorkflow</code> endpoint.
     * </p>
     *
     * @param startMatchingJobRequest
     * @return A Java Future containing the result of the StartMatchingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ExceedsLimitException The request was rejected because it attempted to create resources beyond the
     *         current Entity Resolution account limits. The error message describes the limit exceeded.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.StartMatchingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/StartMatchingJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartMatchingJobResponse> startMatchingJob(StartMatchingJobRequest startMatchingJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startMatchingJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMatchingJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMatchingJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartMatchingJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartMatchingJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartMatchingJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartMatchingJobRequest, StartMatchingJobResponse>()
                            .withOperationName("StartMatchingJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartMatchingJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startMatchingJobRequest));
            CompletableFuture<StartMatchingJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified Entity Resolution resource. Tags can help you
     * organize and categorize your resources. You can also use them to scope user permissions by granting a user
     * permission to access or change only resources with certain tag values. In Entity Resolution,
     * <code>SchemaMapping</code> and <code>MatchingWorkflow</code> can be tagged. Tags don't have any semantic meaning
     * to Amazon Web Services and are interpreted strictly as strings of characters. You can use the
     * <code>TagResource</code> action with a resource that already has tags. If you specify a new tag key, this tag is
     * appended to the list of tags associated with the resource. If you specify a tag key that is already associated
     * with the resource, the new tag value that you specify replaces the previous value for that tag.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more tags from the specified Entity Resolution resource. In Entity Resolution,
     * <code>SchemaMapping</code>, and <code>MatchingWorkflow</code> can be tagged.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing <code>IdMappingWorkflow</code>. This method is identical to
     * <code>CreateIdMappingWorkflow</code>, except it uses an HTTP <code>PUT</code> request instead of a
     * <code>POST</code> request, and the <code>IdMappingWorkflow</code> must already exist for the method to succeed.
     * </p>
     *
     * @param updateIdMappingWorkflowRequest
     * @return A Java Future containing the result of the UpdateIdMappingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.UpdateIdMappingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateIdMappingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateIdMappingWorkflowResponse> updateIdMappingWorkflow(
            UpdateIdMappingWorkflowRequest updateIdMappingWorkflowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateIdMappingWorkflowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIdMappingWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIdMappingWorkflow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateIdMappingWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateIdMappingWorkflowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateIdMappingWorkflowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateIdMappingWorkflowRequest, UpdateIdMappingWorkflowResponse>()
                            .withOperationName("UpdateIdMappingWorkflow").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateIdMappingWorkflowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateIdMappingWorkflowRequest));
            CompletableFuture<UpdateIdMappingWorkflowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing ID namespace.
     * </p>
     *
     * @param updateIdNamespaceRequest
     * @return A Java Future containing the result of the UpdateIdNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.UpdateIdNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateIdNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateIdNamespaceResponse> updateIdNamespace(UpdateIdNamespaceRequest updateIdNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateIdNamespaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIdNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIdNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateIdNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateIdNamespaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateIdNamespaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateIdNamespaceRequest, UpdateIdNamespaceResponse>()
                            .withOperationName("UpdateIdNamespace").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateIdNamespaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateIdNamespaceRequest));
            CompletableFuture<UpdateIdNamespaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing <code>MatchingWorkflow</code>. This method is identical to
     * <code>CreateMatchingWorkflow</code>, except it uses an HTTP <code>PUT</code> request instead of a
     * <code>POST</code> request, and the <code>MatchingWorkflow</code> must already exist for the method to succeed.
     * </p>
     *
     * @param updateMatchingWorkflowRequest
     * @return A Java Future containing the result of the UpdateMatchingWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.UpdateMatchingWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateMatchingWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMatchingWorkflowResponse> updateMatchingWorkflow(
            UpdateMatchingWorkflowRequest updateMatchingWorkflowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMatchingWorkflowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMatchingWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMatchingWorkflow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMatchingWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMatchingWorkflowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMatchingWorkflowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMatchingWorkflowRequest, UpdateMatchingWorkflowResponse>()
                            .withOperationName("UpdateMatchingWorkflow").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateMatchingWorkflowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateMatchingWorkflowRequest));
            CompletableFuture<UpdateMatchingWorkflowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a schema mapping.
     * </p>
     * <note>
     * <p>
     * A schema is immutable if it is being used by a workflow. Therefore, you can't update a schema mapping if it's
     * associated with a workflow.
     * </p>
     * </note>
     *
     * @param updateSchemaMappingRequest
     * @return A Java Future containing the result of the UpdateSchemaMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Entity
     *         Resolution service.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by Entity Resolution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EntityResolutionException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample EntityResolutionAsyncClient.UpdateSchemaMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateSchemaMapping"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSchemaMappingResponse> updateSchemaMapping(
            UpdateSchemaMappingRequest updateSchemaMappingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSchemaMappingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSchemaMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EntityResolution");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSchemaMapping");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSchemaMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSchemaMappingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSchemaMappingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSchemaMappingRequest, UpdateSchemaMappingResponse>()
                            .withOperationName("UpdateSchemaMapping").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateSchemaMappingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateSchemaMappingRequest));
            CompletableFuture<UpdateSchemaMappingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final EntityResolutionServiceClientConfiguration serviceClientConfiguration() {
        return new EntityResolutionServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(EntityResolutionException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ExceedsLimitException")
                                .exceptionBuilderSupplier(ExceedsLimitException::builder).httpStatusCode(402).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        EntityResolutionServiceClientConfigurationBuilder serviceConfigBuilder = new EntityResolutionServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
