/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSchemaMappingResponse extends EntityResolutionResponse implements
        ToCopyableBuilder<CreateSchemaMappingResponse.Builder, CreateSchemaMappingResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateSchemaMappingResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<SchemaInputAttribute>> MAPPED_INPUT_FIELDS_FIELD = SdkField
            .<List<SchemaInputAttribute>> builder(MarshallingType.LIST)
            .memberName("mappedInputFields")
            .getter(getter(CreateSchemaMappingResponse::mappedInputFields))
            .setter(setter(Builder::mappedInputFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappedInputFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SchemaInputAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(SchemaInputAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaArn").getter(getter(CreateSchemaMappingResponse::schemaArn)).setter(setter(Builder::schemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaArn").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaName").getter(getter(CreateSchemaMappingResponse::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            MAPPED_INPUT_FIELDS_FIELD, SCHEMA_ARN_FIELD, SCHEMA_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("description", DESCRIPTION_FIELD);
                    put("mappedInputFields", MAPPED_INPUT_FIELDS_FIELD);
                    put("schemaArn", SCHEMA_ARN_FIELD);
                    put("schemaName", SCHEMA_NAME_FIELD);
                }
            });

    private final String description;

    private final List<SchemaInputAttribute> mappedInputFields;

    private final String schemaArn;

    private final String schemaName;

    private CreateSchemaMappingResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.mappedInputFields = builder.mappedInputFields;
        this.schemaArn = builder.schemaArn;
        this.schemaName = builder.schemaName;
    }

    /**
     * <p>
     * A description of the schema.
     * </p>
     * 
     * @return A description of the schema.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the MappedInputFields property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMappedInputFields() {
        return mappedInputFields != null && !(mappedInputFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>MappedInputFields</code>. Each <code>MappedInputField</code> corresponds to a column the source
     * data table, and contains column name plus additional information that Entity Resolution uses for matching.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMappedInputFields} method.
     * </p>
     * 
     * @return A list of <code>MappedInputFields</code>. Each <code>MappedInputField</code> corresponds to a column the
     *         source data table, and contains column name plus additional information that Entity Resolution uses for
     *         matching.
     */
    public final List<SchemaInputAttribute> mappedInputFields() {
        return mappedInputFields;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>SchemaMapping</code>.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>SchemaMapping</code>.
     */
    public final String schemaArn() {
        return schemaArn;
    }

    /**
     * <p>
     * The name of the schema.
     * </p>
     * 
     * @return The name of the schema.
     */
    public final String schemaName() {
        return schemaName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasMappedInputFields() ? mappedInputFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSchemaMappingResponse)) {
            return false;
        }
        CreateSchemaMappingResponse other = (CreateSchemaMappingResponse) obj;
        return Objects.equals(description(), other.description()) && hasMappedInputFields() == other.hasMappedInputFields()
                && Objects.equals(mappedInputFields(), other.mappedInputFields())
                && Objects.equals(schemaArn(), other.schemaArn()) && Objects.equals(schemaName(), other.schemaName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSchemaMappingResponse").add("Description", description())
                .add("MappedInputFields", hasMappedInputFields() ? mappedInputFields() : null).add("SchemaArn", schemaArn())
                .add("SchemaName", schemaName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "mappedInputFields":
            return Optional.ofNullable(clazz.cast(mappedInputFields()));
        case "schemaArn":
            return Optional.ofNullable(clazz.cast(schemaArn()));
        case "schemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateSchemaMappingResponse, T> g) {
        return obj -> g.apply((CreateSchemaMappingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EntityResolutionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSchemaMappingResponse> {
        /**
         * <p>
         * A description of the schema.
         * </p>
         * 
         * @param description
         *        A description of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of <code>MappedInputFields</code>. Each <code>MappedInputField</code> corresponds to a column the
         * source data table, and contains column name plus additional information that Entity Resolution uses for
         * matching.
         * </p>
         * 
         * @param mappedInputFields
         *        A list of <code>MappedInputFields</code>. Each <code>MappedInputField</code> corresponds to a column
         *        the source data table, and contains column name plus additional information that Entity Resolution
         *        uses for matching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappedInputFields(Collection<SchemaInputAttribute> mappedInputFields);

        /**
         * <p>
         * A list of <code>MappedInputFields</code>. Each <code>MappedInputField</code> corresponds to a column the
         * source data table, and contains column name plus additional information that Entity Resolution uses for
         * matching.
         * </p>
         * 
         * @param mappedInputFields
         *        A list of <code>MappedInputFields</code>. Each <code>MappedInputField</code> corresponds to a column
         *        the source data table, and contains column name plus additional information that Entity Resolution
         *        uses for matching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappedInputFields(SchemaInputAttribute... mappedInputFields);

        /**
         * <p>
         * A list of <code>MappedInputFields</code>. Each <code>MappedInputField</code> corresponds to a column the
         * source data table, and contains column name plus additional information that Entity Resolution uses for
         * matching.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.SchemaInputAttribute.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.entityresolution.model.SchemaInputAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.SchemaInputAttribute.Builder#build()} is called
         * immediately and its result is passed to {@link #mappedInputFields(List<SchemaInputAttribute>)}.
         * 
         * @param mappedInputFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.SchemaInputAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mappedInputFields(java.util.Collection<SchemaInputAttribute>)
         */
        Builder mappedInputFields(Consumer<SchemaInputAttribute.Builder>... mappedInputFields);

        /**
         * <p>
         * The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>SchemaMapping</code>.
         * </p>
         * 
         * @param schemaArn
         *        The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>SchemaMapping</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaArn(String schemaArn);

        /**
         * <p>
         * The name of the schema.
         * </p>
         * 
         * @param schemaName
         *        The name of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);
    }

    static final class BuilderImpl extends EntityResolutionResponse.BuilderImpl implements Builder {
        private String description;

        private List<SchemaInputAttribute> mappedInputFields = DefaultSdkAutoConstructList.getInstance();

        private String schemaArn;

        private String schemaName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSchemaMappingResponse model) {
            super(model);
            description(model.description);
            mappedInputFields(model.mappedInputFields);
            schemaArn(model.schemaArn);
            schemaName(model.schemaName);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<SchemaInputAttribute.Builder> getMappedInputFields() {
            List<SchemaInputAttribute.Builder> result = SchemaInputAttributesCopier.copyToBuilder(this.mappedInputFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMappedInputFields(Collection<SchemaInputAttribute.BuilderImpl> mappedInputFields) {
            this.mappedInputFields = SchemaInputAttributesCopier.copyFromBuilder(mappedInputFields);
        }

        @Override
        public final Builder mappedInputFields(Collection<SchemaInputAttribute> mappedInputFields) {
            this.mappedInputFields = SchemaInputAttributesCopier.copy(mappedInputFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappedInputFields(SchemaInputAttribute... mappedInputFields) {
            mappedInputFields(Arrays.asList(mappedInputFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappedInputFields(Consumer<SchemaInputAttribute.Builder>... mappedInputFields) {
            mappedInputFields(Stream.of(mappedInputFields).map(c -> SchemaInputAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSchemaArn() {
            return schemaArn;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public CreateSchemaMappingResponse build() {
            return new CreateSchemaMappingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
