/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The deleted unique ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletedUniqueId implements SdkPojo, Serializable, ToCopyableBuilder<DeletedUniqueId.Builder, DeletedUniqueId> {
    private static final SdkField<String> UNIQUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uniqueId").getter(getter(DeletedUniqueId::uniqueId)).setter(setter(Builder::uniqueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uniqueId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNIQUE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("uniqueId", UNIQUE_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String uniqueId;

    private DeletedUniqueId(BuilderImpl builder) {
        this.uniqueId = builder.uniqueId;
    }

    /**
     * <p>
     * The unique ID of the deleted item.
     * </p>
     * 
     * @return The unique ID of the deleted item.
     */
    public final String uniqueId() {
        return uniqueId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uniqueId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletedUniqueId)) {
            return false;
        }
        DeletedUniqueId other = (DeletedUniqueId) obj;
        return Objects.equals(uniqueId(), other.uniqueId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeletedUniqueId").add("UniqueId", uniqueId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "uniqueId":
            return Optional.ofNullable(clazz.cast(uniqueId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeletedUniqueId, T> g) {
        return obj -> g.apply((DeletedUniqueId) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeletedUniqueId> {
        /**
         * <p>
         * The unique ID of the deleted item.
         * </p>
         * 
         * @param uniqueId
         *        The unique ID of the deleted item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueId(String uniqueId);
    }

    static final class BuilderImpl implements Builder {
        private String uniqueId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletedUniqueId model) {
            uniqueId(model.uniqueId);
        }

        public final String getUniqueId() {
            return uniqueId;
        }

        public final void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        @Override
        public final Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        @Override
        public DeletedUniqueId build() {
            return new DeletedUniqueId(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
