/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings for the ID namespace for the ID mapping workflow job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdNamespaceIdMappingWorkflowMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<IdNamespaceIdMappingWorkflowMetadata.Builder, IdNamespaceIdMappingWorkflowMetadata> {
    private static final SdkField<String> ID_MAPPING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idMappingType").getter(getter(IdNamespaceIdMappingWorkflowMetadata::idMappingTypeAsString))
            .setter(setter(Builder::idMappingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idMappingType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_MAPPING_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("idMappingType", ID_MAPPING_TYPE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String idMappingType;

    private IdNamespaceIdMappingWorkflowMetadata(BuilderImpl builder) {
        this.idMappingType = builder.idMappingType;
    }

    /**
     * <p>
     * The type of ID mapping.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #idMappingType}
     * will return {@link IdMappingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #idMappingTypeAsString}.
     * </p>
     * 
     * @return The type of ID mapping.
     * @see IdMappingType
     */
    public final IdMappingType idMappingType() {
        return IdMappingType.fromValue(idMappingType);
    }

    /**
     * <p>
     * The type of ID mapping.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #idMappingType}
     * will return {@link IdMappingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #idMappingTypeAsString}.
     * </p>
     * 
     * @return The type of ID mapping.
     * @see IdMappingType
     */
    public final String idMappingTypeAsString() {
        return idMappingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(idMappingTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdNamespaceIdMappingWorkflowMetadata)) {
            return false;
        }
        IdNamespaceIdMappingWorkflowMetadata other = (IdNamespaceIdMappingWorkflowMetadata) obj;
        return Objects.equals(idMappingTypeAsString(), other.idMappingTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdNamespaceIdMappingWorkflowMetadata").add("IdMappingType", idMappingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "idMappingType":
            return Optional.ofNullable(clazz.cast(idMappingTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IdNamespaceIdMappingWorkflowMetadata, T> g) {
        return obj -> g.apply((IdNamespaceIdMappingWorkflowMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdNamespaceIdMappingWorkflowMetadata> {
        /**
         * <p>
         * The type of ID mapping.
         * </p>
         * 
         * @param idMappingType
         *        The type of ID mapping.
         * @see IdMappingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdMappingType
         */
        Builder idMappingType(String idMappingType);

        /**
         * <p>
         * The type of ID mapping.
         * </p>
         * 
         * @param idMappingType
         *        The type of ID mapping.
         * @see IdMappingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdMappingType
         */
        Builder idMappingType(IdMappingType idMappingType);
    }

    static final class BuilderImpl implements Builder {
        private String idMappingType;

        private BuilderImpl() {
        }

        private BuilderImpl(IdNamespaceIdMappingWorkflowMetadata model) {
            idMappingType(model.idMappingType);
        }

        public final String getIdMappingType() {
            return idMappingType;
        }

        public final void setIdMappingType(String idMappingType) {
            this.idMappingType = idMappingType;
        }

        @Override
        public final Builder idMappingType(String idMappingType) {
            this.idMappingType = idMappingType;
            return this;
        }

        @Override
        public final Builder idMappingType(IdMappingType idMappingType) {
            this.idMappingType(idMappingType == null ? null : idMappingType.toString());
            return this;
        }

        @Override
        public IdNamespaceIdMappingWorkflowMetadata build() {
            return new IdNamespaceIdMappingWorkflowMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
