/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of <code>MatchingWorkflowSummary</code> objects, each of which contain the fields <code>WorkflowName</code>,
 * <code>WorkflowArn</code>, <code>CreatedAt</code>, <code>UpdatedAt</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MatchingWorkflowSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MatchingWorkflowSummary.Builder, MatchingWorkflowSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(MatchingWorkflowSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> RESOLUTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolutionType").getter(getter(MatchingWorkflowSummary::resolutionTypeAsString))
            .setter(setter(Builder::resolutionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionType").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(MatchingWorkflowSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowArn").getter(getter(MatchingWorkflowSummary::workflowArn)).setter(setter(Builder::workflowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowArn").build()).build();

    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowName").getter(getter(MatchingWorkflowSummary::workflowName))
            .setter(setter(Builder::workflowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            RESOLUTION_TYPE_FIELD, UPDATED_AT_FIELD, WORKFLOW_ARN_FIELD, WORKFLOW_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("createdAt", CREATED_AT_FIELD);
                    put("resolutionType", RESOLUTION_TYPE_FIELD);
                    put("updatedAt", UPDATED_AT_FIELD);
                    put("workflowArn", WORKFLOW_ARN_FIELD);
                    put("workflowName", WORKFLOW_NAME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String resolutionType;

    private final Instant updatedAt;

    private final String workflowArn;

    private final String workflowName;

    private MatchingWorkflowSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.resolutionType = builder.resolutionType;
        this.updatedAt = builder.updatedAt;
        this.workflowArn = builder.workflowArn;
        this.workflowName = builder.workflowName;
    }

    /**
     * <p>
     * The timestamp of when the workflow was created.
     * </p>
     * 
     * @return The timestamp of when the workflow was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The method that has been specified for data matching, either using matching provided by Entity Resolution or
     * through a provider service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolutionType}
     * will return {@link ResolutionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resolutionTypeAsString}.
     * </p>
     * 
     * @return The method that has been specified for data matching, either using matching provided by Entity Resolution
     *         or through a provider service.
     * @see ResolutionType
     */
    public final ResolutionType resolutionType() {
        return ResolutionType.fromValue(resolutionType);
    }

    /**
     * <p>
     * The method that has been specified for data matching, either using matching provided by Entity Resolution or
     * through a provider service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolutionType}
     * will return {@link ResolutionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resolutionTypeAsString}.
     * </p>
     * 
     * @return The method that has been specified for data matching, either using matching provided by Entity Resolution
     *         or through a provider service.
     * @see ResolutionType
     */
    public final String resolutionTypeAsString() {
        return resolutionType;
    }

    /**
     * <p>
     * The timestamp of when the workflow was last updated.
     * </p>
     * 
     * @return The timestamp of when the workflow was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>MatchingWorkflow</code>.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>MatchingWorkflow</code>.
     */
    public final String workflowArn() {
        return workflowArn;
    }

    /**
     * <p>
     * The name of the workflow.
     * </p>
     * 
     * @return The name of the workflow.
     */
    public final String workflowName() {
        return workflowName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(resolutionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(workflowName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchingWorkflowSummary)) {
            return false;
        }
        MatchingWorkflowSummary other = (MatchingWorkflowSummary) obj;
        return Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(resolutionTypeAsString(), other.resolutionTypeAsString())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(workflowArn(), other.workflowArn())
                && Objects.equals(workflowName(), other.workflowName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MatchingWorkflowSummary").add("CreatedAt", createdAt())
                .add("ResolutionType", resolutionTypeAsString()).add("UpdatedAt", updatedAt()).add("WorkflowArn", workflowArn())
                .add("WorkflowName", workflowName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "resolutionType":
            return Optional.ofNullable(clazz.cast(resolutionTypeAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "workflowArn":
            return Optional.ofNullable(clazz.cast(workflowArn()));
        case "workflowName":
            return Optional.ofNullable(clazz.cast(workflowName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MatchingWorkflowSummary, T> g) {
        return obj -> g.apply((MatchingWorkflowSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MatchingWorkflowSummary> {
        /**
         * <p>
         * The timestamp of when the workflow was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the workflow was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The method that has been specified for data matching, either using matching provided by Entity Resolution or
         * through a provider service.
         * </p>
         * 
         * @param resolutionType
         *        The method that has been specified for data matching, either using matching provided by Entity
         *        Resolution or through a provider service.
         * @see ResolutionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolutionType
         */
        Builder resolutionType(String resolutionType);

        /**
         * <p>
         * The method that has been specified for data matching, either using matching provided by Entity Resolution or
         * through a provider service.
         * </p>
         * 
         * @param resolutionType
         *        The method that has been specified for data matching, either using matching provided by Entity
         *        Resolution or through a provider service.
         * @see ResolutionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolutionType
         */
        Builder resolutionType(ResolutionType resolutionType);

        /**
         * <p>
         * The timestamp of when the workflow was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the workflow was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>MatchingWorkflow</code>.
         * </p>
         * 
         * @param workflowArn
         *        The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>MatchingWorkflow</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowArn(String workflowArn);

        /**
         * <p>
         * The name of the workflow.
         * </p>
         * 
         * @param workflowName
         *        The name of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowName(String workflowName);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String resolutionType;

        private Instant updatedAt;

        private String workflowArn;

        private String workflowName;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchingWorkflowSummary model) {
            createdAt(model.createdAt);
            resolutionType(model.resolutionType);
            updatedAt(model.updatedAt);
            workflowArn(model.workflowArn);
            workflowName(model.workflowName);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getResolutionType() {
            return resolutionType;
        }

        public final void setResolutionType(String resolutionType) {
            this.resolutionType = resolutionType;
        }

        @Override
        public final Builder resolutionType(String resolutionType) {
            this.resolutionType = resolutionType;
            return this;
        }

        @Override
        public final Builder resolutionType(ResolutionType resolutionType) {
            this.resolutionType(resolutionType == null ? null : resolutionType.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getWorkflowArn() {
            return workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final String getWorkflowName() {
            return workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        @Override
        public MatchingWorkflowSummary build() {
            return new MatchingWorkflowSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
