/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddPolicyStatementResponse extends EntityResolutionResponse implements
        ToCopyableBuilder<AddPolicyStatementResponse.Builder, AddPolicyStatementResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(AddPolicyStatementResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("policy")
            .getter(getter(AddPolicyStatementResponse::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final SdkField<String> TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("token")
            .getter(getter(AddPolicyStatementResponse::token)).setter(setter(Builder::token))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, POLICY_FIELD,
            TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("arn", ARN_FIELD);
                    put("policy", POLICY_FIELD);
                    put("token", TOKEN_FIELD);
                }
            });

    private final String arn;

    private final String policy;

    private final String token;

    private AddPolicyStatementResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.policy = builder.policy;
        this.token = builder.token;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource that will be accessed by the principal.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource that will be accessed by the principal.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The resource-based policy.
     * </p>
     * 
     * @return The resource-based policy.
     */
    public final String policy() {
        return policy;
    }

    /**
     * <p>
     * A unique identifier for the current revision of the policy.
     * </p>
     * 
     * @return A unique identifier for the current revision of the policy.
     */
    public final String token() {
        return token;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(token());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPolicyStatementResponse)) {
            return false;
        }
        AddPolicyStatementResponse other = (AddPolicyStatementResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(policy(), other.policy())
                && Objects.equals(token(), other.token());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddPolicyStatementResponse").add("Arn", arn()).add("Policy", policy()).add("Token", token())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "token":
            return Optional.ofNullable(clazz.cast(token()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AddPolicyStatementResponse, T> g) {
        return obj -> g.apply((AddPolicyStatementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EntityResolutionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AddPolicyStatementResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource that will be accessed by the principal.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the resource that will be accessed by the principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The resource-based policy.
         * </p>
         * 
         * @param policy
         *        The resource-based policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * A unique identifier for the current revision of the policy.
         * </p>
         * 
         * @param token
         *        A unique identifier for the current revision of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);
    }

    static final class BuilderImpl extends EntityResolutionResponse.BuilderImpl implements Builder {
        private String arn;

        private String policy;

        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(AddPolicyStatementResponse model) {
            super(model);
            arn(model.arn);
            policy(model.policy);
            token(model.token);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final String getToken() {
            return token;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        @Override
        public AddPolicyStatementResponse build() {
            return new AddPolicyStatementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
