/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIdMappingWorkflowResponse extends EntityResolutionResponse implements
        ToCopyableBuilder<CreateIdMappingWorkflowResponse.Builder, CreateIdMappingWorkflowResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateIdMappingWorkflowResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<IdMappingTechniques> ID_MAPPING_TECHNIQUES_FIELD = SdkField
            .<IdMappingTechniques> builder(MarshallingType.SDK_POJO).memberName("idMappingTechniques")
            .getter(getter(CreateIdMappingWorkflowResponse::idMappingTechniques)).setter(setter(Builder::idMappingTechniques))
            .constructor(IdMappingTechniques::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idMappingTechniques").build())
            .build();

    private static final SdkField<List<IdMappingWorkflowInputSource>> INPUT_SOURCE_CONFIG_FIELD = SdkField
            .<List<IdMappingWorkflowInputSource>> builder(MarshallingType.LIST)
            .memberName("inputSourceConfig")
            .getter(getter(CreateIdMappingWorkflowResponse::inputSourceConfig))
            .setter(setter(Builder::inputSourceConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSourceConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdMappingWorkflowInputSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdMappingWorkflowInputSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<IdMappingWorkflowOutputSource>> OUTPUT_SOURCE_CONFIG_FIELD = SdkField
            .<List<IdMappingWorkflowOutputSource>> builder(MarshallingType.LIST)
            .memberName("outputSourceConfig")
            .getter(getter(CreateIdMappingWorkflowResponse::outputSourceConfig))
            .setter(setter(Builder::outputSourceConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSourceConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdMappingWorkflowOutputSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdMappingWorkflowOutputSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateIdMappingWorkflowResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowArn").getter(getter(CreateIdMappingWorkflowResponse::workflowArn))
            .setter(setter(Builder::workflowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowArn").build()).build();

    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowName").getter(getter(CreateIdMappingWorkflowResponse::workflowName))
            .setter(setter(Builder::workflowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            ID_MAPPING_TECHNIQUES_FIELD, INPUT_SOURCE_CONFIG_FIELD, OUTPUT_SOURCE_CONFIG_FIELD, ROLE_ARN_FIELD,
            WORKFLOW_ARN_FIELD, WORKFLOW_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("description", DESCRIPTION_FIELD);
                    put("idMappingTechniques", ID_MAPPING_TECHNIQUES_FIELD);
                    put("inputSourceConfig", INPUT_SOURCE_CONFIG_FIELD);
                    put("outputSourceConfig", OUTPUT_SOURCE_CONFIG_FIELD);
                    put("roleArn", ROLE_ARN_FIELD);
                    put("workflowArn", WORKFLOW_ARN_FIELD);
                    put("workflowName", WORKFLOW_NAME_FIELD);
                }
            });

    private final String description;

    private final IdMappingTechniques idMappingTechniques;

    private final List<IdMappingWorkflowInputSource> inputSourceConfig;

    private final List<IdMappingWorkflowOutputSource> outputSourceConfig;

    private final String roleArn;

    private final String workflowArn;

    private final String workflowName;

    private CreateIdMappingWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.idMappingTechniques = builder.idMappingTechniques;
        this.inputSourceConfig = builder.inputSourceConfig;
        this.outputSourceConfig = builder.outputSourceConfig;
        this.roleArn = builder.roleArn;
        this.workflowArn = builder.workflowArn;
        this.workflowName = builder.workflowName;
    }

    /**
     * <p>
     * A description of the workflow.
     * </p>
     * 
     * @return A description of the workflow.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * An object which defines the ID mapping technique and any additional configurations.
     * </p>
     * 
     * @return An object which defines the ID mapping technique and any additional configurations.
     */
    public final IdMappingTechniques idMappingTechniques() {
        return idMappingTechniques;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputSourceConfig property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputSourceConfig() {
        return inputSourceConfig != null && !(inputSourceConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
     * <code>SchemaName</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputSourceConfig} method.
     * </p>
     * 
     * @return A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
     *         <code>SchemaName</code>.
     */
    public final List<IdMappingWorkflowInputSource> inputSourceConfig() {
        return inputSourceConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputSourceConfig property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputSourceConfig() {
        return outputSourceConfig != null && !(outputSourceConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>IdMappingWorkflowOutputSource</code> objects, each of which contains fields
     * <code>OutputS3Path</code> and <code>Output</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputSourceConfig} method.
     * </p>
     * 
     * @return A list of <code>IdMappingWorkflowOutputSource</code> objects, each of which contains fields
     *         <code>OutputS3Path</code> and <code>Output</code>.
     */
    public final List<IdMappingWorkflowOutputSource> outputSourceConfig() {
        return outputSourceConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to create resources on your
     * behalf as part of workflow execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to create resources
     *         on your behalf as part of workflow execution.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>IDMappingWorkflow</code>.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>IDMappingWorkflow</code>.
     */
    public final String workflowArn() {
        return workflowArn;
    }

    /**
     * <p>
     * The name of the workflow.
     * </p>
     * 
     * @return The name of the workflow.
     */
    public final String workflowName() {
        return workflowName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(idMappingTechniques());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputSourceConfig() ? inputSourceConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputSourceConfig() ? outputSourceConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(workflowName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIdMappingWorkflowResponse)) {
            return false;
        }
        CreateIdMappingWorkflowResponse other = (CreateIdMappingWorkflowResponse) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(idMappingTechniques(), other.idMappingTechniques())
                && hasInputSourceConfig() == other.hasInputSourceConfig()
                && Objects.equals(inputSourceConfig(), other.inputSourceConfig())
                && hasOutputSourceConfig() == other.hasOutputSourceConfig()
                && Objects.equals(outputSourceConfig(), other.outputSourceConfig()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(workflowArn(), other.workflowArn()) && Objects.equals(workflowName(), other.workflowName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIdMappingWorkflowResponse").add("Description", description())
                .add("IdMappingTechniques", idMappingTechniques())
                .add("InputSourceConfig", hasInputSourceConfig() ? inputSourceConfig() : null)
                .add("OutputSourceConfig", hasOutputSourceConfig() ? outputSourceConfig() : null).add("RoleArn", roleArn())
                .add("WorkflowArn", workflowArn()).add("WorkflowName", workflowName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "idMappingTechniques":
            return Optional.ofNullable(clazz.cast(idMappingTechniques()));
        case "inputSourceConfig":
            return Optional.ofNullable(clazz.cast(inputSourceConfig()));
        case "outputSourceConfig":
            return Optional.ofNullable(clazz.cast(outputSourceConfig()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "workflowArn":
            return Optional.ofNullable(clazz.cast(workflowArn()));
        case "workflowName":
            return Optional.ofNullable(clazz.cast(workflowName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateIdMappingWorkflowResponse, T> g) {
        return obj -> g.apply((CreateIdMappingWorkflowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EntityResolutionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateIdMappingWorkflowResponse> {
        /**
         * <p>
         * A description of the workflow.
         * </p>
         * 
         * @param description
         *        A description of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An object which defines the ID mapping technique and any additional configurations.
         * </p>
         * 
         * @param idMappingTechniques
         *        An object which defines the ID mapping technique and any additional configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idMappingTechniques(IdMappingTechniques idMappingTechniques);

        /**
         * <p>
         * An object which defines the ID mapping technique and any additional configurations.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdMappingTechniques.Builder} avoiding the
         * need to create one manually via {@link IdMappingTechniques#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdMappingTechniques.Builder#build()} is called immediately and
         * its result is passed to {@link #idMappingTechniques(IdMappingTechniques)}.
         * 
         * @param idMappingTechniques
         *        a consumer that will call methods on {@link IdMappingTechniques.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #idMappingTechniques(IdMappingTechniques)
         */
        default Builder idMappingTechniques(Consumer<IdMappingTechniques.Builder> idMappingTechniques) {
            return idMappingTechniques(IdMappingTechniques.builder().applyMutation(idMappingTechniques).build());
        }

        /**
         * <p>
         * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
         * <code>SchemaName</code>.
         * </p>
         * 
         * @param inputSourceConfig
         *        A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
         *        <code>SchemaName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSourceConfig(Collection<IdMappingWorkflowInputSource> inputSourceConfig);

        /**
         * <p>
         * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
         * <code>SchemaName</code>.
         * </p>
         * 
         * @param inputSourceConfig
         *        A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
         *        <code>SchemaName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSourceConfig(IdMappingWorkflowInputSource... inputSourceConfig);

        /**
         * <p>
         * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
         * <code>SchemaName</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowInputSource.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowInputSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowInputSource.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #inputSourceConfig(List<IdMappingWorkflowInputSource>)}.
         * 
         * @param inputSourceConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowInputSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSourceConfig(java.util.Collection<IdMappingWorkflowInputSource>)
         */
        Builder inputSourceConfig(Consumer<IdMappingWorkflowInputSource.Builder>... inputSourceConfig);

        /**
         * <p>
         * A list of <code>IdMappingWorkflowOutputSource</code> objects, each of which contains fields
         * <code>OutputS3Path</code> and <code>Output</code>.
         * </p>
         * 
         * @param outputSourceConfig
         *        A list of <code>IdMappingWorkflowOutputSource</code> objects, each of which contains fields
         *        <code>OutputS3Path</code> and <code>Output</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSourceConfig(Collection<IdMappingWorkflowOutputSource> outputSourceConfig);

        /**
         * <p>
         * A list of <code>IdMappingWorkflowOutputSource</code> objects, each of which contains fields
         * <code>OutputS3Path</code> and <code>Output</code>.
         * </p>
         * 
         * @param outputSourceConfig
         *        A list of <code>IdMappingWorkflowOutputSource</code> objects, each of which contains fields
         *        <code>OutputS3Path</code> and <code>Output</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSourceConfig(IdMappingWorkflowOutputSource... outputSourceConfig);

        /**
         * <p>
         * A list of <code>IdMappingWorkflowOutputSource</code> objects, each of which contains fields
         * <code>OutputS3Path</code> and <code>Output</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowOutputSource.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowOutputSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowOutputSource.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #outputSourceConfig(List<IdMappingWorkflowOutputSource>)}.
         * 
         * @param outputSourceConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowOutputSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputSourceConfig(java.util.Collection<IdMappingWorkflowOutputSource>)
         */
        Builder outputSourceConfig(Consumer<IdMappingWorkflowOutputSource.Builder>... outputSourceConfig);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to create resources on
         * your behalf as part of workflow execution.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to create
         *        resources on your behalf as part of workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>IDMappingWorkflow</code>.
         * </p>
         * 
         * @param workflowArn
         *        The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>IDMappingWorkflow</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowArn(String workflowArn);

        /**
         * <p>
         * The name of the workflow.
         * </p>
         * 
         * @param workflowName
         *        The name of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowName(String workflowName);
    }

    static final class BuilderImpl extends EntityResolutionResponse.BuilderImpl implements Builder {
        private String description;

        private IdMappingTechniques idMappingTechniques;

        private List<IdMappingWorkflowInputSource> inputSourceConfig = DefaultSdkAutoConstructList.getInstance();

        private List<IdMappingWorkflowOutputSource> outputSourceConfig = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private String workflowArn;

        private String workflowName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIdMappingWorkflowResponse model) {
            super(model);
            description(model.description);
            idMappingTechniques(model.idMappingTechniques);
            inputSourceConfig(model.inputSourceConfig);
            outputSourceConfig(model.outputSourceConfig);
            roleArn(model.roleArn);
            workflowArn(model.workflowArn);
            workflowName(model.workflowName);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final IdMappingTechniques.Builder getIdMappingTechniques() {
            return idMappingTechniques != null ? idMappingTechniques.toBuilder() : null;
        }

        public final void setIdMappingTechniques(IdMappingTechniques.BuilderImpl idMappingTechniques) {
            this.idMappingTechniques = idMappingTechniques != null ? idMappingTechniques.build() : null;
        }

        @Override
        public final Builder idMappingTechniques(IdMappingTechniques idMappingTechniques) {
            this.idMappingTechniques = idMappingTechniques;
            return this;
        }

        public final List<IdMappingWorkflowInputSource.Builder> getInputSourceConfig() {
            List<IdMappingWorkflowInputSource.Builder> result = IdMappingWorkflowInputSourceConfigCopier
                    .copyToBuilder(this.inputSourceConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputSourceConfig(Collection<IdMappingWorkflowInputSource.BuilderImpl> inputSourceConfig) {
            this.inputSourceConfig = IdMappingWorkflowInputSourceConfigCopier.copyFromBuilder(inputSourceConfig);
        }

        @Override
        public final Builder inputSourceConfig(Collection<IdMappingWorkflowInputSource> inputSourceConfig) {
            this.inputSourceConfig = IdMappingWorkflowInputSourceConfigCopier.copy(inputSourceConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSourceConfig(IdMappingWorkflowInputSource... inputSourceConfig) {
            inputSourceConfig(Arrays.asList(inputSourceConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSourceConfig(Consumer<IdMappingWorkflowInputSource.Builder>... inputSourceConfig) {
            inputSourceConfig(Stream.of(inputSourceConfig)
                    .map(c -> IdMappingWorkflowInputSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<IdMappingWorkflowOutputSource.Builder> getOutputSourceConfig() {
            List<IdMappingWorkflowOutputSource.Builder> result = IdMappingWorkflowOutputSourceConfigCopier
                    .copyToBuilder(this.outputSourceConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSourceConfig(Collection<IdMappingWorkflowOutputSource.BuilderImpl> outputSourceConfig) {
            this.outputSourceConfig = IdMappingWorkflowOutputSourceConfigCopier.copyFromBuilder(outputSourceConfig);
        }

        @Override
        public final Builder outputSourceConfig(Collection<IdMappingWorkflowOutputSource> outputSourceConfig) {
            this.outputSourceConfig = IdMappingWorkflowOutputSourceConfigCopier.copy(outputSourceConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(IdMappingWorkflowOutputSource... outputSourceConfig) {
            outputSourceConfig(Arrays.asList(outputSourceConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(Consumer<IdMappingWorkflowOutputSource.Builder>... outputSourceConfig) {
            outputSourceConfig(Stream.of(outputSourceConfig)
                    .map(c -> IdMappingWorkflowOutputSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getWorkflowArn() {
            return workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final String getWorkflowName() {
            return workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        @Override
        public CreateIdMappingWorkflowResponse build() {
            return new CreateIdMappingWorkflowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
