/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIdMappingJobResponse extends EntityResolutionResponse implements
        ToCopyableBuilder<GetIdMappingJobResponse.Builder, GetIdMappingJobResponse> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(GetIdMappingJobResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<ErrorDetails> ERROR_DETAILS_FIELD = SdkField.<ErrorDetails> builder(MarshallingType.SDK_POJO)
            .memberName("errorDetails").getter(getter(GetIdMappingJobResponse::errorDetails))
            .setter(setter(Builder::errorDetails)).constructor(ErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDetails").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(GetIdMappingJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<IdMappingJobMetrics> METRICS_FIELD = SdkField
            .<IdMappingJobMetrics> builder(MarshallingType.SDK_POJO).memberName("metrics")
            .getter(getter(GetIdMappingJobResponse::metrics)).setter(setter(Builder::metrics))
            .constructor(IdMappingJobMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build()).build();

    private static final SdkField<List<IdMappingJobOutputSource>> OUTPUT_SOURCE_CONFIG_FIELD = SdkField
            .<List<IdMappingJobOutputSource>> builder(MarshallingType.LIST)
            .memberName("outputSourceConfig")
            .getter(getter(GetIdMappingJobResponse::outputSourceConfig))
            .setter(setter(Builder::outputSourceConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSourceConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdMappingJobOutputSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdMappingJobOutputSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(GetIdMappingJobResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetIdMappingJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD,
            ERROR_DETAILS_FIELD, JOB_ID_FIELD, METRICS_FIELD, OUTPUT_SOURCE_CONFIG_FIELD, START_TIME_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("endTime", END_TIME_FIELD);
                    put("errorDetails", ERROR_DETAILS_FIELD);
                    put("jobId", JOB_ID_FIELD);
                    put("metrics", METRICS_FIELD);
                    put("outputSourceConfig", OUTPUT_SOURCE_CONFIG_FIELD);
                    put("startTime", START_TIME_FIELD);
                    put("status", STATUS_FIELD);
                }
            });

    private final Instant endTime;

    private final ErrorDetails errorDetails;

    private final String jobId;

    private final IdMappingJobMetrics metrics;

    private final List<IdMappingJobOutputSource> outputSourceConfig;

    private final Instant startTime;

    private final String status;

    private GetIdMappingJobResponse(BuilderImpl builder) {
        super(builder);
        this.endTime = builder.endTime;
        this.errorDetails = builder.errorDetails;
        this.jobId = builder.jobId;
        this.metrics = builder.metrics;
        this.outputSourceConfig = builder.outputSourceConfig;
        this.startTime = builder.startTime;
        this.status = builder.status;
    }

    /**
     * <p>
     * The time at which the job has finished.
     * </p>
     * 
     * @return The time at which the job has finished.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * Returns the value of the ErrorDetails property for this object.
     * 
     * @return The value of the ErrorDetails property for this object.
     */
    public final ErrorDetails errorDetails() {
        return errorDetails;
    }

    /**
     * <p>
     * The ID of the job.
     * </p>
     * 
     * @return The ID of the job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * Metrics associated with the execution, specifically total records processed, unique IDs generated, and records
     * the execution skipped.
     * </p>
     * 
     * @return Metrics associated with the execution, specifically total records processed, unique IDs generated, and
     *         records the execution skipped.
     */
    public final IdMappingJobMetrics metrics() {
        return metrics;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputSourceConfig property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputSourceConfig() {
        return outputSourceConfig != null && !(outputSourceConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>OutputSource</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputSourceConfig} method.
     * </p>
     * 
     * @return A list of <code>OutputSource</code> objects.
     */
    public final List<IdMappingJobOutputSource> outputSourceConfig() {
        return outputSourceConfig;
    }

    /**
     * <p>
     * The time at which the job was started.
     * </p>
     * 
     * @return The time at which the job was started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The current status of the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the job.
     * @see JobStatus
     */
    public final JobStatus status() {
        return JobStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the job.
     * @see JobStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(metrics());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputSourceConfig() ? outputSourceConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdMappingJobResponse)) {
            return false;
        }
        GetIdMappingJobResponse other = (GetIdMappingJobResponse) obj;
        return Objects.equals(endTime(), other.endTime()) && Objects.equals(errorDetails(), other.errorDetails())
                && Objects.equals(jobId(), other.jobId()) && Objects.equals(metrics(), other.metrics())
                && hasOutputSourceConfig() == other.hasOutputSourceConfig()
                && Objects.equals(outputSourceConfig(), other.outputSourceConfig())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIdMappingJobResponse").add("EndTime", endTime()).add("ErrorDetails", errorDetails())
                .add("JobId", jobId()).add("Metrics", metrics())
                .add("OutputSourceConfig", hasOutputSourceConfig() ? outputSourceConfig() : null).add("StartTime", startTime())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "errorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "outputSourceConfig":
            return Optional.ofNullable(clazz.cast(outputSourceConfig()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetIdMappingJobResponse, T> g) {
        return obj -> g.apply((GetIdMappingJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EntityResolutionResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetIdMappingJobResponse> {
        /**
         * <p>
         * The time at which the job has finished.
         * </p>
         * 
         * @param endTime
         *        The time at which the job has finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * Sets the value of the ErrorDetails property for this object.
         *
         * @param errorDetails
         *        The new value for the ErrorDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(ErrorDetails errorDetails);

        /**
         * Sets the value of the ErrorDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ErrorDetails.Builder} avoiding the need
         * to create one manually via {@link ErrorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #errorDetails(ErrorDetails)}.
         * 
         * @param errorDetails
         *        a consumer that will call methods on {@link ErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetails(ErrorDetails)
         */
        default Builder errorDetails(Consumer<ErrorDetails.Builder> errorDetails) {
            return errorDetails(ErrorDetails.builder().applyMutation(errorDetails).build());
        }

        /**
         * <p>
         * The ID of the job.
         * </p>
         * 
         * @param jobId
         *        The ID of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * Metrics associated with the execution, specifically total records processed, unique IDs generated, and
         * records the execution skipped.
         * </p>
         * 
         * @param metrics
         *        Metrics associated with the execution, specifically total records processed, unique IDs generated, and
         *        records the execution skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(IdMappingJobMetrics metrics);

        /**
         * <p>
         * Metrics associated with the execution, specifically total records processed, unique IDs generated, and
         * records the execution skipped.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdMappingJobMetrics.Builder} avoiding the
         * need to create one manually via {@link IdMappingJobMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdMappingJobMetrics.Builder#build()} is called immediately and
         * its result is passed to {@link #metrics(IdMappingJobMetrics)}.
         * 
         * @param metrics
         *        a consumer that will call methods on {@link IdMappingJobMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(IdMappingJobMetrics)
         */
        default Builder metrics(Consumer<IdMappingJobMetrics.Builder> metrics) {
            return metrics(IdMappingJobMetrics.builder().applyMutation(metrics).build());
        }

        /**
         * <p>
         * A list of <code>OutputSource</code> objects.
         * </p>
         * 
         * @param outputSourceConfig
         *        A list of <code>OutputSource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSourceConfig(Collection<IdMappingJobOutputSource> outputSourceConfig);

        /**
         * <p>
         * A list of <code>OutputSource</code> objects.
         * </p>
         * 
         * @param outputSourceConfig
         *        A list of <code>OutputSource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSourceConfig(IdMappingJobOutputSource... outputSourceConfig);

        /**
         * <p>
         * A list of <code>OutputSource</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.IdMappingJobOutputSource.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.entityresolution.model.IdMappingJobOutputSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.IdMappingJobOutputSource.Builder#build()} is
         * called immediately and its result is passed to {@link #outputSourceConfig(List<IdMappingJobOutputSource>)}.
         * 
         * @param outputSourceConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.IdMappingJobOutputSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputSourceConfig(java.util.Collection<IdMappingJobOutputSource>)
         */
        Builder outputSourceConfig(Consumer<IdMappingJobOutputSource.Builder>... outputSourceConfig);

        /**
         * <p>
         * The time at which the job was started.
         * </p>
         * 
         * @param startTime
         *        The time at which the job was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The current status of the job.
         * </p>
         * 
         * @param status
         *        The current status of the job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the job.
         * </p>
         * 
         * @param status
         *        The current status of the job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(JobStatus status);
    }

    static final class BuilderImpl extends EntityResolutionResponse.BuilderImpl implements Builder {
        private Instant endTime;

        private ErrorDetails errorDetails;

        private String jobId;

        private IdMappingJobMetrics metrics;

        private List<IdMappingJobOutputSource> outputSourceConfig = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdMappingJobResponse model) {
            super(model);
            endTime(model.endTime);
            errorDetails(model.errorDetails);
            jobId(model.jobId);
            metrics(model.metrics);
            outputSourceConfig(model.outputSourceConfig);
            startTime(model.startTime);
            status(model.status);
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final ErrorDetails.Builder getErrorDetails() {
            return errorDetails != null ? errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(ErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final IdMappingJobMetrics.Builder getMetrics() {
            return metrics != null ? metrics.toBuilder() : null;
        }

        public final void setMetrics(IdMappingJobMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(IdMappingJobMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public final List<IdMappingJobOutputSource.Builder> getOutputSourceConfig() {
            List<IdMappingJobOutputSource.Builder> result = IdMappingJobOutputSourceConfigCopier
                    .copyToBuilder(this.outputSourceConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSourceConfig(Collection<IdMappingJobOutputSource.BuilderImpl> outputSourceConfig) {
            this.outputSourceConfig = IdMappingJobOutputSourceConfigCopier.copyFromBuilder(outputSourceConfig);
        }

        @Override
        public final Builder outputSourceConfig(Collection<IdMappingJobOutputSource> outputSourceConfig) {
            this.outputSourceConfig = IdMappingJobOutputSourceConfigCopier.copy(outputSourceConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(IdMappingJobOutputSource... outputSourceConfig) {
            outputSourceConfig(Arrays.asList(outputSourceConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(Consumer<IdMappingJobOutputSource.Builder>... outputSourceConfig) {
            outputSourceConfig(Stream.of(outputSourceConfig)
                    .map(c -> IdMappingJobOutputSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetIdMappingJobResponse build() {
            return new GetIdMappingJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
