/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing <code>InputSourceARN</code>, <code>SchemaName</code>, and <code>Type</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdMappingWorkflowInputSource implements SdkPojo, Serializable,
        ToCopyableBuilder<IdMappingWorkflowInputSource.Builder, IdMappingWorkflowInputSource> {
    private static final SdkField<String> INPUT_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputSourceARN").getter(getter(IdMappingWorkflowInputSource::inputSourceARN))
            .setter(setter(Builder::inputSourceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSourceARN").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaName").getter(getter(IdMappingWorkflowInputSource::schemaName))
            .setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(IdMappingWorkflowInputSource::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_SOURCE_ARN_FIELD,
            SCHEMA_NAME_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("inputSourceARN", INPUT_SOURCE_ARN_FIELD);
                    put("schemaName", SCHEMA_NAME_FIELD);
                    put("type", TYPE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String inputSourceARN;

    private final String schemaName;

    private final String type;

    private IdMappingWorkflowInputSource(BuilderImpl builder) {
        this.inputSourceARN = builder.inputSourceARN;
        this.schemaName = builder.schemaName;
        this.type = builder.type;
    }

    /**
     * <p>
     * An Glue table Amazon Resource Name (ARN) or a matching workflow ARN for the input source table.
     * </p>
     * 
     * @return An Glue table Amazon Resource Name (ARN) or a matching workflow ARN for the input source table.
     */
    public final String inputSourceARN() {
        return inputSourceARN;
    }

    /**
     * <p>
     * The name of the schema to be retrieved.
     * </p>
     * 
     * @return The name of the schema to be retrieved.
     */
    public final String schemaName() {
        return schemaName;
    }

    /**
     * <p>
     * The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.
     * </p>
     * <p>
     * The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an ID
     * mapping workflow.
     * </p>
     * <p>
     * The <code>TARGET</code> contains a configuration of <code>targetId</code> which all <code>sourceIds</code> will
     * resolve to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IdNamespaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>. </p>
     *         <p>
     *         The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in
     *         an ID mapping workflow.
     *         </p>
     *         <p>
     *         The <code>TARGET</code> contains a configuration of <code>targetId</code> which all
     *         <code>sourceIds</code> will resolve to.
     * @see IdNamespaceType
     */
    public final IdNamespaceType type() {
        return IdNamespaceType.fromValue(type);
    }

    /**
     * <p>
     * The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.
     * </p>
     * <p>
     * The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an ID
     * mapping workflow.
     * </p>
     * <p>
     * The <code>TARGET</code> contains a configuration of <code>targetId</code> which all <code>sourceIds</code> will
     * resolve to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IdNamespaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>. </p>
     *         <p>
     *         The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in
     *         an ID mapping workflow.
     *         </p>
     *         <p>
     *         The <code>TARGET</code> contains a configuration of <code>targetId</code> which all
     *         <code>sourceIds</code> will resolve to.
     * @see IdNamespaceType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputSourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdMappingWorkflowInputSource)) {
            return false;
        }
        IdMappingWorkflowInputSource other = (IdMappingWorkflowInputSource) obj;
        return Objects.equals(inputSourceARN(), other.inputSourceARN()) && Objects.equals(schemaName(), other.schemaName())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdMappingWorkflowInputSource").add("InputSourceARN", inputSourceARN())
                .add("SchemaName", schemaName()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputSourceARN":
            return Optional.ofNullable(clazz.cast(inputSourceARN()));
        case "schemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IdMappingWorkflowInputSource, T> g) {
        return obj -> g.apply((IdMappingWorkflowInputSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdMappingWorkflowInputSource> {
        /**
         * <p>
         * An Glue table Amazon Resource Name (ARN) or a matching workflow ARN for the input source table.
         * </p>
         * 
         * @param inputSourceARN
         *        An Glue table Amazon Resource Name (ARN) or a matching workflow ARN for the input source table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSourceARN(String inputSourceARN);

        /**
         * <p>
         * The name of the schema to be retrieved.
         * </p>
         * 
         * @param schemaName
         *        The name of the schema to be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * <p>
         * The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.
         * </p>
         * <p>
         * The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an
         * ID mapping workflow.
         * </p>
         * <p>
         * The <code>TARGET</code> contains a configuration of <code>targetId</code> which all <code>sourceIds</code>
         * will resolve to.
         * </p>
         * 
         * @param type
         *        The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>. </p>
         *        <p>
         *        The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed
         *        in an ID mapping workflow.
         *        </p>
         *        <p>
         *        The <code>TARGET</code> contains a configuration of <code>targetId</code> which all
         *        <code>sourceIds</code> will resolve to.
         * @see IdNamespaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdNamespaceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.
         * </p>
         * <p>
         * The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an
         * ID mapping workflow.
         * </p>
         * <p>
         * The <code>TARGET</code> contains a configuration of <code>targetId</code> which all <code>sourceIds</code>
         * will resolve to.
         * </p>
         * 
         * @param type
         *        The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>. </p>
         *        <p>
         *        The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed
         *        in an ID mapping workflow.
         *        </p>
         *        <p>
         *        The <code>TARGET</code> contains a configuration of <code>targetId</code> which all
         *        <code>sourceIds</code> will resolve to.
         * @see IdNamespaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdNamespaceType
         */
        Builder type(IdNamespaceType type);
    }

    static final class BuilderImpl implements Builder {
        private String inputSourceARN;

        private String schemaName;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(IdMappingWorkflowInputSource model) {
            inputSourceARN(model.inputSourceARN);
            schemaName(model.schemaName);
            type(model.type);
        }

        public final String getInputSourceARN() {
            return inputSourceARN;
        }

        public final void setInputSourceARN(String inputSourceARN) {
            this.inputSourceARN = inputSourceARN;
        }

        @Override
        public final Builder inputSourceARN(String inputSourceARN) {
            this.inputSourceARN = inputSourceARN;
            return this;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IdNamespaceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public IdMappingWorkflowInputSource build() {
            return new IdMappingWorkflowInputSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
