/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing <code>InputSourceARN</code> and <code>SchemaName</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdNamespaceInputSource implements SdkPojo, Serializable,
        ToCopyableBuilder<IdNamespaceInputSource.Builder, IdNamespaceInputSource> {
    private static final SdkField<String> INPUT_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputSourceARN").getter(getter(IdNamespaceInputSource::inputSourceARN))
            .setter(setter(Builder::inputSourceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSourceARN").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaName").getter(getter(IdNamespaceInputSource::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_SOURCE_ARN_FIELD,
            SCHEMA_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("inputSourceARN", INPUT_SOURCE_ARN_FIELD);
                    put("schemaName", SCHEMA_NAME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String inputSourceARN;

    private final String schemaName;

    private IdNamespaceInputSource(BuilderImpl builder) {
        this.inputSourceARN = builder.inputSourceARN;
        this.schemaName = builder.schemaName;
    }

    /**
     * <p>
     * An Glue table Amazon Resource Name (ARN) or a matching workflow ARN for the input source table.
     * </p>
     * 
     * @return An Glue table Amazon Resource Name (ARN) or a matching workflow ARN for the input source table.
     */
    public final String inputSourceARN() {
        return inputSourceARN;
    }

    /**
     * <p>
     * The name of the schema.
     * </p>
     * 
     * @return The name of the schema.
     */
    public final String schemaName() {
        return schemaName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputSourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdNamespaceInputSource)) {
            return false;
        }
        IdNamespaceInputSource other = (IdNamespaceInputSource) obj;
        return Objects.equals(inputSourceARN(), other.inputSourceARN()) && Objects.equals(schemaName(), other.schemaName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdNamespaceInputSource").add("InputSourceARN", inputSourceARN()).add("SchemaName", schemaName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputSourceARN":
            return Optional.ofNullable(clazz.cast(inputSourceARN()));
        case "schemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IdNamespaceInputSource, T> g) {
        return obj -> g.apply((IdNamespaceInputSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdNamespaceInputSource> {
        /**
         * <p>
         * An Glue table Amazon Resource Name (ARN) or a matching workflow ARN for the input source table.
         * </p>
         * 
         * @param inputSourceARN
         *        An Glue table Amazon Resource Name (ARN) or a matching workflow ARN for the input source table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSourceARN(String inputSourceARN);

        /**
         * <p>
         * The name of the schema.
         * </p>
         * 
         * @param schemaName
         *        The name of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);
    }

    static final class BuilderImpl implements Builder {
        private String inputSourceARN;

        private String schemaName;

        private BuilderImpl() {
        }

        private BuilderImpl(IdNamespaceInputSource model) {
            inputSourceARN(model.inputSourceARN);
            schemaName(model.schemaName);
        }

        public final String getInputSourceARN() {
            return inputSourceARN;
        }

        public final void setInputSourceARN(String inputSourceARN) {
            this.inputSourceARN = inputSourceARN;
        }

        @Override
        public final Builder inputSourceARN(String inputSourceARN) {
            this.inputSourceARN = inputSourceARN;
            return this;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public IdNamespaceInputSource build() {
            return new IdNamespaceInputSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
