/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing <code>KMSArn</code>, <code>OutputS3Path</code>, and <code>RoleArn</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobOutputSource implements SdkPojo, Serializable, ToCopyableBuilder<JobOutputSource.Builder, JobOutputSource> {
    private static final SdkField<String> KMS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KMSArn")
            .getter(getter(JobOutputSource::kmsArn)).setter(setter(Builder::kmsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSArn").build()).build();

    private static final SdkField<String> OUTPUT_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputS3Path").getter(getter(JobOutputSource::outputS3Path)).setter(setter(Builder::outputS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Path").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(JobOutputSource::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_ARN_FIELD,
            OUTPUT_S3_PATH_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("KMSArn", KMS_ARN_FIELD);
                    put("outputS3Path", OUTPUT_S3_PATH_FIELD);
                    put("roleArn", ROLE_ARN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String kmsArn;

    private final String outputS3Path;

    private final String roleArn;

    private JobOutputSource(BuilderImpl builder) {
        this.kmsArn = builder.kmsArn;
        this.outputS3Path = builder.outputS3Path;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * Customer KMS ARN for encryption at rest. If not provided, system will use an Entity Resolution managed KMS key.
     * </p>
     * 
     * @return Customer KMS ARN for encryption at rest. If not provided, system will use an Entity Resolution managed
     *         KMS key.
     */
    public final String kmsArn() {
        return kmsArn;
    }

    /**
     * <p>
     * The S3 path to which Entity Resolution will write the output table.
     * </p>
     * 
     * @return The S3 path to which Entity Resolution will write the output table.
     */
    public final String outputS3Path() {
        return outputS3Path;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access Amazon Web Services
     * resources on your behalf as part of workflow execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access Amazon Web
     *         Services resources on your behalf as part of workflow execution.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsArn());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobOutputSource)) {
            return false;
        }
        JobOutputSource other = (JobOutputSource) obj;
        return Objects.equals(kmsArn(), other.kmsArn()) && Objects.equals(outputS3Path(), other.outputS3Path())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobOutputSource").add("KMSArn", kmsArn()).add("OutputS3Path", outputS3Path())
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KMSArn":
            return Optional.ofNullable(clazz.cast(kmsArn()));
        case "outputS3Path":
            return Optional.ofNullable(clazz.cast(outputS3Path()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<JobOutputSource, T> g) {
        return obj -> g.apply((JobOutputSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobOutputSource> {
        /**
         * <p>
         * Customer KMS ARN for encryption at rest. If not provided, system will use an Entity Resolution managed KMS
         * key.
         * </p>
         * 
         * @param kmsArn
         *        Customer KMS ARN for encryption at rest. If not provided, system will use an Entity Resolution managed
         *        KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsArn(String kmsArn);

        /**
         * <p>
         * The S3 path to which Entity Resolution will write the output table.
         * </p>
         * 
         * @param outputS3Path
         *        The S3 path to which Entity Resolution will write the output table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Path(String outputS3Path);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access Amazon Web
         * Services resources on your behalf as part of workflow execution.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access Amazon
         *        Web Services resources on your behalf as part of workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String kmsArn;

        private String outputS3Path;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(JobOutputSource model) {
            kmsArn(model.kmsArn);
            outputS3Path(model.outputS3Path);
            roleArn(model.roleArn);
        }

        public final String getKmsArn() {
            return kmsArn;
        }

        public final void setKmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
        }

        @Override
        public final Builder kmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
            return this;
        }

        public final String getOutputS3Path() {
            return outputS3Path;
        }

        public final void setOutputS3Path(String outputS3Path) {
            this.outputS3Path = outputS3Path;
        }

        @Override
        public final Builder outputS3Path(String outputS3Path) {
            this.outputS3Path = outputS3Path;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public JobOutputSource build() {
            return new JobOutputSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
