/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIdNamespacesResponse extends EntityResolutionResponse implements
        ToCopyableBuilder<ListIdNamespacesResponse.Builder, ListIdNamespacesResponse> {
    private static final SdkField<List<IdNamespaceSummary>> ID_NAMESPACE_SUMMARIES_FIELD = SdkField
            .<List<IdNamespaceSummary>> builder(MarshallingType.LIST)
            .memberName("idNamespaceSummaries")
            .getter(getter(ListIdNamespacesResponse::idNamespaceSummaries))
            .setter(setter(Builder::idNamespaceSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idNamespaceSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdNamespaceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdNamespaceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListIdNamespacesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_NAMESPACE_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("idNamespaceSummaries", ID_NAMESPACE_SUMMARIES_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<IdNamespaceSummary> idNamespaceSummaries;

    private final String nextToken;

    private ListIdNamespacesResponse(BuilderImpl builder) {
        super(builder);
        this.idNamespaceSummaries = builder.idNamespaceSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IdNamespaceSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIdNamespaceSummaries() {
        return idNamespaceSummaries != null && !(idNamespaceSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>IdNamespaceSummaries</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdNamespaceSummaries} method.
     * </p>
     * 
     * @return A list of <code>IdNamespaceSummaries</code> objects.
     */
    public final List<IdNamespaceSummary> idNamespaceSummaries() {
        return idNamespaceSummaries;
    }

    /**
     * <p>
     * The pagination token from the previous API call.
     * </p>
     * 
     * @return The pagination token from the previous API call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIdNamespaceSummaries() ? idNamespaceSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdNamespacesResponse)) {
            return false;
        }
        ListIdNamespacesResponse other = (ListIdNamespacesResponse) obj;
        return hasIdNamespaceSummaries() == other.hasIdNamespaceSummaries()
                && Objects.equals(idNamespaceSummaries(), other.idNamespaceSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIdNamespacesResponse")
                .add("IdNamespaceSummaries", hasIdNamespaceSummaries() ? idNamespaceSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "idNamespaceSummaries":
            return Optional.ofNullable(clazz.cast(idNamespaceSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListIdNamespacesResponse, T> g) {
        return obj -> g.apply((ListIdNamespacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EntityResolutionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListIdNamespacesResponse> {
        /**
         * <p>
         * A list of <code>IdNamespaceSummaries</code> objects.
         * </p>
         * 
         * @param idNamespaceSummaries
         *        A list of <code>IdNamespaceSummaries</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idNamespaceSummaries(Collection<IdNamespaceSummary> idNamespaceSummaries);

        /**
         * <p>
         * A list of <code>IdNamespaceSummaries</code> objects.
         * </p>
         * 
         * @param idNamespaceSummaries
         *        A list of <code>IdNamespaceSummaries</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idNamespaceSummaries(IdNamespaceSummary... idNamespaceSummaries);

        /**
         * <p>
         * A list of <code>IdNamespaceSummaries</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.IdNamespaceSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.entityresolution.model.IdNamespaceSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.IdNamespaceSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #idNamespaceSummaries(List<IdNamespaceSummary>)}.
         * 
         * @param idNamespaceSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.IdNamespaceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #idNamespaceSummaries(java.util.Collection<IdNamespaceSummary>)
         */
        Builder idNamespaceSummaries(Consumer<IdNamespaceSummary.Builder>... idNamespaceSummaries);

        /**
         * <p>
         * The pagination token from the previous API call.
         * </p>
         * 
         * @param nextToken
         *        The pagination token from the previous API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EntityResolutionResponse.BuilderImpl implements Builder {
        private List<IdNamespaceSummary> idNamespaceSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdNamespacesResponse model) {
            super(model);
            idNamespaceSummaries(model.idNamespaceSummaries);
            nextToken(model.nextToken);
        }

        public final List<IdNamespaceSummary.Builder> getIdNamespaceSummaries() {
            List<IdNamespaceSummary.Builder> result = IdNamespaceListCopier.copyToBuilder(this.idNamespaceSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdNamespaceSummaries(Collection<IdNamespaceSummary.BuilderImpl> idNamespaceSummaries) {
            this.idNamespaceSummaries = IdNamespaceListCopier.copyFromBuilder(idNamespaceSummaries);
        }

        @Override
        public final Builder idNamespaceSummaries(Collection<IdNamespaceSummary> idNamespaceSummaries) {
            this.idNamespaceSummaries = IdNamespaceListCopier.copy(idNamespaceSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idNamespaceSummaries(IdNamespaceSummary... idNamespaceSummaries) {
            idNamespaceSummaries(Arrays.asList(idNamespaceSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idNamespaceSummaries(Consumer<IdNamespaceSummary.Builder>... idNamespaceSummaries) {
            idNamespaceSummaries(Stream.of(idNamespaceSummaries).map(c -> IdNamespaceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIdNamespacesResponse build() {
            return new ListIdNamespacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
