/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProviderServicesResponse extends EntityResolutionResponse implements
        ToCopyableBuilder<ListProviderServicesResponse.Builder, ListProviderServicesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListProviderServicesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ProviderServiceSummary>> PROVIDER_SERVICE_SUMMARIES_FIELD = SdkField
            .<List<ProviderServiceSummary>> builder(MarshallingType.LIST)
            .memberName("providerServiceSummaries")
            .getter(getter(ListProviderServicesResponse::providerServiceSummaries))
            .setter(setter(Builder::providerServiceSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProviderServiceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProviderServiceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PROVIDER_SERVICE_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("nextToken", NEXT_TOKEN_FIELD);
                    put("providerServiceSummaries", PROVIDER_SERVICE_SUMMARIES_FIELD);
                }
            });

    private final String nextToken;

    private final List<ProviderServiceSummary> providerServiceSummaries;

    private ListProviderServicesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.providerServiceSummaries = builder.providerServiceSummaries;
    }

    /**
     * <p>
     * The pagination token from the previous API call.
     * </p>
     * 
     * @return The pagination token from the previous API call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProviderServiceSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProviderServiceSummaries() {
        return providerServiceSummaries != null && !(providerServiceSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ProviderServices</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProviderServiceSummaries} method.
     * </p>
     * 
     * @return A list of <code>ProviderServices</code> objects.
     */
    public final List<ProviderServiceSummary> providerServiceSummaries() {
        return providerServiceSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasProviderServiceSummaries() ? providerServiceSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProviderServicesResponse)) {
            return false;
        }
        ListProviderServicesResponse other = (ListProviderServicesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasProviderServiceSummaries() == other.hasProviderServiceSummaries()
                && Objects.equals(providerServiceSummaries(), other.providerServiceSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProviderServicesResponse").add("NextToken", nextToken())
                .add("ProviderServiceSummaries", hasProviderServiceSummaries() ? providerServiceSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "providerServiceSummaries":
            return Optional.ofNullable(clazz.cast(providerServiceSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListProviderServicesResponse, T> g) {
        return obj -> g.apply((ListProviderServicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EntityResolutionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListProviderServicesResponse> {
        /**
         * <p>
         * The pagination token from the previous API call.
         * </p>
         * 
         * @param nextToken
         *        The pagination token from the previous API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of <code>ProviderServices</code> objects.
         * </p>
         * 
         * @param providerServiceSummaries
         *        A list of <code>ProviderServices</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerServiceSummaries(Collection<ProviderServiceSummary> providerServiceSummaries);

        /**
         * <p>
         * A list of <code>ProviderServices</code> objects.
         * </p>
         * 
         * @param providerServiceSummaries
         *        A list of <code>ProviderServices</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerServiceSummaries(ProviderServiceSummary... providerServiceSummaries);

        /**
         * <p>
         * A list of <code>ProviderServices</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.ProviderServiceSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.entityresolution.model.ProviderServiceSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.ProviderServiceSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #providerServiceSummaries(List<ProviderServiceSummary>)}.
         * 
         * @param providerServiceSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.ProviderServiceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #providerServiceSummaries(java.util.Collection<ProviderServiceSummary>)
         */
        Builder providerServiceSummaries(Consumer<ProviderServiceSummary.Builder>... providerServiceSummaries);
    }

    static final class BuilderImpl extends EntityResolutionResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ProviderServiceSummary> providerServiceSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListProviderServicesResponse model) {
            super(model);
            nextToken(model.nextToken);
            providerServiceSummaries(model.providerServiceSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ProviderServiceSummary.Builder> getProviderServiceSummaries() {
            List<ProviderServiceSummary.Builder> result = ProviderServiceListCopier.copyToBuilder(this.providerServiceSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProviderServiceSummaries(Collection<ProviderServiceSummary.BuilderImpl> providerServiceSummaries) {
            this.providerServiceSummaries = ProviderServiceListCopier.copyFromBuilder(providerServiceSummaries);
        }

        @Override
        public final Builder providerServiceSummaries(Collection<ProviderServiceSummary> providerServiceSummaries) {
            this.providerServiceSummaries = ProviderServiceListCopier.copy(providerServiceSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerServiceSummaries(ProviderServiceSummary... providerServiceSummaries) {
            providerServiceSummaries(Arrays.asList(providerServiceSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerServiceSummaries(Consumer<ProviderServiceSummary.Builder>... providerServiceSummaries) {
            providerServiceSummaries(Stream.of(providerServiceSummaries)
                    .map(c -> ProviderServiceSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListProviderServicesResponse build() {
            return new ListProviderServicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
