/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIdNamespaceRequest extends EntityResolutionRequest implements
        ToCopyableBuilder<GetIdNamespaceRequest.Builder, GetIdNamespaceRequest> {
    private static final SdkField<String> ID_NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idNamespaceName").getter(getter(GetIdNamespaceRequest::idNamespaceName))
            .setter(setter(Builder::idNamespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("idNamespaceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_NAMESPACE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String idNamespaceName;

    private GetIdNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.idNamespaceName = builder.idNamespaceName;
    }

    /**
     * <p>
     * The name of the ID namespace.
     * </p>
     * 
     * @return The name of the ID namespace.
     */
    public final String idNamespaceName() {
        return idNamespaceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(idNamespaceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdNamespaceRequest)) {
            return false;
        }
        GetIdNamespaceRequest other = (GetIdNamespaceRequest) obj;
        return Objects.equals(idNamespaceName(), other.idNamespaceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIdNamespaceRequest").add("IdNamespaceName", idNamespaceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "idNamespaceName":
            return Optional.ofNullable(clazz.cast(idNamespaceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("idNamespaceName", ID_NAMESPACE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIdNamespaceRequest, T> g) {
        return obj -> g.apply((GetIdNamespaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EntityResolutionRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetIdNamespaceRequest> {
        /**
         * <p>
         * The name of the ID namespace.
         * </p>
         * 
         * @param idNamespaceName
         *        The name of the ID namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idNamespaceName(String idNamespaceName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EntityResolutionRequest.BuilderImpl implements Builder {
        private String idNamespaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdNamespaceRequest model) {
            super(model);
            idNamespaceName(model.idNamespaceName);
        }

        public final String getIdNamespaceName() {
            return idNamespaceName;
        }

        public final void setIdNamespaceName(String idNamespaceName) {
            this.idNamespaceName = idNamespaceName;
        }

        @Override
        public final Builder idNamespaceName(String idNamespaceName) {
            this.idNamespaceName = idNamespaceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIdNamespaceRequest build() {
            return new GetIdNamespaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
