/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing <code>SchemaName</code>, <code>SchemaArn</code>, <code>CreatedAt</code>, and
 * <code>UpdatedAt</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaMappingSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SchemaMappingSummary.Builder, SchemaMappingSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(SchemaMappingSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Boolean> HAS_WORKFLOWS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("hasWorkflows").getter(getter(SchemaMappingSummary::hasWorkflows)).setter(setter(Builder::hasWorkflows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasWorkflows").build()).build();

    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaArn").getter(getter(SchemaMappingSummary::schemaArn)).setter(setter(Builder::schemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaArn").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaName").getter(getter(SchemaMappingSummary::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaName").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(SchemaMappingSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            HAS_WORKFLOWS_FIELD, SCHEMA_ARN_FIELD, SCHEMA_NAME_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final Boolean hasWorkflows;

    private final String schemaArn;

    private final String schemaName;

    private final Instant updatedAt;

    private SchemaMappingSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.hasWorkflows = builder.hasWorkflows;
        this.schemaArn = builder.schemaArn;
        this.schemaName = builder.schemaName;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The timestamp of when the <code>SchemaMapping</code> was created.
     * </p>
     * 
     * @return The timestamp of when the <code>SchemaMapping</code> was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Specifies whether the schema mapping has been applied to a workflow.
     * </p>
     * 
     * @return Specifies whether the schema mapping has been applied to a workflow.
     */
    public final Boolean hasWorkflows() {
        return hasWorkflows;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>SchemaMapping</code>.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>SchemaMapping</code>.
     */
    public final String schemaArn() {
        return schemaArn;
    }

    /**
     * <p>
     * The name of the schema.
     * </p>
     * 
     * @return The name of the schema.
     */
    public final String schemaName() {
        return schemaName;
    }

    /**
     * <p>
     * The timestamp of when the <code>SchemaMapping</code> was last updated.
     * </p>
     * 
     * @return The timestamp of when the <code>SchemaMapping</code> was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkflows());
        hashCode = 31 * hashCode + Objects.hashCode(schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaMappingSummary)) {
            return false;
        }
        SchemaMappingSummary other = (SchemaMappingSummary) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(hasWorkflows(), other.hasWorkflows())
                && Objects.equals(schemaArn(), other.schemaArn()) && Objects.equals(schemaName(), other.schemaName())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchemaMappingSummary").add("CreatedAt", createdAt()).add("HasWorkflows", hasWorkflows())
                .add("SchemaArn", schemaArn()).add("SchemaName", schemaName()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "hasWorkflows":
            return Optional.ofNullable(clazz.cast(hasWorkflows()));
        case "schemaArn":
            return Optional.ofNullable(clazz.cast(schemaArn()));
        case "schemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("hasWorkflows", HAS_WORKFLOWS_FIELD);
        map.put("schemaArn", SCHEMA_ARN_FIELD);
        map.put("schemaName", SCHEMA_NAME_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchemaMappingSummary, T> g) {
        return obj -> g.apply((SchemaMappingSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaMappingSummary> {
        /**
         * <p>
         * The timestamp of when the <code>SchemaMapping</code> was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the <code>SchemaMapping</code> was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Specifies whether the schema mapping has been applied to a workflow.
         * </p>
         * 
         * @param hasWorkflows
         *        Specifies whether the schema mapping has been applied to a workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasWorkflows(Boolean hasWorkflows);

        /**
         * <p>
         * The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>SchemaMapping</code>.
         * </p>
         * 
         * @param schemaArn
         *        The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>SchemaMapping</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaArn(String schemaArn);

        /**
         * <p>
         * The name of the schema.
         * </p>
         * 
         * @param schemaName
         *        The name of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * <p>
         * The timestamp of when the <code>SchemaMapping</code> was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the <code>SchemaMapping</code> was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private Boolean hasWorkflows;

        private String schemaArn;

        private String schemaName;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaMappingSummary model) {
            createdAt(model.createdAt);
            hasWorkflows(model.hasWorkflows);
            schemaArn(model.schemaArn);
            schemaName(model.schemaName);
            updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Boolean getHasWorkflows() {
            return hasWorkflows;
        }

        public final void setHasWorkflows(Boolean hasWorkflows) {
            this.hasWorkflows = hasWorkflows;
        }

        @Override
        public final Builder hasWorkflows(Boolean hasWorkflows) {
            this.hasWorkflows = hasWorkflows;
            return this;
        }

        public final String getSchemaArn() {
            return schemaArn;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public SchemaMappingSummary build() {
            return new SchemaMappingSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
