/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteUniqueIdRequest extends EntityResolutionRequest implements
        ToCopyableBuilder<BatchDeleteUniqueIdRequest.Builder, BatchDeleteUniqueIdRequest> {
    private static final SdkField<String> INPUT_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputSource").getter(getter(BatchDeleteUniqueIdRequest::inputSource))
            .setter(setter(Builder::inputSource))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("inputSource").build()).build();

    private static final SdkField<List<String>> UNIQUE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("uniqueIds")
            .getter(getter(BatchDeleteUniqueIdRequest::uniqueIds))
            .setter(setter(Builder::uniqueIds))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("uniqueIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowName").getter(getter(BatchDeleteUniqueIdRequest::workflowName))
            .setter(setter(Builder::workflowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_SOURCE_FIELD,
            UNIQUE_IDS_FIELD, WORKFLOW_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String inputSource;

    private final List<String> uniqueIds;

    private final String workflowName;

    private BatchDeleteUniqueIdRequest(BuilderImpl builder) {
        super(builder);
        this.inputSource = builder.inputSource;
        this.uniqueIds = builder.uniqueIds;
        this.workflowName = builder.workflowName;
    }

    /**
     * <p>
     * The input source for the batch delete unique ID operation.
     * </p>
     * 
     * @return The input source for the batch delete unique ID operation.
     */
    public final String inputSource() {
        return inputSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the UniqueIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUniqueIds() {
        return uniqueIds != null && !(uniqueIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique IDs to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUniqueIds} method.
     * </p>
     * 
     * @return The unique IDs to delete.
     */
    public final List<String> uniqueIds() {
        return uniqueIds;
    }

    /**
     * <p>
     * The name of the workflow.
     * </p>
     * 
     * @return The name of the workflow.
     */
    public final String workflowName() {
        return workflowName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inputSource());
        hashCode = 31 * hashCode + Objects.hashCode(hasUniqueIds() ? uniqueIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workflowName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteUniqueIdRequest)) {
            return false;
        }
        BatchDeleteUniqueIdRequest other = (BatchDeleteUniqueIdRequest) obj;
        return Objects.equals(inputSource(), other.inputSource()) && hasUniqueIds() == other.hasUniqueIds()
                && Objects.equals(uniqueIds(), other.uniqueIds()) && Objects.equals(workflowName(), other.workflowName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteUniqueIdRequest").add("InputSource", inputSource())
                .add("UniqueIds", hasUniqueIds() ? uniqueIds() : null).add("WorkflowName", workflowName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputSource":
            return Optional.ofNullable(clazz.cast(inputSource()));
        case "uniqueIds":
            return Optional.ofNullable(clazz.cast(uniqueIds()));
        case "workflowName":
            return Optional.ofNullable(clazz.cast(workflowName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inputSource", INPUT_SOURCE_FIELD);
        map.put("uniqueIds", UNIQUE_IDS_FIELD);
        map.put("workflowName", WORKFLOW_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteUniqueIdRequest, T> g) {
        return obj -> g.apply((BatchDeleteUniqueIdRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EntityResolutionRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDeleteUniqueIdRequest> {
        /**
         * <p>
         * The input source for the batch delete unique ID operation.
         * </p>
         * 
         * @param inputSource
         *        The input source for the batch delete unique ID operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSource(String inputSource);

        /**
         * <p>
         * The unique IDs to delete.
         * </p>
         * 
         * @param uniqueIds
         *        The unique IDs to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueIds(Collection<String> uniqueIds);

        /**
         * <p>
         * The unique IDs to delete.
         * </p>
         * 
         * @param uniqueIds
         *        The unique IDs to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueIds(String... uniqueIds);

        /**
         * <p>
         * The name of the workflow.
         * </p>
         * 
         * @param workflowName
         *        The name of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowName(String workflowName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EntityResolutionRequest.BuilderImpl implements Builder {
        private String inputSource;

        private List<String> uniqueIds = DefaultSdkAutoConstructList.getInstance();

        private String workflowName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteUniqueIdRequest model) {
            super(model);
            inputSource(model.inputSource);
            uniqueIds(model.uniqueIds);
            workflowName(model.workflowName);
        }

        public final String getInputSource() {
            return inputSource;
        }

        public final void setInputSource(String inputSource) {
            this.inputSource = inputSource;
        }

        @Override
        public final Builder inputSource(String inputSource) {
            this.inputSource = inputSource;
            return this;
        }

        public final Collection<String> getUniqueIds() {
            if (uniqueIds instanceof SdkAutoConstructList) {
                return null;
            }
            return uniqueIds;
        }

        public final void setUniqueIds(Collection<String> uniqueIds) {
            this.uniqueIds = UniqueIdListCopier.copy(uniqueIds);
        }

        @Override
        public final Builder uniqueIds(Collection<String> uniqueIds) {
            this.uniqueIds = UniqueIdListCopier.copy(uniqueIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uniqueIds(String... uniqueIds) {
            uniqueIds(Arrays.asList(uniqueIds));
            return this;
        }

        public final String getWorkflowName() {
            return workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteUniqueIdRequest build() {
            return new BatchDeleteUniqueIdRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
