/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProviderServiceResponse extends EntityResolutionResponse implements
        ToCopyableBuilder<GetProviderServiceResponse.Builder, GetProviderServiceResponse> {
    private static final SdkField<Boolean> ANONYMIZED_OUTPUT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("anonymizedOutput").getter(getter(GetProviderServiceResponse::anonymizedOutput))
            .setter(setter(Builder::anonymizedOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anonymizedOutput").build()).build();

    private static final SdkField<ProviderComponentSchema> PROVIDER_COMPONENT_SCHEMA_FIELD = SdkField
            .<ProviderComponentSchema> builder(MarshallingType.SDK_POJO).memberName("providerComponentSchema")
            .getter(getter(GetProviderServiceResponse::providerComponentSchema)).setter(setter(Builder::providerComponentSchema))
            .constructor(ProviderComponentSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerComponentSchema").build())
            .build();

    private static final SdkField<Document> PROVIDER_CONFIGURATION_DEFINITION_FIELD = SdkField
            .<Document> builder(MarshallingType.DOCUMENT)
            .memberName("providerConfigurationDefinition")
            .getter(getter(GetProviderServiceResponse::providerConfigurationDefinition))
            .setter(setter(Builder::providerConfigurationDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerConfigurationDefinition")
                    .build()).build();

    private static final SdkField<ProviderEndpointConfiguration> PROVIDER_ENDPOINT_CONFIGURATION_FIELD = SdkField
            .<ProviderEndpointConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("providerEndpointConfiguration")
            .getter(getter(GetProviderServiceResponse::providerEndpointConfiguration))
            .setter(setter(Builder::providerEndpointConfiguration))
            .constructor(ProviderEndpointConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerEndpointConfiguration")
                    .build()).build();

    private static final SdkField<Document> PROVIDER_ENTITY_OUTPUT_DEFINITION_FIELD = SdkField
            .<Document> builder(MarshallingType.DOCUMENT)
            .memberName("providerEntityOutputDefinition")
            .getter(getter(GetProviderServiceResponse::providerEntityOutputDefinition))
            .setter(setter(Builder::providerEntityOutputDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerEntityOutputDefinition")
                    .build()).build();

    private static final SdkField<ProviderIdNameSpaceConfiguration> PROVIDER_ID_NAME_SPACE_CONFIGURATION_FIELD = SdkField
            .<ProviderIdNameSpaceConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("providerIdNameSpaceConfiguration")
            .getter(getter(GetProviderServiceResponse::providerIdNameSpaceConfiguration))
            .setter(setter(Builder::providerIdNameSpaceConfiguration))
            .constructor(ProviderIdNameSpaceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerIdNameSpaceConfiguration")
                    .build()).build();

    private static final SdkField<ProviderIntermediateDataAccessConfiguration> PROVIDER_INTERMEDIATE_DATA_ACCESS_CONFIGURATION_FIELD = SdkField
            .<ProviderIntermediateDataAccessConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("providerIntermediateDataAccessConfiguration")
            .getter(getter(GetProviderServiceResponse::providerIntermediateDataAccessConfiguration))
            .setter(setter(Builder::providerIntermediateDataAccessConfiguration))
            .constructor(ProviderIntermediateDataAccessConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("providerIntermediateDataAccessConfiguration").build()).build();

    private static final SdkField<Document> PROVIDER_JOB_CONFIGURATION_FIELD = SdkField
            .<Document> builder(MarshallingType.DOCUMENT).memberName("providerJobConfiguration")
            .getter(getter(GetProviderServiceResponse::providerJobConfiguration))
            .setter(setter(Builder::providerJobConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerJobConfiguration").build())
            .build();

    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerName").getter(getter(GetProviderServiceResponse::providerName))
            .setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()).build();

    private static final SdkField<String> PROVIDER_SERVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerServiceArn").getter(getter(GetProviderServiceResponse::providerServiceArn))
            .setter(setter(Builder::providerServiceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceArn").build())
            .build();

    private static final SdkField<String> PROVIDER_SERVICE_DISPLAY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("providerServiceDisplayName")
            .getter(getter(GetProviderServiceResponse::providerServiceDisplayName))
            .setter(setter(Builder::providerServiceDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceDisplayName").build())
            .build();

    private static final SdkField<String> PROVIDER_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerServiceName").getter(getter(GetProviderServiceResponse::providerServiceName))
            .setter(setter(Builder::providerServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceName").build())
            .build();

    private static final SdkField<String> PROVIDER_SERVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerServiceType").getter(getter(GetProviderServiceResponse::providerServiceTypeAsString))
            .setter(setter(Builder::providerServiceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANONYMIZED_OUTPUT_FIELD,
            PROVIDER_COMPONENT_SCHEMA_FIELD, PROVIDER_CONFIGURATION_DEFINITION_FIELD, PROVIDER_ENDPOINT_CONFIGURATION_FIELD,
            PROVIDER_ENTITY_OUTPUT_DEFINITION_FIELD, PROVIDER_ID_NAME_SPACE_CONFIGURATION_FIELD,
            PROVIDER_INTERMEDIATE_DATA_ACCESS_CONFIGURATION_FIELD, PROVIDER_JOB_CONFIGURATION_FIELD, PROVIDER_NAME_FIELD,
            PROVIDER_SERVICE_ARN_FIELD, PROVIDER_SERVICE_DISPLAY_NAME_FIELD, PROVIDER_SERVICE_NAME_FIELD,
            PROVIDER_SERVICE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean anonymizedOutput;

    private final ProviderComponentSchema providerComponentSchema;

    private final Document providerConfigurationDefinition;

    private final ProviderEndpointConfiguration providerEndpointConfiguration;

    private final Document providerEntityOutputDefinition;

    private final ProviderIdNameSpaceConfiguration providerIdNameSpaceConfiguration;

    private final ProviderIntermediateDataAccessConfiguration providerIntermediateDataAccessConfiguration;

    private final Document providerJobConfiguration;

    private final String providerName;

    private final String providerServiceArn;

    private final String providerServiceDisplayName;

    private final String providerServiceName;

    private final String providerServiceType;

    private GetProviderServiceResponse(BuilderImpl builder) {
        super(builder);
        this.anonymizedOutput = builder.anonymizedOutput;
        this.providerComponentSchema = builder.providerComponentSchema;
        this.providerConfigurationDefinition = builder.providerConfigurationDefinition;
        this.providerEndpointConfiguration = builder.providerEndpointConfiguration;
        this.providerEntityOutputDefinition = builder.providerEntityOutputDefinition;
        this.providerIdNameSpaceConfiguration = builder.providerIdNameSpaceConfiguration;
        this.providerIntermediateDataAccessConfiguration = builder.providerIntermediateDataAccessConfiguration;
        this.providerJobConfiguration = builder.providerJobConfiguration;
        this.providerName = builder.providerName;
        this.providerServiceArn = builder.providerServiceArn;
        this.providerServiceDisplayName = builder.providerServiceDisplayName;
        this.providerServiceName = builder.providerServiceName;
        this.providerServiceType = builder.providerServiceType;
    }

    /**
     * <p>
     * Specifies whether output data from the provider is anonymized. A value of <code>TRUE</code> means the output will
     * be anonymized and you can't relate the data that comes back from the provider to the identifying input. A value
     * of <code>FALSE</code> means the output won't be anonymized and you can relate the data that comes back from the
     * provider to your source data.
     * </p>
     * 
     * @return Specifies whether output data from the provider is anonymized. A value of <code>TRUE</code> means the
     *         output will be anonymized and you can't relate the data that comes back from the provider to the
     *         identifying input. A value of <code>FALSE</code> means the output won't be anonymized and you can relate
     *         the data that comes back from the provider to your source data.
     */
    public final Boolean anonymizedOutput() {
        return anonymizedOutput;
    }

    /**
     * <p>
     * Input schema for the provider service.
     * </p>
     * 
     * @return Input schema for the provider service.
     */
    public final ProviderComponentSchema providerComponentSchema() {
        return providerComponentSchema;
    }

    /**
     * <p>
     * The definition of the provider configuration.
     * </p>
     * 
     * @return The definition of the provider configuration.
     */
    public final Document providerConfigurationDefinition() {
        return providerConfigurationDefinition;
    }

    /**
     * <p>
     * The required configuration fields to use with the provider service.
     * </p>
     * 
     * @return The required configuration fields to use with the provider service.
     */
    public final ProviderEndpointConfiguration providerEndpointConfiguration() {
        return providerEndpointConfiguration;
    }

    /**
     * <p>
     * The definition of the provider entity output.
     * </p>
     * 
     * @return The definition of the provider entity output.
     */
    public final Document providerEntityOutputDefinition() {
        return providerEntityOutputDefinition;
    }

    /**
     * <p>
     * The provider configuration required for different ID namespace types.
     * </p>
     * 
     * @return The provider configuration required for different ID namespace types.
     */
    public final ProviderIdNameSpaceConfiguration providerIdNameSpaceConfiguration() {
        return providerIdNameSpaceConfiguration;
    }

    /**
     * <p>
     * The Amazon Web Services accounts and the S3 permissions that are required by some providers to create an S3
     * bucket for intermediate data storage.
     * </p>
     * 
     * @return The Amazon Web Services accounts and the S3 permissions that are required by some providers to create an
     *         S3 bucket for intermediate data storage.
     */
    public final ProviderIntermediateDataAccessConfiguration providerIntermediateDataAccessConfiguration() {
        return providerIntermediateDataAccessConfiguration;
    }

    /**
     * <p>
     * Provider service job configurations.
     * </p>
     * 
     * @return Provider service job configurations.
     */
    public final Document providerJobConfiguration() {
        return providerJobConfiguration;
    }

    /**
     * <p>
     * The name of the provider. This name is typically the company name.
     * </p>
     * 
     * @return The name of the provider. This name is typically the company name.
     */
    public final String providerName() {
        return providerName;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) that Entity Resolution generated for the provider service.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) that Entity Resolution generated for the provider service.
     */
    public final String providerServiceArn() {
        return providerServiceArn;
    }

    /**
     * <p>
     * The display name of the provider service.
     * </p>
     * 
     * @return The display name of the provider service.
     */
    public final String providerServiceDisplayName() {
        return providerServiceDisplayName;
    }

    /**
     * <p>
     * The name of the product that the provider service provides.
     * </p>
     * 
     * @return The name of the product that the provider service provides.
     */
    public final String providerServiceName() {
        return providerServiceName;
    }

    /**
     * <p>
     * The type of provider service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #providerServiceType} will return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #providerServiceTypeAsString}.
     * </p>
     * 
     * @return The type of provider service.
     * @see ServiceType
     */
    public final ServiceType providerServiceType() {
        return ServiceType.fromValue(providerServiceType);
    }

    /**
     * <p>
     * The type of provider service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #providerServiceType} will return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #providerServiceTypeAsString}.
     * </p>
     * 
     * @return The type of provider service.
     * @see ServiceType
     */
    public final String providerServiceTypeAsString() {
        return providerServiceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anonymizedOutput());
        hashCode = 31 * hashCode + Objects.hashCode(providerComponentSchema());
        hashCode = 31 * hashCode + Objects.hashCode(providerConfigurationDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(providerEndpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(providerEntityOutputDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(providerIdNameSpaceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(providerIntermediateDataAccessConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(providerJobConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        hashCode = 31 * hashCode + Objects.hashCode(providerServiceArn());
        hashCode = 31 * hashCode + Objects.hashCode(providerServiceDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(providerServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(providerServiceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProviderServiceResponse)) {
            return false;
        }
        GetProviderServiceResponse other = (GetProviderServiceResponse) obj;
        return Objects.equals(anonymizedOutput(), other.anonymizedOutput())
                && Objects.equals(providerComponentSchema(), other.providerComponentSchema())
                && Objects.equals(providerConfigurationDefinition(), other.providerConfigurationDefinition())
                && Objects.equals(providerEndpointConfiguration(), other.providerEndpointConfiguration())
                && Objects.equals(providerEntityOutputDefinition(), other.providerEntityOutputDefinition())
                && Objects.equals(providerIdNameSpaceConfiguration(), other.providerIdNameSpaceConfiguration())
                && Objects.equals(providerIntermediateDataAccessConfiguration(),
                        other.providerIntermediateDataAccessConfiguration())
                && Objects.equals(providerJobConfiguration(), other.providerJobConfiguration())
                && Objects.equals(providerName(), other.providerName())
                && Objects.equals(providerServiceArn(), other.providerServiceArn())
                && Objects.equals(providerServiceDisplayName(), other.providerServiceDisplayName())
                && Objects.equals(providerServiceName(), other.providerServiceName())
                && Objects.equals(providerServiceTypeAsString(), other.providerServiceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProviderServiceResponse").add("AnonymizedOutput", anonymizedOutput())
                .add("ProviderComponentSchema", providerComponentSchema())
                .add("ProviderConfigurationDefinition", providerConfigurationDefinition())
                .add("ProviderEndpointConfiguration", providerEndpointConfiguration())
                .add("ProviderEntityOutputDefinition", providerEntityOutputDefinition())
                .add("ProviderIdNameSpaceConfiguration", providerIdNameSpaceConfiguration())
                .add("ProviderIntermediateDataAccessConfiguration", providerIntermediateDataAccessConfiguration())
                .add("ProviderJobConfiguration", providerJobConfiguration()).add("ProviderName", providerName())
                .add("ProviderServiceArn", providerServiceArn()).add("ProviderServiceDisplayName", providerServiceDisplayName())
                .add("ProviderServiceName", providerServiceName()).add("ProviderServiceType", providerServiceTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "anonymizedOutput":
            return Optional.ofNullable(clazz.cast(anonymizedOutput()));
        case "providerComponentSchema":
            return Optional.ofNullable(clazz.cast(providerComponentSchema()));
        case "providerConfigurationDefinition":
            return Optional.ofNullable(clazz.cast(providerConfigurationDefinition()));
        case "providerEndpointConfiguration":
            return Optional.ofNullable(clazz.cast(providerEndpointConfiguration()));
        case "providerEntityOutputDefinition":
            return Optional.ofNullable(clazz.cast(providerEntityOutputDefinition()));
        case "providerIdNameSpaceConfiguration":
            return Optional.ofNullable(clazz.cast(providerIdNameSpaceConfiguration()));
        case "providerIntermediateDataAccessConfiguration":
            return Optional.ofNullable(clazz.cast(providerIntermediateDataAccessConfiguration()));
        case "providerJobConfiguration":
            return Optional.ofNullable(clazz.cast(providerJobConfiguration()));
        case "providerName":
            return Optional.ofNullable(clazz.cast(providerName()));
        case "providerServiceArn":
            return Optional.ofNullable(clazz.cast(providerServiceArn()));
        case "providerServiceDisplayName":
            return Optional.ofNullable(clazz.cast(providerServiceDisplayName()));
        case "providerServiceName":
            return Optional.ofNullable(clazz.cast(providerServiceName()));
        case "providerServiceType":
            return Optional.ofNullable(clazz.cast(providerServiceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("anonymizedOutput", ANONYMIZED_OUTPUT_FIELD);
        map.put("providerComponentSchema", PROVIDER_COMPONENT_SCHEMA_FIELD);
        map.put("providerConfigurationDefinition", PROVIDER_CONFIGURATION_DEFINITION_FIELD);
        map.put("providerEndpointConfiguration", PROVIDER_ENDPOINT_CONFIGURATION_FIELD);
        map.put("providerEntityOutputDefinition", PROVIDER_ENTITY_OUTPUT_DEFINITION_FIELD);
        map.put("providerIdNameSpaceConfiguration", PROVIDER_ID_NAME_SPACE_CONFIGURATION_FIELD);
        map.put("providerIntermediateDataAccessConfiguration", PROVIDER_INTERMEDIATE_DATA_ACCESS_CONFIGURATION_FIELD);
        map.put("providerJobConfiguration", PROVIDER_JOB_CONFIGURATION_FIELD);
        map.put("providerName", PROVIDER_NAME_FIELD);
        map.put("providerServiceArn", PROVIDER_SERVICE_ARN_FIELD);
        map.put("providerServiceDisplayName", PROVIDER_SERVICE_DISPLAY_NAME_FIELD);
        map.put("providerServiceName", PROVIDER_SERVICE_NAME_FIELD);
        map.put("providerServiceType", PROVIDER_SERVICE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetProviderServiceResponse, T> g) {
        return obj -> g.apply((GetProviderServiceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EntityResolutionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetProviderServiceResponse> {
        /**
         * <p>
         * Specifies whether output data from the provider is anonymized. A value of <code>TRUE</code> means the output
         * will be anonymized and you can't relate the data that comes back from the provider to the identifying input.
         * A value of <code>FALSE</code> means the output won't be anonymized and you can relate the data that comes
         * back from the provider to your source data.
         * </p>
         * 
         * @param anonymizedOutput
         *        Specifies whether output data from the provider is anonymized. A value of <code>TRUE</code> means the
         *        output will be anonymized and you can't relate the data that comes back from the provider to the
         *        identifying input. A value of <code>FALSE</code> means the output won't be anonymized and you can
         *        relate the data that comes back from the provider to your source data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anonymizedOutput(Boolean anonymizedOutput);

        /**
         * <p>
         * Input schema for the provider service.
         * </p>
         * 
         * @param providerComponentSchema
         *        Input schema for the provider service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerComponentSchema(ProviderComponentSchema providerComponentSchema);

        /**
         * <p>
         * Input schema for the provider service.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProviderComponentSchema.Builder} avoiding
         * the need to create one manually via {@link ProviderComponentSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProviderComponentSchema.Builder#build()} is called immediately
         * and its result is passed to {@link #providerComponentSchema(ProviderComponentSchema)}.
         * 
         * @param providerComponentSchema
         *        a consumer that will call methods on {@link ProviderComponentSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #providerComponentSchema(ProviderComponentSchema)
         */
        default Builder providerComponentSchema(Consumer<ProviderComponentSchema.Builder> providerComponentSchema) {
            return providerComponentSchema(ProviderComponentSchema.builder().applyMutation(providerComponentSchema).build());
        }

        /**
         * <p>
         * The definition of the provider configuration.
         * </p>
         * 
         * @param providerConfigurationDefinition
         *        The definition of the provider configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerConfigurationDefinition(Document providerConfigurationDefinition);

        /**
         * <p>
         * The required configuration fields to use with the provider service.
         * </p>
         * 
         * @param providerEndpointConfiguration
         *        The required configuration fields to use with the provider service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerEndpointConfiguration(ProviderEndpointConfiguration providerEndpointConfiguration);

        /**
         * <p>
         * The required configuration fields to use with the provider service.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProviderEndpointConfiguration.Builder}
         * avoiding the need to create one manually via {@link ProviderEndpointConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProviderEndpointConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #providerEndpointConfiguration(ProviderEndpointConfiguration)}.
         * 
         * @param providerEndpointConfiguration
         *        a consumer that will call methods on {@link ProviderEndpointConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #providerEndpointConfiguration(ProviderEndpointConfiguration)
         */
        default Builder providerEndpointConfiguration(
                Consumer<ProviderEndpointConfiguration.Builder> providerEndpointConfiguration) {
            return providerEndpointConfiguration(ProviderEndpointConfiguration.builder()
                    .applyMutation(providerEndpointConfiguration).build());
        }

        /**
         * <p>
         * The definition of the provider entity output.
         * </p>
         * 
         * @param providerEntityOutputDefinition
         *        The definition of the provider entity output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerEntityOutputDefinition(Document providerEntityOutputDefinition);

        /**
         * <p>
         * The provider configuration required for different ID namespace types.
         * </p>
         * 
         * @param providerIdNameSpaceConfiguration
         *        The provider configuration required for different ID namespace types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerIdNameSpaceConfiguration(ProviderIdNameSpaceConfiguration providerIdNameSpaceConfiguration);

        /**
         * <p>
         * The provider configuration required for different ID namespace types.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProviderIdNameSpaceConfiguration.Builder}
         * avoiding the need to create one manually via {@link ProviderIdNameSpaceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProviderIdNameSpaceConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #providerIdNameSpaceConfiguration(ProviderIdNameSpaceConfiguration)}.
         * 
         * @param providerIdNameSpaceConfiguration
         *        a consumer that will call methods on {@link ProviderIdNameSpaceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #providerIdNameSpaceConfiguration(ProviderIdNameSpaceConfiguration)
         */
        default Builder providerIdNameSpaceConfiguration(
                Consumer<ProviderIdNameSpaceConfiguration.Builder> providerIdNameSpaceConfiguration) {
            return providerIdNameSpaceConfiguration(ProviderIdNameSpaceConfiguration.builder()
                    .applyMutation(providerIdNameSpaceConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Web Services accounts and the S3 permissions that are required by some providers to create an S3
         * bucket for intermediate data storage.
         * </p>
         * 
         * @param providerIntermediateDataAccessConfiguration
         *        The Amazon Web Services accounts and the S3 permissions that are required by some providers to create
         *        an S3 bucket for intermediate data storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerIntermediateDataAccessConfiguration(
                ProviderIntermediateDataAccessConfiguration providerIntermediateDataAccessConfiguration);

        /**
         * <p>
         * The Amazon Web Services accounts and the S3 permissions that are required by some providers to create an S3
         * bucket for intermediate data storage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ProviderIntermediateDataAccessConfiguration.Builder} avoiding the need to create one manually via
         * {@link ProviderIntermediateDataAccessConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProviderIntermediateDataAccessConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #providerIntermediateDataAccessConfiguration(ProviderIntermediateDataAccessConfiguration)}.
         * 
         * @param providerIntermediateDataAccessConfiguration
         *        a consumer that will call methods on {@link ProviderIntermediateDataAccessConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #providerIntermediateDataAccessConfiguration(ProviderIntermediateDataAccessConfiguration)
         */
        default Builder providerIntermediateDataAccessConfiguration(
                Consumer<ProviderIntermediateDataAccessConfiguration.Builder> providerIntermediateDataAccessConfiguration) {
            return providerIntermediateDataAccessConfiguration(ProviderIntermediateDataAccessConfiguration.builder()
                    .applyMutation(providerIntermediateDataAccessConfiguration).build());
        }

        /**
         * <p>
         * Provider service job configurations.
         * </p>
         * 
         * @param providerJobConfiguration
         *        Provider service job configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerJobConfiguration(Document providerJobConfiguration);

        /**
         * <p>
         * The name of the provider. This name is typically the company name.
         * </p>
         * 
         * @param providerName
         *        The name of the provider. This name is typically the company name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * The ARN (Amazon Resource Name) that Entity Resolution generated for the provider service.
         * </p>
         * 
         * @param providerServiceArn
         *        The ARN (Amazon Resource Name) that Entity Resolution generated for the provider service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerServiceArn(String providerServiceArn);

        /**
         * <p>
         * The display name of the provider service.
         * </p>
         * 
         * @param providerServiceDisplayName
         *        The display name of the provider service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerServiceDisplayName(String providerServiceDisplayName);

        /**
         * <p>
         * The name of the product that the provider service provides.
         * </p>
         * 
         * @param providerServiceName
         *        The name of the product that the provider service provides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerServiceName(String providerServiceName);

        /**
         * <p>
         * The type of provider service.
         * </p>
         * 
         * @param providerServiceType
         *        The type of provider service.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder providerServiceType(String providerServiceType);

        /**
         * <p>
         * The type of provider service.
         * </p>
         * 
         * @param providerServiceType
         *        The type of provider service.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder providerServiceType(ServiceType providerServiceType);
    }

    static final class BuilderImpl extends EntityResolutionResponse.BuilderImpl implements Builder {
        private Boolean anonymizedOutput;

        private ProviderComponentSchema providerComponentSchema;

        private Document providerConfigurationDefinition;

        private ProviderEndpointConfiguration providerEndpointConfiguration;

        private Document providerEntityOutputDefinition;

        private ProviderIdNameSpaceConfiguration providerIdNameSpaceConfiguration;

        private ProviderIntermediateDataAccessConfiguration providerIntermediateDataAccessConfiguration;

        private Document providerJobConfiguration;

        private String providerName;

        private String providerServiceArn;

        private String providerServiceDisplayName;

        private String providerServiceName;

        private String providerServiceType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProviderServiceResponse model) {
            super(model);
            anonymizedOutput(model.anonymizedOutput);
            providerComponentSchema(model.providerComponentSchema);
            providerConfigurationDefinition(model.providerConfigurationDefinition);
            providerEndpointConfiguration(model.providerEndpointConfiguration);
            providerEntityOutputDefinition(model.providerEntityOutputDefinition);
            providerIdNameSpaceConfiguration(model.providerIdNameSpaceConfiguration);
            providerIntermediateDataAccessConfiguration(model.providerIntermediateDataAccessConfiguration);
            providerJobConfiguration(model.providerJobConfiguration);
            providerName(model.providerName);
            providerServiceArn(model.providerServiceArn);
            providerServiceDisplayName(model.providerServiceDisplayName);
            providerServiceName(model.providerServiceName);
            providerServiceType(model.providerServiceType);
        }

        public final Boolean getAnonymizedOutput() {
            return anonymizedOutput;
        }

        public final void setAnonymizedOutput(Boolean anonymizedOutput) {
            this.anonymizedOutput = anonymizedOutput;
        }

        @Override
        public final Builder anonymizedOutput(Boolean anonymizedOutput) {
            this.anonymizedOutput = anonymizedOutput;
            return this;
        }

        public final ProviderComponentSchema.Builder getProviderComponentSchema() {
            return providerComponentSchema != null ? providerComponentSchema.toBuilder() : null;
        }

        public final void setProviderComponentSchema(ProviderComponentSchema.BuilderImpl providerComponentSchema) {
            this.providerComponentSchema = providerComponentSchema != null ? providerComponentSchema.build() : null;
        }

        @Override
        public final Builder providerComponentSchema(ProviderComponentSchema providerComponentSchema) {
            this.providerComponentSchema = providerComponentSchema;
            return this;
        }

        public final Document getProviderConfigurationDefinition() {
            return providerConfigurationDefinition;
        }

        public final void setProviderConfigurationDefinition(Document providerConfigurationDefinition) {
            this.providerConfigurationDefinition = providerConfigurationDefinition;
        }

        @Override
        public final Builder providerConfigurationDefinition(Document providerConfigurationDefinition) {
            this.providerConfigurationDefinition = providerConfigurationDefinition;
            return this;
        }

        public final ProviderEndpointConfiguration.Builder getProviderEndpointConfiguration() {
            return providerEndpointConfiguration != null ? providerEndpointConfiguration.toBuilder() : null;
        }

        public final void setProviderEndpointConfiguration(ProviderEndpointConfiguration.BuilderImpl providerEndpointConfiguration) {
            this.providerEndpointConfiguration = providerEndpointConfiguration != null ? providerEndpointConfiguration.build()
                    : null;
        }

        @Override
        public final Builder providerEndpointConfiguration(ProviderEndpointConfiguration providerEndpointConfiguration) {
            this.providerEndpointConfiguration = providerEndpointConfiguration;
            return this;
        }

        public final Document getProviderEntityOutputDefinition() {
            return providerEntityOutputDefinition;
        }

        public final void setProviderEntityOutputDefinition(Document providerEntityOutputDefinition) {
            this.providerEntityOutputDefinition = providerEntityOutputDefinition;
        }

        @Override
        public final Builder providerEntityOutputDefinition(Document providerEntityOutputDefinition) {
            this.providerEntityOutputDefinition = providerEntityOutputDefinition;
            return this;
        }

        public final ProviderIdNameSpaceConfiguration.Builder getProviderIdNameSpaceConfiguration() {
            return providerIdNameSpaceConfiguration != null ? providerIdNameSpaceConfiguration.toBuilder() : null;
        }

        public final void setProviderIdNameSpaceConfiguration(
                ProviderIdNameSpaceConfiguration.BuilderImpl providerIdNameSpaceConfiguration) {
            this.providerIdNameSpaceConfiguration = providerIdNameSpaceConfiguration != null ? providerIdNameSpaceConfiguration
                    .build() : null;
        }

        @Override
        public final Builder providerIdNameSpaceConfiguration(ProviderIdNameSpaceConfiguration providerIdNameSpaceConfiguration) {
            this.providerIdNameSpaceConfiguration = providerIdNameSpaceConfiguration;
            return this;
        }

        public final ProviderIntermediateDataAccessConfiguration.Builder getProviderIntermediateDataAccessConfiguration() {
            return providerIntermediateDataAccessConfiguration != null ? providerIntermediateDataAccessConfiguration.toBuilder()
                    : null;
        }

        public final void setProviderIntermediateDataAccessConfiguration(
                ProviderIntermediateDataAccessConfiguration.BuilderImpl providerIntermediateDataAccessConfiguration) {
            this.providerIntermediateDataAccessConfiguration = providerIntermediateDataAccessConfiguration != null ? providerIntermediateDataAccessConfiguration
                    .build() : null;
        }

        @Override
        public final Builder providerIntermediateDataAccessConfiguration(
                ProviderIntermediateDataAccessConfiguration providerIntermediateDataAccessConfiguration) {
            this.providerIntermediateDataAccessConfiguration = providerIntermediateDataAccessConfiguration;
            return this;
        }

        public final Document getProviderJobConfiguration() {
            return providerJobConfiguration;
        }

        public final void setProviderJobConfiguration(Document providerJobConfiguration) {
            this.providerJobConfiguration = providerJobConfiguration;
        }

        @Override
        public final Builder providerJobConfiguration(Document providerJobConfiguration) {
            this.providerJobConfiguration = providerJobConfiguration;
            return this;
        }

        public final String getProviderName() {
            return providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final String getProviderServiceArn() {
            return providerServiceArn;
        }

        public final void setProviderServiceArn(String providerServiceArn) {
            this.providerServiceArn = providerServiceArn;
        }

        @Override
        public final Builder providerServiceArn(String providerServiceArn) {
            this.providerServiceArn = providerServiceArn;
            return this;
        }

        public final String getProviderServiceDisplayName() {
            return providerServiceDisplayName;
        }

        public final void setProviderServiceDisplayName(String providerServiceDisplayName) {
            this.providerServiceDisplayName = providerServiceDisplayName;
        }

        @Override
        public final Builder providerServiceDisplayName(String providerServiceDisplayName) {
            this.providerServiceDisplayName = providerServiceDisplayName;
            return this;
        }

        public final String getProviderServiceName() {
            return providerServiceName;
        }

        public final void setProviderServiceName(String providerServiceName) {
            this.providerServiceName = providerServiceName;
        }

        @Override
        public final Builder providerServiceName(String providerServiceName) {
            this.providerServiceName = providerServiceName;
            return this;
        }

        public final String getProviderServiceType() {
            return providerServiceType;
        }

        public final void setProviderServiceType(String providerServiceType) {
            this.providerServiceType = providerServiceType;
        }

        @Override
        public final Builder providerServiceType(String providerServiceType) {
            this.providerServiceType = providerServiceType;
            return this;
        }

        @Override
        public final Builder providerServiceType(ServiceType providerServiceType) {
            this.providerServiceType(providerServiceType == null ? null : providerServiceType.toString());
            return this;
        }

        @Override
        public GetProviderServiceResponse build() {
            return new GetProviderServiceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
