/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The required configuration fields to give intermediate access to a provider service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProviderIntermediateDataAccessConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ProviderIntermediateDataAccessConfiguration.Builder, ProviderIntermediateDataAccessConfiguration> {
    private static final SdkField<List<String>> AWS_ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("awsAccountIds")
            .getter(getter(ProviderIntermediateDataAccessConfiguration::awsAccountIds))
            .setter(setter(Builder::awsAccountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REQUIRED_BUCKET_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("requiredBucketActions")
            .getter(getter(ProviderIntermediateDataAccessConfiguration::requiredBucketActions))
            .setter(setter(Builder::requiredBucketActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredBucketActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_IDS_FIELD,
            REQUIRED_BUCKET_ACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> awsAccountIds;

    private final List<String> requiredBucketActions;

    private ProviderIntermediateDataAccessConfiguration(BuilderImpl builder) {
        this.awsAccountIds = builder.awsAccountIds;
        this.requiredBucketActions = builder.requiredBucketActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AwsAccountIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAwsAccountIds() {
        return awsAccountIds != null && !(awsAccountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services account that provider can use to read or write data into the customer's intermediate S3
     * bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAwsAccountIds} method.
     * </p>
     * 
     * @return The Amazon Web Services account that provider can use to read or write data into the customer's
     *         intermediate S3 bucket.
     */
    public final List<String> awsAccountIds() {
        return awsAccountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequiredBucketActions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRequiredBucketActions() {
        return requiredBucketActions != null && !(requiredBucketActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The S3 bucket actions that the provider requires permission for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequiredBucketActions} method.
     * </p>
     * 
     * @return The S3 bucket actions that the provider requires permission for.
     */
    public final List<String> requiredBucketActions() {
        return requiredBucketActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAwsAccountIds() ? awsAccountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRequiredBucketActions() ? requiredBucketActions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderIntermediateDataAccessConfiguration)) {
            return false;
        }
        ProviderIntermediateDataAccessConfiguration other = (ProviderIntermediateDataAccessConfiguration) obj;
        return hasAwsAccountIds() == other.hasAwsAccountIds() && Objects.equals(awsAccountIds(), other.awsAccountIds())
                && hasRequiredBucketActions() == other.hasRequiredBucketActions()
                && Objects.equals(requiredBucketActions(), other.requiredBucketActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProviderIntermediateDataAccessConfiguration")
                .add("AwsAccountIds", hasAwsAccountIds() ? awsAccountIds() : null)
                .add("RequiredBucketActions", hasRequiredBucketActions() ? requiredBucketActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsAccountIds":
            return Optional.ofNullable(clazz.cast(awsAccountIds()));
        case "requiredBucketActions":
            return Optional.ofNullable(clazz.cast(requiredBucketActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("awsAccountIds", AWS_ACCOUNT_IDS_FIELD);
        map.put("requiredBucketActions", REQUIRED_BUCKET_ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProviderIntermediateDataAccessConfiguration, T> g) {
        return obj -> g.apply((ProviderIntermediateDataAccessConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProviderIntermediateDataAccessConfiguration> {
        /**
         * <p>
         * The Amazon Web Services account that provider can use to read or write data into the customer's intermediate
         * S3 bucket.
         * </p>
         * 
         * @param awsAccountIds
         *        The Amazon Web Services account that provider can use to read or write data into the customer's
         *        intermediate S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountIds(Collection<String> awsAccountIds);

        /**
         * <p>
         * The Amazon Web Services account that provider can use to read or write data into the customer's intermediate
         * S3 bucket.
         * </p>
         * 
         * @param awsAccountIds
         *        The Amazon Web Services account that provider can use to read or write data into the customer's
         *        intermediate S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountIds(String... awsAccountIds);

        /**
         * <p>
         * The S3 bucket actions that the provider requires permission for.
         * </p>
         * 
         * @param requiredBucketActions
         *        The S3 bucket actions that the provider requires permission for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredBucketActions(Collection<String> requiredBucketActions);

        /**
         * <p>
         * The S3 bucket actions that the provider requires permission for.
         * </p>
         * 
         * @param requiredBucketActions
         *        The S3 bucket actions that the provider requires permission for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredBucketActions(String... requiredBucketActions);
    }

    static final class BuilderImpl implements Builder {
        private List<String> awsAccountIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> requiredBucketActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderIntermediateDataAccessConfiguration model) {
            awsAccountIds(model.awsAccountIds);
            requiredBucketActions(model.requiredBucketActions);
        }

        public final Collection<String> getAwsAccountIds() {
            if (awsAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return awsAccountIds;
        }

        public final void setAwsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = AwsAccountIdListCopier.copy(awsAccountIds);
        }

        @Override
        public final Builder awsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = AwsAccountIdListCopier.copy(awsAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountIds(String... awsAccountIds) {
            awsAccountIds(Arrays.asList(awsAccountIds));
            return this;
        }

        public final Collection<String> getRequiredBucketActions() {
            if (requiredBucketActions instanceof SdkAutoConstructList) {
                return null;
            }
            return requiredBucketActions;
        }

        public final void setRequiredBucketActions(Collection<String> requiredBucketActions) {
            this.requiredBucketActions = RequiredBucketActionsListCopier.copy(requiredBucketActions);
        }

        @Override
        public final Builder requiredBucketActions(Collection<String> requiredBucketActions) {
            this.requiredBucketActions = RequiredBucketActionsListCopier.copy(requiredBucketActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredBucketActions(String... requiredBucketActions) {
            requiredBucketActions(Arrays.asList(requiredBucketActions));
            return this;
        }

        @Override
        public ProviderIntermediateDataAccessConfiguration build() {
            return new ProviderIntermediateDataAccessConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
