/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIdNamespaceRequest extends EntityResolutionRequest implements
        ToCopyableBuilder<UpdateIdNamespaceRequest.Builder, UpdateIdNamespaceRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateIdNamespaceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<IdNamespaceIdMappingWorkflowProperties>> ID_MAPPING_WORKFLOW_PROPERTIES_FIELD = SdkField
            .<List<IdNamespaceIdMappingWorkflowProperties>> builder(MarshallingType.LIST)
            .memberName("idMappingWorkflowProperties")
            .getter(getter(UpdateIdNamespaceRequest::idMappingWorkflowProperties))
            .setter(setter(Builder::idMappingWorkflowProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idMappingWorkflowProperties")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdNamespaceIdMappingWorkflowProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdNamespaceIdMappingWorkflowProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idNamespaceName").getter(getter(UpdateIdNamespaceRequest::idNamespaceName))
            .setter(setter(Builder::idNamespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("idNamespaceName").build()).build();

    private static final SdkField<List<IdNamespaceInputSource>> INPUT_SOURCE_CONFIG_FIELD = SdkField
            .<List<IdNamespaceInputSource>> builder(MarshallingType.LIST)
            .memberName("inputSourceConfig")
            .getter(getter(UpdateIdNamespaceRequest::inputSourceConfig))
            .setter(setter(Builder::inputSourceConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSourceConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdNamespaceInputSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdNamespaceInputSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateIdNamespaceRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            ID_MAPPING_WORKFLOW_PROPERTIES_FIELD, ID_NAMESPACE_NAME_FIELD, INPUT_SOURCE_CONFIG_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final List<IdNamespaceIdMappingWorkflowProperties> idMappingWorkflowProperties;

    private final String idNamespaceName;

    private final List<IdNamespaceInputSource> inputSourceConfig;

    private final String roleArn;

    private UpdateIdNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.idMappingWorkflowProperties = builder.idMappingWorkflowProperties;
        this.idNamespaceName = builder.idNamespaceName;
        this.inputSourceConfig = builder.inputSourceConfig;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The description of the ID namespace.
     * </p>
     * 
     * @return The description of the ID namespace.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the IdMappingWorkflowProperties property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIdMappingWorkflowProperties() {
        return idMappingWorkflowProperties != null && !(idMappingWorkflowProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Determines the properties of <code>IdMappingWorkflow</code> where this <code>IdNamespace</code> can be used as a
     * <code>Source</code> or a <code>Target</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdMappingWorkflowProperties} method.
     * </p>
     * 
     * @return Determines the properties of <code>IdMappingWorkflow</code> where this <code>IdNamespace</code> can be
     *         used as a <code>Source</code> or a <code>Target</code>.
     */
    public final List<IdNamespaceIdMappingWorkflowProperties> idMappingWorkflowProperties() {
        return idMappingWorkflowProperties;
    }

    /**
     * <p>
     * The name of the ID namespace.
     * </p>
     * 
     * @return The name of the ID namespace.
     */
    public final String idNamespaceName() {
        return idNamespaceName;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputSourceConfig property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputSourceConfig() {
        return inputSourceConfig != null && !(inputSourceConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
     * <code>SchemaName</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputSourceConfig} method.
     * </p>
     * 
     * @return A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
     *         <code>SchemaName</code>.
     */
    public final List<IdNamespaceInputSource> inputSourceConfig() {
        return inputSourceConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access the resources
     * defined in this <code>IdNamespace</code> on your behalf as part of a workflow run.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access the
     *         resources defined in this <code>IdNamespace</code> on your behalf as part of a workflow run.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasIdMappingWorkflowProperties() ? idMappingWorkflowProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(idNamespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputSourceConfig() ? inputSourceConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdNamespaceRequest)) {
            return false;
        }
        UpdateIdNamespaceRequest other = (UpdateIdNamespaceRequest) obj;
        return Objects.equals(description(), other.description())
                && hasIdMappingWorkflowProperties() == other.hasIdMappingWorkflowProperties()
                && Objects.equals(idMappingWorkflowProperties(), other.idMappingWorkflowProperties())
                && Objects.equals(idNamespaceName(), other.idNamespaceName())
                && hasInputSourceConfig() == other.hasInputSourceConfig()
                && Objects.equals(inputSourceConfig(), other.inputSourceConfig()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIdNamespaceRequest").add("Description", description())
                .add("IdMappingWorkflowProperties", hasIdMappingWorkflowProperties() ? idMappingWorkflowProperties() : null)
                .add("IdNamespaceName", idNamespaceName())
                .add("InputSourceConfig", hasInputSourceConfig() ? inputSourceConfig() : null).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "idMappingWorkflowProperties":
            return Optional.ofNullable(clazz.cast(idMappingWorkflowProperties()));
        case "idNamespaceName":
            return Optional.ofNullable(clazz.cast(idNamespaceName()));
        case "inputSourceConfig":
            return Optional.ofNullable(clazz.cast(inputSourceConfig()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("idMappingWorkflowProperties", ID_MAPPING_WORKFLOW_PROPERTIES_FIELD);
        map.put("idNamespaceName", ID_NAMESPACE_NAME_FIELD);
        map.put("inputSourceConfig", INPUT_SOURCE_CONFIG_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIdNamespaceRequest, T> g) {
        return obj -> g.apply((UpdateIdNamespaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EntityResolutionRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateIdNamespaceRequest> {
        /**
         * <p>
         * The description of the ID namespace.
         * </p>
         * 
         * @param description
         *        The description of the ID namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Determines the properties of <code>IdMappingWorkflow</code> where this <code>IdNamespace</code> can be used
         * as a <code>Source</code> or a <code>Target</code>.
         * </p>
         * 
         * @param idMappingWorkflowProperties
         *        Determines the properties of <code>IdMappingWorkflow</code> where this <code>IdNamespace</code> can be
         *        used as a <code>Source</code> or a <code>Target</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idMappingWorkflowProperties(Collection<IdNamespaceIdMappingWorkflowProperties> idMappingWorkflowProperties);

        /**
         * <p>
         * Determines the properties of <code>IdMappingWorkflow</code> where this <code>IdNamespace</code> can be used
         * as a <code>Source</code> or a <code>Target</code>.
         * </p>
         * 
         * @param idMappingWorkflowProperties
         *        Determines the properties of <code>IdMappingWorkflow</code> where this <code>IdNamespace</code> can be
         *        used as a <code>Source</code> or a <code>Target</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idMappingWorkflowProperties(IdNamespaceIdMappingWorkflowProperties... idMappingWorkflowProperties);

        /**
         * <p>
         * Determines the properties of <code>IdMappingWorkflow</code> where this <code>IdNamespace</code> can be used
         * as a <code>Source</code> or a <code>Target</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.IdNamespaceIdMappingWorkflowProperties.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.entityresolution.model.IdNamespaceIdMappingWorkflowProperties#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.IdNamespaceIdMappingWorkflowProperties.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #idMappingWorkflowProperties(List<IdNamespaceIdMappingWorkflowProperties>)}.
         * 
         * @param idMappingWorkflowProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.IdNamespaceIdMappingWorkflowProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #idMappingWorkflowProperties(java.util.Collection<IdNamespaceIdMappingWorkflowProperties>)
         */
        Builder idMappingWorkflowProperties(
                Consumer<IdNamespaceIdMappingWorkflowProperties.Builder>... idMappingWorkflowProperties);

        /**
         * <p>
         * The name of the ID namespace.
         * </p>
         * 
         * @param idNamespaceName
         *        The name of the ID namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idNamespaceName(String idNamespaceName);

        /**
         * <p>
         * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
         * <code>SchemaName</code>.
         * </p>
         * 
         * @param inputSourceConfig
         *        A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
         *        <code>SchemaName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSourceConfig(Collection<IdNamespaceInputSource> inputSourceConfig);

        /**
         * <p>
         * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
         * <code>SchemaName</code>.
         * </p>
         * 
         * @param inputSourceConfig
         *        A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
         *        <code>SchemaName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSourceConfig(IdNamespaceInputSource... inputSourceConfig);

        /**
         * <p>
         * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
         * <code>SchemaName</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.IdNamespaceInputSource.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.entityresolution.model.IdNamespaceInputSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.IdNamespaceInputSource.Builder#build()} is
         * called immediately and its result is passed to {@link #inputSourceConfig(List<IdNamespaceInputSource>)}.
         * 
         * @param inputSourceConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.IdNamespaceInputSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSourceConfig(java.util.Collection<IdNamespaceInputSource>)
         */
        Builder inputSourceConfig(Consumer<IdNamespaceInputSource.Builder>... inputSourceConfig);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access the resources
         * defined in this <code>IdNamespace</code> on your behalf as part of a workflow run.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access the
         *        resources defined in this <code>IdNamespace</code> on your behalf as part of a workflow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EntityResolutionRequest.BuilderImpl implements Builder {
        private String description;

        private List<IdNamespaceIdMappingWorkflowProperties> idMappingWorkflowProperties = DefaultSdkAutoConstructList
                .getInstance();

        private String idNamespaceName;

        private List<IdNamespaceInputSource> inputSourceConfig = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIdNamespaceRequest model) {
            super(model);
            description(model.description);
            idMappingWorkflowProperties(model.idMappingWorkflowProperties);
            idNamespaceName(model.idNamespaceName);
            inputSourceConfig(model.inputSourceConfig);
            roleArn(model.roleArn);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<IdNamespaceIdMappingWorkflowProperties.Builder> getIdMappingWorkflowProperties() {
            List<IdNamespaceIdMappingWorkflowProperties.Builder> result = IdNamespaceIdMappingWorkflowPropertiesListCopier
                    .copyToBuilder(this.idMappingWorkflowProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdMappingWorkflowProperties(
                Collection<IdNamespaceIdMappingWorkflowProperties.BuilderImpl> idMappingWorkflowProperties) {
            this.idMappingWorkflowProperties = IdNamespaceIdMappingWorkflowPropertiesListCopier
                    .copyFromBuilder(idMappingWorkflowProperties);
        }

        @Override
        public final Builder idMappingWorkflowProperties(
                Collection<IdNamespaceIdMappingWorkflowProperties> idMappingWorkflowProperties) {
            this.idMappingWorkflowProperties = IdNamespaceIdMappingWorkflowPropertiesListCopier.copy(idMappingWorkflowProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idMappingWorkflowProperties(IdNamespaceIdMappingWorkflowProperties... idMappingWorkflowProperties) {
            idMappingWorkflowProperties(Arrays.asList(idMappingWorkflowProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idMappingWorkflowProperties(
                Consumer<IdNamespaceIdMappingWorkflowProperties.Builder>... idMappingWorkflowProperties) {
            idMappingWorkflowProperties(Stream.of(idMappingWorkflowProperties)
                    .map(c -> IdNamespaceIdMappingWorkflowProperties.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getIdNamespaceName() {
            return idNamespaceName;
        }

        public final void setIdNamespaceName(String idNamespaceName) {
            this.idNamespaceName = idNamespaceName;
        }

        @Override
        public final Builder idNamespaceName(String idNamespaceName) {
            this.idNamespaceName = idNamespaceName;
            return this;
        }

        public final List<IdNamespaceInputSource.Builder> getInputSourceConfig() {
            List<IdNamespaceInputSource.Builder> result = IdNamespaceInputSourceConfigCopier
                    .copyToBuilder(this.inputSourceConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputSourceConfig(Collection<IdNamespaceInputSource.BuilderImpl> inputSourceConfig) {
            this.inputSourceConfig = IdNamespaceInputSourceConfigCopier.copyFromBuilder(inputSourceConfig);
        }

        @Override
        public final Builder inputSourceConfig(Collection<IdNamespaceInputSource> inputSourceConfig) {
            this.inputSourceConfig = IdNamespaceInputSourceConfigCopier.copy(inputSourceConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSourceConfig(IdNamespaceInputSource... inputSourceConfig) {
            inputSourceConfig(Arrays.asList(inputSourceConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSourceConfig(Consumer<IdNamespaceInputSource.Builder>... inputSourceConfig) {
            inputSourceConfig(Stream.of(inputSourceConfig).map(c -> IdNamespaceInputSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIdNamespaceRequest build() {
            return new UpdateIdNamespaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
