/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateMatchIdRequest extends EntityResolutionRequest implements
        ToCopyableBuilder<GenerateMatchIdRequest.Builder, GenerateMatchIdRequest> {
    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowName").getter(getter(GenerateMatchIdRequest::workflowName))
            .setter(setter(Builder::workflowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowName").build()).build();

    private static final SdkField<List<Record>> RECORDS_FIELD = SdkField
            .<List<Record>> builder(MarshallingType.LIST)
            .memberName("records")
            .getter(getter(GenerateMatchIdRequest::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Record> builder(MarshallingType.SDK_POJO)
                                            .constructor(Record::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROCESSING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("processingType").getter(getter(GenerateMatchIdRequest::processingTypeAsString))
            .setter(setter(Builder::processingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processingType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_NAME_FIELD,
            RECORDS_FIELD, PROCESSING_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workflowName;

    private final List<Record> records;

    private final String processingType;

    private GenerateMatchIdRequest(BuilderImpl builder) {
        super(builder);
        this.workflowName = builder.workflowName;
        this.records = builder.records;
        this.processingType = builder.processingType;
    }

    /**
     * <p>
     * The name of the rule-based matching workflow.
     * </p>
     * 
     * @return The name of the rule-based matching workflow.
     */
    public final String workflowName() {
        return workflowName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Records property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The records to match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecords} method.
     * </p>
     * 
     * @return The records to match.
     */
    public final List<Record> records() {
        return records;
    }

    /**
     * <p>
     * The processing mode that determines how Match IDs are generated and results are saved. Each mode provides
     * different levels of accuracy, response time, and completeness of results.
     * </p>
     * <p>
     * If not specified, defaults to <code>CONSISTENT</code>.
     * </p>
     * <p>
     * <code>CONSISTENT</code>: Performs immediate lookup and matching against all existing records, with results saved
     * synchronously. Provides highest accuracy but slower response time.
     * </p>
     * <p>
     * <code>EVENTUAL</code> (shown as <i>Background</i> in the console): Performs initial match ID lookup or generation
     * immediately, with record updates processed asynchronously in the background. Offers faster initial response time,
     * with complete matching results available later in S3.
     * </p>
     * <p>
     * <code>EVENTUAL_NO_LOOKUP</code> (shown as <i>Quick ID generation</i> in the console): Generates new match IDs
     * without checking existing matches, with updates processed asynchronously. Provides fastest response time but
     * should only be used for records known to be unique.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #processingType}
     * will return {@link ProcessingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #processingTypeAsString}.
     * </p>
     * 
     * @return The processing mode that determines how Match IDs are generated and results are saved. Each mode provides
     *         different levels of accuracy, response time, and completeness of results.</p>
     *         <p>
     *         If not specified, defaults to <code>CONSISTENT</code>.
     *         </p>
     *         <p>
     *         <code>CONSISTENT</code>: Performs immediate lookup and matching against all existing records, with
     *         results saved synchronously. Provides highest accuracy but slower response time.
     *         </p>
     *         <p>
     *         <code>EVENTUAL</code> (shown as <i>Background</i> in the console): Performs initial match ID lookup or
     *         generation immediately, with record updates processed asynchronously in the background. Offers faster
     *         initial response time, with complete matching results available later in S3.
     *         </p>
     *         <p>
     *         <code>EVENTUAL_NO_LOOKUP</code> (shown as <i>Quick ID generation</i> in the console): Generates new match
     *         IDs without checking existing matches, with updates processed asynchronously. Provides fastest response
     *         time but should only be used for records known to be unique.
     * @see ProcessingType
     */
    public final ProcessingType processingType() {
        return ProcessingType.fromValue(processingType);
    }

    /**
     * <p>
     * The processing mode that determines how Match IDs are generated and results are saved. Each mode provides
     * different levels of accuracy, response time, and completeness of results.
     * </p>
     * <p>
     * If not specified, defaults to <code>CONSISTENT</code>.
     * </p>
     * <p>
     * <code>CONSISTENT</code>: Performs immediate lookup and matching against all existing records, with results saved
     * synchronously. Provides highest accuracy but slower response time.
     * </p>
     * <p>
     * <code>EVENTUAL</code> (shown as <i>Background</i> in the console): Performs initial match ID lookup or generation
     * immediately, with record updates processed asynchronously in the background. Offers faster initial response time,
     * with complete matching results available later in S3.
     * </p>
     * <p>
     * <code>EVENTUAL_NO_LOOKUP</code> (shown as <i>Quick ID generation</i> in the console): Generates new match IDs
     * without checking existing matches, with updates processed asynchronously. Provides fastest response time but
     * should only be used for records known to be unique.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #processingType}
     * will return {@link ProcessingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #processingTypeAsString}.
     * </p>
     * 
     * @return The processing mode that determines how Match IDs are generated and results are saved. Each mode provides
     *         different levels of accuracy, response time, and completeness of results.</p>
     *         <p>
     *         If not specified, defaults to <code>CONSISTENT</code>.
     *         </p>
     *         <p>
     *         <code>CONSISTENT</code>: Performs immediate lookup and matching against all existing records, with
     *         results saved synchronously. Provides highest accuracy but slower response time.
     *         </p>
     *         <p>
     *         <code>EVENTUAL</code> (shown as <i>Background</i> in the console): Performs initial match ID lookup or
     *         generation immediately, with record updates processed asynchronously in the background. Offers faster
     *         initial response time, with complete matching results available later in S3.
     *         </p>
     *         <p>
     *         <code>EVENTUAL_NO_LOOKUP</code> (shown as <i>Quick ID generation</i> in the console): Generates new match
     *         IDs without checking existing matches, with updates processed asynchronously. Provides fastest response
     *         time but should only be used for records known to be unique.
     * @see ProcessingType
     */
    public final String processingTypeAsString() {
        return processingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflowName());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecords() ? records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(processingTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateMatchIdRequest)) {
            return false;
        }
        GenerateMatchIdRequest other = (GenerateMatchIdRequest) obj;
        return Objects.equals(workflowName(), other.workflowName()) && hasRecords() == other.hasRecords()
                && Objects.equals(records(), other.records())
                && Objects.equals(processingTypeAsString(), other.processingTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerateMatchIdRequest").add("WorkflowName", workflowName())
                .add("Records", hasRecords() ? records() : null).add("ProcessingType", processingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workflowName":
            return Optional.ofNullable(clazz.cast(workflowName()));
        case "records":
            return Optional.ofNullable(clazz.cast(records()));
        case "processingType":
            return Optional.ofNullable(clazz.cast(processingTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workflowName", WORKFLOW_NAME_FIELD);
        map.put("records", RECORDS_FIELD);
        map.put("processingType", PROCESSING_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateMatchIdRequest, T> g) {
        return obj -> g.apply((GenerateMatchIdRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EntityResolutionRequest.Builder, SdkPojo, CopyableBuilder<Builder, GenerateMatchIdRequest> {
        /**
         * <p>
         * The name of the rule-based matching workflow.
         * </p>
         * 
         * @param workflowName
         *        The name of the rule-based matching workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowName(String workflowName);

        /**
         * <p>
         * The records to match.
         * </p>
         * 
         * @param records
         *        The records to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<Record> records);

        /**
         * <p>
         * The records to match.
         * </p>
         * 
         * @param records
         *        The records to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Record... records);

        /**
         * <p>
         * The records to match.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.Record.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.entityresolution.model.Record#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.Record.Builder#build()} is called immediately
         * and its result is passed to {@link #records(List<Record>)}.
         * 
         * @param records
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.Record.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #records(java.util.Collection<Record>)
         */
        Builder records(Consumer<Record.Builder>... records);

        /**
         * <p>
         * The processing mode that determines how Match IDs are generated and results are saved. Each mode provides
         * different levels of accuracy, response time, and completeness of results.
         * </p>
         * <p>
         * If not specified, defaults to <code>CONSISTENT</code>.
         * </p>
         * <p>
         * <code>CONSISTENT</code>: Performs immediate lookup and matching against all existing records, with results
         * saved synchronously. Provides highest accuracy but slower response time.
         * </p>
         * <p>
         * <code>EVENTUAL</code> (shown as <i>Background</i> in the console): Performs initial match ID lookup or
         * generation immediately, with record updates processed asynchronously in the background. Offers faster initial
         * response time, with complete matching results available later in S3.
         * </p>
         * <p>
         * <code>EVENTUAL_NO_LOOKUP</code> (shown as <i>Quick ID generation</i> in the console): Generates new match IDs
         * without checking existing matches, with updates processed asynchronously. Provides fastest response time but
         * should only be used for records known to be unique.
         * </p>
         * 
         * @param processingType
         *        The processing mode that determines how Match IDs are generated and results are saved. Each mode
         *        provides different levels of accuracy, response time, and completeness of results.</p>
         *        <p>
         *        If not specified, defaults to <code>CONSISTENT</code>.
         *        </p>
         *        <p>
         *        <code>CONSISTENT</code>: Performs immediate lookup and matching against all existing records, with
         *        results saved synchronously. Provides highest accuracy but slower response time.
         *        </p>
         *        <p>
         *        <code>EVENTUAL</code> (shown as <i>Background</i> in the console): Performs initial match ID lookup or
         *        generation immediately, with record updates processed asynchronously in the background. Offers faster
         *        initial response time, with complete matching results available later in S3.
         *        </p>
         *        <p>
         *        <code>EVENTUAL_NO_LOOKUP</code> (shown as <i>Quick ID generation</i> in the console): Generates new
         *        match IDs without checking existing matches, with updates processed asynchronously. Provides fastest
         *        response time but should only be used for records known to be unique.
         * @see ProcessingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingType
         */
        Builder processingType(String processingType);

        /**
         * <p>
         * The processing mode that determines how Match IDs are generated and results are saved. Each mode provides
         * different levels of accuracy, response time, and completeness of results.
         * </p>
         * <p>
         * If not specified, defaults to <code>CONSISTENT</code>.
         * </p>
         * <p>
         * <code>CONSISTENT</code>: Performs immediate lookup and matching against all existing records, with results
         * saved synchronously. Provides highest accuracy but slower response time.
         * </p>
         * <p>
         * <code>EVENTUAL</code> (shown as <i>Background</i> in the console): Performs initial match ID lookup or
         * generation immediately, with record updates processed asynchronously in the background. Offers faster initial
         * response time, with complete matching results available later in S3.
         * </p>
         * <p>
         * <code>EVENTUAL_NO_LOOKUP</code> (shown as <i>Quick ID generation</i> in the console): Generates new match IDs
         * without checking existing matches, with updates processed asynchronously. Provides fastest response time but
         * should only be used for records known to be unique.
         * </p>
         * 
         * @param processingType
         *        The processing mode that determines how Match IDs are generated and results are saved. Each mode
         *        provides different levels of accuracy, response time, and completeness of results.</p>
         *        <p>
         *        If not specified, defaults to <code>CONSISTENT</code>.
         *        </p>
         *        <p>
         *        <code>CONSISTENT</code>: Performs immediate lookup and matching against all existing records, with
         *        results saved synchronously. Provides highest accuracy but slower response time.
         *        </p>
         *        <p>
         *        <code>EVENTUAL</code> (shown as <i>Background</i> in the console): Performs initial match ID lookup or
         *        generation immediately, with record updates processed asynchronously in the background. Offers faster
         *        initial response time, with complete matching results available later in S3.
         *        </p>
         *        <p>
         *        <code>EVENTUAL_NO_LOOKUP</code> (shown as <i>Quick ID generation</i> in the console): Generates new
         *        match IDs without checking existing matches, with updates processed asynchronously. Provides fastest
         *        response time but should only be used for records known to be unique.
         * @see ProcessingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingType
         */
        Builder processingType(ProcessingType processingType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EntityResolutionRequest.BuilderImpl implements Builder {
        private String workflowName;

        private List<Record> records = DefaultSdkAutoConstructList.getInstance();

        private String processingType;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateMatchIdRequest model) {
            super(model);
            workflowName(model.workflowName);
            records(model.records);
            processingType(model.processingType);
        }

        public final String getWorkflowName() {
            return workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        public final List<Record.Builder> getRecords() {
            List<Record.Builder> result = GenerateMatchIdInputRecordsListCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = GenerateMatchIdInputRecordsListCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = GenerateMatchIdInputRecordsListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record... records) {
            records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<Record.Builder>... records) {
            records(Stream.of(records).map(c -> Record.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProcessingType() {
            return processingType;
        }

        public final void setProcessingType(String processingType) {
            this.processingType = processingType;
        }

        @Override
        public final Builder processingType(String processingType) {
            this.processingType = processingType;
            return this;
        }

        @Override
        public final Builder processingType(ProcessingType processingType) {
            this.processingType(processingType == null ? null : processingType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateMatchIdRequest build() {
            return new GenerateMatchIdRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
