/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Optional. An object that defines the incremental run type. This object contains only the
 * <code>incrementalRunType</code> field, which appears as "Automatic" in the console.
 * </p>
 * <important>
 * <p>
 * For workflows where <code>resolutionType</code> is <code>ML_MATCHING</code>, incremental processing is not supported.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IncrementalRunConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<IncrementalRunConfig.Builder, IncrementalRunConfig> {
    private static final SdkField<String> INCREMENTAL_RUN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("incrementalRunType").getter(getter(IncrementalRunConfig::incrementalRunTypeAsString))
            .setter(setter(Builder::incrementalRunType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incrementalRunType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCREMENTAL_RUN_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String incrementalRunType;

    private IncrementalRunConfig(BuilderImpl builder) {
        this.incrementalRunType = builder.incrementalRunType;
    }

    /**
     * <p>
     * The type of incremental run. The only valid value is <code>IMMEDIATE</code>. This appears as "Automatic" in the
     * console.
     * </p>
     * <important>
     * <p>
     * For workflows where <code>resolutionType</code> is <code>ML_MATCHING</code>, incremental processing is not
     * supported.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #incrementalRunType} will return {@link IncrementalRunType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #incrementalRunTypeAsString}.
     * </p>
     * 
     * @return The type of incremental run. The only valid value is <code>IMMEDIATE</code>. This appears as "Automatic"
     *         in the console.</p> <important>
     *         <p>
     *         For workflows where <code>resolutionType</code> is <code>ML_MATCHING</code>, incremental processing is
     *         not supported.
     *         </p>
     * @see IncrementalRunType
     */
    public final IncrementalRunType incrementalRunType() {
        return IncrementalRunType.fromValue(incrementalRunType);
    }

    /**
     * <p>
     * The type of incremental run. The only valid value is <code>IMMEDIATE</code>. This appears as "Automatic" in the
     * console.
     * </p>
     * <important>
     * <p>
     * For workflows where <code>resolutionType</code> is <code>ML_MATCHING</code>, incremental processing is not
     * supported.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #incrementalRunType} will return {@link IncrementalRunType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #incrementalRunTypeAsString}.
     * </p>
     * 
     * @return The type of incremental run. The only valid value is <code>IMMEDIATE</code>. This appears as "Automatic"
     *         in the console.</p> <important>
     *         <p>
     *         For workflows where <code>resolutionType</code> is <code>ML_MATCHING</code>, incremental processing is
     *         not supported.
     *         </p>
     * @see IncrementalRunType
     */
    public final String incrementalRunTypeAsString() {
        return incrementalRunType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(incrementalRunTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncrementalRunConfig)) {
            return false;
        }
        IncrementalRunConfig other = (IncrementalRunConfig) obj;
        return Objects.equals(incrementalRunTypeAsString(), other.incrementalRunTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IncrementalRunConfig").add("IncrementalRunType", incrementalRunTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "incrementalRunType":
            return Optional.ofNullable(clazz.cast(incrementalRunTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("incrementalRunType", INCREMENTAL_RUN_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IncrementalRunConfig, T> g) {
        return obj -> g.apply((IncrementalRunConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IncrementalRunConfig> {
        /**
         * <p>
         * The type of incremental run. The only valid value is <code>IMMEDIATE</code>. This appears as "Automatic" in
         * the console.
         * </p>
         * <important>
         * <p>
         * For workflows where <code>resolutionType</code> is <code>ML_MATCHING</code>, incremental processing is not
         * supported.
         * </p>
         * </important>
         * 
         * @param incrementalRunType
         *        The type of incremental run. The only valid value is <code>IMMEDIATE</code>. This appears as
         *        "Automatic" in the console.</p> <important>
         *        <p>
         *        For workflows where <code>resolutionType</code> is <code>ML_MATCHING</code>, incremental processing is
         *        not supported.
         *        </p>
         * @see IncrementalRunType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncrementalRunType
         */
        Builder incrementalRunType(String incrementalRunType);

        /**
         * <p>
         * The type of incremental run. The only valid value is <code>IMMEDIATE</code>. This appears as "Automatic" in
         * the console.
         * </p>
         * <important>
         * <p>
         * For workflows where <code>resolutionType</code> is <code>ML_MATCHING</code>, incremental processing is not
         * supported.
         * </p>
         * </important>
         * 
         * @param incrementalRunType
         *        The type of incremental run. The only valid value is <code>IMMEDIATE</code>. This appears as
         *        "Automatic" in the console.</p> <important>
         *        <p>
         *        For workflows where <code>resolutionType</code> is <code>ML_MATCHING</code>, incremental processing is
         *        not supported.
         *        </p>
         * @see IncrementalRunType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncrementalRunType
         */
        Builder incrementalRunType(IncrementalRunType incrementalRunType);
    }

    static final class BuilderImpl implements Builder {
        private String incrementalRunType;

        private BuilderImpl() {
        }

        private BuilderImpl(IncrementalRunConfig model) {
            incrementalRunType(model.incrementalRunType);
        }

        public final String getIncrementalRunType() {
            return incrementalRunType;
        }

        public final void setIncrementalRunType(String incrementalRunType) {
            this.incrementalRunType = incrementalRunType;
        }

        @Override
        public final Builder incrementalRunType(String incrementalRunType) {
            this.incrementalRunType = incrementalRunType;
            return this;
        }

        @Override
        public final Builder incrementalRunType(IncrementalRunType incrementalRunType) {
            this.incrementalRunType(incrementalRunType == null ? null : incrementalRunType.toString());
            return this;
        }

        @Override
        public IncrementalRunConfig build() {
            return new IncrementalRunConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
