/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The provider schema attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProviderSchemaAttribute implements SdkPojo, Serializable,
        ToCopyableBuilder<ProviderSchemaAttribute.Builder, ProviderSchemaAttribute> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldName").getter(getter(ProviderSchemaAttribute::fieldName)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ProviderSchemaAttribute::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> SUB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subType").getter(getter(ProviderSchemaAttribute::subType)).setter(setter(Builder::subType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subType").build()).build();

    private static final SdkField<Boolean> HASHING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("hashing").getter(getter(ProviderSchemaAttribute::hashing)).setter(setter(Builder::hashing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hashing").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD, TYPE_FIELD,
            SUB_TYPE_FIELD, HASHING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldName;

    private final String type;

    private final String subType;

    private final Boolean hashing;

    private ProviderSchemaAttribute(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.type = builder.type;
        this.subType = builder.subType;
        this.hashing = builder.hashing;
    }

    /**
     * <p>
     * The field name.
     * </p>
     * 
     * @return The field name.
     */
    public final String fieldName() {
        return fieldName;
    }

    /**
     * <p>
     * The type of the provider schema attribute.
     * </p>
     * <p>
     * LiveRamp supports: <code>NAME</code> | <code>NAME_FIRST</code> | <code>NAME_MIDDLE</code> |
     * <code>NAME_LAST</code> | <code>ADDRESS</code> | <code>ADDRESS_STREET1</code> | <code>ADDRESS_STREET2</code> |
     * <code>ADDRESS_STREET3</code> | <code>ADDRESS_CITY</code> | <code>ADDRESS_STATE</code> |
     * <code>ADDRESS_COUNTRY</code> | <code>ADDRESS_POSTALCODE</code> | <code>PHONE</code> | <code>PHONE_NUMBER</code> |
     * <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code> | <code>PROVIDER_ID</code>
     * </p>
     * <p>
     * TransUnion supports: <code>NAME</code> | <code>NAME_FIRST</code> | <code>NAME_LAST</code> | <code>ADDRESS</code>
     * | <code>ADDRESS_CITY</code> | <code>ADDRESS_STATE</code> | <code>ADDRESS_COUNTRY</code> |
     * <code>ADDRESS_POSTALCODE</code> | <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code>
     * | <code>DATE</code> | <code>IPV4</code> | <code>IPV6</code> | <code>MAID</code>
     * </p>
     * <p>
     * Unified ID 2.0 supports: <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SchemaAttributeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the provider schema attribute.</p>
     *         <p>
     *         LiveRamp supports: <code>NAME</code> | <code>NAME_FIRST</code> | <code>NAME_MIDDLE</code> |
     *         <code>NAME_LAST</code> | <code>ADDRESS</code> | <code>ADDRESS_STREET1</code> |
     *         <code>ADDRESS_STREET2</code> | <code>ADDRESS_STREET3</code> | <code>ADDRESS_CITY</code> |
     *         <code>ADDRESS_STATE</code> | <code>ADDRESS_COUNTRY</code> | <code>ADDRESS_POSTALCODE</code> |
     *         <code>PHONE</code> | <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code> |
     *         <code>PROVIDER_ID</code>
     *         </p>
     *         <p>
     *         TransUnion supports: <code>NAME</code> | <code>NAME_FIRST</code> | <code>NAME_LAST</code> |
     *         <code>ADDRESS</code> | <code>ADDRESS_CITY</code> | <code>ADDRESS_STATE</code> |
     *         <code>ADDRESS_COUNTRY</code> | <code>ADDRESS_POSTALCODE</code> | <code>PHONE_NUMBER</code> |
     *         <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code> | <code>DATE</code> | <code>IPV4</code> |
     *         <code>IPV6</code> | <code>MAID</code>
     *         </p>
     *         <p>
     *         Unified ID 2.0 supports: <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code>
     * @see SchemaAttributeType
     */
    public final SchemaAttributeType type() {
        return SchemaAttributeType.fromValue(type);
    }

    /**
     * <p>
     * The type of the provider schema attribute.
     * </p>
     * <p>
     * LiveRamp supports: <code>NAME</code> | <code>NAME_FIRST</code> | <code>NAME_MIDDLE</code> |
     * <code>NAME_LAST</code> | <code>ADDRESS</code> | <code>ADDRESS_STREET1</code> | <code>ADDRESS_STREET2</code> |
     * <code>ADDRESS_STREET3</code> | <code>ADDRESS_CITY</code> | <code>ADDRESS_STATE</code> |
     * <code>ADDRESS_COUNTRY</code> | <code>ADDRESS_POSTALCODE</code> | <code>PHONE</code> | <code>PHONE_NUMBER</code> |
     * <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code> | <code>PROVIDER_ID</code>
     * </p>
     * <p>
     * TransUnion supports: <code>NAME</code> | <code>NAME_FIRST</code> | <code>NAME_LAST</code> | <code>ADDRESS</code>
     * | <code>ADDRESS_CITY</code> | <code>ADDRESS_STATE</code> | <code>ADDRESS_COUNTRY</code> |
     * <code>ADDRESS_POSTALCODE</code> | <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code>
     * | <code>DATE</code> | <code>IPV4</code> | <code>IPV6</code> | <code>MAID</code>
     * </p>
     * <p>
     * Unified ID 2.0 supports: <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SchemaAttributeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the provider schema attribute.</p>
     *         <p>
     *         LiveRamp supports: <code>NAME</code> | <code>NAME_FIRST</code> | <code>NAME_MIDDLE</code> |
     *         <code>NAME_LAST</code> | <code>ADDRESS</code> | <code>ADDRESS_STREET1</code> |
     *         <code>ADDRESS_STREET2</code> | <code>ADDRESS_STREET3</code> | <code>ADDRESS_CITY</code> |
     *         <code>ADDRESS_STATE</code> | <code>ADDRESS_COUNTRY</code> | <code>ADDRESS_POSTALCODE</code> |
     *         <code>PHONE</code> | <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code> |
     *         <code>PROVIDER_ID</code>
     *         </p>
     *         <p>
     *         TransUnion supports: <code>NAME</code> | <code>NAME_FIRST</code> | <code>NAME_LAST</code> |
     *         <code>ADDRESS</code> | <code>ADDRESS_CITY</code> | <code>ADDRESS_STATE</code> |
     *         <code>ADDRESS_COUNTRY</code> | <code>ADDRESS_POSTALCODE</code> | <code>PHONE_NUMBER</code> |
     *         <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code> | <code>DATE</code> | <code>IPV4</code> |
     *         <code>IPV6</code> | <code>MAID</code>
     *         </p>
     *         <p>
     *         Unified ID 2.0 supports: <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code>
     * @see SchemaAttributeType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The sub type of the provider schema attribute.
     * </p>
     * 
     * @return The sub type of the provider schema attribute.
     */
    public final String subType() {
        return subType;
    }

    /**
     * <p>
     * The hashing attribute of the provider schema.
     * </p>
     * 
     * @return The hashing attribute of the provider schema.
     */
    public final Boolean hashing() {
        return hashing;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subType());
        hashCode = 31 * hashCode + Objects.hashCode(hashing());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderSchemaAttribute)) {
            return false;
        }
        ProviderSchemaAttribute other = (ProviderSchemaAttribute) obj;
        return Objects.equals(fieldName(), other.fieldName()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(subType(), other.subType()) && Objects.equals(hashing(), other.hashing());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProviderSchemaAttribute").add("FieldName", fieldName()).add("Type", typeAsString())
                .add("SubType", subType()).add("Hashing", hashing()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fieldName":
            return Optional.ofNullable(clazz.cast(fieldName()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "subType":
            return Optional.ofNullable(clazz.cast(subType()));
        case "hashing":
            return Optional.ofNullable(clazz.cast(hashing()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fieldName", FIELD_NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("subType", SUB_TYPE_FIELD);
        map.put("hashing", HASHING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProviderSchemaAttribute, T> g) {
        return obj -> g.apply((ProviderSchemaAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProviderSchemaAttribute> {
        /**
         * <p>
         * The field name.
         * </p>
         * 
         * @param fieldName
         *        The field name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * The type of the provider schema attribute.
         * </p>
         * <p>
         * LiveRamp supports: <code>NAME</code> | <code>NAME_FIRST</code> | <code>NAME_MIDDLE</code> |
         * <code>NAME_LAST</code> | <code>ADDRESS</code> | <code>ADDRESS_STREET1</code> | <code>ADDRESS_STREET2</code> |
         * <code>ADDRESS_STREET3</code> | <code>ADDRESS_CITY</code> | <code>ADDRESS_STATE</code> |
         * <code>ADDRESS_COUNTRY</code> | <code>ADDRESS_POSTALCODE</code> | <code>PHONE</code> |
         * <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code> | <code>PROVIDER_ID</code>
         * </p>
         * <p>
         * TransUnion supports: <code>NAME</code> | <code>NAME_FIRST</code> | <code>NAME_LAST</code> |
         * <code>ADDRESS</code> | <code>ADDRESS_CITY</code> | <code>ADDRESS_STATE</code> | <code>ADDRESS_COUNTRY</code>
         * | <code>ADDRESS_POSTALCODE</code> | <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> |
         * <code>UNIQUE_ID</code> | <code>DATE</code> | <code>IPV4</code> | <code>IPV6</code> | <code>MAID</code>
         * </p>
         * <p>
         * Unified ID 2.0 supports: <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code>
         * </p>
         * 
         * @param type
         *        The type of the provider schema attribute.</p>
         *        <p>
         *        LiveRamp supports: <code>NAME</code> | <code>NAME_FIRST</code> | <code>NAME_MIDDLE</code> |
         *        <code>NAME_LAST</code> | <code>ADDRESS</code> | <code>ADDRESS_STREET1</code> |
         *        <code>ADDRESS_STREET2</code> | <code>ADDRESS_STREET3</code> | <code>ADDRESS_CITY</code> |
         *        <code>ADDRESS_STATE</code> | <code>ADDRESS_COUNTRY</code> | <code>ADDRESS_POSTALCODE</code> |
         *        <code>PHONE</code> | <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code> |
         *        <code>PROVIDER_ID</code>
         *        </p>
         *        <p>
         *        TransUnion supports: <code>NAME</code> | <code>NAME_FIRST</code> | <code>NAME_LAST</code> |
         *        <code>ADDRESS</code> | <code>ADDRESS_CITY</code> | <code>ADDRESS_STATE</code> |
         *        <code>ADDRESS_COUNTRY</code> | <code>ADDRESS_POSTALCODE</code> | <code>PHONE_NUMBER</code> |
         *        <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code> | <code>DATE</code> | <code>IPV4</code> |
         *        <code>IPV6</code> | <code>MAID</code>
         *        </p>
         *        <p>
         *        Unified ID 2.0 supports: <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> |
         *        <code>UNIQUE_ID</code>
         * @see SchemaAttributeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaAttributeType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the provider schema attribute.
         * </p>
         * <p>
         * LiveRamp supports: <code>NAME</code> | <code>NAME_FIRST</code> | <code>NAME_MIDDLE</code> |
         * <code>NAME_LAST</code> | <code>ADDRESS</code> | <code>ADDRESS_STREET1</code> | <code>ADDRESS_STREET2</code> |
         * <code>ADDRESS_STREET3</code> | <code>ADDRESS_CITY</code> | <code>ADDRESS_STATE</code> |
         * <code>ADDRESS_COUNTRY</code> | <code>ADDRESS_POSTALCODE</code> | <code>PHONE</code> |
         * <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code> | <code>PROVIDER_ID</code>
         * </p>
         * <p>
         * TransUnion supports: <code>NAME</code> | <code>NAME_FIRST</code> | <code>NAME_LAST</code> |
         * <code>ADDRESS</code> | <code>ADDRESS_CITY</code> | <code>ADDRESS_STATE</code> | <code>ADDRESS_COUNTRY</code>
         * | <code>ADDRESS_POSTALCODE</code> | <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> |
         * <code>UNIQUE_ID</code> | <code>DATE</code> | <code>IPV4</code> | <code>IPV6</code> | <code>MAID</code>
         * </p>
         * <p>
         * Unified ID 2.0 supports: <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code>
         * </p>
         * 
         * @param type
         *        The type of the provider schema attribute.</p>
         *        <p>
         *        LiveRamp supports: <code>NAME</code> | <code>NAME_FIRST</code> | <code>NAME_MIDDLE</code> |
         *        <code>NAME_LAST</code> | <code>ADDRESS</code> | <code>ADDRESS_STREET1</code> |
         *        <code>ADDRESS_STREET2</code> | <code>ADDRESS_STREET3</code> | <code>ADDRESS_CITY</code> |
         *        <code>ADDRESS_STATE</code> | <code>ADDRESS_COUNTRY</code> | <code>ADDRESS_POSTALCODE</code> |
         *        <code>PHONE</code> | <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code> |
         *        <code>PROVIDER_ID</code>
         *        </p>
         *        <p>
         *        TransUnion supports: <code>NAME</code> | <code>NAME_FIRST</code> | <code>NAME_LAST</code> |
         *        <code>ADDRESS</code> | <code>ADDRESS_CITY</code> | <code>ADDRESS_STATE</code> |
         *        <code>ADDRESS_COUNTRY</code> | <code>ADDRESS_POSTALCODE</code> | <code>PHONE_NUMBER</code> |
         *        <code>EMAIL_ADDRESS</code> | <code>UNIQUE_ID</code> | <code>DATE</code> | <code>IPV4</code> |
         *        <code>IPV6</code> | <code>MAID</code>
         *        </p>
         *        <p>
         *        Unified ID 2.0 supports: <code>PHONE_NUMBER</code> | <code>EMAIL_ADDRESS</code> |
         *        <code>UNIQUE_ID</code>
         * @see SchemaAttributeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaAttributeType
         */
        Builder type(SchemaAttributeType type);

        /**
         * <p>
         * The sub type of the provider schema attribute.
         * </p>
         * 
         * @param subType
         *        The sub type of the provider schema attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subType(String subType);

        /**
         * <p>
         * The hashing attribute of the provider schema.
         * </p>
         * 
         * @param hashing
         *        The hashing attribute of the provider schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hashing(Boolean hashing);
    }

    static final class BuilderImpl implements Builder {
        private String fieldName;

        private String type;

        private String subType;

        private Boolean hashing;

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderSchemaAttribute model) {
            fieldName(model.fieldName);
            type(model.type);
            subType(model.subType);
            hashing(model.hashing);
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SchemaAttributeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSubType() {
            return subType;
        }

        public final void setSubType(String subType) {
            this.subType = subType;
        }

        @Override
        public final Builder subType(String subType) {
            this.subType = subType;
            return this;
        }

        public final Boolean getHashing() {
            return hashing;
        }

        public final void setHashing(Boolean hashing) {
            this.hashing = hashing;
        }

        @Override
        public final Builder hashing(Boolean hashing) {
            this.hashing = hashing;
            return this;
        }

        @Override
        public ProviderSchemaAttribute build() {
            return new ProviderSchemaAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
