/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The record.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Record implements SdkPojo, Serializable, ToCopyableBuilder<Record.Builder, Record> {
    private static final SdkField<String> INPUT_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputSourceARN").getter(getter(Record::inputSourceARN)).setter(setter(Builder::inputSourceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSourceARN").build()).build();

    private static final SdkField<String> UNIQUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uniqueId").getter(getter(Record::uniqueId)).setter(setter(Builder::uniqueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uniqueId").build()).build();

    private static final SdkField<Map<String, String>> RECORD_ATTRIBUTE_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("recordAttributeMap")
            .getter(getter(Record::recordAttributeMap))
            .setter(setter(Builder::recordAttributeMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordAttributeMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_SOURCE_ARN_FIELD,
            UNIQUE_ID_FIELD, RECORD_ATTRIBUTE_MAP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String inputSourceARN;

    private final String uniqueId;

    private final Map<String, String> recordAttributeMap;

    private Record(BuilderImpl builder) {
        this.inputSourceARN = builder.inputSourceARN;
        this.uniqueId = builder.uniqueId;
        this.recordAttributeMap = builder.recordAttributeMap;
    }

    /**
     * <p>
     * The input source ARN of the record.
     * </p>
     * 
     * @return The input source ARN of the record.
     */
    public final String inputSourceARN() {
        return inputSourceARN;
    }

    /**
     * <p>
     * The unique ID of the record.
     * </p>
     * 
     * @return The unique ID of the record.
     */
    public final String uniqueId() {
        return uniqueId;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecordAttributeMap property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecordAttributeMap() {
        return recordAttributeMap != null && !(recordAttributeMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The record's attribute map.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecordAttributeMap} method.
     * </p>
     * 
     * @return The record's attribute map.
     */
    public final Map<String, String> recordAttributeMap() {
        return recordAttributeMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputSourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(uniqueId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecordAttributeMap() ? recordAttributeMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record) obj;
        return Objects.equals(inputSourceARN(), other.inputSourceARN()) && Objects.equals(uniqueId(), other.uniqueId())
                && hasRecordAttributeMap() == other.hasRecordAttributeMap()
                && Objects.equals(recordAttributeMap(), other.recordAttributeMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Record").add("InputSourceARN", inputSourceARN()).add("UniqueId", uniqueId())
                .add("RecordAttributeMap", recordAttributeMap() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputSourceARN":
            return Optional.ofNullable(clazz.cast(inputSourceARN()));
        case "uniqueId":
            return Optional.ofNullable(clazz.cast(uniqueId()));
        case "recordAttributeMap":
            return Optional.ofNullable(clazz.cast(recordAttributeMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inputSourceARN", INPUT_SOURCE_ARN_FIELD);
        map.put("uniqueId", UNIQUE_ID_FIELD);
        map.put("recordAttributeMap", RECORD_ATTRIBUTE_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Record, T> g) {
        return obj -> g.apply((Record) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Record> {
        /**
         * <p>
         * The input source ARN of the record.
         * </p>
         * 
         * @param inputSourceARN
         *        The input source ARN of the record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSourceARN(String inputSourceARN);

        /**
         * <p>
         * The unique ID of the record.
         * </p>
         * 
         * @param uniqueId
         *        The unique ID of the record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueId(String uniqueId);

        /**
         * <p>
         * The record's attribute map.
         * </p>
         * 
         * @param recordAttributeMap
         *        The record's attribute map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordAttributeMap(Map<String, String> recordAttributeMap);
    }

    static final class BuilderImpl implements Builder {
        private String inputSourceARN;

        private String uniqueId;

        private Map<String, String> recordAttributeMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Record model) {
            inputSourceARN(model.inputSourceARN);
            uniqueId(model.uniqueId);
            recordAttributeMap(model.recordAttributeMap);
        }

        public final String getInputSourceARN() {
            return inputSourceARN;
        }

        public final void setInputSourceARN(String inputSourceARN) {
            this.inputSourceARN = inputSourceARN;
        }

        @Override
        public final Builder inputSourceARN(String inputSourceARN) {
            this.inputSourceARN = inputSourceARN;
            return this;
        }

        public final String getUniqueId() {
            return uniqueId;
        }

        public final void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        @Override
        public final Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public final Map<String, String> getRecordAttributeMap() {
            if (recordAttributeMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return recordAttributeMap;
        }

        public final void setRecordAttributeMap(Map<String, String> recordAttributeMap) {
            this.recordAttributeMap = RecordAttributeMapString255Copier.copy(recordAttributeMap);
        }

        @Override
        public final Builder recordAttributeMap(Map<String, String> recordAttributeMap) {
            this.recordAttributeMap = RecordAttributeMapString255Copier.copy(recordAttributeMap);
            return this;
        }

        @Override
        public Record build() {
            return new Record(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
