/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMatchingWorkflowResponse extends EntityResolutionResponse implements
        ToCopyableBuilder<UpdateMatchingWorkflowResponse.Builder, UpdateMatchingWorkflowResponse> {
    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowName").getter(getter(UpdateMatchingWorkflowResponse::workflowName))
            .setter(setter(Builder::workflowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateMatchingWorkflowResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<InputSource>> INPUT_SOURCE_CONFIG_FIELD = SdkField
            .<List<InputSource>> builder(MarshallingType.LIST)
            .memberName("inputSourceConfig")
            .getter(getter(UpdateMatchingWorkflowResponse::inputSourceConfig))
            .setter(setter(Builder::inputSourceConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSourceConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OutputSource>> OUTPUT_SOURCE_CONFIG_FIELD = SdkField
            .<List<OutputSource>> builder(MarshallingType.LIST)
            .memberName("outputSourceConfig")
            .getter(getter(UpdateMatchingWorkflowResponse::outputSourceConfig))
            .setter(setter(Builder::outputSourceConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSourceConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ResolutionTechniques> RESOLUTION_TECHNIQUES_FIELD = SdkField
            .<ResolutionTechniques> builder(MarshallingType.SDK_POJO).memberName("resolutionTechniques")
            .getter(getter(UpdateMatchingWorkflowResponse::resolutionTechniques)).setter(setter(Builder::resolutionTechniques))
            .constructor(ResolutionTechniques::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionTechniques").build())
            .build();

    private static final SdkField<IncrementalRunConfig> INCREMENTAL_RUN_CONFIG_FIELD = SdkField
            .<IncrementalRunConfig> builder(MarshallingType.SDK_POJO).memberName("incrementalRunConfig")
            .getter(getter(UpdateMatchingWorkflowResponse::incrementalRunConfig)).setter(setter(Builder::incrementalRunConfig))
            .constructor(IncrementalRunConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incrementalRunConfig").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateMatchingWorkflowResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_NAME_FIELD,
            DESCRIPTION_FIELD, INPUT_SOURCE_CONFIG_FIELD, OUTPUT_SOURCE_CONFIG_FIELD, RESOLUTION_TECHNIQUES_FIELD,
            INCREMENTAL_RUN_CONFIG_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workflowName;

    private final String description;

    private final List<InputSource> inputSourceConfig;

    private final List<OutputSource> outputSourceConfig;

    private final ResolutionTechniques resolutionTechniques;

    private final IncrementalRunConfig incrementalRunConfig;

    private final String roleArn;

    private UpdateMatchingWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.workflowName = builder.workflowName;
        this.description = builder.description;
        this.inputSourceConfig = builder.inputSourceConfig;
        this.outputSourceConfig = builder.outputSourceConfig;
        this.resolutionTechniques = builder.resolutionTechniques;
        this.incrementalRunConfig = builder.incrementalRunConfig;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The name of the workflow.
     * </p>
     * 
     * @return The name of the workflow.
     */
    public final String workflowName() {
        return workflowName;
    }

    /**
     * <p>
     * A description of the workflow.
     * </p>
     * 
     * @return A description of the workflow.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputSourceConfig property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputSourceConfig() {
        return inputSourceConfig != null && !(inputSourceConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
     * <code>SchemaName</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputSourceConfig} method.
     * </p>
     * 
     * @return A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
     *         <code>SchemaName</code>.
     */
    public final List<InputSource> inputSourceConfig() {
        return inputSourceConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputSourceConfig property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputSourceConfig() {
        return outputSourceConfig != null && !(outputSourceConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>OutputSource</code> objects, each of which contains fields <code>outputS3Path</code>,
     * <code>applyNormalization</code>, <code>KMSArn</code>, and <code>output</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputSourceConfig} method.
     * </p>
     * 
     * @return A list of <code>OutputSource</code> objects, each of which contains fields <code>outputS3Path</code>,
     *         <code>applyNormalization</code>, <code>KMSArn</code>, and <code>output</code>.
     */
    public final List<OutputSource> outputSourceConfig() {
        return outputSourceConfig;
    }

    /**
     * <p>
     * An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>.
     * </p>
     * 
     * @return An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>.
     */
    public final ResolutionTechniques resolutionTechniques() {
        return resolutionTechniques;
    }

    /**
     * <p>
     * An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
     * </p>
     * 
     * @return An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
     */
    public final IncrementalRunConfig incrementalRunConfig() {
        return incrementalRunConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to create resources on your
     * behalf as part of workflow execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to create resources
     *         on your behalf as part of workflow execution.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflowName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputSourceConfig() ? inputSourceConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputSourceConfig() ? outputSourceConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resolutionTechniques());
        hashCode = 31 * hashCode + Objects.hashCode(incrementalRunConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMatchingWorkflowResponse)) {
            return false;
        }
        UpdateMatchingWorkflowResponse other = (UpdateMatchingWorkflowResponse) obj;
        return Objects.equals(workflowName(), other.workflowName()) && Objects.equals(description(), other.description())
                && hasInputSourceConfig() == other.hasInputSourceConfig()
                && Objects.equals(inputSourceConfig(), other.inputSourceConfig())
                && hasOutputSourceConfig() == other.hasOutputSourceConfig()
                && Objects.equals(outputSourceConfig(), other.outputSourceConfig())
                && Objects.equals(resolutionTechniques(), other.resolutionTechniques())
                && Objects.equals(incrementalRunConfig(), other.incrementalRunConfig())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMatchingWorkflowResponse").add("WorkflowName", workflowName())
                .add("Description", description()).add("InputSourceConfig", hasInputSourceConfig() ? inputSourceConfig() : null)
                .add("OutputSourceConfig", hasOutputSourceConfig() ? outputSourceConfig() : null)
                .add("ResolutionTechniques", resolutionTechniques()).add("IncrementalRunConfig", incrementalRunConfig())
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workflowName":
            return Optional.ofNullable(clazz.cast(workflowName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "inputSourceConfig":
            return Optional.ofNullable(clazz.cast(inputSourceConfig()));
        case "outputSourceConfig":
            return Optional.ofNullable(clazz.cast(outputSourceConfig()));
        case "resolutionTechniques":
            return Optional.ofNullable(clazz.cast(resolutionTechniques()));
        case "incrementalRunConfig":
            return Optional.ofNullable(clazz.cast(incrementalRunConfig()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workflowName", WORKFLOW_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("inputSourceConfig", INPUT_SOURCE_CONFIG_FIELD);
        map.put("outputSourceConfig", OUTPUT_SOURCE_CONFIG_FIELD);
        map.put("resolutionTechniques", RESOLUTION_TECHNIQUES_FIELD);
        map.put("incrementalRunConfig", INCREMENTAL_RUN_CONFIG_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMatchingWorkflowResponse, T> g) {
        return obj -> g.apply((UpdateMatchingWorkflowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EntityResolutionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateMatchingWorkflowResponse> {
        /**
         * <p>
         * The name of the workflow.
         * </p>
         * 
         * @param workflowName
         *        The name of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowName(String workflowName);

        /**
         * <p>
         * A description of the workflow.
         * </p>
         * 
         * @param description
         *        A description of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
         * <code>SchemaName</code>.
         * </p>
         * 
         * @param inputSourceConfig
         *        A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
         *        <code>SchemaName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSourceConfig(Collection<InputSource> inputSourceConfig);

        /**
         * <p>
         * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
         * <code>SchemaName</code>.
         * </p>
         * 
         * @param inputSourceConfig
         *        A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
         *        <code>SchemaName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSourceConfig(InputSource... inputSourceConfig);

        /**
         * <p>
         * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
         * <code>SchemaName</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.InputSource.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.entityresolution.model.InputSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.InputSource.Builder#build()} is called
         * immediately and its result is passed to {@link #inputSourceConfig(List<InputSource>)}.
         * 
         * @param inputSourceConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.InputSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSourceConfig(java.util.Collection<InputSource>)
         */
        Builder inputSourceConfig(Consumer<InputSource.Builder>... inputSourceConfig);

        /**
         * <p>
         * A list of <code>OutputSource</code> objects, each of which contains fields <code>outputS3Path</code>,
         * <code>applyNormalization</code>, <code>KMSArn</code>, and <code>output</code>.
         * </p>
         * 
         * @param outputSourceConfig
         *        A list of <code>OutputSource</code> objects, each of which contains fields <code>outputS3Path</code>,
         *        <code>applyNormalization</code>, <code>KMSArn</code>, and <code>output</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSourceConfig(Collection<OutputSource> outputSourceConfig);

        /**
         * <p>
         * A list of <code>OutputSource</code> objects, each of which contains fields <code>outputS3Path</code>,
         * <code>applyNormalization</code>, <code>KMSArn</code>, and <code>output</code>.
         * </p>
         * 
         * @param outputSourceConfig
         *        A list of <code>OutputSource</code> objects, each of which contains fields <code>outputS3Path</code>,
         *        <code>applyNormalization</code>, <code>KMSArn</code>, and <code>output</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSourceConfig(OutputSource... outputSourceConfig);

        /**
         * <p>
         * A list of <code>OutputSource</code> objects, each of which contains fields <code>outputS3Path</code>,
         * <code>applyNormalization</code>, <code>KMSArn</code>, and <code>output</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.OutputSource.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.entityresolution.model.OutputSource#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.OutputSource.Builder#build()} is called
         * immediately and its result is passed to {@link #outputSourceConfig(List<OutputSource>)}.
         * 
         * @param outputSourceConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.OutputSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputSourceConfig(java.util.Collection<OutputSource>)
         */
        Builder outputSourceConfig(Consumer<OutputSource.Builder>... outputSourceConfig);

        /**
         * <p>
         * An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>.
         * </p>
         * 
         * @param resolutionTechniques
         *        An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolutionTechniques(ResolutionTechniques resolutionTechniques);

        /**
         * <p>
         * An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResolutionTechniques.Builder} avoiding
         * the need to create one manually via {@link ResolutionTechniques#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResolutionTechniques.Builder#build()} is called immediately and
         * its result is passed to {@link #resolutionTechniques(ResolutionTechniques)}.
         * 
         * @param resolutionTechniques
         *        a consumer that will call methods on {@link ResolutionTechniques.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolutionTechniques(ResolutionTechniques)
         */
        default Builder resolutionTechniques(Consumer<ResolutionTechniques.Builder> resolutionTechniques) {
            return resolutionTechniques(ResolutionTechniques.builder().applyMutation(resolutionTechniques).build());
        }

        /**
         * <p>
         * An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
         * </p>
         * 
         * @param incrementalRunConfig
         *        An object which defines an incremental run type and has only <code>incrementalRunType</code> as a
         *        field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incrementalRunConfig(IncrementalRunConfig incrementalRunConfig);

        /**
         * <p>
         * An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
         * </p>
         * This is a convenience method that creates an instance of the {@link IncrementalRunConfig.Builder} avoiding
         * the need to create one manually via {@link IncrementalRunConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IncrementalRunConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #incrementalRunConfig(IncrementalRunConfig)}.
         * 
         * @param incrementalRunConfig
         *        a consumer that will call methods on {@link IncrementalRunConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incrementalRunConfig(IncrementalRunConfig)
         */
        default Builder incrementalRunConfig(Consumer<IncrementalRunConfig.Builder> incrementalRunConfig) {
            return incrementalRunConfig(IncrementalRunConfig.builder().applyMutation(incrementalRunConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to create resources on
         * your behalf as part of workflow execution.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to create
         *        resources on your behalf as part of workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl extends EntityResolutionResponse.BuilderImpl implements Builder {
        private String workflowName;

        private String description;

        private List<InputSource> inputSourceConfig = DefaultSdkAutoConstructList.getInstance();

        private List<OutputSource> outputSourceConfig = DefaultSdkAutoConstructList.getInstance();

        private ResolutionTechniques resolutionTechniques;

        private IncrementalRunConfig incrementalRunConfig;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMatchingWorkflowResponse model) {
            super(model);
            workflowName(model.workflowName);
            description(model.description);
            inputSourceConfig(model.inputSourceConfig);
            outputSourceConfig(model.outputSourceConfig);
            resolutionTechniques(model.resolutionTechniques);
            incrementalRunConfig(model.incrementalRunConfig);
            roleArn(model.roleArn);
        }

        public final String getWorkflowName() {
            return workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<InputSource.Builder> getInputSourceConfig() {
            List<InputSource.Builder> result = InputSourceConfigCopier.copyToBuilder(this.inputSourceConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputSourceConfig(Collection<InputSource.BuilderImpl> inputSourceConfig) {
            this.inputSourceConfig = InputSourceConfigCopier.copyFromBuilder(inputSourceConfig);
        }

        @Override
        public final Builder inputSourceConfig(Collection<InputSource> inputSourceConfig) {
            this.inputSourceConfig = InputSourceConfigCopier.copy(inputSourceConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSourceConfig(InputSource... inputSourceConfig) {
            inputSourceConfig(Arrays.asList(inputSourceConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSourceConfig(Consumer<InputSource.Builder>... inputSourceConfig) {
            inputSourceConfig(Stream.of(inputSourceConfig).map(c -> InputSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<OutputSource.Builder> getOutputSourceConfig() {
            List<OutputSource.Builder> result = OutputSourceConfigCopier.copyToBuilder(this.outputSourceConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSourceConfig(Collection<OutputSource.BuilderImpl> outputSourceConfig) {
            this.outputSourceConfig = OutputSourceConfigCopier.copyFromBuilder(outputSourceConfig);
        }

        @Override
        public final Builder outputSourceConfig(Collection<OutputSource> outputSourceConfig) {
            this.outputSourceConfig = OutputSourceConfigCopier.copy(outputSourceConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(OutputSource... outputSourceConfig) {
            outputSourceConfig(Arrays.asList(outputSourceConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(Consumer<OutputSource.Builder>... outputSourceConfig) {
            outputSourceConfig(Stream.of(outputSourceConfig).map(c -> OutputSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ResolutionTechniques.Builder getResolutionTechniques() {
            return resolutionTechniques != null ? resolutionTechniques.toBuilder() : null;
        }

        public final void setResolutionTechniques(ResolutionTechniques.BuilderImpl resolutionTechniques) {
            this.resolutionTechniques = resolutionTechniques != null ? resolutionTechniques.build() : null;
        }

        @Override
        public final Builder resolutionTechniques(ResolutionTechniques resolutionTechniques) {
            this.resolutionTechniques = resolutionTechniques;
            return this;
        }

        public final IncrementalRunConfig.Builder getIncrementalRunConfig() {
            return incrementalRunConfig != null ? incrementalRunConfig.toBuilder() : null;
        }

        public final void setIncrementalRunConfig(IncrementalRunConfig.BuilderImpl incrementalRunConfig) {
            this.incrementalRunConfig = incrementalRunConfig != null ? incrementalRunConfig.build() : null;
        }

        @Override
        public final Builder incrementalRunConfig(IncrementalRunConfig incrementalRunConfig) {
            this.incrementalRunConfig = incrementalRunConfig;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public UpdateMatchingWorkflowResponse build() {
            return new UpdateMatchingWorkflowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
