/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters needed for you to provide custom input to a target based on one or more pieces of data
 * extracted from the event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputTransformer implements SdkPojo, Serializable,
        ToCopyableBuilder<InputTransformer.Builder, InputTransformer> {
    private static final SdkField<Map<String, String>> INPUT_PATHS_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(InputTransformer::inputPathsMap))
            .setter(setter(Builder::inputPathsMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputPathsMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> INPUT_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InputTransformer::inputTemplate)).setter(setter(Builder::inputTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_PATHS_MAP_FIELD,
            INPUT_TEMPLATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> inputPathsMap;

    private final String inputTemplate;

    private InputTransformer(BuilderImpl builder) {
        this.inputPathsMap = builder.inputPathsMap;
        this.inputTemplate = builder.inputTemplate;
    }

    /**
     * Returns true if the InputPathsMap property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInputPathsMap() {
        return inputPathsMap != null && !(inputPathsMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Map of JSON paths to be extracted from the event. You can then insert these in the template in
     * <code>InputTemplate</code> to produce the output to be sent to the target.
     * </p>
     * <p>
     * <code>InputPathsMap</code> is an array key-value pairs, where each value is a valid JSON path. You can have as
     * many as 10 key-value pairs. You must use JSON dot notation, not bracket notation.
     * </p>
     * <p>
     * The keys can't start with <code>"AWS"</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputPathsMap()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Map of JSON paths to be extracted from the event. You can then insert these in the template in
     *         <code>InputTemplate</code> to produce the output to be sent to the target.</p>
     *         <p>
     *         <code>InputPathsMap</code> is an array key-value pairs, where each value is a valid JSON path. You can
     *         have as many as 10 key-value pairs. You must use JSON dot notation, not bracket notation.
     *         </p>
     *         <p>
     *         The keys can't start with <code>"AWS"</code>.
     */
    public Map<String, String> inputPathsMap() {
        return inputPathsMap;
    }

    /**
     * <p>
     * Input template where you specify placeholders that will be filled with the values of the keys from
     * <code>InputPathsMap</code> to customize the data sent to the target. Enclose each <code>InputPathsMaps</code>
     * value in brackets: &lt;<i>value</i>&gt;. The InputTemplate must be valid JSON.
     * </p>
     * <p>
     * If <code>InputTemplate</code> is a JSON object (surrounded by curly braces), the following restrictions apply:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The placeholder can't be used as an object key
     * </p>
     * </li>
     * <li>
     * <p>
     * Object values can't include quote marks
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following example shows the syntax for using <code>InputPathsMap</code> and <code>InputTemplate</code>.
     * </p>
     * <p>
     * <code> "InputTransformer":</code>
     * </p>
     * <p>
     * <code>{</code>
     * </p>
     * <p>
     * <code>"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},</code>
     * </p>
     * <p>
     * <code>"InputTemplate": "&lt;instance&gt; is in state &lt;status&gt;"</code>
     * </p>
     * <p>
     * <code>}</code>
     * </p>
     * <p>
     * To have the <code>InputTemplate</code> include quote marks within a JSON string, escape each quote marks with a
     * slash, as in the following example:
     * </p>
     * <p>
     * <code> "InputTransformer":</code>
     * </p>
     * <p>
     * <code>{</code>
     * </p>
     * <p>
     * <code>"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},</code>
     * </p>
     * <p>
     * <code>"InputTemplate": "&lt;instance&gt; is in state \"&lt;status&gt;\""</code>
     * </p>
     * <p>
     * <code>}</code>
     * </p>
     * 
     * @return Input template where you specify placeholders that will be filled with the values of the keys from
     *         <code>InputPathsMap</code> to customize the data sent to the target. Enclose each
     *         <code>InputPathsMaps</code> value in brackets: &lt;<i>value</i>&gt;. The InputTemplate must be valid
     *         JSON.</p>
     *         <p>
     *         If <code>InputTemplate</code> is a JSON object (surrounded by curly braces), the following restrictions
     *         apply:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The placeholder can't be used as an object key
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Object values can't include quote marks
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following example shows the syntax for using <code>InputPathsMap</code> and
     *         <code>InputTemplate</code>.
     *         </p>
     *         <p>
     *         <code> "InputTransformer":</code>
     *         </p>
     *         <p>
     *         <code>{</code>
     *         </p>
     *         <p>
     *         <code>"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},</code>
     *         </p>
     *         <p>
     *         <code>"InputTemplate": "&lt;instance&gt; is in state &lt;status&gt;"</code>
     *         </p>
     *         <p>
     *         <code>}</code>
     *         </p>
     *         <p>
     *         To have the <code>InputTemplate</code> include quote marks within a JSON string, escape each quote marks
     *         with a slash, as in the following example:
     *         </p>
     *         <p>
     *         <code> "InputTransformer":</code>
     *         </p>
     *         <p>
     *         <code>{</code>
     *         </p>
     *         <p>
     *         <code>"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},</code>
     *         </p>
     *         <p>
     *         <code>"InputTemplate": "&lt;instance&gt; is in state \"&lt;status&gt;\""</code>
     *         </p>
     *         <p>
     *         <code>}</code>
     */
    public String inputTemplate() {
        return inputTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputPathsMap());
        hashCode = 31 * hashCode + Objects.hashCode(inputTemplate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputTransformer)) {
            return false;
        }
        InputTransformer other = (InputTransformer) obj;
        return Objects.equals(inputPathsMap(), other.inputPathsMap()) && Objects.equals(inputTemplate(), other.inputTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InputTransformer").add("InputPathsMap", inputPathsMap()).add("InputTemplate", inputTemplate())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputPathsMap":
            return Optional.ofNullable(clazz.cast(inputPathsMap()));
        case "InputTemplate":
            return Optional.ofNullable(clazz.cast(inputTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputTransformer, T> g) {
        return obj -> g.apply((InputTransformer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputTransformer> {
        /**
         * <p>
         * Map of JSON paths to be extracted from the event. You can then insert these in the template in
         * <code>InputTemplate</code> to produce the output to be sent to the target.
         * </p>
         * <p>
         * <code>InputPathsMap</code> is an array key-value pairs, where each value is a valid JSON path. You can have
         * as many as 10 key-value pairs. You must use JSON dot notation, not bracket notation.
         * </p>
         * <p>
         * The keys can't start with <code>"AWS"</code>.
         * </p>
         * 
         * @param inputPathsMap
         *        Map of JSON paths to be extracted from the event. You can then insert these in the template in
         *        <code>InputTemplate</code> to produce the output to be sent to the target.</p>
         *        <p>
         *        <code>InputPathsMap</code> is an array key-value pairs, where each value is a valid JSON path. You can
         *        have as many as 10 key-value pairs. You must use JSON dot notation, not bracket notation.
         *        </p>
         *        <p>
         *        The keys can't start with <code>"AWS"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputPathsMap(Map<String, String> inputPathsMap);

        /**
         * <p>
         * Input template where you specify placeholders that will be filled with the values of the keys from
         * <code>InputPathsMap</code> to customize the data sent to the target. Enclose each <code>InputPathsMaps</code>
         * value in brackets: &lt;<i>value</i>&gt;. The InputTemplate must be valid JSON.
         * </p>
         * <p>
         * If <code>InputTemplate</code> is a JSON object (surrounded by curly braces), the following restrictions
         * apply:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The placeholder can't be used as an object key
         * </p>
         * </li>
         * <li>
         * <p>
         * Object values can't include quote marks
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following example shows the syntax for using <code>InputPathsMap</code> and <code>InputTemplate</code>.
         * </p>
         * <p>
         * <code> "InputTransformer":</code>
         * </p>
         * <p>
         * <code>{</code>
         * </p>
         * <p>
         * <code>"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},</code>
         * </p>
         * <p>
         * <code>"InputTemplate": "&lt;instance&gt; is in state &lt;status&gt;"</code>
         * </p>
         * <p>
         * <code>}</code>
         * </p>
         * <p>
         * To have the <code>InputTemplate</code> include quote marks within a JSON string, escape each quote marks with
         * a slash, as in the following example:
         * </p>
         * <p>
         * <code> "InputTransformer":</code>
         * </p>
         * <p>
         * <code>{</code>
         * </p>
         * <p>
         * <code>"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},</code>
         * </p>
         * <p>
         * <code>"InputTemplate": "&lt;instance&gt; is in state \"&lt;status&gt;\""</code>
         * </p>
         * <p>
         * <code>}</code>
         * </p>
         * 
         * @param inputTemplate
         *        Input template where you specify placeholders that will be filled with the values of the keys from
         *        <code>InputPathsMap</code> to customize the data sent to the target. Enclose each
         *        <code>InputPathsMaps</code> value in brackets: &lt;<i>value</i>&gt;. The InputTemplate must be valid
         *        JSON.</p>
         *        <p>
         *        If <code>InputTemplate</code> is a JSON object (surrounded by curly braces), the following
         *        restrictions apply:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The placeholder can't be used as an object key
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Object values can't include quote marks
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following example shows the syntax for using <code>InputPathsMap</code> and
         *        <code>InputTemplate</code>.
         *        </p>
         *        <p>
         *        <code> "InputTransformer":</code>
         *        </p>
         *        <p>
         *        <code>{</code>
         *        </p>
         *        <p>
         *        <code>"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},</code>
         *        </p>
         *        <p>
         *        <code>"InputTemplate": "&lt;instance&gt; is in state &lt;status&gt;"</code>
         *        </p>
         *        <p>
         *        <code>}</code>
         *        </p>
         *        <p>
         *        To have the <code>InputTemplate</code> include quote marks within a JSON string, escape each quote
         *        marks with a slash, as in the following example:
         *        </p>
         *        <p>
         *        <code> "InputTransformer":</code>
         *        </p>
         *        <p>
         *        <code>{</code>
         *        </p>
         *        <p>
         *        <code>"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},</code>
         *        </p>
         *        <p>
         *        <code>"InputTemplate": "&lt;instance&gt; is in state \"&lt;status&gt;\""</code>
         *        </p>
         *        <p>
         *        <code>}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputTemplate(String inputTemplate);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> inputPathsMap = DefaultSdkAutoConstructMap.getInstance();

        private String inputTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(InputTransformer model) {
            inputPathsMap(model.inputPathsMap);
            inputTemplate(model.inputTemplate);
        }

        public final Map<String, String> getInputPathsMap() {
            return inputPathsMap;
        }

        @Override
        public final Builder inputPathsMap(Map<String, String> inputPathsMap) {
            this.inputPathsMap = TransformerPathsCopier.copy(inputPathsMap);
            return this;
        }

        public final void setInputPathsMap(Map<String, String> inputPathsMap) {
            this.inputPathsMap = TransformerPathsCopier.copy(inputPathsMap);
        }

        public final String getInputTemplate() {
            return inputTemplate;
        }

        @Override
        public final Builder inputTemplate(String inputTemplate) {
            this.inputTemplate = inputTemplate;
            return this;
        }

        public final void setInputTemplate(String inputTemplate) {
            this.inputTemplate = inputTemplate;
        }

        @Override
        public InputTransformer build() {
            return new InputTransformer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
