/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Targets are the resources to be invoked when a rule is triggered. For a complete list of services and resources that
 * can be set as a target, see <a>PutTargets</a>.
 * </p>
 * <p>
 * If you are setting the event bus of another account as the target, and that account granted permission to your
 * account through an organization instead of directly by the account ID, then you must specify a <code>RoleArn</code>
 * with proper permissions in the <code>Target</code> structure. For more information, see <a
 * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">Sending
 * and Receiving Events Between AWS Accounts</a> in the <i>Amazon EventBridge User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Target implements SdkPojo, Serializable, ToCopyableBuilder<Target.Builder, Target> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).getter(getter(Target::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Target::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Target::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Target::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()).build();

    private static final SdkField<String> INPUT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Target::inputPath)).setter(setter(Builder::inputPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputPath").build()).build();

    private static final SdkField<InputTransformer> INPUT_TRANSFORMER_FIELD = SdkField
            .<InputTransformer> builder(MarshallingType.SDK_POJO).getter(getter(Target::inputTransformer))
            .setter(setter(Builder::inputTransformer)).constructor(InputTransformer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputTransformer").build()).build();

    private static final SdkField<KinesisParameters> KINESIS_PARAMETERS_FIELD = SdkField
            .<KinesisParameters> builder(MarshallingType.SDK_POJO).getter(getter(Target::kinesisParameters))
            .setter(setter(Builder::kinesisParameters)).constructor(KinesisParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisParameters").build()).build();

    private static final SdkField<RunCommandParameters> RUN_COMMAND_PARAMETERS_FIELD = SdkField
            .<RunCommandParameters> builder(MarshallingType.SDK_POJO).getter(getter(Target::runCommandParameters))
            .setter(setter(Builder::runCommandParameters)).constructor(RunCommandParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunCommandParameters").build())
            .build();

    private static final SdkField<EcsParameters> ECS_PARAMETERS_FIELD = SdkField
            .<EcsParameters> builder(MarshallingType.SDK_POJO).getter(getter(Target::ecsParameters))
            .setter(setter(Builder::ecsParameters)).constructor(EcsParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EcsParameters").build()).build();

    private static final SdkField<BatchParameters> BATCH_PARAMETERS_FIELD = SdkField
            .<BatchParameters> builder(MarshallingType.SDK_POJO).getter(getter(Target::batchParameters))
            .setter(setter(Builder::batchParameters)).constructor(BatchParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchParameters").build()).build();

    private static final SdkField<SqsParameters> SQS_PARAMETERS_FIELD = SdkField
            .<SqsParameters> builder(MarshallingType.SDK_POJO).getter(getter(Target::sqsParameters))
            .setter(setter(Builder::sqsParameters)).constructor(SqsParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqsParameters").build()).build();

    private static final SdkField<HttpParameters> HTTP_PARAMETERS_FIELD = SdkField
            .<HttpParameters> builder(MarshallingType.SDK_POJO).getter(getter(Target::httpParameters))
            .setter(setter(Builder::httpParameters)).constructor(HttpParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpParameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            ROLE_ARN_FIELD, INPUT_FIELD, INPUT_PATH_FIELD, INPUT_TRANSFORMER_FIELD, KINESIS_PARAMETERS_FIELD,
            RUN_COMMAND_PARAMETERS_FIELD, ECS_PARAMETERS_FIELD, BATCH_PARAMETERS_FIELD, SQS_PARAMETERS_FIELD,
            HTTP_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String roleArn;

    private final String input;

    private final String inputPath;

    private final InputTransformer inputTransformer;

    private final KinesisParameters kinesisParameters;

    private final RunCommandParameters runCommandParameters;

    private final EcsParameters ecsParameters;

    private final BatchParameters batchParameters;

    private final SqsParameters sqsParameters;

    private final HttpParameters httpParameters;

    private Target(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.roleArn = builder.roleArn;
        this.input = builder.input;
        this.inputPath = builder.inputPath;
        this.inputTransformer = builder.inputTransformer;
        this.kinesisParameters = builder.kinesisParameters;
        this.runCommandParameters = builder.runCommandParameters;
        this.ecsParameters = builder.ecsParameters;
        this.batchParameters = builder.batchParameters;
        this.sqsParameters = builder.sqsParameters;
        this.httpParameters = builder.httpParameters;
    }

    /**
     * <p>
     * The ID of the target.
     * </p>
     * 
     * @return The ID of the target.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the target.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the target.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. If one rule
     * triggers multiple targets, you can use a different IAM role for each target.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. If
     *         one rule triggers multiple targets, you can use a different IAM role for each target.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. For
     * more information, see <a href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation (JSON)
     * Data Interchange Format</a>.
     * </p>
     * 
     * @return Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the
     *         target. For more information, see <a href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript
     *         Object Notation (JSON) Data Interchange Format</a>.
     */
    public String input() {
        return input;
    }

    /**
     * <p>
     * The value of the JSONPath that is used for extracting part of the matched event when passing it to the target.
     * You must use JSON dot notation, not bracket notation. For more information about JSON paths, see <a
     * href="http://goessner.net/articles/JsonPath/">JSONPath</a>.
     * </p>
     * 
     * @return The value of the JSONPath that is used for extracting part of the matched event when passing it to the
     *         target. You must use JSON dot notation, not bracket notation. For more information about JSON paths, see
     *         <a href="http://goessner.net/articles/JsonPath/">JSONPath</a>.
     */
    public String inputPath() {
        return inputPath;
    }

    /**
     * <p>
     * Settings to enable you to provide custom input to a target based on certain event data. You can extract one or
     * more key-value pairs from the event and then use that data to send customized input to the target.
     * </p>
     * 
     * @return Settings to enable you to provide custom input to a target based on certain event data. You can extract
     *         one or more key-value pairs from the event and then use that data to send customized input to the target.
     */
    public InputTransformer inputTransformer() {
        return inputTransformer;
    }

    /**
     * <p>
     * The custom parameter you can use to control the shard assignment, when the target is a Kinesis data stream. If
     * you do not include this parameter, the default is to use the <code>eventId</code> as the partition key.
     * </p>
     * 
     * @return The custom parameter you can use to control the shard assignment, when the target is a Kinesis data
     *         stream. If you do not include this parameter, the default is to use the <code>eventId</code> as the
     *         partition key.
     */
    public KinesisParameters kinesisParameters() {
        return kinesisParameters;
    }

    /**
     * <p>
     * Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
     * </p>
     * 
     * @return Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
     */
    public RunCommandParameters runCommandParameters() {
        return runCommandParameters;
    }

    /**
     * <p>
     * Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon ECS task. For
     * more information about Amazon ECS tasks, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Task Definitions </a> in
     * the <i>Amazon EC2 Container Service Developer Guide</i>.
     * </p>
     * 
     * @return Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon ECS
     *         task. For more information about Amazon ECS tasks, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Task Definitions
     *         </a> in the <i>Amazon EC2 Container Service Developer Guide</i>.
     */
    public EcsParameters ecsParameters() {
        return ecsParameters;
    }

    /**
     * <p>
     * If the event target is an AWS Batch job, this contains the job definition, job name, and other parameters. For
     * more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/jobs.html">Jobs</a> in the
     * <i>AWS Batch User Guide</i>.
     * </p>
     * 
     * @return If the event target is an AWS Batch job, this contains the job definition, job name, and other
     *         parameters. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/jobs.html">Jobs</a> in the <i>AWS Batch User
     *         Guide</i>.
     */
    public BatchParameters batchParameters() {
        return batchParameters;
    }

    /**
     * <p>
     * Contains the message group ID to use when the target is a FIFO queue.
     * </p>
     * <p>
     * If you specify an SQS FIFO queue as a target, the queue must have content-based deduplication enabled.
     * </p>
     * 
     * @return Contains the message group ID to use when the target is a FIFO queue.</p>
     *         <p>
     *         If you specify an SQS FIFO queue as a target, the queue must have content-based deduplication enabled.
     */
    public SqsParameters sqsParameters() {
        return sqsParameters;
    }

    /**
     * <p>
     * Contains the HTTP parameters to use when the target is a API Gateway REST endpoint.
     * </p>
     * <p>
     * If you specify an API Gateway REST API as a target, you can use this parameter to specify headers, path
     * parameter, query string keys/values as part of your target invoking request.
     * </p>
     * 
     * @return Contains the HTTP parameters to use when the target is a API Gateway REST endpoint.</p>
     *         <p>
     *         If you specify an API Gateway REST API as a target, you can use this parameter to specify headers, path
     *         parameter, query string keys/values as part of your target invoking request.
     */
    public HttpParameters httpParameters() {
        return httpParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(inputPath());
        hashCode = 31 * hashCode + Objects.hashCode(inputTransformer());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisParameters());
        hashCode = 31 * hashCode + Objects.hashCode(runCommandParameters());
        hashCode = 31 * hashCode + Objects.hashCode(ecsParameters());
        hashCode = 31 * hashCode + Objects.hashCode(batchParameters());
        hashCode = 31 * hashCode + Objects.hashCode(sqsParameters());
        hashCode = 31 * hashCode + Objects.hashCode(httpParameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Target)) {
            return false;
        }
        Target other = (Target) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(input(), other.input())
                && Objects.equals(inputPath(), other.inputPath()) && Objects.equals(inputTransformer(), other.inputTransformer())
                && Objects.equals(kinesisParameters(), other.kinesisParameters())
                && Objects.equals(runCommandParameters(), other.runCommandParameters())
                && Objects.equals(ecsParameters(), other.ecsParameters())
                && Objects.equals(batchParameters(), other.batchParameters())
                && Objects.equals(sqsParameters(), other.sqsParameters())
                && Objects.equals(httpParameters(), other.httpParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Target").add("Id", id()).add("Arn", arn()).add("RoleArn", roleArn()).add("Input", input())
                .add("InputPath", inputPath()).add("InputTransformer", inputTransformer())
                .add("KinesisParameters", kinesisParameters()).add("RunCommandParameters", runCommandParameters())
                .add("EcsParameters", ecsParameters()).add("BatchParameters", batchParameters())
                .add("SqsParameters", sqsParameters()).add("HttpParameters", httpParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "InputPath":
            return Optional.ofNullable(clazz.cast(inputPath()));
        case "InputTransformer":
            return Optional.ofNullable(clazz.cast(inputTransformer()));
        case "KinesisParameters":
            return Optional.ofNullable(clazz.cast(kinesisParameters()));
        case "RunCommandParameters":
            return Optional.ofNullable(clazz.cast(runCommandParameters()));
        case "EcsParameters":
            return Optional.ofNullable(clazz.cast(ecsParameters()));
        case "BatchParameters":
            return Optional.ofNullable(clazz.cast(batchParameters()));
        case "SqsParameters":
            return Optional.ofNullable(clazz.cast(sqsParameters()));
        case "HttpParameters":
            return Optional.ofNullable(clazz.cast(httpParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Target, T> g) {
        return obj -> g.apply((Target) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Target> {
        /**
         * <p>
         * The ID of the target.
         * </p>
         * 
         * @param id
         *        The ID of the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the target.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. If one
         * rule triggers multiple targets, you can use a different IAM role for each target.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered.
         *        If one rule triggers multiple targets, you can use a different IAM role for each target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target.
         * For more information, see <a href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation
         * (JSON) Data Interchange Format</a>.
         * </p>
         * 
         * @param input
         *        Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the
         *        target. For more information, see <a href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript
         *        Object Notation (JSON) Data Interchange Format</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * The value of the JSONPath that is used for extracting part of the matched event when passing it to the
         * target. You must use JSON dot notation, not bracket notation. For more information about JSON paths, see <a
         * href="http://goessner.net/articles/JsonPath/">JSONPath</a>.
         * </p>
         * 
         * @param inputPath
         *        The value of the JSONPath that is used for extracting part of the matched event when passing it to the
         *        target. You must use JSON dot notation, not bracket notation. For more information about JSON paths,
         *        see <a href="http://goessner.net/articles/JsonPath/">JSONPath</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputPath(String inputPath);

        /**
         * <p>
         * Settings to enable you to provide custom input to a target based on certain event data. You can extract one
         * or more key-value pairs from the event and then use that data to send customized input to the target.
         * </p>
         * 
         * @param inputTransformer
         *        Settings to enable you to provide custom input to a target based on certain event data. You can
         *        extract one or more key-value pairs from the event and then use that data to send customized input to
         *        the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputTransformer(InputTransformer inputTransformer);

        /**
         * <p>
         * Settings to enable you to provide custom input to a target based on certain event data. You can extract one
         * or more key-value pairs from the event and then use that data to send customized input to the target.
         * </p>
         * This is a convenience that creates an instance of the {@link InputTransformer.Builder} avoiding the need to
         * create one manually via {@link InputTransformer#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputTransformer.Builder#build()} is called immediately and its
         * result is passed to {@link #inputTransformer(InputTransformer)}.
         * 
         * @param inputTransformer
         *        a consumer that will call methods on {@link InputTransformer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputTransformer(InputTransformer)
         */
        default Builder inputTransformer(Consumer<InputTransformer.Builder> inputTransformer) {
            return inputTransformer(InputTransformer.builder().applyMutation(inputTransformer).build());
        }

        /**
         * <p>
         * The custom parameter you can use to control the shard assignment, when the target is a Kinesis data stream.
         * If you do not include this parameter, the default is to use the <code>eventId</code> as the partition key.
         * </p>
         * 
         * @param kinesisParameters
         *        The custom parameter you can use to control the shard assignment, when the target is a Kinesis data
         *        stream. If you do not include this parameter, the default is to use the <code>eventId</code> as the
         *        partition key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisParameters(KinesisParameters kinesisParameters);

        /**
         * <p>
         * The custom parameter you can use to control the shard assignment, when the target is a Kinesis data stream.
         * If you do not include this parameter, the default is to use the <code>eventId</code> as the partition key.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisParameters.Builder} avoiding the need to
         * create one manually via {@link KinesisParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #kinesisParameters(KinesisParameters)}.
         * 
         * @param kinesisParameters
         *        a consumer that will call methods on {@link KinesisParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisParameters(KinesisParameters)
         */
        default Builder kinesisParameters(Consumer<KinesisParameters.Builder> kinesisParameters) {
            return kinesisParameters(KinesisParameters.builder().applyMutation(kinesisParameters).build());
        }

        /**
         * <p>
         * Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
         * </p>
         * 
         * @param runCommandParameters
         *        Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runCommandParameters(RunCommandParameters runCommandParameters);

        /**
         * <p>
         * Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
         * </p>
         * This is a convenience that creates an instance of the {@link RunCommandParameters.Builder} avoiding the need
         * to create one manually via {@link RunCommandParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link RunCommandParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #runCommandParameters(RunCommandParameters)}.
         * 
         * @param runCommandParameters
         *        a consumer that will call methods on {@link RunCommandParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runCommandParameters(RunCommandParameters)
         */
        default Builder runCommandParameters(Consumer<RunCommandParameters.Builder> runCommandParameters) {
            return runCommandParameters(RunCommandParameters.builder().applyMutation(runCommandParameters).build());
        }

        /**
         * <p>
         * Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon ECS task.
         * For more information about Amazon ECS tasks, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Task Definitions </a>
         * in the <i>Amazon EC2 Container Service Developer Guide</i>.
         * </p>
         * 
         * @param ecsParameters
         *        Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon
         *        ECS task. For more information about Amazon ECS tasks, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Task
         *        Definitions </a> in the <i>Amazon EC2 Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsParameters(EcsParameters ecsParameters);

        /**
         * <p>
         * Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon ECS task.
         * For more information about Amazon ECS tasks, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Task Definitions </a>
         * in the <i>Amazon EC2 Container Service Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link EcsParameters.Builder} avoiding the need to
         * create one manually via {@link EcsParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link EcsParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #ecsParameters(EcsParameters)}.
         * 
         * @param ecsParameters
         *        a consumer that will call methods on {@link EcsParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecsParameters(EcsParameters)
         */
        default Builder ecsParameters(Consumer<EcsParameters.Builder> ecsParameters) {
            return ecsParameters(EcsParameters.builder().applyMutation(ecsParameters).build());
        }

        /**
         * <p>
         * If the event target is an AWS Batch job, this contains the job definition, job name, and other parameters.
         * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/jobs.html">Jobs</a> in
         * the <i>AWS Batch User Guide</i>.
         * </p>
         * 
         * @param batchParameters
         *        If the event target is an AWS Batch job, this contains the job definition, job name, and other
         *        parameters. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/jobs.html">Jobs</a> in the <i>AWS Batch User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchParameters(BatchParameters batchParameters);

        /**
         * <p>
         * If the event target is an AWS Batch job, this contains the job definition, job name, and other parameters.
         * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/jobs.html">Jobs</a> in
         * the <i>AWS Batch User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchParameters.Builder} avoiding the need to
         * create one manually via {@link BatchParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #batchParameters(BatchParameters)}.
         * 
         * @param batchParameters
         *        a consumer that will call methods on {@link BatchParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchParameters(BatchParameters)
         */
        default Builder batchParameters(Consumer<BatchParameters.Builder> batchParameters) {
            return batchParameters(BatchParameters.builder().applyMutation(batchParameters).build());
        }

        /**
         * <p>
         * Contains the message group ID to use when the target is a FIFO queue.
         * </p>
         * <p>
         * If you specify an SQS FIFO queue as a target, the queue must have content-based deduplication enabled.
         * </p>
         * 
         * @param sqsParameters
         *        Contains the message group ID to use when the target is a FIFO queue.</p>
         *        <p>
         *        If you specify an SQS FIFO queue as a target, the queue must have content-based deduplication enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqsParameters(SqsParameters sqsParameters);

        /**
         * <p>
         * Contains the message group ID to use when the target is a FIFO queue.
         * </p>
         * <p>
         * If you specify an SQS FIFO queue as a target, the queue must have content-based deduplication enabled.
         * </p>
         * This is a convenience that creates an instance of the {@link SqsParameters.Builder} avoiding the need to
         * create one manually via {@link SqsParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link SqsParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #sqsParameters(SqsParameters)}.
         * 
         * @param sqsParameters
         *        a consumer that will call methods on {@link SqsParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqsParameters(SqsParameters)
         */
        default Builder sqsParameters(Consumer<SqsParameters.Builder> sqsParameters) {
            return sqsParameters(SqsParameters.builder().applyMutation(sqsParameters).build());
        }

        /**
         * <p>
         * Contains the HTTP parameters to use when the target is a API Gateway REST endpoint.
         * </p>
         * <p>
         * If you specify an API Gateway REST API as a target, you can use this parameter to specify headers, path
         * parameter, query string keys/values as part of your target invoking request.
         * </p>
         * 
         * @param httpParameters
         *        Contains the HTTP parameters to use when the target is a API Gateway REST endpoint.</p>
         *        <p>
         *        If you specify an API Gateway REST API as a target, you can use this parameter to specify headers,
         *        path parameter, query string keys/values as part of your target invoking request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpParameters(HttpParameters httpParameters);

        /**
         * <p>
         * Contains the HTTP parameters to use when the target is a API Gateway REST endpoint.
         * </p>
         * <p>
         * If you specify an API Gateway REST API as a target, you can use this parameter to specify headers, path
         * parameter, query string keys/values as part of your target invoking request.
         * </p>
         * This is a convenience that creates an instance of the {@link HttpParameters.Builder} avoiding the need to
         * create one manually via {@link HttpParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #httpParameters(HttpParameters)}.
         * 
         * @param httpParameters
         *        a consumer that will call methods on {@link HttpParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpParameters(HttpParameters)
         */
        default Builder httpParameters(Consumer<HttpParameters.Builder> httpParameters) {
            return httpParameters(HttpParameters.builder().applyMutation(httpParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String roleArn;

        private String input;

        private String inputPath;

        private InputTransformer inputTransformer;

        private KinesisParameters kinesisParameters;

        private RunCommandParameters runCommandParameters;

        private EcsParameters ecsParameters;

        private BatchParameters batchParameters;

        private SqsParameters sqsParameters;

        private HttpParameters httpParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(Target model) {
            id(model.id);
            arn(model.arn);
            roleArn(model.roleArn);
            input(model.input);
            inputPath(model.inputPath);
            inputTransformer(model.inputTransformer);
            kinesisParameters(model.kinesisParameters);
            runCommandParameters(model.runCommandParameters);
            ecsParameters(model.ecsParameters);
            batchParameters(model.batchParameters);
            sqsParameters(model.sqsParameters);
            httpParameters(model.httpParameters);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getInput() {
            return input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final String getInputPath() {
            return inputPath;
        }

        @Override
        public final Builder inputPath(String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        public final void setInputPath(String inputPath) {
            this.inputPath = inputPath;
        }

        public final InputTransformer.Builder getInputTransformer() {
            return inputTransformer != null ? inputTransformer.toBuilder() : null;
        }

        @Override
        public final Builder inputTransformer(InputTransformer inputTransformer) {
            this.inputTransformer = inputTransformer;
            return this;
        }

        public final void setInputTransformer(InputTransformer.BuilderImpl inputTransformer) {
            this.inputTransformer = inputTransformer != null ? inputTransformer.build() : null;
        }

        public final KinesisParameters.Builder getKinesisParameters() {
            return kinesisParameters != null ? kinesisParameters.toBuilder() : null;
        }

        @Override
        public final Builder kinesisParameters(KinesisParameters kinesisParameters) {
            this.kinesisParameters = kinesisParameters;
            return this;
        }

        public final void setKinesisParameters(KinesisParameters.BuilderImpl kinesisParameters) {
            this.kinesisParameters = kinesisParameters != null ? kinesisParameters.build() : null;
        }

        public final RunCommandParameters.Builder getRunCommandParameters() {
            return runCommandParameters != null ? runCommandParameters.toBuilder() : null;
        }

        @Override
        public final Builder runCommandParameters(RunCommandParameters runCommandParameters) {
            this.runCommandParameters = runCommandParameters;
            return this;
        }

        public final void setRunCommandParameters(RunCommandParameters.BuilderImpl runCommandParameters) {
            this.runCommandParameters = runCommandParameters != null ? runCommandParameters.build() : null;
        }

        public final EcsParameters.Builder getEcsParameters() {
            return ecsParameters != null ? ecsParameters.toBuilder() : null;
        }

        @Override
        public final Builder ecsParameters(EcsParameters ecsParameters) {
            this.ecsParameters = ecsParameters;
            return this;
        }

        public final void setEcsParameters(EcsParameters.BuilderImpl ecsParameters) {
            this.ecsParameters = ecsParameters != null ? ecsParameters.build() : null;
        }

        public final BatchParameters.Builder getBatchParameters() {
            return batchParameters != null ? batchParameters.toBuilder() : null;
        }

        @Override
        public final Builder batchParameters(BatchParameters batchParameters) {
            this.batchParameters = batchParameters;
            return this;
        }

        public final void setBatchParameters(BatchParameters.BuilderImpl batchParameters) {
            this.batchParameters = batchParameters != null ? batchParameters.build() : null;
        }

        public final SqsParameters.Builder getSqsParameters() {
            return sqsParameters != null ? sqsParameters.toBuilder() : null;
        }

        @Override
        public final Builder sqsParameters(SqsParameters sqsParameters) {
            this.sqsParameters = sqsParameters;
            return this;
        }

        public final void setSqsParameters(SqsParameters.BuilderImpl sqsParameters) {
            this.sqsParameters = sqsParameters != null ? sqsParameters.build() : null;
        }

        public final HttpParameters.Builder getHttpParameters() {
            return httpParameters != null ? httpParameters.toBuilder() : null;
        }

        @Override
        public final Builder httpParameters(HttpParameters httpParameters) {
            this.httpParameters = httpParameters;
            return this;
        }

        public final void setHttpParameters(HttpParameters.BuilderImpl httpParameters) {
            this.httpParameters = httpParameters != null ? httpParameters.build() : null;
        }

        @Override
        public Target build() {
            return new Target(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
