/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutTargetsResponse extends EventBridgeResponse implements
        ToCopyableBuilder<PutTargetsResponse.Builder, PutTargetsResponse> {
    private static final SdkField<Integer> FAILED_ENTRY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FailedEntryCount").getter(getter(PutTargetsResponse::failedEntryCount))
            .setter(setter(Builder::failedEntryCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedEntryCount").build()).build();

    private static final SdkField<List<PutTargetsResultEntry>> FAILED_ENTRIES_FIELD = SdkField
            .<List<PutTargetsResultEntry>> builder(MarshallingType.LIST)
            .memberName("FailedEntries")
            .getter(getter(PutTargetsResponse::failedEntries))
            .setter(setter(Builder::failedEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PutTargetsResultEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(PutTargetsResultEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_ENTRY_COUNT_FIELD,
            FAILED_ENTRIES_FIELD));

    private final Integer failedEntryCount;

    private final List<PutTargetsResultEntry> failedEntries;

    private PutTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.failedEntryCount = builder.failedEntryCount;
        this.failedEntries = builder.failedEntries;
    }

    /**
     * <p>
     * The number of failed entries.
     * </p>
     * 
     * @return The number of failed entries.
     */
    public Integer failedEntryCount() {
        return failedEntryCount;
    }

    /**
     * Returns true if the FailedEntries property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFailedEntries() {
        return failedEntries != null && !(failedEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The failed target entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailedEntries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The failed target entries.
     */
    public List<PutTargetsResultEntry> failedEntries() {
        return failedEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(failedEntryCount());
        hashCode = 31 * hashCode + Objects.hashCode(failedEntries());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTargetsResponse)) {
            return false;
        }
        PutTargetsResponse other = (PutTargetsResponse) obj;
        return Objects.equals(failedEntryCount(), other.failedEntryCount())
                && Objects.equals(failedEntries(), other.failedEntries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutTargetsResponse").add("FailedEntryCount", failedEntryCount())
                .add("FailedEntries", failedEntries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedEntryCount":
            return Optional.ofNullable(clazz.cast(failedEntryCount()));
        case "FailedEntries":
            return Optional.ofNullable(clazz.cast(failedEntries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutTargetsResponse, T> g) {
        return obj -> g.apply((PutTargetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutTargetsResponse> {
        /**
         * <p>
         * The number of failed entries.
         * </p>
         * 
         * @param failedEntryCount
         *        The number of failed entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedEntryCount(Integer failedEntryCount);

        /**
         * <p>
         * The failed target entries.
         * </p>
         * 
         * @param failedEntries
         *        The failed target entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedEntries(Collection<PutTargetsResultEntry> failedEntries);

        /**
         * <p>
         * The failed target entries.
         * </p>
         * 
         * @param failedEntries
         *        The failed target entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedEntries(PutTargetsResultEntry... failedEntries);

        /**
         * <p>
         * The failed target entries.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PutTargetsResultEntry>.Builder} avoiding
         * the need to create one manually via {@link List<PutTargetsResultEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PutTargetsResultEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #failedEntries(List<PutTargetsResultEntry>)}.
         * 
         * @param failedEntries
         *        a consumer that will call methods on {@link List<PutTargetsResultEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedEntries(List<PutTargetsResultEntry>)
         */
        Builder failedEntries(Consumer<PutTargetsResultEntry.Builder>... failedEntries);
    }

    static final class BuilderImpl extends EventBridgeResponse.BuilderImpl implements Builder {
        private Integer failedEntryCount;

        private List<PutTargetsResultEntry> failedEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutTargetsResponse model) {
            super(model);
            failedEntryCount(model.failedEntryCount);
            failedEntries(model.failedEntries);
        }

        public final Integer getFailedEntryCount() {
            return failedEntryCount;
        }

        @Override
        public final Builder failedEntryCount(Integer failedEntryCount) {
            this.failedEntryCount = failedEntryCount;
            return this;
        }

        public final void setFailedEntryCount(Integer failedEntryCount) {
            this.failedEntryCount = failedEntryCount;
        }

        public final Collection<PutTargetsResultEntry.Builder> getFailedEntries() {
            return failedEntries != null ? failedEntries.stream().map(PutTargetsResultEntry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedEntries(Collection<PutTargetsResultEntry> failedEntries) {
            this.failedEntries = PutTargetsResultEntryListCopier.copy(failedEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEntries(PutTargetsResultEntry... failedEntries) {
            failedEntries(Arrays.asList(failedEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEntries(Consumer<PutTargetsResultEntry.Builder>... failedEntries) {
            failedEntries(Stream.of(failedEntries).map(c -> PutTargetsResultEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFailedEntries(Collection<PutTargetsResultEntry.BuilderImpl> failedEntries) {
            this.failedEntries = PutTargetsResultEntryListCopier.copyFromBuilder(failedEntries);
        }

        @Override
        public PutTargetsResponse build() {
            return new PutTargetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
