/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This parameter contains the criteria (either InstanceIds or a tag) used to specify which EC2 instances are to be sent
 * the command.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RunCommandParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<RunCommandParameters.Builder, RunCommandParameters> {
    private static final SdkField<List<RunCommandTarget>> RUN_COMMAND_TARGETS_FIELD = SdkField
            .<List<RunCommandTarget>> builder(MarshallingType.LIST)
            .memberName("RunCommandTargets")
            .getter(getter(RunCommandParameters::runCommandTargets))
            .setter(setter(Builder::runCommandTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunCommandTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RunCommandTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(RunCommandTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_COMMAND_TARGETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<RunCommandTarget> runCommandTargets;

    private RunCommandParameters(BuilderImpl builder) {
        this.runCommandTargets = builder.runCommandTargets;
    }

    /**
     * Returns true if the RunCommandTargets property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRunCommandTargets() {
        return runCommandTargets != null && !(runCommandTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Currently, we support including only one RunCommandTarget block, which specifies either an array of InstanceIds
     * or a tag.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRunCommandTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Currently, we support including only one RunCommandTarget block, which specifies either an array of
     *         InstanceIds or a tag.
     */
    public List<RunCommandTarget> runCommandTargets() {
        return runCommandTargets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(runCommandTargets());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunCommandParameters)) {
            return false;
        }
        RunCommandParameters other = (RunCommandParameters) obj;
        return Objects.equals(runCommandTargets(), other.runCommandTargets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RunCommandParameters").add("RunCommandTargets", runCommandTargets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RunCommandTargets":
            return Optional.ofNullable(clazz.cast(runCommandTargets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RunCommandParameters, T> g) {
        return obj -> g.apply((RunCommandParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RunCommandParameters> {
        /**
         * <p>
         * Currently, we support including only one RunCommandTarget block, which specifies either an array of
         * InstanceIds or a tag.
         * </p>
         * 
         * @param runCommandTargets
         *        Currently, we support including only one RunCommandTarget block, which specifies either an array of
         *        InstanceIds or a tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runCommandTargets(Collection<RunCommandTarget> runCommandTargets);

        /**
         * <p>
         * Currently, we support including only one RunCommandTarget block, which specifies either an array of
         * InstanceIds or a tag.
         * </p>
         * 
         * @param runCommandTargets
         *        Currently, we support including only one RunCommandTarget block, which specifies either an array of
         *        InstanceIds or a tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runCommandTargets(RunCommandTarget... runCommandTargets);

        /**
         * <p>
         * Currently, we support including only one RunCommandTarget block, which specifies either an array of
         * InstanceIds or a tag.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RunCommandTarget>.Builder} avoiding the
         * need to create one manually via {@link List<RunCommandTarget>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RunCommandTarget>.Builder#build()} is called immediately and
         * its result is passed to {@link #runCommandTargets(List<RunCommandTarget>)}.
         * 
         * @param runCommandTargets
         *        a consumer that will call methods on {@link List<RunCommandTarget>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runCommandTargets(List<RunCommandTarget>)
         */
        Builder runCommandTargets(Consumer<RunCommandTarget.Builder>... runCommandTargets);
    }

    static final class BuilderImpl implements Builder {
        private List<RunCommandTarget> runCommandTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RunCommandParameters model) {
            runCommandTargets(model.runCommandTargets);
        }

        public final Collection<RunCommandTarget.Builder> getRunCommandTargets() {
            return runCommandTargets != null ? runCommandTargets.stream().map(RunCommandTarget::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder runCommandTargets(Collection<RunCommandTarget> runCommandTargets) {
            this.runCommandTargets = RunCommandTargetsCopier.copy(runCommandTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runCommandTargets(RunCommandTarget... runCommandTargets) {
            runCommandTargets(Arrays.asList(runCommandTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runCommandTargets(Consumer<RunCommandTarget.Builder>... runCommandTargets) {
            runCommandTargets(Stream.of(runCommandTargets).map(c -> RunCommandTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRunCommandTargets(Collection<RunCommandTarget.BuilderImpl> runCommandTargets) {
            this.runCommandTargets = RunCommandTargetsCopier.copyFromBuilder(runCommandTargets);
        }

        @Override
        public RunCommandParameters build() {
            return new RunCommandParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
