/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutPartnerEventsResponse extends EventBridgeResponse implements
        ToCopyableBuilder<PutPartnerEventsResponse.Builder, PutPartnerEventsResponse> {
    private static final SdkField<Integer> FAILED_ENTRY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FailedEntryCount").getter(getter(PutPartnerEventsResponse::failedEntryCount))
            .setter(setter(Builder::failedEntryCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedEntryCount").build()).build();

    private static final SdkField<List<PutPartnerEventsResultEntry>> ENTRIES_FIELD = SdkField
            .<List<PutPartnerEventsResultEntry>> builder(MarshallingType.LIST)
            .memberName("Entries")
            .getter(getter(PutPartnerEventsResponse::entries))
            .setter(setter(Builder::entries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PutPartnerEventsResultEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(PutPartnerEventsResultEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_ENTRY_COUNT_FIELD,
            ENTRIES_FIELD));

    private final Integer failedEntryCount;

    private final List<PutPartnerEventsResultEntry> entries;

    private PutPartnerEventsResponse(BuilderImpl builder) {
        super(builder);
        this.failedEntryCount = builder.failedEntryCount;
        this.entries = builder.entries;
    }

    /**
     * <p>
     * The number of events from this operation that could not be written to the partner event bus.
     * </p>
     * 
     * @return The number of events from this operation that could not be written to the partner event bus.
     */
    public Integer failedEntryCount() {
        return failedEntryCount;
    }

    /**
     * Returns true if the Entries property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEntries() {
        return entries != null && !(entries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of events from this operation that were successfully written to the partner event bus.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of events from this operation that were successfully written to the partner event bus.
     */
    public List<PutPartnerEventsResultEntry> entries() {
        return entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(failedEntryCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntries() ? entries() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPartnerEventsResponse)) {
            return false;
        }
        PutPartnerEventsResponse other = (PutPartnerEventsResponse) obj;
        return Objects.equals(failedEntryCount(), other.failedEntryCount()) && hasEntries() == other.hasEntries()
                && Objects.equals(entries(), other.entries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutPartnerEventsResponse").add("FailedEntryCount", failedEntryCount())
                .add("Entries", hasEntries() ? entries() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedEntryCount":
            return Optional.ofNullable(clazz.cast(failedEntryCount()));
        case "Entries":
            return Optional.ofNullable(clazz.cast(entries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutPartnerEventsResponse, T> g) {
        return obj -> g.apply((PutPartnerEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutPartnerEventsResponse> {
        /**
         * <p>
         * The number of events from this operation that could not be written to the partner event bus.
         * </p>
         * 
         * @param failedEntryCount
         *        The number of events from this operation that could not be written to the partner event bus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedEntryCount(Integer failedEntryCount);

        /**
         * <p>
         * The list of events from this operation that were successfully written to the partner event bus.
         * </p>
         * 
         * @param entries
         *        The list of events from this operation that were successfully written to the partner event bus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<PutPartnerEventsResultEntry> entries);

        /**
         * <p>
         * The list of events from this operation that were successfully written to the partner event bus.
         * </p>
         * 
         * @param entries
         *        The list of events from this operation that were successfully written to the partner event bus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(PutPartnerEventsResultEntry... entries);

        /**
         * <p>
         * The list of events from this operation that were successfully written to the partner event bus.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PutPartnerEventsResultEntry>.Builder}
         * avoiding the need to create one manually via {@link List<PutPartnerEventsResultEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PutPartnerEventsResultEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #entries(List<PutPartnerEventsResultEntry>)}.
         * 
         * @param entries
         *        a consumer that will call methods on {@link List<PutPartnerEventsResultEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entries(List<PutPartnerEventsResultEntry>)
         */
        Builder entries(Consumer<PutPartnerEventsResultEntry.Builder>... entries);
    }

    static final class BuilderImpl extends EventBridgeResponse.BuilderImpl implements Builder {
        private Integer failedEntryCount;

        private List<PutPartnerEventsResultEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutPartnerEventsResponse model) {
            super(model);
            failedEntryCount(model.failedEntryCount);
            entries(model.entries);
        }

        public final Integer getFailedEntryCount() {
            return failedEntryCount;
        }

        @Override
        public final Builder failedEntryCount(Integer failedEntryCount) {
            this.failedEntryCount = failedEntryCount;
            return this;
        }

        public final void setFailedEntryCount(Integer failedEntryCount) {
            this.failedEntryCount = failedEntryCount;
        }

        public final Collection<PutPartnerEventsResultEntry.Builder> getEntries() {
            if (entries instanceof SdkAutoConstructList) {
                return null;
            }
            return entries != null ? entries.stream().map(PutPartnerEventsResultEntry::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder entries(Collection<PutPartnerEventsResultEntry> entries) {
            this.entries = PutPartnerEventsResultEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(PutPartnerEventsResultEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<PutPartnerEventsResultEntry.Builder>... entries) {
            entries(Stream.of(entries).map(c -> PutPartnerEventsResultEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntries(Collection<PutPartnerEventsResultEntry.BuilderImpl> entries) {
            this.entries = PutPartnerEventsResultEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        public PutPartnerEventsResponse build() {
            return new PutPartnerEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
