/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListArchivesResponse extends EventBridgeResponse implements
        ToCopyableBuilder<ListArchivesResponse.Builder, ListArchivesResponse> {
    private static final SdkField<List<Archive>> ARCHIVES_FIELD = SdkField
            .<List<Archive>> builder(MarshallingType.LIST)
            .memberName("Archives")
            .getter(getter(ListArchivesResponse::archives))
            .setter(setter(Builder::archives))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Archives").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Archive> builder(MarshallingType.SDK_POJO)
                                            .constructor(Archive::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListArchivesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Archive> archives;

    private final String nextToken;

    private ListArchivesResponse(BuilderImpl builder) {
        super(builder);
        this.archives = builder.archives;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Archives property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasArchives() {
        return archives != null && !(archives instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Archive</code> objects that include details about an archive.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasArchives()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>Archive</code> objects that include details about an archive.
     */
    public List<Archive> archives() {
        return archives;
    }

    /**
     * <p>
     * The token returned by a previous call to retrieve the next set of results.
     * </p>
     * 
     * @return The token returned by a previous call to retrieve the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasArchives() ? archives() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListArchivesResponse)) {
            return false;
        }
        ListArchivesResponse other = (ListArchivesResponse) obj;
        return hasArchives() == other.hasArchives() && Objects.equals(archives(), other.archives())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListArchivesResponse").add("Archives", hasArchives() ? archives() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Archives":
            return Optional.ofNullable(clazz.cast(archives()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListArchivesResponse, T> g) {
        return obj -> g.apply((ListArchivesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListArchivesResponse> {
        /**
         * <p>
         * An array of <code>Archive</code> objects that include details about an archive.
         * </p>
         * 
         * @param archives
         *        An array of <code>Archive</code> objects that include details about an archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archives(Collection<Archive> archives);

        /**
         * <p>
         * An array of <code>Archive</code> objects that include details about an archive.
         * </p>
         * 
         * @param archives
         *        An array of <code>Archive</code> objects that include details about an archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archives(Archive... archives);

        /**
         * <p>
         * An array of <code>Archive</code> objects that include details about an archive.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Archive>.Builder} avoiding the need to
         * create one manually via {@link List<Archive>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Archive>.Builder#build()} is called immediately and its
         * result is passed to {@link #archives(List<Archive>)}.
         * 
         * @param archives
         *        a consumer that will call methods on {@link List<Archive>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #archives(List<Archive>)
         */
        Builder archives(Consumer<Archive.Builder>... archives);

        /**
         * <p>
         * The token returned by a previous call to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token returned by a previous call to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EventBridgeResponse.BuilderImpl implements Builder {
        private List<Archive> archives = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListArchivesResponse model) {
            super(model);
            archives(model.archives);
            nextToken(model.nextToken);
        }

        public final Collection<Archive.Builder> getArchives() {
            if (archives instanceof SdkAutoConstructList) {
                return null;
            }
            return archives != null ? archives.stream().map(Archive::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder archives(Collection<Archive> archives) {
            this.archives = ArchiveResponseListCopier.copy(archives);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder archives(Archive... archives) {
            archives(Arrays.asList(archives));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder archives(Consumer<Archive.Builder>... archives) {
            archives(Stream.of(archives).map(c -> Archive.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setArchives(Collection<Archive.BuilderImpl> archives) {
            this.archives = ArchiveResponseListCopier.copyFromBuilder(archives);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListArchivesResponse build() {
            return new ListArchivesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
