/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRuleResponse extends EventBridgeResponse implements
        ToCopyableBuilder<DescribeRuleResponse.Builder, DescribeRuleResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeRuleResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeRuleResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> EVENT_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventPattern").getter(getter(DescribeRuleResponse::eventPattern)).setter(setter(Builder::eventPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventPattern").build()).build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpression").getter(getter(DescribeRuleResponse::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(DescribeRuleResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeRuleResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeRuleResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> MANAGED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedBy").getter(getter(DescribeRuleResponse::managedBy)).setter(setter(Builder::managedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedBy").build()).build();

    private static final SdkField<String> EVENT_BUS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventBusName").getter(getter(DescribeRuleResponse::eventBusName)).setter(setter(Builder::eventBusName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBusName").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(DescribeRuleResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            EVENT_PATTERN_FIELD, SCHEDULE_EXPRESSION_FIELD, STATE_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD, MANAGED_BY_FIELD,
            EVENT_BUS_NAME_FIELD, CREATED_BY_FIELD));

    private final String name;

    private final String arn;

    private final String eventPattern;

    private final String scheduleExpression;

    private final String state;

    private final String description;

    private final String roleArn;

    private final String managedBy;

    private final String eventBusName;

    private final String createdBy;

    private DescribeRuleResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.arn = builder.arn;
        this.eventPattern = builder.eventPattern;
        this.scheduleExpression = builder.scheduleExpression;
        this.state = builder.state;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.managedBy = builder.managedBy;
        this.eventBusName = builder.eventBusName;
        this.createdBy = builder.createdBy;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the rule.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The event pattern. For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and
     * Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * 
     * @return The event pattern. For more information, see <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html"
     *         >Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.
     */
    public String eventPattern() {
        return eventPattern;
    }

    /**
     * <p>
     * The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)".
     * </p>
     * 
     * @return The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)".
     */
    public String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * Specifies whether the rule is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RuleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Specifies whether the rule is enabled or disabled.
     * @see RuleState
     */
    public RuleState state() {
        return RuleState.fromValue(state);
    }

    /**
     * <p>
     * Specifies whether the rule is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RuleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Specifies whether the rule is enabled or disabled.
     * @see RuleState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The description of the rule.
     * </p>
     * 
     * @return The description of the rule.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role associated with the rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role associated with the rule.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * If this is a managed rule, created by an AWS service on your behalf, this field displays the principal name of
     * the AWS service that created the rule.
     * </p>
     * 
     * @return If this is a managed rule, created by an AWS service on your behalf, this field displays the principal
     *         name of the AWS service that created the rule.
     */
    public String managedBy() {
        return managedBy;
    }

    /**
     * <p>
     * The name of the event bus associated with the rule.
     * </p>
     * 
     * @return The name of the event bus associated with the rule.
     */
    public String eventBusName() {
        return eventBusName;
    }

    /**
     * <p>
     * The account ID of the user that created the rule. If you use <code>PutRule</code> to put a rule on an event bus
     * in another account, the other account is the owner of the rule, and the rule ARN includes the account ID for that
     * account. However, the value for <code>CreatedBy</code> is the account ID as the account that created the rule in
     * the other account.
     * </p>
     * 
     * @return The account ID of the user that created the rule. If you use <code>PutRule</code> to put a rule on an
     *         event bus in another account, the other account is the owner of the rule, and the rule ARN includes the
     *         account ID for that account. However, the value for <code>CreatedBy</code> is the account ID as the
     *         account that created the rule in the other account.
     */
    public String createdBy() {
        return createdBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(eventPattern());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(managedBy());
        hashCode = 31 * hashCode + Objects.hashCode(eventBusName());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRuleResponse)) {
            return false;
        }
        DescribeRuleResponse other = (DescribeRuleResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(eventPattern(), other.eventPattern())
                && Objects.equals(scheduleExpression(), other.scheduleExpression())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(managedBy(), other.managedBy())
                && Objects.equals(eventBusName(), other.eventBusName()) && Objects.equals(createdBy(), other.createdBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeRuleResponse").add("Name", name()).add("Arn", arn()).add("EventPattern", eventPattern())
                .add("ScheduleExpression", scheduleExpression()).add("State", stateAsString()).add("Description", description())
                .add("RoleArn", roleArn()).add("ManagedBy", managedBy()).add("EventBusName", eventBusName())
                .add("CreatedBy", createdBy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "EventPattern":
            return Optional.ofNullable(clazz.cast(eventPattern()));
        case "ScheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ManagedBy":
            return Optional.ofNullable(clazz.cast(managedBy()));
        case "EventBusName":
            return Optional.ofNullable(clazz.cast(eventBusName()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRuleResponse, T> g) {
        return obj -> g.apply((DescribeRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRuleResponse> {
        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param name
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the rule.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The event pattern. For more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events
         * and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * 
         * @param eventPattern
         *        The event pattern. For more information, see <a
         *        href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html"
         *        >Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventPattern(String eventPattern);

        /**
         * <p>
         * The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)".
         * </p>
         * 
         * @param scheduleExpression
         *        The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * Specifies whether the rule is enabled or disabled.
         * </p>
         * 
         * @param state
         *        Specifies whether the rule is enabled or disabled.
         * @see RuleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleState
         */
        Builder state(String state);

        /**
         * <p>
         * Specifies whether the rule is enabled or disabled.
         * </p>
         * 
         * @param state
         *        Specifies whether the rule is enabled or disabled.
         * @see RuleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleState
         */
        Builder state(RuleState state);

        /**
         * <p>
         * The description of the rule.
         * </p>
         * 
         * @param description
         *        The description of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role associated with the rule.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role associated with the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * If this is a managed rule, created by an AWS service on your behalf, this field displays the principal name
         * of the AWS service that created the rule.
         * </p>
         * 
         * @param managedBy
         *        If this is a managed rule, created by an AWS service on your behalf, this field displays the principal
         *        name of the AWS service that created the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedBy(String managedBy);

        /**
         * <p>
         * The name of the event bus associated with the rule.
         * </p>
         * 
         * @param eventBusName
         *        The name of the event bus associated with the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBusName(String eventBusName);

        /**
         * <p>
         * The account ID of the user that created the rule. If you use <code>PutRule</code> to put a rule on an event
         * bus in another account, the other account is the owner of the rule, and the rule ARN includes the account ID
         * for that account. However, the value for <code>CreatedBy</code> is the account ID as the account that created
         * the rule in the other account.
         * </p>
         * 
         * @param createdBy
         *        The account ID of the user that created the rule. If you use <code>PutRule</code> to put a rule on an
         *        event bus in another account, the other account is the owner of the rule, and the rule ARN includes
         *        the account ID for that account. However, the value for <code>CreatedBy</code> is the account ID as
         *        the account that created the rule in the other account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);
    }

    static final class BuilderImpl extends EventBridgeResponse.BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String eventPattern;

        private String scheduleExpression;

        private String state;

        private String description;

        private String roleArn;

        private String managedBy;

        private String eventBusName;

        private String createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRuleResponse model) {
            super(model);
            name(model.name);
            arn(model.arn);
            eventPattern(model.eventPattern);
            scheduleExpression(model.scheduleExpression);
            state(model.state);
            description(model.description);
            roleArn(model.roleArn);
            managedBy(model.managedBy);
            eventBusName(model.eventBusName);
            createdBy(model.createdBy);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getEventPattern() {
            return eventPattern;
        }

        @Override
        public final Builder eventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        public final void setEventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RuleState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getManagedBy() {
            return managedBy;
        }

        @Override
        public final Builder managedBy(String managedBy) {
            this.managedBy = managedBy;
            return this;
        }

        public final void setManagedBy(String managedBy) {
            this.managedBy = managedBy;
        }

        public final String getEventBusName() {
            return eventBusName;
        }

        @Override
        public final Builder eventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
            return this;
        }

        public final void setEventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public DescribeRuleResponse build() {
            return new DescribeRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
