/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details about an event generated by an SaaS partner.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutPartnerEventsRequestEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<PutPartnerEventsRequestEntry.Builder, PutPartnerEventsRequestEntry> {
    private static final SdkField<Instant> TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("Time")
            .getter(getter(PutPartnerEventsRequestEntry::time)).setter(setter(Builder::time))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(PutPartnerEventsRequestEntry::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<List<String>> RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Resources")
            .getter(getter(PutPartnerEventsRequestEntry::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DETAIL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetailType").getter(getter(PutPartnerEventsRequestEntry::detailType))
            .setter(setter(Builder::detailType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailType").build()).build();

    private static final SdkField<String> DETAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Detail")
            .getter(getter(PutPartnerEventsRequestEntry::detail)).setter(setter(Builder::detail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Detail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_FIELD, SOURCE_FIELD,
            RESOURCES_FIELD, DETAIL_TYPE_FIELD, DETAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant time;

    private final String source;

    private final List<String> resources;

    private final String detailType;

    private final String detail;

    private PutPartnerEventsRequestEntry(BuilderImpl builder) {
        this.time = builder.time;
        this.source = builder.source;
        this.resources = builder.resources;
        this.detailType = builder.detailType;
        this.detail = builder.detail;
    }

    /**
     * <p>
     * The date and time of the event.
     * </p>
     * 
     * @return The date and time of the event.
     */
    public Instant time() {
        return time;
    }

    /**
     * <p>
     * The event source that is generating the evntry.
     * </p>
     * 
     * @return The event source that is generating the evntry.
     */
    public String source() {
        return source;
    }

    /**
     * Returns true if the Resources property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * AWS resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any number,
     * including zero, may be present.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return AWS resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any number,
     *         including zero, may be present.
     */
    public List<String> resources() {
        return resources;
    }

    /**
     * <p>
     * A free-form string used to decide what fields to expect in the event detail.
     * </p>
     * 
     * @return A free-form string used to decide what fields to expect in the event detail.
     */
    public String detailType() {
        return detailType;
    }

    /**
     * <p>
     * A valid JSON string. There is no other schema imposed. The JSON string may contain fields and nested subobjects.
     * </p>
     * 
     * @return A valid JSON string. There is no other schema imposed. The JSON string may contain fields and nested
     *         subobjects.
     */
    public String detail() {
        return detail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(time());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(detailType());
        hashCode = 31 * hashCode + Objects.hashCode(detail());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPartnerEventsRequestEntry)) {
            return false;
        }
        PutPartnerEventsRequestEntry other = (PutPartnerEventsRequestEntry) obj;
        return Objects.equals(time(), other.time()) && Objects.equals(source(), other.source())
                && hasResources() == other.hasResources() && Objects.equals(resources(), other.resources())
                && Objects.equals(detailType(), other.detailType()) && Objects.equals(detail(), other.detail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutPartnerEventsRequestEntry").add("Time", time()).add("Source", source())
                .add("Resources", hasResources() ? resources() : null).add("DetailType", detailType()).add("Detail", detail())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Time":
            return Optional.ofNullable(clazz.cast(time()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "DetailType":
            return Optional.ofNullable(clazz.cast(detailType()));
        case "Detail":
            return Optional.ofNullable(clazz.cast(detail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutPartnerEventsRequestEntry, T> g) {
        return obj -> g.apply((PutPartnerEventsRequestEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PutPartnerEventsRequestEntry> {
        /**
         * <p>
         * The date and time of the event.
         * </p>
         * 
         * @param time
         *        The date and time of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder time(Instant time);

        /**
         * <p>
         * The event source that is generating the evntry.
         * </p>
         * 
         * @param source
         *        The event source that is generating the evntry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * AWS resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any number,
         * including zero, may be present.
         * </p>
         * 
         * @param resources
         *        AWS resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any
         *        number, including zero, may be present.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<String> resources);

        /**
         * <p>
         * AWS resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any number,
         * including zero, may be present.
         * </p>
         * 
         * @param resources
         *        AWS resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any
         *        number, including zero, may be present.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(String... resources);

        /**
         * <p>
         * A free-form string used to decide what fields to expect in the event detail.
         * </p>
         * 
         * @param detailType
         *        A free-form string used to decide what fields to expect in the event detail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailType(String detailType);

        /**
         * <p>
         * A valid JSON string. There is no other schema imposed. The JSON string may contain fields and nested
         * subobjects.
         * </p>
         * 
         * @param detail
         *        A valid JSON string. There is no other schema imposed. The JSON string may contain fields and nested
         *        subobjects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detail(String detail);
    }

    static final class BuilderImpl implements Builder {
        private Instant time;

        private String source;

        private List<String> resources = DefaultSdkAutoConstructList.getInstance();

        private String detailType;

        private String detail;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPartnerEventsRequestEntry model) {
            time(model.time);
            source(model.source);
            resources(model.resources);
            detailType(model.detailType);
            detail(model.detail);
        }

        public final Instant getTime() {
            return time;
        }

        @Override
        public final Builder time(Instant time) {
            this.time = time;
            return this;
        }

        public final void setTime(Instant time) {
            this.time = time;
        }

        public final String getSource() {
            return source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final Collection<String> getResources() {
            if (resources instanceof SdkAutoConstructList) {
                return null;
            }
            return resources;
        }

        @Override
        public final Builder resources(Collection<String> resources) {
            this.resources = EventResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(String... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = EventResourceListCopier.copy(resources);
        }

        public final String getDetailType() {
            return detailType;
        }

        @Override
        public final Builder detailType(String detailType) {
            this.detailType = detailType;
            return this;
        }

        public final void setDetailType(String detailType) {
            this.detailType = detailType;
        }

        public final String getDetail() {
            return detail;
        }

        @Override
        public final Builder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public final void setDetail(String detail) {
            this.detail = detail;
        }

        @Override
        public PutPartnerEventsRequestEntry build() {
            return new PutPartnerEventsRequestEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
