/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestEventPatternResponse extends EventBridgeResponse implements
        ToCopyableBuilder<TestEventPatternResponse.Builder, TestEventPatternResponse> {
    private static final SdkField<Boolean> RESULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Result").getter(getter(TestEventPatternResponse::result)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_FIELD));

    private final Boolean result;

    private TestEventPatternResponse(BuilderImpl builder) {
        super(builder);
        this.result = builder.result;
    }

    /**
     * <p>
     * Indicates whether the event matches the event pattern.
     * </p>
     * 
     * @return Indicates whether the event matches the event pattern.
     */
    public final Boolean result() {
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(result());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestEventPatternResponse)) {
            return false;
        }
        TestEventPatternResponse other = (TestEventPatternResponse) obj;
        return Objects.equals(result(), other.result());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestEventPatternResponse").add("Result", result()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Result":
            return Optional.ofNullable(clazz.cast(result()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestEventPatternResponse, T> g) {
        return obj -> g.apply((TestEventPatternResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeResponse.Builder, SdkPojo, CopyableBuilder<Builder, TestEventPatternResponse> {
        /**
         * <p>
         * Indicates whether the event matches the event pattern.
         * </p>
         * 
         * @param result
         *        Indicates whether the event matches the event pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(Boolean result);
    }

    static final class BuilderImpl extends EventBridgeResponse.BuilderImpl implements Builder {
        private Boolean result;

        private BuilderImpl() {
        }

        private BuilderImpl(TestEventPatternResponse model) {
            super(model);
            result(model.result);
        }

        public final Boolean getResult() {
            return result;
        }

        @Override
        public final Builder result(Boolean result) {
            this.result = result;
            return this;
        }

        public final void setResult(Boolean result) {
            this.result = result;
        }

        @Override
        public TestEventPatternResponse build() {
            return new TestEventPatternResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
