/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>ReplayDestination</code> object that contains details about a replay.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplayDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplayDestination.Builder, ReplayDestination> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ReplayDestination::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<List<String>> FILTER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FilterArns")
            .getter(getter(ReplayDestination::filterArns))
            .setter(setter(Builder::filterArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, FILTER_ARNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final List<String> filterArns;

    private ReplayDestination(BuilderImpl builder) {
        this.arn = builder.arn;
        this.filterArns = builder.filterArns;
    }

    /**
     * <p>
     * The ARN of the event bus to replay event to. You can replay events only to the event bus specified to create the
     * archive.
     * </p>
     * 
     * @return The ARN of the event bus to replay event to. You can replay events only to the event bus specified to
     *         create the archive.
     */
    public final String arn() {
        return arn;
    }

    /**
     * Returns true if the FilterArns property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilterArns() {
        return filterArns != null && !(filterArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ARNs for rules to replay events to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilterArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of ARNs for rules to replay events to.
     */
    public final List<String> filterArns() {
        return filterArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterArns() ? filterArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplayDestination)) {
            return false;
        }
        ReplayDestination other = (ReplayDestination) obj;
        return Objects.equals(arn(), other.arn()) && hasFilterArns() == other.hasFilterArns()
                && Objects.equals(filterArns(), other.filterArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplayDestination").add("Arn", arn()).add("FilterArns", hasFilterArns() ? filterArns() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "FilterArns":
            return Optional.ofNullable(clazz.cast(filterArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplayDestination, T> g) {
        return obj -> g.apply((ReplayDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplayDestination> {
        /**
         * <p>
         * The ARN of the event bus to replay event to. You can replay events only to the event bus specified to create
         * the archive.
         * </p>
         * 
         * @param arn
         *        The ARN of the event bus to replay event to. You can replay events only to the event bus specified to
         *        create the archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A list of ARNs for rules to replay events to.
         * </p>
         * 
         * @param filterArns
         *        A list of ARNs for rules to replay events to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterArns(Collection<String> filterArns);

        /**
         * <p>
         * A list of ARNs for rules to replay events to.
         * </p>
         * 
         * @param filterArns
         *        A list of ARNs for rules to replay events to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterArns(String... filterArns);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private List<String> filterArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplayDestination model) {
            arn(model.arn);
            filterArns(model.filterArns);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<String> getFilterArns() {
            if (filterArns instanceof SdkAutoConstructList) {
                return null;
            }
            return filterArns;
        }

        @Override
        public final Builder filterArns(Collection<String> filterArns) {
            this.filterArns = ReplayDestinationFiltersCopier.copy(filterArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterArns(String... filterArns) {
            filterArns(Arrays.asList(filterArns));
            return this;
        }

        public final void setFilterArns(Collection<String> filterArns) {
            this.filterArns = ReplayDestinationFiltersCopier.copy(filterArns);
        }

        @Override
        public ReplayDestination build() {
            return new ReplayDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
