/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eventbridge.model.Condition;
import software.amazon.awssdk.services.eventbridge.model.EventBridgeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutPermissionRequest
extends EventBridgeRequest
implements ToCopyableBuilder<Builder, PutPermissionRequest> {
    private static final SdkField<String> EVENT_BUS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventBusName").getter(PutPermissionRequest.getter(PutPermissionRequest::eventBusName)).setter(PutPermissionRequest.setter(Builder::eventBusName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBusName").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(PutPermissionRequest.getter(PutPermissionRequest::action)).setter(PutPermissionRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Principal").getter(PutPermissionRequest.getter(PutPermissionRequest::principal)).setter(PutPermissionRequest.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()}).build();
    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatementId").getter(PutPermissionRequest.getter(PutPermissionRequest::statementId)).setter(PutPermissionRequest.setter(Builder::statementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementId").build()}).build();
    private static final SdkField<Condition> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Condition").getter(PutPermissionRequest.getter(PutPermissionRequest::condition)).setter(PutPermissionRequest.setter(Builder::condition)).constructor(Condition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()}).build();
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Policy").getter(PutPermissionRequest.getter(PutPermissionRequest::policy)).setter(PutPermissionRequest.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_BUS_NAME_FIELD, ACTION_FIELD, PRINCIPAL_FIELD, STATEMENT_ID_FIELD, CONDITION_FIELD, POLICY_FIELD));
    private final String eventBusName;
    private final String action;
    private final String principal;
    private final String statementId;
    private final Condition condition;
    private final String policy;

    private PutPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.eventBusName = builder.eventBusName;
        this.action = builder.action;
        this.principal = builder.principal;
        this.statementId = builder.statementId;
        this.condition = builder.condition;
        this.policy = builder.policy;
    }

    public final String eventBusName() {
        return this.eventBusName;
    }

    public final String action() {
        return this.action;
    }

    public final String principal() {
        return this.principal;
    }

    public final String statementId() {
        return this.statementId;
    }

    public final Condition condition() {
        return this.condition;
    }

    public final String policy() {
        return this.policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBusName());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.statementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.condition());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPermissionRequest)) {
            return false;
        }
        PutPermissionRequest other = (PutPermissionRequest)((Object)obj);
        return Objects.equals(this.eventBusName(), other.eventBusName()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.principal(), other.principal()) && Objects.equals(this.statementId(), other.statementId()) && Objects.equals(this.condition(), other.condition()) && Objects.equals(this.policy(), other.policy());
    }

    public final String toString() {
        return ToString.builder((String)"PutPermissionRequest").add("EventBusName", (Object)this.eventBusName()).add("Action", (Object)this.action()).add("Principal", (Object)this.principal()).add("StatementId", (Object)this.statementId()).add("Condition", (Object)this.condition()).add("Policy", (Object)this.policy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventBusName": {
                return Optional.ofNullable(clazz.cast(this.eventBusName()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "Principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "StatementId": {
                return Optional.ofNullable(clazz.cast(this.statementId()));
            }
            case "Condition": {
                return Optional.ofNullable(clazz.cast(this.condition()));
            }
            case "Policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutPermissionRequest, T> g) {
        return obj -> g.apply((PutPermissionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EventBridgeRequest.BuilderImpl
    implements Builder {
        private String eventBusName;
        private String action;
        private String principal;
        private String statementId;
        private Condition condition;
        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPermissionRequest model) {
            super(model);
            this.eventBusName(model.eventBusName);
            this.action(model.action);
            this.principal(model.principal);
            this.statementId(model.statementId);
            this.condition(model.condition);
            this.policy(model.policy);
        }

        public final String getEventBusName() {
            return this.eventBusName;
        }

        public final void setEventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
        }

        @Override
        @Transient
        public final Builder eventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        @Transient
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getPrincipal() {
            return this.principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        @Transient
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final String getStatementId() {
            return this.statementId;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        @Transient
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final Condition.Builder getCondition() {
            return this.condition != null ? this.condition.toBuilder() : null;
        }

        public final void setCondition(Condition.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        @Override
        @Transient
        public final Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public final String getPolicy() {
            return this.policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        @Transient
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutPermissionRequest build() {
            return new PutPermissionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EventBridgeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutPermissionRequest> {
        public Builder eventBusName(String var1);

        public Builder action(String var1);

        public Builder principal(String var1);

        public Builder statementId(String var1);

        public Builder condition(Condition var1);

        default public Builder condition(Consumer<Condition.Builder> condition) {
            return this.condition((Condition)((Condition.Builder)Condition.builder().applyMutation(condition)).build());
        }

        public Builder policy(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

