/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a capacity provider strategy. To learn more, see <a
 * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CapacityProviderStrategyItem.html"
 * >CapacityProviderStrategyItem</a> in the Amazon ECS API Reference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityProviderStrategyItem implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityProviderStrategyItem.Builder, CapacityProviderStrategyItem> {
    private static final SdkField<String> CAPACITY_PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("capacityProvider").getter(getter(CapacityProviderStrategyItem::capacityProvider))
            .setter(setter(Builder::capacityProvider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProvider").build()).build();

    private static final SdkField<Integer> WEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("weight").getter(getter(CapacityProviderStrategyItem::weight)).setter(setter(Builder::weight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weight").build()).build();

    private static final SdkField<Integer> BASE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("base")
            .getter(getter(CapacityProviderStrategyItem::base)).setter(setter(Builder::base))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("base").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDER_FIELD,
            WEIGHT_FIELD, BASE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String capacityProvider;

    private final Integer weight;

    private final Integer base;

    private CapacityProviderStrategyItem(BuilderImpl builder) {
        this.capacityProvider = builder.capacityProvider;
        this.weight = builder.weight;
        this.base = builder.base;
    }

    /**
     * <p>
     * The short name of the capacity provider.
     * </p>
     * 
     * @return The short name of the capacity provider.
     */
    public final String capacityProvider() {
        return capacityProvider;
    }

    /**
     * <p>
     * The weight value designates the relative percentage of the total number of tasks launched that should use the
     * specified capacity provider. The weight value is taken into consideration after the base value, if defined, is
     * satisfied.
     * </p>
     * 
     * @return The weight value designates the relative percentage of the total number of tasks launched that should use
     *         the specified capacity provider. The weight value is taken into consideration after the base value, if
     *         defined, is satisfied.
     */
    public final Integer weight() {
        return weight;
    }

    /**
     * <p>
     * The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one
     * capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default
     * value of 0 is used.
     * </p>
     * 
     * @return The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only
     *         one capacity provider in a capacity provider strategy can have a base defined. If no value is specified,
     *         the default value of 0 is used.
     */
    public final Integer base() {
        return base;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityProvider());
        hashCode = 31 * hashCode + Objects.hashCode(weight());
        hashCode = 31 * hashCode + Objects.hashCode(base());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityProviderStrategyItem)) {
            return false;
        }
        CapacityProviderStrategyItem other = (CapacityProviderStrategyItem) obj;
        return Objects.equals(capacityProvider(), other.capacityProvider()) && Objects.equals(weight(), other.weight())
                && Objects.equals(base(), other.base());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityProviderStrategyItem").add("CapacityProvider", capacityProvider())
                .add("Weight", weight()).add("Base", base()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capacityProvider":
            return Optional.ofNullable(clazz.cast(capacityProvider()));
        case "weight":
            return Optional.ofNullable(clazz.cast(weight()));
        case "base":
            return Optional.ofNullable(clazz.cast(base()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityProviderStrategyItem, T> g) {
        return obj -> g.apply((CapacityProviderStrategyItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityProviderStrategyItem> {
        /**
         * <p>
         * The short name of the capacity provider.
         * </p>
         * 
         * @param capacityProvider
         *        The short name of the capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProvider(String capacityProvider);

        /**
         * <p>
         * The weight value designates the relative percentage of the total number of tasks launched that should use the
         * specified capacity provider. The weight value is taken into consideration after the base value, if defined,
         * is satisfied.
         * </p>
         * 
         * @param weight
         *        The weight value designates the relative percentage of the total number of tasks launched that should
         *        use the specified capacity provider. The weight value is taken into consideration after the base
         *        value, if defined, is satisfied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(Integer weight);

        /**
         * <p>
         * The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one
         * capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the
         * default value of 0 is used.
         * </p>
         * 
         * @param base
         *        The base value designates how many tasks, at a minimum, to run on the specified capacity provider.
         *        Only one capacity provider in a capacity provider strategy can have a base defined. If no value is
         *        specified, the default value of 0 is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder base(Integer base);
    }

    static final class BuilderImpl implements Builder {
        private String capacityProvider;

        private Integer weight;

        private Integer base;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityProviderStrategyItem model) {
            capacityProvider(model.capacityProvider);
            weight(model.weight);
            base(model.base);
        }

        public final String getCapacityProvider() {
            return capacityProvider;
        }

        public final void setCapacityProvider(String capacityProvider) {
            this.capacityProvider = capacityProvider;
        }

        @Override
        @Transient
        public final Builder capacityProvider(String capacityProvider) {
            this.capacityProvider = capacityProvider;
            return this;
        }

        public final Integer getWeight() {
            return weight;
        }

        public final void setWeight(Integer weight) {
            this.weight = weight;
        }

        @Override
        @Transient
        public final Builder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public final Integer getBase() {
            return base;
        }

        public final void setBase(Integer base) {
            this.base = base;
        }

        @Override
        @Transient
        public final Builder base(Integer base) {
            this.base = base;
            return this;
        }

        @Override
        public CapacityProviderStrategyItem build() {
            return new CapacityProviderStrategyItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
