/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApiDestinationRequest extends EventBridgeRequest implements
        ToCopyableBuilder<UpdateApiDestinationRequest.Builder, UpdateApiDestinationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateApiDestinationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateApiDestinationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionArn").getter(getter(UpdateApiDestinationRequest::connectionArn))
            .setter(setter(Builder::connectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()).build();

    private static final SdkField<String> INVOCATION_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvocationEndpoint").getter(getter(UpdateApiDestinationRequest::invocationEndpoint))
            .setter(setter(Builder::invocationEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationEndpoint").build())
            .build();

    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HttpMethod").getter(getter(UpdateApiDestinationRequest::httpMethodAsString))
            .setter(setter(Builder::httpMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpMethod").build()).build();

    private static final SdkField<Integer> INVOCATION_RATE_LIMIT_PER_SECOND_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InvocationRateLimitPerSecond")
            .getter(getter(UpdateApiDestinationRequest::invocationRateLimitPerSecond))
            .setter(setter(Builder::invocationRateLimitPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationRateLimitPerSecond")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            CONNECTION_ARN_FIELD, INVOCATION_ENDPOINT_FIELD, HTTP_METHOD_FIELD, INVOCATION_RATE_LIMIT_PER_SECOND_FIELD));

    private final String name;

    private final String description;

    private final String connectionArn;

    private final String invocationEndpoint;

    private final String httpMethod;

    private final Integer invocationRateLimitPerSecond;

    private UpdateApiDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.connectionArn = builder.connectionArn;
        this.invocationEndpoint = builder.invocationEndpoint;
        this.httpMethod = builder.httpMethod;
        this.invocationRateLimitPerSecond = builder.invocationRateLimitPerSecond;
    }

    /**
     * <p>
     * The name of the API destination to update.
     * </p>
     * 
     * @return The name of the API destination to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the API destination to update.
     * </p>
     * 
     * @return The name of the API destination to update.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ARN of the connection to use for the API destination.
     * </p>
     * 
     * @return The ARN of the connection to use for the API destination.
     */
    public final String connectionArn() {
        return connectionArn;
    }

    /**
     * <p>
     * The URL to the endpoint to use for the API destination.
     * </p>
     * 
     * @return The URL to the endpoint to use for the API destination.
     */
    public final String invocationEndpoint() {
        return invocationEndpoint;
    }

    /**
     * <p>
     * The method to use for the API destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpMethod} will
     * return {@link ApiDestinationHttpMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #httpMethodAsString}.
     * </p>
     * 
     * @return The method to use for the API destination.
     * @see ApiDestinationHttpMethod
     */
    public final ApiDestinationHttpMethod httpMethod() {
        return ApiDestinationHttpMethod.fromValue(httpMethod);
    }

    /**
     * <p>
     * The method to use for the API destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpMethod} will
     * return {@link ApiDestinationHttpMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #httpMethodAsString}.
     * </p>
     * 
     * @return The method to use for the API destination.
     * @see ApiDestinationHttpMethod
     */
    public final String httpMethodAsString() {
        return httpMethod;
    }

    /**
     * <p>
     * The maximum number of invocations per second to send to the API destination.
     * </p>
     * 
     * @return The maximum number of invocations per second to send to the API destination.
     */
    public final Integer invocationRateLimitPerSecond() {
        return invocationRateLimitPerSecond;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(invocationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(httpMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(invocationRateLimitPerSecond());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApiDestinationRequest)) {
            return false;
        }
        UpdateApiDestinationRequest other = (UpdateApiDestinationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(connectionArn(), other.connectionArn())
                && Objects.equals(invocationEndpoint(), other.invocationEndpoint())
                && Objects.equals(httpMethodAsString(), other.httpMethodAsString())
                && Objects.equals(invocationRateLimitPerSecond(), other.invocationRateLimitPerSecond());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApiDestinationRequest").add("Name", name()).add("Description", description())
                .add("ConnectionArn", connectionArn()).add("InvocationEndpoint", invocationEndpoint())
                .add("HttpMethod", httpMethodAsString()).add("InvocationRateLimitPerSecond", invocationRateLimitPerSecond())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ConnectionArn":
            return Optional.ofNullable(clazz.cast(connectionArn()));
        case "InvocationEndpoint":
            return Optional.ofNullable(clazz.cast(invocationEndpoint()));
        case "HttpMethod":
            return Optional.ofNullable(clazz.cast(httpMethodAsString()));
        case "InvocationRateLimitPerSecond":
            return Optional.ofNullable(clazz.cast(invocationRateLimitPerSecond()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApiDestinationRequest, T> g) {
        return obj -> g.apply((UpdateApiDestinationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApiDestinationRequest> {
        /**
         * <p>
         * The name of the API destination to update.
         * </p>
         * 
         * @param name
         *        The name of the API destination to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the API destination to update.
         * </p>
         * 
         * @param description
         *        The name of the API destination to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN of the connection to use for the API destination.
         * </p>
         * 
         * @param connectionArn
         *        The ARN of the connection to use for the API destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionArn(String connectionArn);

        /**
         * <p>
         * The URL to the endpoint to use for the API destination.
         * </p>
         * 
         * @param invocationEndpoint
         *        The URL to the endpoint to use for the API destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationEndpoint(String invocationEndpoint);

        /**
         * <p>
         * The method to use for the API destination.
         * </p>
         * 
         * @param httpMethod
         *        The method to use for the API destination.
         * @see ApiDestinationHttpMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiDestinationHttpMethod
         */
        Builder httpMethod(String httpMethod);

        /**
         * <p>
         * The method to use for the API destination.
         * </p>
         * 
         * @param httpMethod
         *        The method to use for the API destination.
         * @see ApiDestinationHttpMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiDestinationHttpMethod
         */
        Builder httpMethod(ApiDestinationHttpMethod httpMethod);

        /**
         * <p>
         * The maximum number of invocations per second to send to the API destination.
         * </p>
         * 
         * @param invocationRateLimitPerSecond
         *        The maximum number of invocations per second to send to the API destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationRateLimitPerSecond(Integer invocationRateLimitPerSecond);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EventBridgeRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String connectionArn;

        private String invocationEndpoint;

        private String httpMethod;

        private Integer invocationRateLimitPerSecond;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApiDestinationRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            connectionArn(model.connectionArn);
            invocationEndpoint(model.invocationEndpoint);
            httpMethod(model.httpMethod);
            invocationRateLimitPerSecond(model.invocationRateLimitPerSecond);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getConnectionArn() {
            return connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        @Transient
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getInvocationEndpoint() {
            return invocationEndpoint;
        }

        public final void setInvocationEndpoint(String invocationEndpoint) {
            this.invocationEndpoint = invocationEndpoint;
        }

        @Override
        @Transient
        public final Builder invocationEndpoint(String invocationEndpoint) {
            this.invocationEndpoint = invocationEndpoint;
            return this;
        }

        public final String getHttpMethod() {
            return httpMethod;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        @Transient
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @Override
        @Transient
        public final Builder httpMethod(ApiDestinationHttpMethod httpMethod) {
            this.httpMethod(httpMethod == null ? null : httpMethod.toString());
            return this;
        }

        public final Integer getInvocationRateLimitPerSecond() {
            return invocationRateLimitPerSecond;
        }

        public final void setInvocationRateLimitPerSecond(Integer invocationRateLimitPerSecond) {
            this.invocationRateLimitPerSecond = invocationRateLimitPerSecond;
        }

        @Override
        @Transient
        public final Builder invocationRateLimitPerSecond(Integer invocationRateLimitPerSecond) {
            this.invocationRateLimitPerSecond = invocationRateLimitPerSecond;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApiDestinationRequest build() {
            return new UpdateApiDestinationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
