/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEventSourcesResponse extends EventBridgeResponse implements
        ToCopyableBuilder<ListEventSourcesResponse.Builder, ListEventSourcesResponse> {
    private static final SdkField<List<EventSource>> EVENT_SOURCES_FIELD = SdkField
            .<List<EventSource>> builder(MarshallingType.LIST)
            .memberName("EventSources")
            .getter(getter(ListEventSourcesResponse::eventSources))
            .setter(setter(Builder::eventSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEventSourcesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_SOURCES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<EventSource> eventSources;

    private final String nextToken;

    private ListEventSourcesResponse(BuilderImpl builder) {
        super(builder);
        this.eventSources = builder.eventSources;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventSources() {
        return eventSources != null && !(eventSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of event sources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventSources} method.
     * </p>
     * 
     * @return The list of event sources.
     */
    public final List<EventSource> eventSources() {
        return eventSources;
    }

    /**
     * <p>
     * A token you can use in a subsequent operation to retrieve the next set of results.
     * </p>
     * 
     * @return A token you can use in a subsequent operation to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEventSources() ? eventSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventSourcesResponse)) {
            return false;
        }
        ListEventSourcesResponse other = (ListEventSourcesResponse) obj;
        return hasEventSources() == other.hasEventSources() && Objects.equals(eventSources(), other.eventSources())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEventSourcesResponse").add("EventSources", hasEventSources() ? eventSources() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventSources":
            return Optional.ofNullable(clazz.cast(eventSources()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEventSourcesResponse, T> g) {
        return obj -> g.apply((ListEventSourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EventBridgeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEventSourcesResponse> {
        /**
         * <p>
         * The list of event sources.
         * </p>
         * 
         * @param eventSources
         *        The list of event sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSources(Collection<EventSource> eventSources);

        /**
         * <p>
         * The list of event sources.
         * </p>
         * 
         * @param eventSources
         *        The list of event sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSources(EventSource... eventSources);

        /**
         * <p>
         * The list of event sources.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<EventSource>.Builder} avoiding the
         * need to create one manually via {@link List<EventSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventSource>.Builder#build()} is called immediately and its
         * result is passed to {@link #eventSources(List<EventSource>)}.
         * 
         * @param eventSources
         *        a consumer that will call methods on {@link List<EventSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventSources(List<EventSource>)
         */
        Builder eventSources(Consumer<EventSource.Builder>... eventSources);

        /**
         * <p>
         * A token you can use in a subsequent operation to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token you can use in a subsequent operation to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EventBridgeResponse.BuilderImpl implements Builder {
        private List<EventSource> eventSources = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventSourcesResponse model) {
            super(model);
            eventSources(model.eventSources);
            nextToken(model.nextToken);
        }

        public final List<EventSource.Builder> getEventSources() {
            List<EventSource.Builder> result = EventSourceListCopier.copyToBuilder(this.eventSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventSources(Collection<EventSource.BuilderImpl> eventSources) {
            this.eventSources = EventSourceListCopier.copyFromBuilder(eventSources);
        }

        @Override
        @Transient
        public final Builder eventSources(Collection<EventSource> eventSources) {
            this.eventSources = EventSourceListCopier.copy(eventSources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventSources(EventSource... eventSources) {
            eventSources(Arrays.asList(eventSources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventSources(Consumer<EventSource.Builder>... eventSources) {
            eventSources(Stream.of(eventSources).map(c -> EventSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEventSourcesResponse build() {
            return new ListEventSourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
